// MiStar

Star	"A"
{
	ParentBody     "MiStar I"
	Class	       "K2 V"
	Luminosity      0.28112
	MassSol         0.728153
	RadSol          0.835312
	Teff            4900

	Age             11.3899

	InertiaMoment   0.0817812

	Obliquity       -13.4694
	EqAscendNode    -100.759
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (1.000 0.765 0.595)

	Surface
	{
		Randomize      (0.797, 0.039, 0.074)
		colorDistMagn   0.528751
		colorDistFreq   12.3641
		detailScale     1.49533e+006
		colorConversion true
		tropicLatitude  0.5
		icecapLatitude  1
		mareFreq        31.3417
		mareDensity     0.0113425
		erosion         1
		montesFreq      537
		dunesMagn       0.5
		hillsMagn       0.03
		hillsFreq       4748.26
		craterOctaves   0
		BumpHeight      586.413
		BumpOffset      586.413
		SpecularPower   -1e+038
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      1
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Sun"
		Height          5813.77
		Density         0
		Pressure        1
		Bright          10
		Opacity         0
		SkyLight        0
		Hue             0
		Saturation      1
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	Corona
	{
		Radius      3.0631e+006
		Period      0.0134432
		Brightness  0.5
		RayDensity  3.15229
		RayCurv     14.6717
	}

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.813841
		Period          3.27221
		Eccentricity    0.834593
		Inclination     -13.4694
		AscendingNode   -100.759
		ArgOfPericenter 38.5806
		MeanAnomaly     -109.539
	}
}

Star	"B"
{
	ParentBody     "MiStar I"
	Class	       "K9.5 V"
	Luminosity      0.0592886
	MassSol         0.49345
	RadSol          0.750756
	Teff            3885

	Age             11.3899

	InertiaMoment   0.053873

	RotationPeriod  912.114
	Obliquity       -13.4694
	EqAscendNode    -100.759

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (1.000 0.616 0.342)

	Surface
	{
		Randomize      (-0.437, 0.958, 0.889)
		colorDistMagn   0.443437
		colorDistFreq   8.81309
		detailScale     1.34397e+006
		colorConversion true
		tropicLatitude  0.5138
		icecapLatitude  1.0092
		mareFreq        38.6639
		mareDensity     0.0138804
		erosion         1
		montesFreq      537
		dunesMagn       0.511913
		hillsMagn       0.03
		hillsFreq       4483.88
		craterOctaves   0
		BumpHeight      640.242
		BumpOffset      640.242
		SpecularPower   -1e+038
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      1
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Sun"
		Height          5225.26
		Density         0
		Pressure        1
		Bright          10
		Opacity         0
		SkyLight        0
		Hue             0
		Saturation      1
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	Corona
	{
		Radius      2.88086e+006
		Period      0.0441639
		Brightness  0.5
		RayDensity  3.16233
		RayCurv     15.2093
	}

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   1.20094
		Period          3.27221
		Eccentricity    0.834593
		Inclination     -13.4694
		AscendingNode   -100.759
		ArgOfPericenter 218.581
		MeanAnomaly     -109.539
	}
}

Planet	"B1"
{
	ParentBody     "B"
	Class	       "Desert"

	Mass            0.0559147
	Radius          2237.2
	InertiaMoment   0.340032

	Obliquity       -1.04823
	EqAscendNode    -111.861
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      2
	Color          (0.869 0.682 0.460)

	Surface
	{
		SurfStyle       0.0747653
		OceanStyle      0.919389
		Randomize      (-0.708, -0.738, 0.433)
		colorDistMagn   0.0846813
		colorDistFreq   275.124
		detailScale     5754.21
		colorConversion true
		seaLevel        0.11987
		snowLevel       2
		tropicLatitude  0.0204951
		icecapLatitude  10
		icecapHeight    0.132149
		climatePole     0.4375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.872542
		venusFreq       1.14059
		venusMagn       0
		mareFreq        1.39664
		mareDensity     0.0423464
		terraceProb     0.106447
		erosion         0
		montesMagn      0.138355
		montesFreq      113.792
		montesSpiky     0.954656
		montesFraction  0.0482464
		dunesMagn       0.0420518
		dunesFreq       15.6061
		dunesFraction   0.53699
		hillsMagn       0.139727
		hillsFreq       233.662
		hillsFraction   0
		hills2Fraction  0
		riversMagn      68.6881
		riversFreq      2.13112
		riversSin       6.49123
		riversOctaves   0
		canyonsMagn     0.0451433
		canyonsFreq     65.0399
		canyonFraction  0
		cracksMagn      0.100013
		cracksFreq      0.251823
		cracksOctaves   0
		craterMagn      0.605772
		craterFreq      5.2552
		craterDensity   0.782135
		craterOctaves   10.206
		volcanoMagn     0.434201
		volcanoFreq     2.6347
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.383475
		volcanoRadius   0.325686
		volcanoTemp     1754.39
		lavaCoverTidal  0.0506009
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.240, 0.230, 0.230, 0.000)
		colorShelf     (0.380, 0.360, 0.350, 0.000)
		colorBeach     (0.550, 0.520, 0.480, 0.000)
		colorDesert    (0.520, 0.490, 0.470, 0.000)
		colorLowland   (0.460, 0.440, 0.410, 0.000)
		colorUpland    (0.390, 0.360, 0.330, 0.000)
		colorRock      (0.170, 0.160, 0.160, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 0.769)
		colorLowPlants (0.460, 0.440, 0.410, 0.000)
		colorUpPlants  (0.390, 0.360, 0.330, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.5
		SpecBrightIce   0.5
		SpecularPower   30
		Hapke           0.986152
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Mars"
		Height          79.3195
		Density         0.00138478
		Pressure        0.00121269
		Greenhouse      0.185217
		Bright          4.2489
		Opacity         1
		SkyLight        1.4163
		Hue             0.000430651
		Saturation      1

		Composition
		{
			SO2   	99.9993
			Kr    	0.000656265
			Xe    	3.55852e-005
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0445154
		Period          0.0133704
		Eccentricity    0.0457886
		Inclination     -1.04823
		AscendingNode   -111.861
		ArgOfPericenter 232.382
		MeanAnomaly     152.486
	}
}

Moon	"B1.1"
{
	ParentBody     "B1"
	Class	       "Selena"

	Mass            0.000154571
	Radius          322.181
	InertiaMoment   0.398296

	Oblateness      0.014469

	Obliquity       0.248703
	EqAscendNode    123.554
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.858 0.750 0.543)

	Surface
	{
		SurfStyle       0.147693
		OceanStyle      0.651402
		Randomize      (-0.999, -0.779, 0.117)
		colorDistMagn   0.0552009
		colorDistFreq   41.0664
		detailScale     828.669
		colorConversion true
		drivenDarkening 0
		seaLevel        0.185911
		snowLevel       2
		tropicLatitude  0.00409981
		icecapLatitude  10
		icecapHeight    0.162257
		climatePole     0.4375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.62616
		venusFreq       1.12151
		venusMagn       0
		mareFreq        0
		mareDensity     0.000508718
		terraceProb     0.22449
		erosion         0
		montesMagn      0.0509791
		montesFreq      17.5285
		montesSpiky     0.991534
		montesFraction  0.24253
		dunesMagn       0.0244224
		dunesFreq       426.56
		dunesFraction   0.883381
		hillsMagn       0.149739
		hillsFreq       40.9265
		hillsFraction   0.229985
		hills2Fraction  0
		riversMagn      45.1869
		riversFreq      3.93559
		riversSin       5.80717
		riversOctaves   0
		canyonsMagn     0.439198
		canyonsFreq     0.121339
		canyonFraction  0.826019
		cracksMagn      0.0380799
		cracksFreq      0.0948335
		cracksOctaves   0
		craterMagn      0.807823
		craterFreq      0.79389
		craterDensity   0.887622
		craterOctaves   7.55913
		craterRayedFactor 0.271242
		volcanoMagn     0.211497
		volcanoFreq     3.1674
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.200548
		volcanoRadius   1.07242
		volcanoTemp     1690.5
		lavaCoverTidal  0.0612315
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.320, 0.320, 0.320, 0.000)
		colorShelf     (0.370, 0.370, 0.370, 0.000)
		colorBeach     (0.379, 0.378, 0.377, 0.000)
		colorDesert    (0.470, 0.454, 0.430, 0.200)
		colorLowland   (0.508, 0.484, 0.483, 0.500)
		colorUpland    (0.531, 0.507, 0.498, 0.800)
		colorRock      (0.650, 0.610, 0.620, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      16.1091
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   6.76518e-005
		Period          0.00135905
		Eccentricity    0.0226
		Inclination     0.248703
		AscendingNode   123.554
		ArgOfPericenter 45.9224
		MeanAnomaly     100.476
	}
}

DwarfMoon	"B1.D1"
{
	ParentBody     "B1"
	Class	       "Asteroid"

	Mass            8.56283e-009
	Radius          28.0261
	InertiaMoment   0.399745

	Oblateness      0.175129

	Obliquity       -47.2142
	EqAscendNode    -106.944
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.581 0.513 0.389)

	Surface
	{
		SurfStyle       0.468114
		OceanStyle      0.33351
		Randomize      (0.141, 0.322, -0.609)
		colorDistMagn   0.996271
		colorDistFreq   0.201993
		detailScale     765.299
		colorConversion true
		snowLevel       2
		tropicLatitude  0.78589
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.592837
		terraceProb     0.265855
		erosion         0
		montesMagn      0.531101
		montesFreq      2.77573
		montesSpiky     0.792982
		montesFraction  0.42713
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.59624
		hillsFraction   0.619234
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236402
		craterFreq      0.233079
		craterDensity   0.812435
		craterOctaves   13
		volcanoActivity 0.497133
		volcanoFlows    0
		volcanoRadius   47.4854
		volcanoTemp     1388.92
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.273, 0.231, 0.193, 0.000)
		colorShelf     (0.290, 0.246, 0.205, 0.000)
		colorBeach     (0.307, 0.260, 0.217, 0.000)
		colorDesert    (0.324, 0.275, 0.229, 0.000)
		colorLowland   (0.341, 0.289, 0.241, 0.000)
		colorUpland    (0.358, 0.304, 0.253, 0.000)
		colorRock      (0.375, 0.318, 0.265, 0.000)
		colorSnow      (0.392, 0.333, 0.277, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   6.72964e-005
		Period          0.00135022
		Eccentricity    0.151584
		Inclination     -47.2142
		AscendingNode   -106.944
		ArgOfPericenter 79.7908
		MeanAnomaly     -133.977
	}
}

Planet	"1"
{
	ParentBody     "MiStar I"
	Class	       "IceWorld"

	Mass            0.0215983
	Radius          2417.3
	InertiaMoment   0.359318

	Oblateness      0.00315781

	RotationPeriod  41.222
	Obliquity       -21.1577
	EqAscendNode    -96.6098

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.736 0.511 0.399)

	Surface
	{
		SurfStyle       0.86256
		OceanStyle      0.958886
		Randomize      (-0.232, -0.950, 0.044)
		colorDistMagn   0.058413
		colorDistFreq   302.346
		detailScale     6217.44
		colorConversion true
		drivenDarkening 0
		seaLevel        0.262663
		snowLevel       2
		tropicLatitude  0.388553
		icecapLatitude  1
		icecapHeight    0.262663
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.72109
		venusFreq       0.316891
		venusMagn       0.158566
		mareFreq        1.2973
		mareDensity     0.00229423
		terraceProb     0.160081
		erosion         0
		montesMagn      0.114232
		montesFreq      136.832
		montesSpiky     0.99563
		montesFraction  0.292168
		dunesMagn       0.0373628
		dunesFreq       3201.16
		dunesFraction   0.282869
		hillsMagn       0.141237
		hillsFreq       280.755
		hillsFraction   0.798191
		hills2Fraction  0.149989
		riversMagn      63.0078
		riversFreq      3.85494
		riversSin       5.99375
		riversOctaves   0
		canyonsMagn     0.697815
		canyonsFreq     0.784822
		canyonFraction  0
		cracksMagn      0.0376282
		cracksFreq      0.950352
		cracksOctaves   2
		craterMagn      0.526386
		craterFreq      6.35004
		craterDensity   0.924576
		craterOctaves   12
		craterRayedFactor 0.463659
		volcanoMagn     0.516124
		volcanoFreq     0.703038
		volcanoDensity  0.0456497
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.236724
		volcanoRadius   0.453259
		volcanoTemp     1573.1
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.736, 0.383, 0.229, 0.000)
		colorShelf     (0.699, 0.364, 0.218, 0.000)
		colorBeach     (0.368, 0.191, 0.115, 0.000)
		colorDesert    (0.625, 0.326, 0.195, 0.000)
		colorLowland   (0.596, 0.337, 0.218, 0.000)
		colorUpland    (0.684, 0.356, 0.213, 0.000)
		colorRock      (1.000, 1.000, 1.000, 0.500)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.596, 0.337, 0.218, 0.000)
		colorUpPlants  (0.684, 0.356, 0.213, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Sun"
		Height          63.4339
		Density         2.72397e-008
		Pressure        1.59568e-009
		Greenhouse      7.20202e-005
		Bright          0.5
		Opacity         0
		SkyLight        0.166667
		Hue             -0.0418777
		Saturation      1

		Composition
		{
			Kr    	100
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   11.4418
		Period          35.0168
		Eccentricity    0.0269275
		Inclination     -13.8487
		AscendingNode   -100.636
		ArgOfPericenter 312.348
		MeanAnomaly     269.797
	}
}

Planet	"2"
{
	ParentBody     "MiStar I"
	Class	       "GasGiant"

	Mass            95.2904
	Radius          58428.8
	InertiaMoment   0.218911

	Oblateness      0.0763594

	RotationPeriod  11.7099
	Obliquity       8.00552
	EqAscendNode    -94.9144

	AlbedoBond      0.456175
	AlbedoGeom      0.54741
	Brightness      2
	Color          (1.000 1.000 1.000)

	Surface
	{
		SurfStyle       0.568096
		Randomize      (0.932, -0.875, 0.129)
		detailScale     150282
		colorConversion true
		tropicLatitude  0.314062
		icecapLatitude  1
		mainFreq        0.0388149
		venusFreq       8.64477
		venusMagn       0.42669
		craterOctaves   0
		volcanoActivity 0
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		twistZones      4.36123
		twistMagn       1.25383
		cycloneMagn     5.82068
		cycloneFreq     0.344226
		cycloneDensity  0.143483
		cycloneOctaves  1
		colorLayer0    (0.570, 0.550, 0.480, 1.100)
		colorLayer1    (0.850, 0.860, 0.870, 0.700)
		colorLayer2    (0.450, 0.390, 0.260, 0.200)
		colorLayer3    (0.430, 0.330, 0.170, 0.020)
		colorLayer4    (0.830, 0.830, 0.830, 0.000)
		colorLayer5    (0.510, 0.400, 0.140, 0.000)
		colorLayer6    (0.370, 0.350, 0.280, 0.000)
		colorLayer7    (0.420, 0.390, 0.310, 1.000)
		colorLowPlants (0.830, 0.830, 0.830, 0.000)
		colorUpPlants  (0.510, 0.400, 0.140, 0.000)
		BumpHeight      18.7689
		SpecularPower   -1e+038
		Hapke           0
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      1
	}

	Clouds
	{
		Height          104.082
		BumpHeight      61.637
		Hapke           0
		SpotBright      2
		SpotWidth       0.15
		DayAmbient      1
		mainFreq        0.881137
		mainOctaves     10
		Coverage        0.0617461
		twistZones      4.36123
		twistMagn       1.25383
	}

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Earth"
		Height          445.344
		Density         11013.7
		Pressure        1e+006
		Bright          10
		Opacity         1
		SkyLight        3.33333
		Hue             0.589822
		Saturation      0.599121

		Composition
		{
			H2    	92.1732
			He    	7.82502
			Ne    	0.00126826
			N2    	0.000459071
		}
	}

	Aurora
	{
		Height      2553.33
		NorthLat    82.2431
		NorthLon    -57.9392
		NorthRadius 11212.6
		NorthWidth  3666.79
		NorthRings  5
		NorthBright 1
		NorthParticles 10000
		SouthLat    -82.915
		SouthLon    128.807
		SouthRadius 13178.9
		SouthWidth  4117.54
		SouthRings  4
		SouthBright 1
		SouthParticles 10000
		TopColor    (1.000 1.000 1.000)
		BottomColor (1.000 0.000 0.500)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   18.3119
		Period          70.89
		Eccentricity    0.0343625
		Inclination     -15.0173
		AscendingNode   -101.238
		ArgOfPericenter 48.1904
		MeanAnomaly     5.4305
	}
}

DwarfMoon	"2.D1"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.44346e-008
	Radius          40.9529
	InertiaMoment   0.399358

	Oblateness      0.249

	Obliquity       0.00441711
	EqAscendNode    166.462
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.635 0.500 0.430)

	Surface
	{
		SurfStyle       0.77965
		OceanStyle      0.424368
		Randomize      (0.638, -0.090, 0.855)
		colorDistMagn   0.837205
		colorDistFreq   0.913973
		detailScale     1118.29
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.56978
		terraceProb     0.43563
		erosion         0
		montesMagn      0.385298
		montesFreq      3.26333
		montesSpiky     0.928291
		montesFraction  0.545744
		dunesFraction   0
		hillsMagn       0
		hillsFreq       3.56528
		hillsFraction   0.760677
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.246483
		craterFreq      0.2682
		craterDensity   0.762164
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.076
		volcanoTemp     1287.38
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.248, 0.170, 0.120, 0.000)
		colorShelf     (0.254, 0.175, 0.137, 0.000)
		colorBeach     (0.299, 0.205, 0.163, 0.000)
		colorDesert    (0.324, 0.220, 0.159, 0.000)
		colorLowland   (0.356, 0.235, 0.180, 0.000)
		colorUpland    (0.394, 0.285, 0.219, 0.000)
		colorRock      (0.426, 0.310, 0.236, 0.000)
		colorSnow      (0.464, 0.330, 0.249, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00058096
		Period          0.000829612
		Eccentricity    2.8887e-005
		Inclination     0.00441711
		AscendingNode   166.462
		ArgOfPericenter -31.9154
		MeanAnomaly     -52.5381
	}
}

DwarfMoon	"2.D2"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.31577e-008
	Radius          43.5114
	InertiaMoment   0.39669

	Oblateness      0.249

	Obliquity       -0.00669429
	EqAscendNode    157.918
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.759 0.756 0.753)

	Surface
	{
		SurfStyle       0.353363
		OceanStyle      0.664425
		Randomize      (0.509, 0.381, -0.255)
		colorDistMagn   0.171142
		colorDistFreq   0.364924
		detailScale     1188.15
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.346989
		terraceProb     0.577215
		erosion         0
		montesMagn      0.447961
		montesFreq      3.1143
		montesSpiky     0.967671
		montesFraction  0.843186
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.79188
		hillsFraction   0.520437
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.199703
		craterFreq      0.228065
		craterDensity   0.949135
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.4642
		volcanoTemp     1879.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.304, 0.302, 0.301, 0.000)
		colorShelf     (0.323, 0.321, 0.320, 0.000)
		colorBeach     (0.342, 0.340, 0.339, 0.000)
		colorDesert    (0.361, 0.359, 0.358, 0.000)
		colorLowland   (0.380, 0.378, 0.377, 0.000)
		colorUpland    (0.399, 0.397, 0.396, 0.000)
		colorRock      (0.418, 0.416, 0.414, 0.000)
		colorSnow      (0.437, 0.435, 0.433, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000621982
		Period          0.000919013
		Eccentricity    7.58526e-005
		Inclination     -0.00669429
		AscendingNode   157.918
		ArgOfPericenter -30.2825
		MeanAnomaly     -80.7113
	}
}

DwarfMoon	"2.D3"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.50009e-008
	Radius          61.3862
	InertiaMoment   0.398482

	Oblateness      0.249

	Obliquity       -0.00149008
	EqAscendNode    49.8461
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.442 0.437 0.435)

	Surface
	{
		SurfStyle       0.0461787
		OceanStyle      0.865259
		Randomize      (-0.905, 0.650, -0.085)
		colorDistMagn   0.236069
		colorDistFreq   2.73926
		detailScale     1676.25
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.593605
		terraceProb     0.468325
		erosion         0
		montesMagn      0.400758
		montesFreq      2.2154
		montesSpiky     0.916439
		montesFraction  0.544989
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.14869
		hillsFraction   0.781401
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.237389
		craterFreq      0.198189
		craterDensity   0.884021
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   45.3697
		volcanoTemp     1250.58
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.177, 0.175, 0.174, 0.000)
		colorShelf     (0.188, 0.186, 0.185, 0.000)
		colorBeach     (0.199, 0.196, 0.196, 0.000)
		colorDesert    (0.210, 0.207, 0.206, 0.000)
		colorLowland   (0.221, 0.218, 0.217, 0.000)
		colorUpland    (0.232, 0.229, 0.228, 0.000)
		colorRock      (0.243, 0.240, 0.239, 0.000)
		colorSnow      (0.254, 0.251, 0.250, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000671299
		Period          0.00103045
		Eccentricity    6.72081e-005
		Inclination     -0.00149008
		AscendingNode   49.8461
		ArgOfPericenter 129.01
		MeanAnomaly     -131.323
	}
}

DwarfMoon	"2.D4"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.11352e-008
	Radius          58.5754
	InertiaMoment   0.399488

	Oblateness      0.249

	Obliquity       -0.00237755
	EqAscendNode    84.3057
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.635 0.631 0.628)

	Surface
	{
		SurfStyle       0.906092
		OceanStyle      0.594331
		Randomize      (0.946, 0.321, 0.522)
		colorDistMagn   0.414026
		colorDistFreq   2.98892
		detailScale     1599.5
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.572719
		terraceProb     0.305053
		erosion         0
		montesMagn      0.344834
		montesFreq      2.95226
		montesSpiky     0.786834
		montesFraction  0.513744
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.54767
		hillsFraction   0.598574
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.200813
		craterFreq      0.189674
		craterDensity   0.750987
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.1429
		volcanoTemp     1414.55
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.216, 0.221, 0.251, 0.050)
		colorShelf     (0.254, 0.259, 0.289, 0.040)
		colorBeach     (0.292, 0.297, 0.326, 0.030)
		colorDesert    (0.330, 0.334, 0.370, 0.020)
		colorLowland   (0.368, 0.372, 0.408, 0.030)
		colorUpland    (0.406, 0.410, 0.446, 0.050)
		colorRock      (0.444, 0.448, 0.496, 0.020)
		colorSnow      (0.444, 0.448, 0.496, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00070482
		Period          0.00110859
		Eccentricity    6.13133e-005
		Inclination     -0.00237755
		AscendingNode   84.3057
		ArgOfPericenter 34.7668
		MeanAnomaly     -46.067
	}
}

DwarfMoon	"2.D5"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            8.32105e-008
	Radius          61.9648
	InertiaMoment   0.397105

	Oblateness      0.239291

	Obliquity       -0.00738869
	EqAscendNode    101.975
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.539 0.474 0.437)

	Surface
	{
		SurfStyle       0.519454
		OceanStyle      0.697059
		Randomize      (0.133, -0.599, 0.615)
		colorDistMagn   0.608621
		colorDistFreq   2.64114
		detailScale     1692.05
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.3613
		terraceProb     0.150881
		erosion         0
		montesMagn      0.52931
		montesFreq      2.578
		montesSpiky     0.939163
		montesFraction  0.634123
		dunesFraction   0
		hillsMagn       0
		hillsFreq       9.18135
		hillsFraction   0.752301
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.220849
		craterFreq      0.253576
		craterDensity   0.866807
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   33.6792
		volcanoTemp     1345.35
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.210, 0.161, 0.122, 0.000)
		colorShelf     (0.215, 0.166, 0.140, 0.000)
		colorBeach     (0.253, 0.194, 0.166, 0.000)
		colorDesert    (0.275, 0.209, 0.162, 0.000)
		colorLowland   (0.302, 0.223, 0.183, 0.000)
		colorUpland    (0.334, 0.270, 0.223, 0.000)
		colorRock      (0.361, 0.294, 0.240, 0.000)
		colorSnow      (0.393, 0.313, 0.253, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000748065
		Period          0.00121217
		Eccentricity    6.86644e-005
		Inclination     -0.00738869
		AscendingNode   101.975
		ArgOfPericenter 119.696
		MeanAnomaly     -2.1673
	}
}

DwarfMoon	"2.D6"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.13575e-007
	Radius          66.0085
	InertiaMoment   0.398644

	Oblateness      0.191286

	Obliquity       0.00823578
	EqAscendNode    121.153
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.808 0.691 0.649)

	Surface
	{
		SurfStyle       0.896165
		OceanStyle      0.385852
		Randomize      (0.844, 0.656, -0.339)
		colorDistMagn   0.0728212
		colorDistFreq   2.15379
		detailScale     1802.47
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.51874
		terraceProb     0.409049
		erosion         0
		montesMagn      0.537496
		montesFreq      2.34851
		montesSpiky     0.866502
		montesFraction  0.489674
		dunesFraction   0
		hillsMagn       0
		hillsFreq       10.1237
		hillsFraction   0.600133
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.206914
		craterFreq      0.210033
		craterDensity   0.879537
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.7089
		volcanoTemp     1431.78
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.275, 0.242, 0.260, 0.050)
		colorShelf     (0.323, 0.283, 0.299, 0.040)
		colorBeach     (0.372, 0.325, 0.338, 0.030)
		colorDesert    (0.420, 0.366, 0.383, 0.020)
		colorLowland   (0.469, 0.408, 0.422, 0.030)
		colorUpland    (0.517, 0.449, 0.461, 0.050)
		colorRock      (0.566, 0.491, 0.513, 0.020)
		colorSnow      (0.566, 0.491, 0.513, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000775549
		Period          0.00127958
		Eccentricity    3.61888e-005
		Inclination     0.00823578
		AscendingNode   121.153
		ArgOfPericenter -84.2816
		MeanAnomaly     -0.697598
	}
}

DwarfMoon	"2.D7"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.55606e-007
	Radius          68.1749
	InertiaMoment   0.399616

	Oblateness      0.127836

	Obliquity       -0.00135709
	EqAscendNode    -4.50938
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.593 0.586 0.583)

	Surface
	{
		SurfStyle       0.325719
		OceanStyle      0.170612
		Randomize      (0.255, -0.216, -0.355)
		colorDistMagn   0.314824
		colorDistFreq   2.97868
		detailScale     1861.63
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.576752
		terraceProb     0.304152
		erosion         0
		montesMagn      0.509556
		montesFreq      2.89308
		montesSpiky     0.939637
		montesFraction  0.431191
		dunesFraction   0
		hillsMagn       0
		hillsFreq       11.065
		hillsFraction   0.719394
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.26958
		craterFreq      0.224512
		craterDensity   1.00334
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.0967
		volcanoTemp     1519.74
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.237, 0.234, 0.233, 0.000)
		colorShelf     (0.252, 0.249, 0.248, 0.000)
		colorBeach     (0.267, 0.264, 0.262, 0.000)
		colorDesert    (0.282, 0.278, 0.277, 0.000)
		colorLowland   (0.297, 0.293, 0.291, 0.000)
		colorUpland    (0.311, 0.308, 0.306, 0.000)
		colorRock      (0.326, 0.322, 0.321, 0.000)
		colorSnow      (0.341, 0.337, 0.335, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000825893
		Period          0.00140618
		Eccentricity    6.91996e-005
		Inclination     -0.00135709
		AscendingNode   -4.50938
		ArgOfPericenter 82.2127
		MeanAnomaly     113.42
	}
}

DwarfMoon	"2.D8"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.14229e-007
	Radius          89.7416
	InertiaMoment   0.397423

	Oblateness      0.195316

	Obliquity       -0.00894352
	EqAscendNode    -49.5138
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.652 0.546 0.408)

	Surface
	{
		SurfStyle       0.892462
		OceanStyle      0.800997
		Randomize      (-0.248, 0.236, 0.155)
		colorDistMagn   0.250403
		colorDistFreq   4.6065
		detailScale     2450.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.000345267
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.332567
		terraceProb     0.210067
		erosion         0
		montesMagn      0.468963
		montesFreq      3.13811
		montesSpiky     0.980049
		montesFraction  0.349146
		dunesFraction   0
		hillsMagn       0
		hillsFreq       18.9453
		hillsFraction   0.511266
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.222246
		craterFreq      0.204918
		craterDensity   0.972238
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.3991
		volcanoTemp     1641.08
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.222, 0.191, 0.163, 0.050)
		colorShelf     (0.261, 0.224, 0.188, 0.040)
		colorBeach     (0.300, 0.257, 0.212, 0.030)
		colorDesert    (0.339, 0.290, 0.241, 0.020)
		colorLowland   (0.378, 0.322, 0.265, 0.030)
		colorUpland    (0.417, 0.355, 0.290, 0.050)
		colorRock      (0.456, 0.388, 0.322, 0.020)
		colorSnow      (0.456, 0.388, 0.322, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000846169
		Period          0.00145828
		Eccentricity    8.45785e-005
		Inclination     -0.00894352
		AscendingNode   -49.5138
		ArgOfPericenter -54.1053
		MeanAnomaly     146.281
	}
}

DwarfMoon	"2.D9"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.96716e-007
	Radius          95.2171
	InertiaMoment   0.398797

	Oblateness      0.154648

	Obliquity       -0.00554025
	EqAscendNode    16.5961
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.597 0.551 0.481)

	Surface
	{
		SurfStyle       0.456941
		OceanStyle      0.350596
		Randomize      (-0.770, 0.332, -0.243)
		colorDistMagn   0.487608
		colorDistFreq   6.69381
		detailScale     2600.06
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.523238
		terraceProb     0.34267
		erosion         0
		montesMagn      0.640252
		montesFreq      2.5414
		montesSpiky     0.841173
		montesFraction  0.739045
		dunesFraction   0
		hillsMagn       0
		hillsFreq       27.7266
		hillsFraction   0.516259
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.272096
		craterFreq      0.280555
		craterDensity   1.05604
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.4063
		volcanoTemp     1551.54
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.239, 0.220, 0.193, 0.000)
		colorShelf     (0.254, 0.234, 0.205, 0.000)
		colorBeach     (0.269, 0.248, 0.217, 0.000)
		colorDesert    (0.284, 0.262, 0.229, 0.000)
		colorLowland   (0.299, 0.275, 0.241, 0.000)
		colorUpland    (0.314, 0.289, 0.253, 0.000)
		colorRock      (0.329, 0.303, 0.265, 0.000)
		colorSnow      (0.344, 0.317, 0.277, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000872103
		Period          0.00152583
		Eccentricity    3.58226e-005
		Inclination     -0.00554025
		AscendingNode   16.5961
		ArgOfPericenter 39.9577
		MeanAnomaly     59.4507
	}
}

DwarfMoon	"2.D10"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.13991e-007
	Radius          102.205
	InertiaMoment   0.399742

	Oblateness      0.129313

	Obliquity       0.00173016
	EqAscendNode    79.8334
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.795 0.793 0.791)

	Surface
	{
		SurfStyle       0.835992
		OceanStyle      0.755256
		Randomize      (0.106, -0.253, -0.711)
		colorDistMagn   0.235994
		colorDistFreq   8.34936
		detailScale     2790.87
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.417324
		terraceProb     0.193451
		erosion         0
		montesMagn      0.21766
		montesFreq      2.51321
		montesSpiky     0.800844
		montesFraction  0.355579
		dunesFraction   0
		hillsMagn       0
		hillsFreq       33.0089
		hillsFraction   0.747873
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24874
		craterFreq      0.438828
		craterDensity   0.986861
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   24.9047
		volcanoTemp     1375.61
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.310, 0.270, 0.221, 0.000)
		colorShelf     (0.318, 0.278, 0.253, 0.000)
		colorBeach     (0.374, 0.325, 0.300, 0.000)
		colorDesert    (0.405, 0.349, 0.293, 0.000)
		colorLowland   (0.445, 0.373, 0.332, 0.000)
		colorUpland    (0.493, 0.452, 0.403, 0.000)
		colorRock      (0.533, 0.492, 0.435, 0.000)
		colorSnow      (0.580, 0.523, 0.459, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000890268
		Period          0.00157375
		Eccentricity    4.93971e-005
		Inclination     0.00173016
		AscendingNode   79.8334
		ArgOfPericenter -88.1064
		MeanAnomaly     -152.396
	}
}

Moon	"2.1"
{
	ParentBody     "2"
	Class	       "Desert"

	Mass            0.249608
	Radius          4984.19
	InertiaMoment   0.333372

	Oblateness      0.00604292

	Obliquity       0.945311
	EqAscendNode    -119.93
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      2
	Color          (0.542 0.538 0.530)

	Surface
	{
		SurfStyle       0.173108
		OceanStyle      0.324913
		Randomize      (0.143, -0.571, 0.298)
		colorDistMagn   0.0563795
		colorDistFreq   524.688
		detailScale     12819.6
		colorConversion true
		seaLevel        0.173023
		snowLevel       2
		tropicLatitude  0.0165146
		icecapLatitude  0.862641
		icecapHeight    0.17649
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.733719
		venusFreq       1.03142
		venusMagn       0.346815
		mareFreq        1.19706
		mareDensity     0.0338925
		terraceProb     0.103481
		erosion         0
		montesMagn      0.169815
		montesFreq      196.581
		montesSpiky     0.955751
		montesFraction  0.428318
		dunesMagn       0.0485507
		dunesFreq       46.7449
		dunesFraction   0.741285
		hillsMagn       0.147928
		hillsFreq       437.766
		hillsFraction   0
		hills2Fraction  0
		riversMagn      61.8824
		riversFreq      2.77966
		riversSin       5.95667
		riversOctaves   0
		canyonsMagn     0.0610686
		canyonsFreq     121.685
		canyonFraction  0
		cracksMagn      0.0888036
		cracksFreq      0.423564
		cracksOctaves   0
		craterMagn      0.664894
		craterFreq      14.1534
		craterDensity   0.403395
		craterOctaves   6.4995
		volcanoMagn     0.71461
		volcanoFreq     3.17408
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.73214
		volcanoRadius   0.413721
		volcanoTemp     1072.47
		lavaCoverTidal  0.504049
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.240, 0.230, 0.230, 0.000)
		colorShelf     (0.380, 0.360, 0.350, 0.000)
		colorBeach     (0.550, 0.520, 0.480, 0.000)
		colorDesert    (0.520, 0.490, 0.470, 0.000)
		colorLowland   (0.460, 0.440, 0.410, 0.000)
		colorUpland    (0.390, 0.360, 0.330, 0.000)
		colorRock      (0.170, 0.160, 0.160, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 0.769)
		colorLowPlants (0.460, 0.440, 0.410, 0.000)
		colorUpPlants  (0.390, 0.360, 0.330, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.5
		SpecBrightIce   0.5
		SpecularPower   30
		Hapke           0.974353
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Neptune"
		Height          73.4312
		Density         0.00256465
		Pressure        0.00179783
		Greenhouse      0.260008
		Bright          4.80624
		Opacity         1
		SkyLight        1.60208
		Hue             0
		Saturation      1

		Composition
		{
			CO2   	52.8466
			H2O   	29.9721
			CH4   	10.6992
			H2S   	3.62128
			SO2   	1.34146
			N2    	0.809952
			C2H2  	0.527929
			NH3   	0.10439
			C2H4  	0.0375229
			C3H8  	0.0329575
			C2H6  	0.00441327
			CO    	0.00182716
			Ar    	0.000175698
			Ne    	0.000155799
		}
	}

	Aurora
	{
		Height      65.4258
		NorthLat    73.3786
		NorthLon    -56.5315
		NorthRadius 1673.87
		NorthWidth  1793.33
		NorthRings  2
		NorthBright 0.3
		NorthParticles 50000
		SouthLat    -74.2261
		SouthLon    145.581
		SouthRadius 682.943
		SouthWidth  793.933
		SouthRings  5
		SouthBright 0.3
		SouthParticles 50000
		TopColor    (1.000 1.000 1.000)
		BottomColor (0.000 1.000 0.000)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00131527
		Period          0.00282234
		Eccentricity    0.00821096
		Inclination     0.945311
		AscendingNode   -119.93
		ArgOfPericenter -140.111
		MeanAnomaly     120.256
	}
}

Moon	"2.2"
{
	ParentBody     "2"
	Class	       "Selena"

	Mass            0.0299238
	Radius          2688.05
	InertiaMoment   0.355941

	Oblateness      0.00273128

	Obliquity       0.838581
	EqAscendNode    -49.1077
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.495 0.491 0.483)

	Surface
	{
		SurfStyle       0.420622
		OceanStyle      0.788761
		Randomize      (0.947, -0.302, -0.535)
		colorDistMagn   0.073216
		colorDistFreq   345.507
		detailScale     6913.82
		colorConversion true
		drivenDarkening 0
		seaLevel        0.190716
		snowLevel       2
		tropicLatitude  0.0266213
		icecapLatitude  0.943145
		icecapHeight    0.191363
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.86005
		venusFreq       1.31144
		venusMagn       0
		mareFreq        1.46536
		mareDensity     0.00385457
		terraceProb     0.138765
		erosion         0
		montesMagn      0.16499
		montesFreq      134.131
		montesSpiky     0.992953
		montesFraction  0.811139
		dunesMagn       0.0421438
		dunesFreq       3462.9
		dunesFraction   0.513163
		hillsMagn       0.113736
		hillsFreq       247.836
		hillsFraction   0.378385
		hills2Fraction  0
		riversMagn      65.7905
		riversFreq      2.94237
		riversSin       7.5465
		riversOctaves   0
		canyonsMagn     0.503053
		canyonsFreq     1.08965
		canyonFraction  0.766423
		cracksMagn      0.0417557
		cracksFreq      0.953596
		cracksOctaves   0
		craterMagn      0.571179
		craterFreq      7.7186
		craterDensity   0.669796
		craterOctaves   9.64267
		craterRayedFactor 0.264829
		volcanoMagn     0.614961
		volcanoFreq     2.46399
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.241397
		volcanoRadius   0.500257
		volcanoTemp     1561.35
		lavaCoverTidal  0.218271
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.420, 0.420, 0.430, 0.000)
		colorShelf     (0.470, 0.480, 0.480, 0.000)
		colorBeach     (0.272, 0.280, 0.290, 0.000)
		colorDesert    (0.238, 0.226, 0.222, 0.000)
		colorLowland   (0.302, 0.299, 0.271, 0.000)
		colorUpland    (0.322, 0.319, 0.295, 0.000)
		colorRock      (0.340, 0.340, 0.340, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00192575
		Period          0.00500596
		Eccentricity    0.0125196
		Inclination     0.838581
		AscendingNode   -49.1077
		ArgOfPericenter 78.4135
		MeanAnomaly     42.3399
	}
}

Moon	"2.3"
{
	ParentBody     "2"
	Class	       "Selena"

	Mass            0.0362555
	Radius          2690.84
	InertiaMoment   0.351013

	Obliquity       0.116683
	EqAscendNode    -155.01
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.736 0.732 0.729)

	Surface
	{
		SurfStyle       0.142946
		OceanStyle      0.717346
		Randomize      (0.366, -0.395, 0.792)
		colorDistMagn   0.0806836
		colorDistFreq   376.905
		detailScale     6920.99
		colorConversion true
		drivenDarkening 0
		seaLevel        0.128848
		snowLevel       2
		tropicLatitude  0.00091349
		icecapLatitude  0.50695
		icecapHeight    0.15259
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.88351
		venusFreq       1.41745
		venusMagn       0
		mareFreq        1.65605
		mareDensity     0.0060866
		terraceProb     0.537454
		erosion         0
		montesMagn      0.224515
		montesFreq      129.7
		montesSpiky     0.959133
		montesFraction  0.348793
		dunesMagn       0.044691
		dunesFreq       3579.69
		dunesFraction   0.196966
		hillsMagn       0.109463
		hillsFreq       254.631
		hillsFraction   0.869287
		hills2Fraction  0
		riversMagn      59.2877
		riversFreq      3.17262
		riversSin       5.41797
		riversOctaves   0
		canyonsMagn     0.390748
		canyonsFreq     0.857258
		canyonFraction  0.511938
		cracksMagn      0.0536016
		cracksFreq      0.733993
		cracksOctaves   0
		craterMagn      0.629996
		craterFreq      7.21016
		craterDensity   0.785384
		craterOctaves   10.0269
		craterRayedFactor 0.371362
		volcanoMagn     0.623644
		volcanoFreq     3.9582
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.318946
		volcanoRadius   0.730842
		volcanoTemp     1318.71
		lavaCoverTidal  0.182695
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.320, 0.320, 0.320, 0.000)
		colorShelf     (0.370, 0.370, 0.370, 0.000)
		colorBeach     (0.368, 0.366, 0.364, 0.000)
		colorDesert    (0.457, 0.439, 0.415, 0.200)
		colorLowland   (0.493, 0.468, 0.466, 0.500)
		colorUpland    (0.515, 0.490, 0.481, 0.800)
		colorRock      (0.650, 0.610, 0.620, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           0.999999
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Sun"
		Height          92.5854
		Density         1.22148e-007
		Pressure        2.06495e-008
		Greenhouse      0.000870188
		Bright          0.656715
		Opacity         0
		SkyLight        0.218905
		Hue             0.0320437
		Saturation      1

		Composition
		{
			Ar    	93.5285
			Kr    	5.75253
			Xe    	0.717863
			CO2   	0.00116221
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00281959
		Period          0.00886854
		Eccentricity    0.0415194
		Inclination     0.116683
		AscendingNode   -155.01
		ArgOfPericenter -63.5248
		MeanAnomaly     -23.5285
	}
}

Moon	"2.4"
{
	ParentBody     "2"
	Class	       "Selena"

	Mass            0.0445206
	Radius          3057.86
	InertiaMoment   0.345928

	Obliquity       -0.314569
	EqAscendNode    -115.324
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.732 0.693 0.642)

	Surface
	{
		SurfStyle       0.501553
		OceanStyle      0.629758
		Randomize      (0.326, 0.688, -0.334)
		colorDistMagn   0.0932985
		colorDistFreq   359.517
		detailScale     7864.99
		colorConversion true
		drivenDarkening 0
		seaLevel        0.278222
		snowLevel       2
		tropicLatitude  0.00586951
		icecapLatitude  0.606091
		icecapHeight    0.306325
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        2.07562
		venusFreq       1.45245
		venusMagn       0
		mareFreq        1.87525
		mareDensity     0.00493101
		terraceProb     0.444093
		erosion         0
		montesMagn      0.160363
		montesFreq      97.1149
		montesSpiky     0.920435
		montesFraction  0.935118
		dunesMagn       0.0562312
		dunesFreq       4047.97
		dunesFraction   0.392011
		hillsMagn       0.105849
		hillsFreq       376.287
		hillsFraction   0.592066
		hills2Fraction  0
		riversMagn      73.6532
		riversFreq      2.75504
		riversSin       5.80965
		riversOctaves   0
		canyonsMagn     0.581153
		canyonsFreq     0.942654
		canyonFraction  0.53194
		cracksMagn      0.0621787
		cracksFreq      1.34274
		cracksOctaves   0
		craterMagn      0.635442
		craterFreq      7.56246
		craterDensity   0.865586
		craterOctaves   11.5276
		craterRayedFactor 0.219283
		volcanoMagn     0.681772
		volcanoFreq     2.94116
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.164249
		volcanoRadius   0.556904
		volcanoTemp     1835.69
		lavaCoverTidal  0.0437413
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.430, 0.400, 0.370, 0.000)
		colorShelf     (0.620, 0.600, 0.530, 0.000)
		colorBeach     (0.454, 0.423, 0.347, 0.000)
		colorDesert    (0.476, 0.430, 0.353, 0.000)
		colorLowland   (0.373, 0.319, 0.270, 0.000)
		colorUpland    (0.549, 0.492, 0.398, 0.000)
		colorRock      (0.300, 0.260, 0.220, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           0.999972
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Pluto"
		Height          115.639
		Density         2.78037e-006
		Pressure        3.09879e-007
		Greenhouse      0.00157013
		Bright          1.22693
		Opacity         0
		SkyLight        0.408977
		Hue             0.0397951
		Saturation      1

		Composition
		{
			Ar    	100
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00412831
		Period          0.0157113
		Eccentricity    0.0296825
		Inclination     -0.314569
		AscendingNode   -115.324
		ArgOfPericenter -176.58
		MeanAnomaly     -116.11
	}
}

DwarfMoon	"2.D11"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.60417e-006
	Radius          180.319
	InertiaMoment   0.399085

	Obliquity       -0.5174
	EqAscendNode    79.3926
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.655 0.651 0.646)

	Surface
	{
		SurfStyle       0.998249
		OceanStyle      0.738339
		Randomize      (0.085, -0.432, -0.188)
		colorDistMagn   0.809686
		colorDistFreq   14.7981
		detailScale     4923.91
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0138964
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.608005
		terraceProb     0.111236
		erosion         0
		montesMagn      0.621908
		montesFreq      2.79265
		montesSpiky     0.966259
		montesFraction  0.519774
		dunesFraction   0
		hillsMagn       0
		hillsFreq       76.7678
		hillsFraction   0.502003
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.225822
		craterFreq      1.10768
		craterDensity   0.800915
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   17.5191
		volcanoTemp     1511.52
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.223, 0.228, 0.258, 0.050)
		colorShelf     (0.262, 0.267, 0.297, 0.040)
		colorBeach     (0.302, 0.306, 0.336, 0.030)
		colorDesert    (0.341, 0.345, 0.381, 0.020)
		colorLowland   (0.380, 0.384, 0.420, 0.030)
		colorUpland    (0.419, 0.423, 0.458, 0.050)
		colorRock      (0.459, 0.462, 0.510, 0.020)
		colorSnow      (0.459, 0.462, 0.510, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00604447
		Period          0.0278415
		Eccentricity    0.0326478
		Inclination     -0.5174
		AscendingNode   79.3926
		ArgOfPericenter -39.6431
		MeanAnomaly     121.293
	}
}

Moon	"2.5"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            0.711302
	Radius          7338.51
	InertiaMoment   0.326537

	Obliquity       -1.16845
	EqAscendNode    -11.9897
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.792 0.701 0.579)

	Surface
	{
		SurfStyle       0.877553
		OceanStyle      0.571557
		Randomize      (-0.475, 0.548, 0.509)
		colorDistMagn   0.0765923
		colorDistFreq   703.411
		detailScale     18875.1
		colorConversion true
		drivenDarkening 0
		seaLevel        0.290338
		snowLevel       2
		tropicLatitude  0.0405528
		icecapLatitude  0.524067
		icecapHeight    0.302521
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.67112
		venusFreq       0.900302
		venusMagn       0.122051
		mareFreq        1.5953
		mareDensity     0.0337732
		terraceProb     0.137853
		erosion         0
		montesMagn      0.152864
		montesFreq      295.734
		montesSpiky     0.893711
		montesFraction  0.37616
		dunesMagn       0.0395666
		dunesFreq       9431.38
		dunesFraction   0.283764
		hillsMagn       0.133988
		hillsFreq       875.328
		hillsFraction   0.22755
		hills2Fraction  0.124241
		riversMagn      52.0263
		riversFreq      3.92784
		riversSin       5.70208
		riversOctaves   0
		canyonsMagn     0.44249
		canyonsFreq     2.81841
		canyonFraction  0
		cracksMagn      0.055992
		cracksFreq      4.20576
		cracksOctaves   7
		craterMagn      0.584462
		craterFreq      24.206
		craterDensity   0.857035
		craterOctaves   13
		craterRayedFactor 0
		volcanoMagn     0.669596
		volcanoFreq     0.745031
		volcanoDensity  0.0589528
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.0712836
		volcanoRadius   0.254098
		volcanoTemp     1499.16
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.792, 0.526, 0.332, 0.000)
		colorShelf     (0.752, 0.499, 0.315, 0.000)
		colorBeach     (0.396, 0.263, 0.166, 0.000)
		colorDesert    (0.673, 0.447, 0.282, 0.000)
		colorLowland   (0.641, 0.463, 0.315, 0.000)
		colorUpland    (0.736, 0.488, 0.309, 0.000)
		colorRock      (1.000, 1.000, 1.000, 0.500)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.641, 0.463, 0.315, 0.000)
		colorUpPlants  (0.736, 0.488, 0.309, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           0.994957
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Pluto"
		Height          79.0534
		Density         0.00050429
		Pressure        7.28648e-005
		Greenhouse      0.0701528
		Bright          3.47165
		Opacity         0
		SkyLight        1.15722
		Hue             -0.0447021
		Saturation      1

		Composition
		{
			N2    	99.8311
			Ne    	0.164799
			CO    	0.00365454
			Ar    	0.000417428
		}
	}

	Aurora
	{
		Height      108.011
		NorthLat    48.1466
		NorthLon    -15.7469
		NorthRadius 2639.89
		NorthWidth  2428.67
		NorthRings  4
		NorthBright 0.3
		NorthParticles 50000
		SouthLat    -42.1866
		SouthLon    145.398
		SouthRadius 2057.73
		SouthWidth  2093.43
		SouthRings  3
		SouthBright 0.3
		SouthParticles 50000
		TopColor    (1.000 1.000 1.000)
		BottomColor (0.000 1.000 0.000)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00885003
		Period          0.0491425
		Eccentricity    0.0346299
		Inclination     -1.16845
		AscendingNode   -11.9897
		ArgOfPericenter 131.52
		MeanAnomaly     -56.7286
	}
}

Moon	"2.6"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            0.0939146
	Radius          3656.31
	InertiaMoment   0.333426

	Obliquity       0.763006
	EqAscendNode    148.743
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.723 0.721 0.717)

	Surface
	{
		SurfStyle       0.804115
		OceanStyle      0.928817
		Randomize      (-0.179, 0.208, -0.431)
		colorDistMagn   0.0761949
		colorDistFreq   393.884
		detailScale     9404.24
		colorConversion true
		drivenDarkening 0
		seaLevel        0.281494
		snowLevel       2
		tropicLatitude  0.00717619
		icecapLatitude  0.866656
		icecapHeight    0.292135
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.78755
		venusFreq       0.924225
		venusMagn       0
		mareFreq        2.10679
		mareDensity     0.0124927
		terraceProb     0.231718
		erosion         0
		montesMagn      0.158398
		montesFreq      211.597
		montesSpiky     0.828514
		montesFraction  0.468253
		dunesMagn       0.0472829
		dunesFreq       4759.43
		dunesFraction   0.425209
		hillsMagn       0.13456
		hillsFreq       396.171
		hillsFraction   0.576728
		hills2Fraction  0.0444867
		riversMagn      62.3415
		riversFreq      2.80871
		riversSin       6.71511
		riversOctaves   0
		canyonsMagn     0.403348
		canyonsFreq     1.64862
		canyonFraction  0
		cracksMagn      0.0441041
		cracksFreq      1.0079
		cracksOctaves   4
		craterMagn      0.605968
		craterFreq      10.7602
		craterDensity   0.959698
		craterOctaves   12
		craterRayedFactor 0.143266
		volcanoMagn     0.688639
		volcanoFreq     1.09686
		volcanoDensity  0.0667238
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.267993
		volcanoRadius   0.512951
		volcanoTemp     1690.33
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.723, 0.541, 0.412, 0.000)
		colorShelf     (0.687, 0.513, 0.391, 0.000)
		colorBeach     (0.362, 0.270, 0.206, 0.000)
		colorDesert    (0.615, 0.460, 0.350, 0.000)
		colorLowland   (0.586, 0.476, 0.391, 0.000)
		colorUpland    (0.673, 0.503, 0.383, 0.000)
		colorRock      (1.000, 1.000, 1.000, 0.500)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.586, 0.476, 0.391, 0.000)
		colorUpPlants  (0.673, 0.503, 0.383, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           0.997535
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Pluto"
		Height          107.308
		Density         0.000246456
		Pressure        3.48986e-005
		Greenhouse      0.0511582
		Bright          3.00849
		Opacity         0
		SkyLight        1.00283
		Hue             -0.0369508
		Saturation      1

		Composition
		{
			N2    	99.9732
			Ne    	0.0231774
			CO    	0.00284346
			Ar    	0.00077529
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0129578
		Period          0.0873448
		Eccentricity    0.0488542
		Inclination     0.763006
		AscendingNode   148.743
		ArgOfPericenter -104.583
		MeanAnomaly     -178.1
	}
}

Moon	"2.7"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            6.48267e-005
	Radius          354.488
	InertiaMoment   0.399166

	Obliquity       -0.424202
	EqAscendNode    125.086
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.685 0.525 0.452)

	Surface
	{
		SurfStyle       0.133843
		OceanStyle      0.677493
		Randomize      (-0.824, -0.570, -0.517)
		colorDistMagn   0.0544922
		colorDistFreq   36.9682
		detailScale     911.763
		colorConversion true
		drivenDarkening 0.288212
		seaLevel        0.193936
		snowLevel       2
		tropicLatitude  0.00682717
		icecapLatitude  0.496817
		icecapHeight    0.211475
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.7866
		venusFreq       1.21442
		venusMagn       0
		mareFreq        0
		mareDensity     6.11942e-005
		terraceProb     0.166067
		erosion         0
		montesMagn      0.0593995
		montesFreq      22.171
		montesSpiky     0.881971
		montesFraction  0.187732
		dunesMagn       0.052724
		dunesFreq       477.783
		dunesFraction   0.80019
		hillsMagn       0.146186
		hillsFreq       37.1262
		hillsFraction   0.0320781
		hills2Fraction  0.296292
		riversMagn      58.9705
		riversFreq      2.46111
		riversSin       5.72452
		riversOctaves   0
		canyonsMagn     0.631302
		canyonsFreq     0.155535
		canyonFraction  0
		cracksMagn      0.0262909
		cracksFreq      0.0795503
		cracksOctaves   0
		craterMagn      0.593158
		craterFreq      0.636582
		craterDensity   0.892786
		craterOctaves   8
		craterRayedFactor 0.158852
		volcanoMagn     0.216496
		volcanoFreq     0.664038
		volcanoDensity  0.0595591
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.272101
		volcanoRadius   1.14594
		volcanoTemp     1178.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.685, 0.525, 0.452, 0.500)
		colorShelf     (0.651, 0.499, 0.429, 0.500)
		colorBeach     (0.480, 0.368, 0.316, 0.750)
		colorDesert    (0.583, 0.446, 0.384, 1.000)
		colorLowland   (0.603, 0.462, 0.398, 1.000)
		colorUpland    (0.637, 0.488, 0.420, 1.000)
		colorRock      (1.000, 1.000, 1.000, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.603, 0.462, 0.398, 1.000)
		colorUpPlants  (0.637, 0.488, 0.420, 1.000)
		BumpHeight      17.7244
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0189721
		Period          0.154821
		Eccentricity    0.00329402
		Inclination     -0.424202
		AscendingNode   125.086
		ArgOfPericenter -39.8022
		MeanAnomaly     -71.4079
	}
}

Moon	"2.8"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            0.000135434
	Radius          426.309
	InertiaMoment   0.398633

	Obliquity       -1.00464
	EqAscendNode    85.3812
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.633 0.473 0.377)

	Surface
	{
		SurfStyle       0.416616
		OceanStyle      0.458223
		Randomize      (-0.180, -0.748, 0.342)
		colorDistMagn   0.053802
		colorDistFreq   41.1534
		detailScale     1096.49
		colorConversion true
		drivenDarkening 0.196846
		seaLevel        0.092722
		snowLevel       2
		tropicLatitude  0.0257729
		icecapLatitude  0.68846
		icecapHeight    0.11323
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.95633
		venusFreq       0.968323
		venusMagn       0.224043
		mareFreq        0
		mareDensity     0.000133895
		terraceProb     0.21682
		erosion         0
		montesMagn      0.0553027
		montesFreq      22.1373
		montesSpiky     0.92088
		montesFraction  0.162176
		dunesMagn       0.0330281
		dunesFreq       561.322
		dunesFraction   0.903169
		hillsMagn       0.141101
		hillsFreq       50.1203
		hillsFraction   0.38878
		hills2Fraction  0.0128945
		riversMagn      62.847
		riversFreq      2.68423
		riversSin       5.69292
		riversOctaves   0
		canyonsMagn     0.399942
		canyonsFreq     0.144863
		canyonFraction  0
		cracksMagn      0.0247267
		cracksFreq      0.141228
		cracksOctaves   0
		craterMagn      0.570343
		craterFreq      0.803905
		craterDensity   0.802597
		craterOctaves   9
		craterRayedFactor 0.379444
		volcanoMagn     0.245281
		volcanoFreq     1.14583
		volcanoDensity  0.0568801
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.328393
		volcanoRadius   1.64523
		volcanoTemp     1136.25
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.633, 0.473, 0.377, 0.500)
		colorShelf     (0.601, 0.449, 0.358, 0.500)
		colorBeach     (0.443, 0.331, 0.264, 0.750)
		colorDesert    (0.538, 0.402, 0.321, 1.000)
		colorLowland   (0.557, 0.416, 0.332, 1.000)
		colorUpland    (0.589, 0.440, 0.351, 1.000)
		colorRock      (1.000, 1.000, 1.000, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.557, 0.416, 0.332, 1.000)
		colorUpPlants  (0.589, 0.440, 0.351, 1.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0277781
		Period          0.274289
		Eccentricity    0.00688633
		Inclination     -1.00464
		AscendingNode   85.3812
		ArgOfPericenter 84.4506
		MeanAnomaly     -122.286
	}
}

DwarfMoon	"2.D12"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.89597e-011
	Radius          6.36654
	InertiaMoment   0.398306

	RotationPeriod  1867.01
	Obliquity       -104.921
	EqAscendNode    -117.478

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.475 0.404 0.352)

	Surface
	{
		SurfStyle       0.472825
		OceanStyle      0.928251
		Randomize      (0.234, 0.985, 0.815)
		colorDistMagn   0.327619
		colorDistFreq   0.010733
		detailScale     173.849
		colorConversion true
		snowLevel       2
		tropicLatitude  0.985708
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.733019
		terraceProb     0.453812
		erosion         0
		montesMagn      0.430398
		montesFreq      2.62928
		montesSpiky     0.779254
		montesFraction  0.722762
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.112197
		hillsFraction   0.644842
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.229402
		craterFreq      0.263694
		craterDensity   0.756195
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   120.202
		volcanoTemp     1397.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.190, 0.162, 0.141, 0.000)
		colorShelf     (0.202, 0.172, 0.149, 0.000)
		colorBeach     (0.214, 0.182, 0.158, 0.000)
		colorDesert    (0.225, 0.192, 0.167, 0.000)
		colorLowland   (0.237, 0.202, 0.176, 0.000)
		colorUpland    (0.249, 0.212, 0.185, 0.000)
		colorRock      (0.261, 0.222, 0.193, 0.000)
		colorSnow      (0.273, 0.232, 0.202, 1.000)
		BumpHeight      5.72989
		BumpOffset      1.14598
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.150935
		Period          3.47409
		Eccentricity    0.40497
		Inclination     -53.3782
		AscendingNode   -114.537
		ArgOfPericenter -84.988
		MeanAnomaly     169.058
	}
}

DwarfMoon	"2.D13"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.1523e-010
	Radius          7.07674
	InertiaMoment   0.399355

	RotationPeriod  1624.69
	Obliquity       -109.65
	EqAscendNode    -1.6427

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.487 0.479 0.475)

	Surface
	{
		SurfStyle       0.127528
		OceanStyle      0.32039
		Randomize      (0.938, -0.869, 0.404)
		colorDistMagn   0.684751
		colorDistFreq   0.0174561
		detailScale     193.242
		colorConversion true
		snowLevel       2
		tropicLatitude  0.030824
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.515012
		terraceProb     0.52391
		erosion         0
		montesMagn      0.468686
		montesFreq      3.07012
		montesSpiky     0.936288
		montesFraction  0.483651
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.136285
		hillsFraction   0.655915
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.196167
		craterFreq      0.229646
		craterDensity   0.758031
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   103.361
		volcanoTemp     1733.48
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.195, 0.192, 0.190, 0.000)
		colorShelf     (0.207, 0.204, 0.202, 0.000)
		colorBeach     (0.219, 0.216, 0.214, 0.000)
		colorDesert    (0.231, 0.228, 0.225, 0.000)
		colorLowland   (0.244, 0.240, 0.237, 0.000)
		colorUpland    (0.256, 0.251, 0.249, 0.000)
		colorRock      (0.268, 0.263, 0.261, 0.000)
		colorSnow      (0.280, 0.275, 0.273, 1.000)
		BumpHeight      6.36906
		BumpOffset      1.27381
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.151281
		Period          3.48605
		Eccentricity    0.18274
		Inclination     -69.3218
		AscendingNode   -1.52975
		ArgOfPericenter 82.1758
		MeanAnomaly     65.0359
	}
}

DwarfMoon	"2.D14"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.8478e-010
	Radius          7.94644
	InertiaMoment   0.39668

	RotationPeriod  1446.81
	Obliquity       -59.3429
	EqAscendNode    166.53

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.459 0.454 0.452)

	Surface
	{
		SurfStyle       0.885312
		OceanStyle      0.977096
		Randomize      (-0.720, 0.412, 0.648)
		colorDistMagn   0.360091
		colorDistFreq   0.0322524
		detailScale     216.991
		colorConversion true
		snowLevel       2
		tropicLatitude  0.223225
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.28462
		terraceProb     0.292323
		erosion         0
		montesMagn      0.462049
		montesFreq      3.50585
		montesSpiky     0.864961
		montesFraction  0.614714
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.164744
		hillsFraction   0.781433
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.245559
		craterFreq      0.275925
		craterDensity   0.928908
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   91.6538
		volcanoTemp     1603.78
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.156, 0.159, 0.181, 0.050)
		colorShelf     (0.183, 0.186, 0.208, 0.040)
		colorBeach     (0.211, 0.213, 0.235, 0.030)
		colorDesert    (0.238, 0.241, 0.267, 0.020)
		colorLowland   (0.266, 0.268, 0.294, 0.030)
		colorUpland    (0.293, 0.295, 0.321, 0.050)
		colorRock      (0.321, 0.322, 0.357, 0.020)
		colorSnow      (0.321, 0.322, 0.357, 1.000)
		BumpHeight      7.1518
		BumpOffset      1.43036
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.151863
		Period          3.50616
		Eccentricity    0.184155
		Inclination     -66.8187
		AscendingNode   168.192
		ArgOfPericenter 153.625
		MeanAnomaly     -74.0475
	}
}

DwarfMoon	"2.D15"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.86889e-010
	Radius          8.80355
	InertiaMoment   0.398479

	RotationPeriod  1297.64
	Obliquity       87.8773
	EqAscendNode    -94.0523

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.788 0.701 0.634)

	Surface
	{
		SurfStyle       0.699028
		OceanStyle      0.175096
		Randomize      (-0.490, 0.545, 0.596)
		colorDistMagn   0.816395
		colorDistFreq   0.0229841
		detailScale     240.396
		colorConversion true
		snowLevel       2
		tropicLatitude  0.994962
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.390293
		terraceProb     0.351961
		erosion         0
		montesMagn      0.447361
		montesFreq      2.75543
		montesSpiky     0.975822
		montesFraction  0.41396
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.142658
		hillsFraction   0.835956
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.216308
		craterFreq      0.239327
		craterDensity   0.814267
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   81.4904
		volcanoTemp     1128.73
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.307, 0.238, 0.177, 0.000)
		colorShelf     (0.315, 0.245, 0.203, 0.000)
		colorBeach     (0.370, 0.288, 0.241, 0.000)
		colorDesert    (0.402, 0.309, 0.234, 0.000)
		colorLowland   (0.441, 0.330, 0.266, 0.000)
		colorUpland    (0.489, 0.400, 0.323, 0.000)
		colorRock      (0.528, 0.435, 0.348, 0.000)
		colorSnow      (0.575, 0.463, 0.367, 1.000)
		BumpHeight      7.92319
		BumpOffset      1.58464
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.152202
		Period          3.51791
		Eccentricity    0.286574
		Inclination     67.5701
		AscendingNode   -95.3496
		ArgOfPericenter -52.0949
		MeanAnomaly     -13.1083
	}
}

DwarfMoon	"2.D16"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.34038e-010
	Radius          11.9635
	InertiaMoment   0.399485

	RotationPeriod  1426.95
	Obliquity       14.7495
	EqAscendNode    -1.23085

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.791 0.788 0.786)

	Surface
	{
		SurfStyle       0.00419718
		OceanStyle      0.552209
		Randomize      (-0.954, 0.653, -0.298)
		colorDistMagn   0.878309
		colorDistFreq   0.0314627
		detailScale     326.684
		colorConversion true
		snowLevel       2
		tropicLatitude  0.933036
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.67379
		terraceProb     0.27184
		erosion         0
		montesMagn      0.342939
		montesFreq      3.76052
		montesSpiky     0.911867
		montesFraction  0.216344
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.413376
		hillsFraction   0.655851
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.253207
		craterFreq      0.237291
		craterDensity   0.861685
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   90.0328
		volcanoTemp     1634.67
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.316, 0.315, 0.314, 0.000)
		colorShelf     (0.336, 0.335, 0.334, 0.000)
		colorBeach     (0.356, 0.355, 0.353, 0.000)
		colorDesert    (0.376, 0.374, 0.373, 0.000)
		colorLowland   (0.395, 0.394, 0.393, 0.000)
		colorUpland    (0.415, 0.414, 0.412, 0.000)
		colorRock      (0.435, 0.434, 0.432, 0.000)
		colorSnow      (0.455, 0.453, 0.452, 1.000)
		BumpHeight      10.7672
		BumpOffset      2.15343
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.152806
		Period          3.53887
		Eccentricity    0.00532504
		Inclination     54.188
		AscendingNode   3.55185
		ArgOfPericenter 2.00063
		MeanAnomaly     -49.3947
	}
}

DwarfMoon	"2.D17"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.4296e-010
	Radius          12.6371
	InertiaMoment   0.397098

	RotationPeriod  1244.56
	Obliquity       107.768
	EqAscendNode    126.392

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.817 0.785 0.752)

	Surface
	{
		SurfStyle       0.161088
		OceanStyle      0.0171717
		Randomize      (0.926, -0.600, 0.740)
		colorDistMagn   0.677566
		colorDistFreq   0.0601055
		detailScale     345.077
		colorConversion true
		snowLevel       2
		tropicLatitude  0.927536
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.662048
		terraceProb     0.240941
		erosion         0
		montesMagn      0.627727
		montesFreq      2.6555
		montesSpiky     0.823345
		montesFraction  0.21024
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.286788
		hillsFraction   0.645352
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.258209
		craterFreq      0.264737
		craterDensity   0.868999
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   78.1378
		volcanoTemp     1384.43
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.327, 0.314, 0.301, 0.000)
		colorShelf     (0.347, 0.334, 0.319, 0.000)
		colorBeach     (0.367, 0.353, 0.338, 0.000)
		colorDesert    (0.388, 0.373, 0.357, 0.000)
		colorLowland   (0.408, 0.393, 0.376, 0.000)
		colorUpland    (0.429, 0.412, 0.395, 0.000)
		colorRock      (0.449, 0.432, 0.413, 0.000)
		colorSnow      (0.470, 0.452, 0.432, 1.000)
		BumpHeight      11.3734
		BumpOffset      2.27468
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.153262
		Period          3.55473
		Eccentricity    0.408746
		Inclination     61.6359
		AscendingNode   128.243
		ArgOfPericenter 81.4146
		MeanAnomaly     -47.0958
	}
}

DwarfMoon	"2.D18"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            9.3604e-010
	Radius          13.7243
	InertiaMoment   0.398641

	RotationPeriod  1128.11
	Obliquity       65.7484
	EqAscendNode    19.9537

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.645 0.644 0.641)

	Surface
	{
		SurfStyle       0.740729
		OceanStyle      0.521963
		Randomize      (-0.656, -0.752, 0.096)
		colorDistMagn   0.764839
		colorDistFreq   0.107405
		detailScale     374.764
		colorConversion true
		snowLevel       2
		tropicLatitude  0.949983
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.369447
		terraceProb     0.381869
		erosion         0
		montesMagn      0.566973
		montesFreq      2.87194
		montesSpiky     0.917851
		montesFraction  0.747806
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.521248
		hillsFraction   0.880648
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236202
		craterFreq      0.173793
		craterDensity   0.935682
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   70.3311
		volcanoTemp     1376.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.252, 0.219, 0.179, 0.000)
		colorShelf     (0.258, 0.225, 0.205, 0.000)
		colorBeach     (0.303, 0.264, 0.244, 0.000)
		colorDesert    (0.329, 0.283, 0.237, 0.000)
		colorLowland   (0.361, 0.303, 0.269, 0.000)
		colorUpland    (0.400, 0.367, 0.327, 0.000)
		colorRock      (0.432, 0.399, 0.353, 0.000)
		colorSnow      (0.471, 0.425, 0.372, 1.000)
		BumpHeight      12.3518
		BumpOffset      2.47037
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.153511
		Period          3.56341
		Eccentricity    0.314472
		Inclination     6.23517
		AscendingNode   14.164
		ArgOfPericenter 52.7464
		MeanAnomaly     20.549
	}
}

DwarfMoon	"2.D19"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.3432e-009
	Radius          14.8376
	InertiaMoment   0.399613

	RotationPeriod  1023.99
	Obliquity       -137.104
	EqAscendNode    -15.308

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.470 0.465 0.460)

	Surface
	{
		SurfStyle       0.289082
		OceanStyle      0.807557
		Randomize      (0.969, -0.948, -0.079)
		colorDistMagn   0.396295
		colorDistFreq   0.0681983
		detailScale     405.164
		colorConversion true
		snowLevel       2
		tropicLatitude  0.438456
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.601115
		terraceProb     0.233659
		erosion         0
		montesMagn      0.233497
		montesFreq      3.59499
		montesSpiky     0.928369
		montesFraction  0.302616
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.553347
		hillsFraction   0.485231
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.272352
		craterFreq      0.237285
		craterDensity   0.975845
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   63.4743
		volcanoTemp     1384.75
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.188, 0.186, 0.184, 0.000)
		colorShelf     (0.200, 0.197, 0.196, 0.000)
		colorBeach     (0.211, 0.209, 0.207, 0.000)
		colorDesert    (0.223, 0.221, 0.219, 0.000)
		colorLowland   (0.235, 0.232, 0.230, 0.000)
		colorUpland    (0.247, 0.244, 0.242, 0.000)
		colorRock      (0.258, 0.256, 0.253, 0.000)
		colorSnow      (0.270, 0.267, 0.265, 1.000)
		BumpHeight      13.3538
		BumpOffset      2.67076
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.153767
		Period          3.57232
		Eccentricity    0.266977
		Inclination     -60.9012
		AscendingNode   -24.2021
		ArgOfPericenter -121.231
		MeanAnomaly     -178.359
	}
}

DwarfMoon	"2.D20"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.90442e-009
	Radius          20.1016
	InertiaMoment   0.397417

	RotationPeriod  1155.04
	Obliquity       50.845
	EqAscendNode    7.98282

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.748 0.704 0.629)

	Surface
	{
		SurfStyle       0.917222
		OceanStyle      0.78986
		Randomize      (-0.940, -0.973, 0.868)
		colorDistMagn   0.760486
		colorDistFreq   0.1661
		detailScale     548.908
		colorConversion true
		snowLevel       2
		tropicLatitude  0.999992
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.540141
		terraceProb     0.38915
		erosion         0
		montesMagn      0.431757
		montesFreq      2.70817
		montesSpiky     0.957789
		montesFraction  0.765433
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.05738
		hillsFraction   0.474921
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.235072
		craterFreq      0.237472
		craterDensity   0.787081
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   72.2197
		volcanoTemp     1815.9
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.254, 0.247, 0.251, 0.050)
		colorShelf     (0.299, 0.289, 0.289, 0.040)
		colorBeach     (0.344, 0.331, 0.327, 0.030)
		colorDesert    (0.389, 0.373, 0.371, 0.020)
		colorLowland   (0.434, 0.416, 0.409, 0.030)
		colorUpland    (0.479, 0.458, 0.446, 0.050)
		colorRock      (0.523, 0.500, 0.497, 0.020)
		colorSnow      (0.523, 0.500, 0.497, 1.000)
		BumpHeight      18.0914
		BumpOffset      3.61829
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.15416
		Period          3.58602
		Eccentricity    0.296358
		Inclination     39.4512
		AscendingNode   -3.87199
		ArgOfPericenter 176.01
		MeanAnomaly     148.511
	}
}

DwarfMoon	"2.D21"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.67313e-009
	Radius          20.4675
	InertiaMoment   0.398794

	RotationPeriod  1001.05
	Obliquity       21.3759
	EqAscendNode    -71.0249

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.699 0.645 0.590)

	Surface
	{
		SurfStyle       0.658416
		OceanStyle      0.781043
		Randomize      (0.287, -0.759, -0.241)
		colorDistMagn   0.340896
		colorDistFreq   0.177495
		detailScale     558.898
		colorConversion true
		snowLevel       2
		tropicLatitude  0.673045
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.473372
		terraceProb     0.3091
		erosion         0
		montesMagn      0.573724
		montesFreq      2.71475
		montesSpiky     0.918281
		montesFraction  0.64063
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.792193
		hillsFraction   0.450975
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.270371
		craterFreq      0.232497
		craterDensity   0.775698
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   62.0669
		volcanoTemp     1490.6
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.272, 0.219, 0.165, 0.000)
		colorShelf     (0.279, 0.226, 0.189, 0.000)
		colorBeach     (0.328, 0.264, 0.224, 0.000)
		colorDesert    (0.356, 0.284, 0.218, 0.000)
		colorLowland   (0.391, 0.303, 0.248, 0.000)
		colorUpland    (0.433, 0.368, 0.301, 0.000)
		colorRock      (0.468, 0.400, 0.325, 0.000)
		colorSnow      (0.510, 0.426, 0.342, 1.000)
		BumpHeight      18.4207
		BumpOffset      3.68414
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.154724
		Period          3.60571
		Eccentricity    0.45838
		Inclination     34.1987
		AscendingNode   -81.4112
		ArgOfPericenter 94.8235
		MeanAnomaly     13.114
	}
}

DwarfMoon	"2.D22"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.72087e-009
	Radius          21.8633
	InertiaMoment   0.39974

	RotationPeriod  910.999
	Obliquity       -13.6744
	EqAscendNode    25.6353

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.739 0.686 0.600)

	Surface
	{
		SurfStyle       0.221249
		OceanStyle      0.764505
		Randomize      (0.702, -0.064, 0.140)
		colorDistMagn   0.845594
		colorDistFreq   0.284243
		detailScale     597.013
		colorConversion true
		snowLevel       2
		tropicLatitude  0.208881
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.457508
		terraceProb     0.466339
		erosion         0
		montesMagn      0.451721
		montesFreq      3.5866
		montesSpiky     0.937912
		montesFraction  0.243424
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.24931
		hillsFraction   0.657637
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.222242
		craterFreq      0.258474
		craterDensity   0.766573
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   56.1952
		volcanoTemp     2038.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.296, 0.275, 0.240, 0.000)
		colorShelf     (0.314, 0.292, 0.255, 0.000)
		colorBeach     (0.332, 0.309, 0.270, 0.000)
		colorDesert    (0.351, 0.326, 0.285, 0.000)
		colorLowland   (0.369, 0.343, 0.300, 0.000)
		colorUpland    (0.388, 0.360, 0.315, 0.000)
		colorRock      (0.406, 0.378, 0.330, 0.000)
		colorSnow      (0.425, 0.395, 0.345, 1.000)
		BumpHeight      19.6769
		BumpOffset      3.93539
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.154933
		Period          3.61302
		Eccentricity    0.155762
		Inclination     23.7499
		AscendingNode   21.5197
		ArgOfPericenter 81.9763
		MeanAnomaly     154.915
	}
}

DwarfMoon	"2.D23"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            5.14354e-009
	Radius          23.3719
	InertiaMoment   0.397682

	RotationPeriod  829.101
	Obliquity       27.6587
	EqAscendNode    177.624

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.449 0.444 0.440)

	Surface
	{
		SurfStyle       0.778376
		OceanStyle      0.755587
		Randomize      (0.656, 0.742, -0.362)
		colorDistMagn   0.569876
		colorDistFreq   0.331486
		detailScale     638.209
		colorConversion true
		snowLevel       2
		tropicLatitude  0.236376
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.463588
		terraceProb     0.214353
		erosion         0
		montesMagn      0.560762
		montesFreq      2.33487
		montesSpiky     0.992899
		montesFraction  0.381023
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.43351
		hillsFraction   0.361049
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.261169
		craterFreq      0.199411
		craterDensity   1.05302
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   51.0939
		volcanoTemp     1789.07
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.175, 0.151, 0.123, 0.000)
		colorShelf     (0.180, 0.156, 0.141, 0.000)
		colorBeach     (0.211, 0.182, 0.167, 0.000)
		colorDesert    (0.229, 0.196, 0.163, 0.000)
		colorLowland   (0.252, 0.209, 0.185, 0.000)
		colorUpland    (0.279, 0.253, 0.224, 0.000)
		colorRock      (0.301, 0.275, 0.242, 0.000)
		colorSnow      (0.328, 0.293, 0.255, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.155276
		Period          3.62504
		Eccentricity    0.240715
		Inclination     14.0856
		AscendingNode   175.118
		ArgOfPericenter 165.72
		MeanAnomaly     1.28236
	}
}

DwarfMoon	"2.D24"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            7.07011e-009
	Radius          32.9434
	InertiaMoment   0.398941

	RotationPeriod  991.137
	Obliquity       -55.9133
	EqAscendNode    106.455

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.636 0.632 0.627)

	Surface
	{
		SurfStyle       0.537969
		OceanStyle      0.424915
		Randomize      (-0.748, -0.232, -0.801)
		colorDistMagn   0.539482
		colorDistFreq   0.131542
		detailScale     899.575
		colorConversion true
		snowLevel       2
		tropicLatitude  0.861743
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.480321
		terraceProb     0.338142
		erosion         0
		montesMagn      0.475945
		montesFreq      2.81444
		montesSpiky     0.962566
		montesFraction  0.620283
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.83486
		hillsFraction   0.716806
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.279034
		craterFreq      0.20802
		craterDensity   0.899856
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   61.4273
		volcanoTemp     1370.21
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.248, 0.215, 0.175, 0.000)
		colorShelf     (0.254, 0.221, 0.201, 0.000)
		colorBeach     (0.299, 0.259, 0.238, 0.000)
		colorDesert    (0.324, 0.278, 0.232, 0.000)
		colorLowland   (0.356, 0.297, 0.263, 0.000)
		colorUpland    (0.394, 0.360, 0.320, 0.000)
		colorRock      (0.426, 0.392, 0.345, 0.000)
		colorSnow      (0.464, 0.417, 0.363, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.155869
		Period          3.64582
		Eccentricity    0.398735
		Inclination     -44.9202
		AscendingNode   100.891
		ArgOfPericenter -116.628
		MeanAnomaly     -39.6216
	}
}

DwarfMoon	"2.D25"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            9.67453e-009
	Radius          31.6709
	InertiaMoment   0.399865

	RotationPeriod  821.577
	Obliquity       115.177
	EqAscendNode    27.1187

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.691 0.633 0.602)

	Surface
	{
		SurfStyle       0.872591
		OceanStyle      0.433644
		Randomize      (-0.457, -0.620, 0.888)
		colorDistMagn   0.832978
		colorDistFreq   0.693307
		detailScale     864.827
		colorConversion true
		snowLevel       2
		tropicLatitude  0.280232
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.498399
		terraceProb     0.162111
		erosion         0
		montesMagn      0.53863
		montesFreq      2.21645
		montesSpiky     0.853547
		montesFraction  0.340436
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.3818
		hillsFraction   0.412906
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.239914
		craterFreq      0.257098
		craterDensity   0.821024
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   50.4837
		volcanoTemp     1699.89
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.235, 0.222, 0.241, 0.050)
		colorShelf     (0.276, 0.260, 0.277, 0.040)
		colorBeach     (0.318, 0.298, 0.313, 0.030)
		colorDesert    (0.359, 0.336, 0.355, 0.020)
		colorLowland   (0.401, 0.374, 0.391, 0.030)
		colorUpland    (0.442, 0.412, 0.428, 0.050)
		colorRock      (0.484, 0.450, 0.476, 0.020)
		colorSnow      (0.484, 0.450, 0.476, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.156456
		Period          3.66641
		Eccentricity    0.313636
		Inclination     74.9305
		AscendingNode   13.6129
		ArgOfPericenter -148.608
		MeanAnomaly     46.5491
	}
}

DwarfMoon	"2.D26"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.31924e-008
	Radius          33.5281
	InertiaMoment   0.397911

	RotationPeriod  745.447
	Obliquity       -101.001
	EqAscendNode    -151.862

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.695 0.693 0.691)

	Surface
	{
		SurfStyle       0.0190932
		OceanStyle      0.32946
		Randomize      (-0.153, 0.469, -0.737)
		colorDistMagn   0.763724
		colorDistFreq   0.16275
		detailScale     915.541
		colorConversion true
		snowLevel       2
		tropicLatitude  0.562088
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.510787
		terraceProb     0.140087
		erosion         0
		montesMagn      0.660176
		montesFreq      3.10229
		montesSpiky     0.716243
		montesFraction  0.427018
		dunesFraction   0
		hillsMagn       0
		hillsFreq       3.2244
		hillsFraction   0.653421
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.201266
		craterFreq      0.210286
		craterDensity   0.829635
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   45.7672
		volcanoTemp     1537.57
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.278, 0.277, 0.277, 0.000)
		colorShelf     (0.295, 0.295, 0.294, 0.000)
		colorBeach     (0.313, 0.312, 0.311, 0.000)
		colorDesert    (0.330, 0.329, 0.328, 0.000)
		colorLowland   (0.347, 0.347, 0.346, 0.000)
		colorUpland    (0.365, 0.364, 0.363, 0.000)
		colorRock      (0.382, 0.381, 0.380, 0.000)
		colorSnow      (0.399, 0.399, 0.398, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.157018
		Period          3.68621
		Eccentricity    0.113847
		Inclination     -78.3249
		AscendingNode   -154.228
		ArgOfPericenter -62.0396
		MeanAnomaly     -121.785
	}
}

DwarfMoon	"2.D27"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.79441e-008
	Radius          35.674
	InertiaMoment   0.399082

	RotationPeriod  682.942
	Obliquity       -30.4504
	EqAscendNode    -59.9464

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.495 0.446 0.351)

	Surface
	{
		SurfStyle       0.79892
		OceanStyle      0.0393899
		Randomize      (0.248, 0.384, -0.411)
		colorDistMagn   0.345827
		colorDistFreq   0.455537
		detailScale     974.139
		colorConversion true
		snowLevel       2
		tropicLatitude  0.685291
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.383511
		terraceProb     0.220641
		erosion         0
		montesMagn      0.496116
		montesFreq      3.77077
		montesSpiky     0.83112
		montesFraction  0.451155
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.62746
		hillsFraction   0.625284
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.231578
		craterFreq      0.26281
		craterDensity   0.844755
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.7539
		volcanoTemp     1501.5
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.193, 0.152, 0.098, 0.000)
		colorShelf     (0.198, 0.156, 0.112, 0.000)
		colorBeach     (0.233, 0.183, 0.133, 0.000)
		colorDesert    (0.253, 0.196, 0.130, 0.000)
		colorLowland   (0.277, 0.210, 0.148, 0.000)
		colorUpland    (0.307, 0.254, 0.179, 0.000)
		colorRock      (0.332, 0.277, 0.193, 0.000)
		colorSnow      (0.362, 0.294, 0.204, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.157264
		Period          3.69488
		Eccentricity    0.0999414
		Inclination     -21.1292
		AscendingNode   -65.471
		ArgOfPericenter 158.059
		MeanAnomaly     48.2631
	}
}

DwarfMoon	"2.D28"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.43681e-008
	Radius          36.6928
	InertiaMoment   0.39999

	RotationPeriod  605.516
	Obliquity       35.8309
	EqAscendNode    -69.7724

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.794 0.792 0.790)

	Surface
	{
		SurfStyle       0.236289
		OceanStyle      0.277036
		Randomize      (0.747, 0.849, -0.562)
		colorDistMagn   0.532173
		colorDistFreq   0.772611
		detailScale     1001.96
		colorConversion true
		snowLevel       2
		tropicLatitude  0.997242
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.445572
		terraceProb     0.214121
		erosion         0
		montesMagn      0.522475
		montesFreq      2.72428
		montesSpiky     0.848828
		montesFraction  0.274005
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.80025
		hillsFraction   0.621908
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.266999
		craterFreq      0.268343
		craterDensity   1.01543
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   36.8532
		volcanoTemp     1501.63
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.317, 0.317, 0.316, 0.000)
		colorShelf     (0.337, 0.337, 0.336, 0.000)
		colorBeach     (0.357, 0.356, 0.356, 0.000)
		colorDesert    (0.377, 0.376, 0.375, 0.000)
		colorLowland   (0.397, 0.396, 0.395, 0.000)
		colorUpland    (0.417, 0.416, 0.415, 0.000)
		colorRock      (0.436, 0.436, 0.435, 0.000)
		colorSnow      (0.456, 0.455, 0.454, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.157478
		Period          3.70242
		Eccentricity    0.253436
		Inclination     70.3048
		AscendingNode   -68.8328
		ArgOfPericenter -28.9546
		MeanAnomaly     -173.065
	}
}

DwarfMoon	"2.D29"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.30675e-008
	Radius          48.1188
	InertiaMoment   0.398116

	RotationPeriod  677.869
	Obliquity       -3.52526
	EqAscendNode    -99.9245

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.565 0.385 0.306)

	Surface
	{
		SurfStyle       0.493157
		OceanStyle      0.726533
		Randomize      (-0.082, 0.398, 0.944)
		colorDistMagn   0.945764
		colorDistFreq   1.69012
		detailScale     1313.96
		colorConversion true
		snowLevel       2
		tropicLatitude  0.348088
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.55433
		terraceProb     0.120493
		erosion         0
		montesMagn      0.532845
		montesFreq      3.59137
		montesSpiky     0.857123
		montesFraction  0.944373
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.58234
		hillsFraction   0.651016
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236767
		craterFreq      0.266286
		craterDensity   0.796724
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.4878
		volcanoTemp     1139.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.226, 0.154, 0.123, 0.000)
		colorShelf     (0.240, 0.163, 0.130, 0.000)
		colorBeach     (0.254, 0.173, 0.138, 0.000)
		colorDesert    (0.268, 0.183, 0.146, 0.000)
		colorLowland   (0.283, 0.192, 0.153, 0.000)
		colorUpland    (0.297, 0.202, 0.161, 0.000)
		colorRock      (0.311, 0.212, 0.168, 0.000)
		colorSnow      (0.325, 0.221, 0.176, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.158074
		Period          3.72346
		Eccentricity    0.0268227
		Inclination     -21.1302
		AscendingNode   -106.953
		ArgOfPericenter -59.2669
		MeanAnomaly     -162.782
	}
}

DwarfMoon	"2.D30"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.48782e-008
	Radius          50.7177
	InertiaMoment   0.399219

	RotationPeriod  615.813
	Obliquity       63.7265
	EqAscendNode    -41.3799

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.640 0.636 0.632)

	Surface
	{
		SurfStyle       0.76385
		OceanStyle      0.791004
		Randomize      (0.943, -0.805, -0.744)
		colorDistMagn   0.792409
		colorDistFreq   0.968253
		detailScale     1384.93
		colorConversion true
		snowLevel       2
		tropicLatitude  0.999893
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.625767
		terraceProb     0.565008
		erosion         0
		montesMagn      0.48829
		montesFreq      3.35635
		montesSpiky     0.917847
		montesFraction  0.559495
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.5512
		hillsFraction   0.873007
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233029
		craterFreq      0.188158
		craterDensity   0.886391
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.536
		volcanoTemp     1830.46
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.249, 0.216, 0.177, 0.000)
		colorShelf     (0.256, 0.223, 0.202, 0.000)
		colorBeach     (0.301, 0.261, 0.240, 0.000)
		colorDesert    (0.326, 0.280, 0.234, 0.000)
		colorLowland   (0.358, 0.299, 0.265, 0.000)
		colorUpland    (0.397, 0.362, 0.322, 0.000)
		colorRock      (0.429, 0.394, 0.347, 0.000)
		colorSnow      (0.467, 0.420, 0.366, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.158471
		Period          3.73749
		Eccentricity    0.414862
		Inclination     32.5231
		AscendingNode   -41.9411
		ArgOfPericenter -2.03075
		MeanAnomaly     -17.2597
	}
}

DwarfMoon	"2.D31"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.09677e-008
	Radius          53.9575
	InertiaMoment   0.396009

	RotationPeriod  561.169
	Obliquity       12.4564
	EqAscendNode    50.1633

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.761 0.692 0.605)

	Surface
	{
		SurfStyle       0.564117
		OceanStyle      0.852528
		Randomize      (-0.338, 0.369, -0.016)
		colorDistMagn   0.532925
		colorDistFreq   1.58694
		detailScale     1473.4
		colorConversion true
		snowLevel       2
		tropicLatitude  0.304259
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.440494
		terraceProb     0.370723
		erosion         0
		montesMagn      0.546275
		montesFreq      3.29978
		montesSpiky     0.948932
		montesFraction  0.488553
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.88829
		hillsFraction   0.744392
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247627
		craterFreq      0.180226
		craterDensity   0.934616
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.2616
		volcanoTemp     1677.25
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.297, 0.235, 0.170, 0.000)
		colorShelf     (0.305, 0.242, 0.194, 0.000)
		colorBeach     (0.358, 0.284, 0.230, 0.000)
		colorDesert    (0.388, 0.304, 0.224, 0.000)
		colorLowland   (0.426, 0.325, 0.254, 0.000)
		colorUpland    (0.472, 0.394, 0.309, 0.000)
		colorRock      (0.510, 0.429, 0.333, 0.000)
		colorSnow      (0.556, 0.457, 0.351, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.1587
		Period          3.7456
		Eccentricity    0.307118
		Inclination     6.35715
		AscendingNode   41.5754
		ArgOfPericenter 65.713
		MeanAnomaly     -171.846
	}
}

DwarfMoon	"2.D32"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            8.29808e-008
	Radius          56.3994
	InertiaMoment   0.398302

	RotationPeriod  505.455
	Obliquity       -9.3372
	EqAscendNode    -82.017

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.498 0.494 0.493)

	Surface
	{
		SurfStyle       0.352879
		OceanStyle      0.722412
		Randomize      (0.738, 0.825, -0.799)
		colorDistMagn   0.874443
		colorDistFreq   2.27085
		detailScale     1540.08
		colorConversion true
		snowLevel       2
		tropicLatitude  0.51987
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.451892
		terraceProb     0.365304
		erosion         0
		montesMagn      0.446126
		montesFreq      3.07794
		montesSpiky     0.944683
		montesFraction  0.488153
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.02731
		hillsFraction   0.715929
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247535
		craterFreq      0.217983
		craterDensity   0.952626
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.6967
		volcanoTemp     1072.42
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.199, 0.198, 0.197, 0.000)
		colorShelf     (0.212, 0.210, 0.209, 0.000)
		colorBeach     (0.224, 0.222, 0.222, 0.000)
		colorDesert    (0.237, 0.235, 0.234, 0.000)
		colorLowland   (0.249, 0.247, 0.246, 0.000)
		colorUpland    (0.261, 0.259, 0.259, 0.000)
		colorRock      (0.274, 0.272, 0.271, 0.000)
		colorSnow      (0.286, 0.284, 0.283, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.159225
		Period          3.76418
		Eccentricity    0.121752
		Inclination     -29.0805
		AscendingNode   -84.0943
		ArgOfPericenter 166.613
		MeanAnomaly     -7.96785
	}
}

DwarfMoon	"2.D33"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.13258e-007
	Radius          73.2366
	InertiaMoment   0.399352

	RotationPeriod  561.166
	Obliquity       60.0594
	EqAscendNode    27.7951

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.462 0.389 0.345)

	Surface
	{
		SurfStyle       0.824897
		OceanStyle      0.758977
		Randomize      (0.414, 0.150, -0.682)
		colorDistMagn   0.835599
		colorDistFreq   2.73613
		detailScale     1999.85
		colorConversion true
		snowLevel       2
		tropicLatitude  0.99333
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.517236
		terraceProb     0.421807
		erosion         0
		montesMagn      0.560871
		montesFreq      3.4633
		montesSpiky     0.98665
		montesFraction  0.492018
		dunesFraction   0
		hillsMagn       0
		hillsFreq       13.4483
		hillsFraction   0.75674
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248914
		craterFreq      0.263394
		craterDensity   0.890761
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.1193
		volcanoTemp     1559.39
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.180, 0.132, 0.097, 0.000)
		colorShelf     (0.185, 0.136, 0.110, 0.000)
		colorBeach     (0.217, 0.160, 0.131, 0.000)
		colorDesert    (0.235, 0.171, 0.128, 0.000)
		colorLowland   (0.259, 0.183, 0.145, 0.000)
		colorUpland    (0.286, 0.222, 0.176, 0.000)
		colorRock      (0.309, 0.241, 0.190, 0.000)
		colorSnow      (0.337, 0.257, 0.200, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.159575
		Period          3.7766
		Eccentricity    0.220558
		Inclination     26.7836
		AscendingNode   32.248
		ArgOfPericenter 13.0873
		MeanAnomaly     -127.745
	}
}

DwarfMoon	"2.D34"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.55166e-007
	Radius          77.148
	InertiaMoment   0.396669

	RotationPeriod  504.58
	Obliquity       -36.2612
	EqAscendNode    -151.264

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.496 0.493 0.488)

	Surface
	{
		SurfStyle       0.809401
		OceanStyle      0.12154
		Randomize      (0.777, -0.038, -0.982)
		colorDistMagn   0.181862
		colorDistFreq   3.55851
		detailScale     2106.66
		colorConversion true
		snowLevel       2
		tropicLatitude  0.522094
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.537946
		terraceProb     0.378103
		erosion         0
		montesMagn      0.377991
		montesFreq      2.40295
		montesSpiky     0.778686
		montesFraction  0.903558
		dunesFraction   0
		hillsMagn       0
		hillsFreq       14.5687
		hillsFraction   0.718194
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.249956
		craterFreq      0.198437
		craterDensity   0.746877
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.7066
		volcanoTemp     1592.75
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.194, 0.168, 0.137, 0.000)
		colorShelf     (0.199, 0.172, 0.156, 0.000)
		colorBeach     (0.233, 0.202, 0.186, 0.000)
		colorDesert    (0.253, 0.217, 0.181, 0.000)
		colorLowland   (0.278, 0.232, 0.205, 0.000)
		colorUpland    (0.308, 0.281, 0.249, 0.000)
		colorRock      (0.333, 0.305, 0.269, 0.000)
		colorSnow      (0.362, 0.325, 0.283, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.160164
		Period          3.79752
		Eccentricity    0.105255
		Inclination     -5.36861
		AscendingNode   -154.857
		ArgOfPericenter -120.102
		MeanAnomaly     -16.0951
	}
}

DwarfMoon	"2.D35"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.13613e-007
	Radius          82.4345
	InertiaMoment   0.398475

	RotationPeriod  461.43
	Obliquity       -20.3511
	EqAscendNode    116.463

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.731 0.727 0.723)

	Surface
	{
		SurfStyle       0.678885
		OceanStyle      0.937229
		Randomize      (0.771, 0.078, -0.665)
		colorDistMagn   0.298142
		colorDistFreq   4.53629
		detailScale     2251.01
		colorConversion true
		snowLevel       2
		tropicLatitude  0.753047
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.47953
		terraceProb     0.463537
		erosion         0
		montesMagn      0.583006
		montesFreq      2.73001
		montesSpiky     0.99356
		montesFraction  0.580128
		dunesFraction   0
		hillsMagn       0
		hillsFreq       16.4678
		hillsFraction   0.705638
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.256139
		craterFreq      0.244623
		craterDensity   0.95626
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.9641
		volcanoTemp     1637.15
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.285, 0.247, 0.202, 0.000)
		colorShelf     (0.292, 0.254, 0.231, 0.000)
		colorBeach     (0.343, 0.298, 0.275, 0.000)
		colorDesert    (0.373, 0.320, 0.267, 0.000)
		colorLowland   (0.409, 0.342, 0.304, 0.000)
		colorUpland    (0.453, 0.414, 0.369, 0.000)
		colorRock      (0.490, 0.451, 0.398, 0.000)
		colorSnow      (0.534, 0.480, 0.419, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.160407
		Period          3.80618
		Eccentricity    0.395021
		Inclination     36.0101
		AscendingNode   119.426
		ArgOfPericenter -120.766
		MeanAnomaly     -90.3481
	}
}

DwarfMoon	"2.D36"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.95846e-007
	Radius          87.2864
	InertiaMoment   0.399482

	RotationPeriod  416.509
	Obliquity       73.9667
	EqAscendNode    -135.185

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.506 0.501 0.494)

	Surface
	{
		SurfStyle       0.584348
		OceanStyle      0.668421
		Randomize      (-0.449, 0.763, 0.444)
		colorDistMagn   0.562167
		colorDistFreq   1.43503
		detailScale     2383.5
		colorConversion true
		snowLevel       2
		tropicLatitude  0.96373
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.394663
		terraceProb     0.26244
		erosion         0
		montesMagn      0.479196
		montesFreq      2.41274
		montesSpiky     0.854136
		montesFraction  0.80414
		dunesFraction   0
		hillsMagn       0
		hillsFreq       14.1862
		hillsFraction   0.632688
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.235247
		craterFreq      0.257947
		craterDensity   0.774895
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   25.1605
		volcanoTemp     1535.92
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.197, 0.170, 0.138, 0.000)
		colorShelf     (0.202, 0.175, 0.158, 0.000)
		colorBeach     (0.238, 0.205, 0.188, 0.000)
		colorDesert    (0.258, 0.220, 0.183, 0.000)
		colorLowland   (0.283, 0.235, 0.208, 0.000)
		colorUpland    (0.314, 0.286, 0.252, 0.000)
		colorRock      (0.339, 0.311, 0.272, 0.000)
		colorSnow      (0.369, 0.331, 0.287, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.16078
		Period          3.81948
		Eccentricity    0.085287
		Inclination     -0.719942
		AscendingNode   -140.318
		ArgOfPericenter 158.284
		MeanAnomaly     142.649
	}
}

DwarfMoon	"2.D37"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.12747e-007
	Radius          113.967
	InertiaMoment   0.39709

	RotationPeriod  458.19
	Obliquity       -2.48534
	EqAscendNode    100.75

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.646 0.642 0.638)

	Surface
	{
		SurfStyle       0.951957
		OceanStyle      0.705301
		Randomize      (-0.647, 0.210, -0.607)
		colorDistMagn   0.830764
		colorDistFreq   5.88576
		detailScale     3112.06
		colorConversion true
		snowLevel       2
		tropicLatitude  0.456841
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.472651
		terraceProb     0.102559
		erosion         0
		montesMagn      0.297133
		montesFreq      3.52168
		montesSpiky     0.928184
		montesFraction  0.76288
		dunesFraction   0
		hillsMagn       0
		hillsFreq       27.7097
		hillsFraction   0.626969
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234186
		craterFreq      0.306469
		craterDensity   1.05738
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.8127
		volcanoTemp     1531.41
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.220, 0.225, 0.255, 0.050)
		colorShelf     (0.259, 0.263, 0.293, 0.040)
		colorBeach     (0.297, 0.302, 0.332, 0.030)
		colorDesert    (0.336, 0.340, 0.376, 0.020)
		colorLowland   (0.375, 0.379, 0.415, 0.030)
		colorUpland    (0.414, 0.417, 0.453, 0.050)
		colorRock      (0.452, 0.456, 0.504, 0.020)
		colorSnow      (0.452, 0.456, 0.504, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.161007
		Period          3.82756
		Eccentricity    0.0877753
		Inclination     26.5576
		AscendingNode   102.197
		ArgOfPericenter -140.681
		MeanAnomaly     -98.0809
	}
}

DwarfMoon	"2.D38"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            5.80949e-007
	Radius          120.533
	InertiaMoment   0.398637

	RotationPeriod  410.11
	Obliquity       36.3417
	EqAscendNode    166.272

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.630 0.536 0.361)

	Surface
	{
		SurfStyle       0.236666
		OceanStyle      0.446153
		Randomize      (-0.697, 0.802, -0.619)
		colorDistMagn   0.38094
		colorDistFreq   12.5418
		detailScale     3291.35
		colorConversion true
		snowLevel       2
		tropicLatitude  0.979395
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.415474
		terraceProb     0.256252
		erosion         0
		montesMagn      0.511043
		montesFreq      2.20332
		montesSpiky     0.956807
		montesFraction  0.593048
		dunesFraction   0
		hillsMagn       0
		hillsFreq       31.9501
		hillsFraction   0.499654
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.26615
		craterFreq      0.505871
		craterDensity   0.847893
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   24.7937
		volcanoTemp     1176.26
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.252, 0.214, 0.144, 0.000)
		colorShelf     (0.268, 0.228, 0.153, 0.000)
		colorBeach     (0.283, 0.241, 0.162, 0.000)
		colorDesert    (0.299, 0.254, 0.171, 0.000)
		colorLowland   (0.315, 0.268, 0.180, 0.000)
		colorUpland    (0.331, 0.281, 0.189, 0.000)
		colorRock      (0.346, 0.295, 0.198, 0.000)
		colorSnow      (0.362, 0.308, 0.207, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.16154
		Period          3.84657
		Eccentricity    0.051786
		Inclination     -65.8488
		AscendingNode   169.411
		ArgOfPericenter -117.732
		MeanAnomaly     -79.7509
	}
}

DwarfMoon	"2.D39"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            8.26404e-007
	Radius          130.152
	InertiaMoment   0.39961

	RotationPeriod  372.362
	Obliquity       -8.55266
	EqAscendNode    66.947

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.405 0.403 0.401)

	Surface
	{
		SurfStyle       0.0366906
		OceanStyle      0.589571
		Randomize      (-0.007, -0.661, 0.638)
		colorDistMagn   0.452261
		colorDistFreq   7.71721
		detailScale     3554.02
		colorConversion true
		snowLevel       2
		tropicLatitude  0.765829
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.555711
		terraceProb     0.406648
		erosion         0
		montesMagn      0.494247
		montesFreq      3.09384
		montesSpiky     0.818069
		montesFraction  0.491107
		dunesFraction   0
		hillsMagn       0
		hillsFreq       40.6199
		hillsFraction   0.538974
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24213
		craterFreq      0.558627
		craterDensity   0.809051
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   22.4472
		volcanoTemp     1688.07
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.162, 0.161, 0.160, 0.000)
		colorShelf     (0.172, 0.171, 0.170, 0.000)
		colorBeach     (0.182, 0.181, 0.180, 0.000)
		colorDesert    (0.193, 0.191, 0.190, 0.000)
		colorLowland   (0.203, 0.201, 0.200, 0.000)
		colorUpland    (0.213, 0.211, 0.210, 0.000)
		colorRock      (0.223, 0.222, 0.221, 0.000)
		colorSnow      (0.233, 0.232, 0.231, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.161933
		Period          3.86062
		Eccentricity    0.466738
		Inclination     -46.1427
		AscendingNode   66.8747
		ArgOfPericenter 89.7978
		MeanAnomaly     124.578
	}
}

DwarfMoon	"2.D40"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.19057e-006
	Radius          140.233
	InertiaMoment   0.397411

	RotationPeriod  333.898
	Obliquity       -72.3514
	EqAscendNode    16.152

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.624 0.619 0.614)

	Surface
	{
		SurfStyle       0.154427
		OceanStyle      0.248033
		Randomize      (0.854, 0.218, 0.666)
		colorDistMagn   0.460175
		colorDistFreq   13.3534
		detailScale     3829.3
		colorConversion true
		snowLevel       2
		tropicLatitude  0.976738
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.307194
		terraceProb     0.158659
		erosion         0
		montesMagn      0.472682
		montesFreq      2.78065
		montesSpiky     0.847672
		montesFraction  0.495655
		dunesFraction   0
		hillsMagn       0
		hillsFreq       36.4545
		hillsFraction   0.715065
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.243825
		craterFreq      0.696934
		craterDensity   0.903113
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   20.1502
		volcanoTemp     1519.37
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.249, 0.248, 0.246, 0.000)
		colorShelf     (0.265, 0.263, 0.261, 0.000)
		colorBeach     (0.281, 0.279, 0.276, 0.000)
		colorDesert    (0.296, 0.294, 0.292, 0.000)
		colorLowland   (0.312, 0.310, 0.307, 0.000)
		colorUpland    (0.327, 0.325, 0.322, 0.000)
		colorRock      (0.343, 0.341, 0.338, 0.000)
		colorSnow      (0.359, 0.356, 0.353, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.162334
		Period          3.87497
		Eccentricity    0.0459578
		Inclination     -5.69521
		AscendingNode   22.6962
		ArgOfPericenter -45.1108
		MeanAnomaly     128.887
	}
}

DwarfMoon	"2.D41"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.74153e-006
	Radius          186.655
	InertiaMoment   0.398791

	RotationPeriod  367.557
	Obliquity       9.69738
	EqAscendNode    51.0997

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.597 0.592 0.590)

	Surface
	{
		SurfStyle       0.652942
		OceanStyle      0.804948
		Randomize      (-0.221, -0.393, -0.157)
		colorDistMagn   0.506792
		colorDistFreq   28.5763
		detailScale     5096.92
		colorConversion true
		snowLevel       2
		tropicLatitude  0.933682
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.278955
		terraceProb     0.229886
		erosion         0
		montesMagn      0.411131
		montesFreq      2.72455
		montesSpiky     0.942136
		montesFraction  0.459578
		dunesFraction   0
		hillsMagn       0
		hillsFreq       91.1127
		hillsFraction   0.746184
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23112
		craterFreq      1.37053
		craterDensity   0.80389
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   22.1758
		volcanoTemp     1490.75
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.233, 0.201, 0.165, 0.000)
		colorShelf     (0.239, 0.207, 0.189, 0.000)
		colorBeach     (0.281, 0.243, 0.224, 0.000)
		colorDesert    (0.305, 0.261, 0.218, 0.000)
		colorLowland   (0.335, 0.278, 0.248, 0.000)
		colorUpland    (0.370, 0.338, 0.301, 0.000)
		colorRock      (0.400, 0.367, 0.325, 0.000)
		colorSnow      (0.436, 0.391, 0.342, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.162624
		Period          3.88536
		Eccentricity    0.391718
		Inclination     62.5008
		AscendingNode   49.5001
		ArgOfPericenter 130.916
		MeanAnomaly     19.5933
	}
}

Moon	"2.9"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            2.59467e-006
	Radius          199.773
	InertiaMoment   0.399737

	RotationPeriod  323.297
	Obliquity       -24.1667
	EqAscendNode    -121.068

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.735 0.733 0.731)

	Surface
	{
		SurfStyle       0.525297
		OceanStyle      0.993358
		Randomize      (-0.962, 0.808, -0.484)
		colorDistMagn   0.0687705
		colorDistFreq   27.3797
		detailScale     513.827
		colorConversion true
		drivenDarkening 0.0335253
		seaLevel        0.256227
		snowLevel       2
		tropicLatitude  0.845041
		icecapLatitude  1
		icecapHeight    0.256227
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.67709
		venusFreq       0.965664
		venusMagn       0.22407
		mareFreq        0
		mareDensity     9.62862e-007
		terraceProb     0.233009
		erosion         0
		montesMagn      0.0536481
		montesFreq      7.82842
		montesSpiky     0.914692
		montesFraction  0.49555
		dunesMagn       0.0495021
		dunesFreq       260.694
		dunesFraction   0.340726
		hillsMagn       0.126604
		hillsFreq       23.2846
		hillsFraction   0.952875
		hills2Fraction  0.0554836
		riversMagn      52.9628
		riversFreq      2.71695
		riversSin       5.06458
		riversOctaves   0
		canyonsMagn     0.658774
		canyonsFreq     0.0793355
		canyonFraction  0
		cracksMagn      0.0593389
		cracksFreq      0.0678151
		cracksOctaves   0
		craterMagn      1.18556
		craterFreq      0.619568
		craterDensity   0.797822
		craterOctaves   7
		craterRayedFactor 0.290433
		volcanoMagn     0.206244
		volcanoFreq     1.00066
		volcanoDensity  0.0495973
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.205122
		volcanoRadius   4.86438
		volcanoTemp     1652.01
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.221, 0.183, 0.161, 0.000)
		colorShelf     (0.272, 0.227, 0.205, 0.000)
		colorBeach     (0.412, 0.345, 0.307, 0.200)
		colorDesert    (0.375, 0.323, 0.270, 0.500)
		colorLowland   (0.287, 0.249, 0.205, 0.800)
		colorUpland    (0.485, 0.440, 0.380, 1.000)
		colorRock      (0.670, 0.620, 0.550, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.287, 0.249, 0.205, 0.800)
		colorUpPlants  (0.485, 0.440, 0.380, 1.000)
		BumpHeight      9.98865
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.163101
		Period          3.90246
		Eccentricity    0.441528
		Inclination     -63.8367
		AscendingNode   -111.122
		ArgOfPericenter -95.7761
		MeanAnomaly     -6.56198
	}
}

Moon	"2.10"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            3.95318e-006
	Radius          220.54
	InertiaMoment   0.397676

	RotationPeriod  288.837
	Obliquity       -72.9074
	EqAscendNode    56.5458

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.593 0.587 0.584)

	Surface
	{
		SurfStyle       0.593
		OceanStyle      0.317366
		Randomize      (-0.318, -0.774, -0.433)
		colorDistMagn   0.074438
		colorDistFreq   26.5169
		detailScale     567.242
		colorConversion true
		drivenDarkening 0.0334292
		seaLevel        0.241586
		snowLevel       2
		tropicLatitude  0.985198
		icecapLatitude  1
		icecapHeight    0.241586
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.59536
		venusFreq       1.07637
		venusMagn       0.195956
		mareFreq        0
		mareDensity     1.30984e-006
		terraceProb     0.32168
		erosion         0
		montesMagn      0.0549057
		montesFreq      10.4553
		montesSpiky     0.987927
		montesFraction  0.749555
		dunesMagn       0.0346149
		dunesFreq       292.486
		dunesFraction   0.937268
		hillsMagn       0.131729
		hillsFreq       21.9552
		hillsFraction   0.107318
		hills2Fraction  0.0934886
		riversMagn      52.0703
		riversFreq      3.32923
		riversSin       5.88305
		riversOctaves   0
		canyonsMagn     0.57619
		canyonsFreq     0.0658301
		canyonFraction  0
		cracksMagn      0.0560639
		cracksFreq      0.121013
		cracksOctaves   0
		craterMagn      1.13465
		craterFreq      0.451244
		craterDensity   0.945297
		craterOctaves   8
		craterRayedFactor 0.403893
		volcanoMagn     0.227869
		volcanoFreq     0.817461
		volcanoDensity  0.0561605
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.339064
		volcanoRadius   3.55408
		volcanoTemp     1600.7
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.178, 0.147, 0.129, 0.000)
		colorShelf     (0.219, 0.182, 0.164, 0.000)
		colorBeach     (0.332, 0.276, 0.245, 0.200)
		colorDesert    (0.302, 0.258, 0.216, 0.500)
		colorLowland   (0.231, 0.200, 0.164, 0.800)
		colorUpland    (0.391, 0.352, 0.304, 1.000)
		colorRock      (0.670, 0.620, 0.550, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.231, 0.200, 0.164, 0.800)
		colorUpPlants  (0.391, 0.352, 0.304, 1.000)
		BumpHeight      11.027
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.163569
		Period          3.9193
		Eccentricity    0.195671
		Inclination     -47.5107
		AscendingNode   58.3404
		ArgOfPericenter -110.793
		MeanAnomaly     -72.1225
	}
}

Moon	"2.11"
{
	ParentBody     "2"
	Class	       "IceWorld"

	Mass            6.19134e-006
	Radius          245.012
	InertiaMoment   0.398938

	RotationPeriod  257.171
	Obliquity       -0.124832
	EqAscendNode    32.3308

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.438 0.434 0.428)

	Surface
	{
		SurfStyle       0.87153
		OceanStyle      0.0528898
		Randomize      (0.696, -0.993, 0.666)
		colorDistMagn   0.0687295
		colorDistFreq   36.2191
		detailScale     630.184
		colorConversion true
		drivenDarkening 0.0333822
		seaLevel        0.157838
		snowLevel       2
		tropicLatitude  0.197323
		icecapLatitude  0.944778
		icecapHeight    0.165924
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.66706
		venusFreq       0.640868
		venusMagn       0.214394
		mareFreq        0
		mareDensity     1.96268e-006
		terraceProb     0.202085
		erosion         0
		montesMagn      0.0522857
		montesFreq      10.4694
		montesSpiky     0.946452
		montesFraction  0.459749
		dunesMagn       0.0312289
		dunesFreq       323.076
		dunesFraction   0.597439
		hillsMagn       0.112195
		hillsFreq       31.0802
		hillsFraction   0.382755
		hills2Fraction  0.0430266
		riversMagn      67.1639
		riversFreq      3.20103
		riversSin       4.01996
		riversOctaves   0
		canyonsMagn     0.614928
		canyonsFreq     0.0901415
		canyonFraction  0
		cracksMagn      0.0436616
		cracksFreq      0.0613375
		cracksOctaves   0
		craterMagn      0.928143
		craterFreq      0.628274
		craterDensity   0.801564
		craterOctaves   8
		craterRayedFactor 0.212738
		volcanoMagn     0.212391
		volcanoFreq     0.860532
		volcanoDensity  0.0611871
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.402007
		volcanoRadius   3.3213
		volcanoTemp     1930.44
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.438, 0.326, 0.246, 0.000)
		colorShelf     (0.416, 0.309, 0.233, 0.000)
		colorBeach     (0.219, 0.163, 0.123, 0.000)
		colorDesert    (0.373, 0.277, 0.209, 0.000)
		colorLowland   (0.355, 0.287, 0.233, 0.000)
		colorUpland    (0.408, 0.303, 0.228, 0.000)
		colorRock      (1.000, 1.000, 1.000, 0.500)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.355, 0.287, 0.233, 0.000)
		colorUpPlants  (0.408, 0.303, 0.228, 0.000)
		BumpHeight      12.2506
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.1638
		Period          3.92759
		Eccentricity    0.225993
		Inclination     11.4747
		AscendingNode   40.7737
		ArgOfPericenter -114.112
		MeanAnomaly     -36.026
	}
}

DwarfMoon	"2.D42"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.04636e-011
	Radius          4.31775
	InertiaMoment   0.399863

	RotationPeriod  2275.63
	Obliquity       16.5434
	EqAscendNode    91.6716

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.659 0.654 0.651)

	Surface
	{
		SurfStyle       0.395997
		OceanStyle      0.461054
		Randomize      (0.727, 0.732, 0.585)
		colorDistMagn   0.482302
		colorDistFreq   0.00889874
		detailScale     117.903
		colorConversion true
		snowLevel       2
		tropicLatitude  0.352137
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.493897
		terraceProb     0.498363
		erosion         0
		montesMagn      0.325426
		montesFreq      2.65291
		montesSpiky     0.98627
		montesFraction  0.467298
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0457132
		hillsFraction   0.759033
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.192043
		craterFreq      0.250429
		craterDensity   0.95262
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   149.648
		volcanoTemp     1213.7
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.264, 0.262, 0.261, 0.000)
		colorShelf     (0.280, 0.278, 0.277, 0.000)
		colorBeach     (0.297, 0.294, 0.293, 0.000)
		colorDesert    (0.313, 0.311, 0.309, 0.000)
		colorLowland   (0.330, 0.327, 0.326, 0.000)
		colorUpland    (0.346, 0.344, 0.342, 0.000)
		colorRock      (0.363, 0.360, 0.358, 0.000)
		colorSnow      (0.379, 0.376, 0.375, 1.000)
		BumpHeight      3.88598
		BumpOffset      0.777195
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.164091
		Period          3.93805
		Eccentricity    0.465945
		Inclination     14.5153
		AscendingNode   96.3894
		ArgOfPericenter 179.994
		MeanAnomaly     -58.2133
	}
}

DwarfMoon	"2.D43"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.88888e-011
	Radius          4.95889
	InertiaMoment   0.397906

	RotationPeriod  1923.15
	Obliquity       -106.634
	EqAscendNode    -144.638

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.686 0.681 0.678)

	Surface
	{
		SurfStyle       0.238197
		OceanStyle      0.147098
		Randomize      (-0.508, 0.095, 0.557)
		colorDistMagn   0.214695
		colorDistFreq   0.0212388
		detailScale     135.411
		colorConversion true
		snowLevel       2
		tropicLatitude  0.67796
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.613198
		terraceProb     0.304493
		erosion         0
		montesMagn      0.322934
		montesFreq      2.9176
		montesSpiky     0.930297
		montesFraction  0.307907
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0622561
		hillsFraction   0.730725
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.264123
		craterFreq      0.227487
		craterDensity   0.759615
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   124.675
		volcanoTemp     1600.16
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.274, 0.272, 0.271, 0.000)
		colorShelf     (0.292, 0.289, 0.288, 0.000)
		colorBeach     (0.309, 0.306, 0.305, 0.000)
		colorDesert    (0.326, 0.323, 0.322, 0.000)
		colorLowland   (0.343, 0.340, 0.339, 0.000)
		colorUpland    (0.360, 0.358, 0.356, 0.000)
		colorRock      (0.377, 0.375, 0.373, 0.000)
		colorSnow      (0.394, 0.392, 0.390, 1.000)
		BumpHeight      4.463
		BumpOffset      0.8926
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.164681
		Period          3.9593
		Eccentricity    0.281867
		Inclination     -84.9255
		AscendingNode   -142.821
		ArgOfPericenter 165.537
		MeanAnomaly     -151.738
	}
}

DwarfMoon	"2.D44"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.86292e-011
	Radius          5.74264
	InertiaMoment   0.399079

	RotationPeriod  1696.86
	Obliquity       -0.0774893
	EqAscendNode    -184.198

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.623 0.620 0.615)

	Surface
	{
		SurfStyle       0.76623
		OceanStyle      0.0348966
		Randomize      (-0.028, -0.197, 0.811)
		colorDistMagn   0.568065
		colorDistFreq   0.0136255
		detailScale     156.812
		colorConversion true
		snowLevel       2
		tropicLatitude  0.156753
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.599673
		terraceProb     0.237119
		erosion         0
		montesMagn      0.417173
		montesFreq      3.75789
		montesSpiky     0.845163
		montesFraction  0.637371
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0623384
		hillsFraction   0.482412
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.279259
		craterFreq      0.253539
		craterDensity   0.747982
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   108.683
		volcanoTemp     1538.89
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.243, 0.211, 0.172, 0.000)
		colorShelf     (0.249, 0.217, 0.197, 0.000)
		colorBeach     (0.293, 0.254, 0.234, 0.000)
		colorDesert    (0.318, 0.273, 0.228, 0.000)
		colorLowland   (0.349, 0.291, 0.258, 0.000)
		colorUpland    (0.386, 0.353, 0.314, 0.000)
		colorRock      (0.418, 0.385, 0.338, 0.000)
		colorSnow      (0.455, 0.409, 0.357, 1.000)
		BumpHeight      5.16838
		BumpOffset      1.03368
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.165094
		Period          3.97424
		Eccentricity    0.325533
		Inclination     8.94115
		AscendingNode   -176.133
		ArgOfPericenter 49.8887
		MeanAnomaly     -162.377
	}
}

DwarfMoon	"2.D45"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.14726e-010
	Radius          6.53217
	InertiaMoment   0.399988

	RotationPeriod  1507.72
	Obliquity       -107.994
	EqAscendNode    0.283749

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.757 0.678 0.620)

	Surface
	{
		SurfStyle       0.528911
		OceanStyle      0.360725
		Randomize      (-0.627, 0.280, 0.309)
		colorDistMagn   0.266616
		colorDistFreq   0.0215519
		detailScale     178.372
		colorConversion true
		snowLevel       2
		tropicLatitude  0.574875
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.741697
		terraceProb     0.609625
		erosion         0
		montesMagn      0.357449
		montesFreq      3.51478
		montesSpiky     0.842484
		montesFraction  0.536557
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.115322
		hillsFraction   0.513024
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.226763
		craterFreq      0.202626
		craterDensity   1.09075
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   95.6163
		volcanoTemp     1071.44
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.295, 0.231, 0.174, 0.000)
		colorShelf     (0.303, 0.237, 0.198, 0.000)
		colorBeach     (0.356, 0.278, 0.236, 0.000)
		colorDesert    (0.386, 0.299, 0.229, 0.000)
		colorLowland   (0.424, 0.319, 0.260, 0.000)
		colorUpland    (0.469, 0.387, 0.316, 0.000)
		colorRock      (0.507, 0.421, 0.341, 0.000)
		colorSnow      (0.553, 0.448, 0.360, 1.000)
		BumpHeight      5.87895
		BumpOffset      1.17579
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.165436
		Period          3.98659
		Eccentricity    0.167935
		Inclination     -37.1668
		AscendingNode   5.36462
		ArgOfPericenter -118.637
		MeanAnomaly     -175.737
	}
}

DwarfMoon	"2.D46"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.84031e-010
	Radius          9.21001
	InertiaMoment   0.398111

	RotationPeriod  1662.56
	Obliquity       7.10728
	EqAscendNode    14.0671

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.779 0.686 0.611)

	Surface
	{
		SurfStyle       0.503697
		OceanStyle      0.303582
		Randomize      (-0.170, -0.942, -0.644)
		colorDistMagn   0.695176
		colorDistFreq   0.0514683
		detailScale     251.495
		colorConversion true
		snowLevel       2
		tropicLatitude  0.649037
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.762134
		terraceProb     0.302666
		erosion         0
		montesMagn      0.574803
		montesFreq      3.67698
		montesSpiky     0.872707
		montesFraction  0.741252
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.209067
		hillsFraction   0.601031
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.268753
		craterFreq      0.16031
		craterDensity   0.809624
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   106.444
		volcanoTemp     1472.42
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.304, 0.233, 0.171, 0.000)
		colorShelf     (0.312, 0.240, 0.196, 0.000)
		colorBeach     (0.366, 0.281, 0.232, 0.000)
		colorDesert    (0.397, 0.302, 0.226, 0.000)
		colorLowland   (0.436, 0.322, 0.257, 0.000)
		colorUpland    (0.483, 0.391, 0.312, 0.000)
		colorRock      (0.522, 0.425, 0.336, 0.000)
		colorSnow      (0.569, 0.452, 0.355, 1.000)
		BumpHeight      8.28901
		BumpOffset      1.6578
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.166036
		Period          4.00827
		Eccentricity    0.214324
		Inclination     -47.0564
		AscendingNode   20.7209
		ArgOfPericenter -140.708
		MeanAnomaly     88.1331
	}
}

DwarfMoon	"2.D47"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.85799e-010
	Radius          9.71086
	InertiaMoment   0.399216

	RotationPeriod  1424.26
	Obliquity       -67.0267
	EqAscendNode    -60.0727

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.796 0.795 0.794)

	Surface
	{
		SurfStyle       0.122743
		OceanStyle      0.756039
		Randomize      (0.420, -0.902, 0.374)
		colorDistMagn   0.833618
		colorDistFreq   0.0485362
		detailScale     265.171
		colorConversion true
		snowLevel       2
		tropicLatitude  0.985423
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.33084
		terraceProb     0.181011
		erosion         0
		montesMagn      0.412119
		montesFreq      3.30159
		montesSpiky     0.943295
		montesFraction  0.226142
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.20322
		hillsFraction   0.707978
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241919
		craterFreq      0.164168
		craterDensity   0.985923
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   90.0602
		volcanoTemp     1617.1
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.319, 0.318, 0.318, 0.000)
		colorShelf     (0.338, 0.338, 0.337, 0.000)
		colorBeach     (0.358, 0.358, 0.357, 0.000)
		colorDesert    (0.378, 0.378, 0.377, 0.000)
		colorLowland   (0.398, 0.398, 0.397, 0.000)
		colorUpland    (0.418, 0.417, 0.417, 0.000)
		colorRock      (0.438, 0.437, 0.437, 0.000)
		colorSnow      (0.458, 0.457, 0.457, 1.000)
		BumpHeight      8.73977
		BumpOffset      1.74795
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.166527
		Period          4.02609
		Eccentricity    0.4005
		Inclination     -22.0931
		AscendingNode   -56.4218
		ArgOfPericenter 126.602
		MeanAnomaly     12.635
	}
}

DwarfMoon	"2.D48"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.32479e-010
	Radius          10.6669
	InertiaMoment   0.395988

	RotationPeriod  1275.34
	Obliquity       30.6448
	EqAscendNode    98.0324

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.615 0.531 0.381)

	Surface
	{
		SurfStyle       0.753688
		OceanStyle      0.777758
		Randomize      (-0.081, -0.792, 0.545)
		colorDistMagn   0.865607
		colorDistFreq   0.0806012
		detailScale     291.278
		colorConversion true
		snowLevel       2
		tropicLatitude  0.627951
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.419223
		terraceProb     0.525946
		erosion         0
		montesMagn      0.386281
		montesFreq      3.78275
		montesSpiky     0.940692
		montesFraction  0.286678
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.225652
		hillsFraction   0.61254
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238537
		craterFreq      0.189144
		craterDensity   0.795159
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   80.4198
		volcanoTemp     1518.55
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.240, 0.181, 0.107, 0.000)
		colorShelf     (0.246, 0.186, 0.122, 0.000)
		colorBeach     (0.289, 0.218, 0.145, 0.000)
		colorDesert    (0.314, 0.234, 0.141, 0.000)
		colorLowland   (0.345, 0.250, 0.160, 0.000)
		colorUpland    (0.381, 0.303, 0.194, 0.000)
		colorRock      (0.412, 0.329, 0.210, 0.000)
		colorSnow      (0.449, 0.351, 0.221, 1.000)
		BumpHeight      9.60024
		BumpOffset      1.92005
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.166853
		Period          4.0379
		Eccentricity    0.17035
		Inclination     24.7188
		AscendingNode   89.124
		ArgOfPericenter 44.8939
		MeanAnomaly     -4.98999
	}
}

DwarfMoon	"2.D49"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.40759e-010
	Radius          11.6691
	InertiaMoment   0.398298

	RotationPeriod  1155.84
	Obliquity       -80.0171
	EqAscendNode    106.096

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.809 0.781 0.753)

	Surface
	{
		SurfStyle       0.0995668
		OceanStyle      0.724774
		Randomize      (0.471, 0.163, 0.379)
		colorDistMagn   0.426401
		colorDistFreq   0.0640552
		detailScale     318.644
		colorConversion true
		snowLevel       2
		tropicLatitude  0.968316
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.607286
		terraceProb     0.152924
		erosion         0
		montesMagn      0.454693
		montesFreq      2.62895
		montesSpiky     0.970145
		montesFraction  0.342475
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.4318
		hillsFraction   0.671101
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.229246
		craterFreq      0.229067
		craterDensity   1.06872
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   72.2762
		volcanoTemp     1814.75
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.323, 0.312, 0.301, 0.000)
		colorShelf     (0.344, 0.332, 0.320, 0.000)
		colorBeach     (0.364, 0.351, 0.339, 0.000)
		colorDesert    (0.384, 0.371, 0.358, 0.000)
		colorLowland   (0.404, 0.390, 0.377, 0.000)
		colorUpland    (0.425, 0.410, 0.395, 0.000)
		colorRock      (0.445, 0.429, 0.414, 0.000)
		colorSnow      (0.465, 0.449, 0.433, 1.000)
		BumpHeight      10.5022
		BumpOffset      2.10044
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.167518
		Period          4.06207
		Eccentricity    0.234637
		Inclination     -23.0136
		AscendingNode   103.544
		ArgOfPericenter -167.977
		MeanAnomaly     49.2308
	}
}

DwarfMoon	"2.D50"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            9.3297e-010
	Radius          16.6902
	InertiaMoment   0.399349

	RotationPeriod  1359.21
	Obliquity       101.285
	EqAscendNode    -118.391

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.678 0.673 0.670)

	Surface
	{
		SurfStyle       0.47661
		OceanStyle      0.206062
		Randomize      (0.053, -0.985, 0.730)
		colorDistMagn   0.516878
		colorDistFreq   0.152239
		detailScale     455.753
		colorConversion true
		snowLevel       2
		tropicLatitude  0.897357
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.313005
		terraceProb     0.256393
		erosion         0
		montesMagn      0.553204
		montesFreq      3.38677
		montesSpiky     0.970165
		montesFraction  0.501795
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.528844
		hillsFraction   0.773001
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.257005
		craterFreq      0.242304
		craterDensity   0.94675
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   85.6708
		volcanoTemp     1630.84
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.271, 0.269, 0.268, 0.000)
		colorShelf     (0.288, 0.286, 0.285, 0.000)
		colorBeach     (0.305, 0.303, 0.301, 0.000)
		colorDesert    (0.322, 0.320, 0.318, 0.000)
		colorLowland   (0.339, 0.337, 0.335, 0.000)
		colorUpland    (0.356, 0.353, 0.351, 0.000)
		colorRock      (0.373, 0.370, 0.368, 0.000)
		colorSnow      (0.390, 0.387, 0.385, 1.000)
		BumpHeight      15.0212
		BumpOffset      3.00423
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.167855
		Period          4.07435
		Eccentricity    0.111038
		Inclination     68.874
		AscendingNode   -124.024
		ArgOfPericenter -117.826
		MeanAnomaly     141.391
	}
}

DwarfMoon	"2.D51"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.33895e-009
	Radius          16.3759
	InertiaMoment   0.396658

	RotationPeriod  1121.59
	Obliquity       -35.5619
	EqAscendNode    107.44

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.717 0.716 0.715)

	Surface
	{
		SurfStyle       0.408539
		OceanStyle      0.466556
		Randomize      (0.984, 0.852, -0.100)
		colorDistMagn   0.93845
		colorDistFreq   0.0903992
		detailScale     447.171
		colorConversion true
		snowLevel       2
		tropicLatitude  0.665275
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.276204
		terraceProb     0.22997
		erosion         0
		montesMagn      0.533897
		montesFreq      2.35103
		montesSpiky     0.919568
		montesFraction  0.571796
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.684256
		hillsFraction   0.558971
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.198571
		craterFreq      0.235215
		craterDensity   0.988107
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   70.1663
		volcanoTemp     1242.34
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.287, 0.286, 0.286, 0.000)
		colorShelf     (0.305, 0.304, 0.304, 0.000)
		colorBeach     (0.323, 0.322, 0.322, 0.000)
		colorDesert    (0.341, 0.340, 0.339, 0.000)
		colorLowland   (0.359, 0.358, 0.357, 0.000)
		colorUpland    (0.377, 0.376, 0.375, 0.000)
		colorRock      (0.395, 0.394, 0.393, 0.000)
		colorSnow      (0.413, 0.412, 0.411, 1.000)
		BumpHeight      14.7383
		BumpOffset      2.94766
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.168514
		Period          4.09834
		Eccentricity    0.445437
		Inclination     -43.4522
		AscendingNode   112.963
		ArgOfPericenter -71.5609
		MeanAnomaly     97.5981
	}
}

DwarfMoon	"2.D52"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.89858e-009
	Radius          17.5655
	InertiaMoment   0.398471

	RotationPeriod  1017.42
	Obliquity       -79.6409
	EqAscendNode    53.0057

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.783 0.781 0.779)

	Surface
	{
		SurfStyle       0.996464
		OceanStyle      0.716089
		Randomize      (0.054, 0.878, 0.669)
		colorDistMagn   0.575333
		colorDistFreq   0.165044
		detailScale     479.655
		colorConversion true
		snowLevel       2
		tropicLatitude  0.910793
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.547578
		terraceProb     0.390291
		erosion         0
		montesMagn      0.44122
		montesFreq      2.88656
		montesSpiky     0.968667
		montesFraction  0.510616
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.913305
		hillsFraction   0.482555
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234322
		craterFreq      0.201058
		craterDensity   0.937665
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   63.2051
		volcanoTemp     1372.24
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.266, 0.273, 0.312, 0.050)
		colorShelf     (0.313, 0.320, 0.358, 0.040)
		colorBeach     (0.360, 0.367, 0.405, 0.030)
		colorDesert    (0.407, 0.414, 0.460, 0.020)
		colorLowland   (0.454, 0.461, 0.507, 0.030)
		colorUpland    (0.501, 0.507, 0.553, 0.050)
		colorRock      (0.548, 0.554, 0.616, 0.020)
		colorSnow      (0.548, 0.554, 0.616, 1.000)
		BumpHeight      15.809
		BumpOffset      3.16179
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.168968
		Period          4.11492
		Eccentricity    0.11446
		Inclination     -62.5657
		AscendingNode   55.4046
		ArgOfPericenter -152.1
		MeanAnomaly     164.36
	}
}

DwarfMoon	"2.D53"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.66515e-009
	Radius          18.8868
	InertiaMoment   0.399479

	RotationPeriod  928.234
	Obliquity       -81.3623
	EqAscendNode    -106.061

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.770 0.768 0.767)

	Surface
	{
		SurfStyle       0.145119
		OceanStyle      0.698532
		Randomize      (-0.453, -0.093, 0.919)
		colorDistMagn   0.342777
		colorDistFreq   0.177111
		detailScale     515.735
		colorConversion true
		snowLevel       2
		tropicLatitude  0.969255
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.468171
		terraceProb     0.285575
		erosion         0
		montesMagn      0.585765
		montesFreq      3.56145
		montesSpiky     0.93192
		montesFraction  0.730311
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.984676
		hillsFraction   0.590745
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.210836
		craterFreq      0.19562
		craterDensity   1.05154
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   57.3592
		volcanoTemp     1818.27
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.308, 0.307, 0.307, 0.000)
		colorShelf     (0.327, 0.326, 0.326, 0.000)
		colorBeach     (0.346, 0.345, 0.345, 0.000)
		colorDesert    (0.366, 0.365, 0.364, 0.000)
		colorLowland   (0.385, 0.384, 0.384, 0.000)
		colorUpland    (0.404, 0.403, 0.403, 0.000)
		colorRock      (0.423, 0.422, 0.422, 0.000)
		colorSnow      (0.443, 0.441, 0.441, 1.000)
		BumpHeight      16.9981
		BumpOffset      3.39962
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.169551
		Period          4.13625
		Eccentricity    0.109265
		Inclination     -39.1026
		AscendingNode   -101.988
		ArgOfPericenter -50.7999
		MeanAnomaly     61.4804
	}
}

DwarfMoon	"2.D54"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.71002e-009
	Radius          19.5621
	InertiaMoment   0.397082

	RotationPeriod  816.52
	Obliquity       -5.05086
	EqAscendNode    -9.65101

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.699 0.697 0.695)

	Surface
	{
		SurfStyle       0.543544
		OceanStyle      0.872375
		Randomize      (-0.249, -0.083, -0.942)
		colorDistMagn   0.291021
		colorDistFreq   0.325225
		detailScale     534.177
		colorConversion true
		snowLevel       2
		tropicLatitude  0.323213
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.715796
		terraceProb     0.126685
		erosion         0
		montesMagn      0.45855
		montesFreq      2.28416
		montesSpiky     0.963535
		montesFraction  0.421818
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.03985
		hillsFraction   0.58546
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.274907
		craterFreq      0.240542
		craterDensity   0.871905
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   50.354
		volcanoTemp     1475.84
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.273, 0.237, 0.195, 0.000)
		colorShelf     (0.280, 0.244, 0.222, 0.000)
		colorBeach     (0.328, 0.286, 0.264, 0.000)
		colorDesert    (0.356, 0.307, 0.257, 0.000)
		colorLowland   (0.391, 0.328, 0.292, 0.000)
		colorUpland    (0.433, 0.397, 0.354, 0.000)
		colorRock      (0.468, 0.432, 0.382, 0.000)
		colorSnow      (0.510, 0.460, 0.403, 1.000)
		BumpHeight      17.6059
		BumpOffset      3.52118
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.170202
		Period          4.16009
		Eccentricity    0.200582
		Inclination     23.8349
		AscendingNode   -8.73804
		ArgOfPericenter 22.6288
		MeanAnomaly     127.445
	}
}

DwarfMoon	"2.D55"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            5.12883e-009
	Radius          25.8425
	InertiaMoment   0.398634

	RotationPeriod  915.193
	Obliquity       -55.9945
	EqAscendNode    63.2687

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.680 0.678 0.675)

	Surface
	{
		SurfStyle       0.0893295
		OceanStyle      0.409627
		Randomize      (0.007, -0.724, -0.110)
		colorDistMagn   0.39496
		colorDistFreq   0.301609
		detailScale     705.674
		colorConversion true
		snowLevel       2
		tropicLatitude  0.972943
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.439642
		terraceProb     0.57125
		erosion         0
		montesMagn      0.568737
		montesFreq      2.84519
		montesSpiky     0.995653
		montesFraction  0.830785
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.0801
		hillsFraction   0.867964
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.225068
		craterFreq      0.209174
		craterDensity   0.815883
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   56.576
		volcanoTemp     1548.47
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.272, 0.271, 0.270, 0.000)
		colorShelf     (0.289, 0.288, 0.287, 0.000)
		colorBeach     (0.306, 0.305, 0.304, 0.000)
		colorDesert    (0.323, 0.322, 0.321, 0.000)
		colorLowland   (0.340, 0.339, 0.338, 0.000)
		colorUpland    (0.357, 0.356, 0.355, 0.000)
		colorRock      (0.374, 0.373, 0.371, 0.000)
		colorSnow      (0.391, 0.390, 0.388, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.170751
		Period          4.18021
		Eccentricity    0.385002
		Inclination     -79.447
		AscendingNode   65.8461
		ArgOfPericenter 32.6951
		MeanAnomaly     -122.684
	}
}

DwarfMoon	"2.D56"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            7.05021e-009
	Radius          27.3587
	InertiaMoment   0.399608

	RotationPeriod  830.538
	Obliquity       73.4823
	EqAscendNode    -84.631

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.802 0.773 0.754)

	Surface
	{
		SurfStyle       0.269984
		OceanStyle      0.0611669
		Randomize      (-0.911, 0.470, -0.697)
		colorDistMagn   0.218102
		colorDistFreq   0.646774
		detailScale     747.074
		colorConversion true
		snowLevel       2
		tropicLatitude  0.990995
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.260656
		terraceProb     0.375478
		erosion         0
		montesMagn      0.370637
		montesFreq      3.65391
		montesSpiky     0.895994
		montesFraction  0.492774
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.16323
		hillsFraction   0.686703
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.186491
		craterFreq      0.228532
		craterDensity   0.988955
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   51.0858
		volcanoTemp     1468.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.321, 0.309, 0.302, 0.000)
		colorShelf     (0.341, 0.328, 0.320, 0.000)
		colorBeach     (0.361, 0.348, 0.339, 0.000)
		colorDesert    (0.381, 0.367, 0.358, 0.000)
		colorLowland   (0.401, 0.386, 0.377, 0.000)
		colorUpland    (0.421, 0.406, 0.396, 0.000)
		colorRock      (0.441, 0.425, 0.415, 0.000)
		colorSnow      (0.461, 0.444, 0.434, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.171019
		Period          4.19008
		Eccentricity    0.112514
		Inclination     36.3584
		AscendingNode   -80.3719
		ArgOfPericenter -66.7924
		MeanAnomaly     93.1199
	}
}

DwarfMoon	"2.D57"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            9.64763e-009
	Radius          29.1767
	InertiaMoment   0.397405

	RotationPeriod  757.547
	Obliquity       -75.08
	EqAscendNode    126.014

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.554 0.544 0.540)

	Surface
	{
		SurfStyle       0.0283406
		OceanStyle      0.896866
		Randomize      (0.962, 0.954, -0.986)
		colorDistMagn   0.840478
		colorDistFreq   0.382556
		detailScale     796.719
		colorConversion true
		snowLevel       2
		tropicLatitude  0.938129
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.317389
		terraceProb     0.194354
		erosion         0
		montesMagn      0.393634
		montesFreq      2.9098
		montesSpiky     0.929027
		montesFraction  0.585915
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.74357
		hillsFraction   0.569365
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247396
		craterFreq      0.272538
		craterDensity   0.939166
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   46.5727
		volcanoTemp     1443.09
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.222, 0.218, 0.216, 0.000)
		colorShelf     (0.235, 0.231, 0.230, 0.000)
		colorBeach     (0.249, 0.245, 0.243, 0.000)
		colorDesert    (0.263, 0.259, 0.257, 0.000)
		colorLowland   (0.277, 0.272, 0.270, 0.000)
		colorUpland    (0.291, 0.286, 0.284, 0.000)
		colorRock      (0.305, 0.299, 0.297, 0.000)
		colorSnow      (0.319, 0.313, 0.311, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.171353
		Period          4.20237
		Eccentricity    0.295299
		Inclination     -9.08726
		AscendingNode   127.095
		ArgOfPericenter 44.8525
		MeanAnomaly     166.739
	}
}

DwarfMoon	"2.D58"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.31561e-008
	Radius          30.5025
	InertiaMoment   0.398787

	RotationPeriod  681.682
	Obliquity       59.6483
	EqAscendNode    -106.574

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.472 0.468 0.461)

	Surface
	{
		SurfStyle       0.57325
		OceanStyle      0.745575
		Randomize      (-0.980, 0.456, 0.064)
		colorDistMagn   0.886447
		colorDistFreq   0.481625
		detailScale     832.921
		colorConversion true
		snowLevel       2
		tropicLatitude  0.87782
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.683657
		terraceProb     0.545127
		erosion         0
		montesMagn      0.54132
		montesFreq      2.38954
		montesSpiky     0.950795
		montesFraction  0.648414
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.93768
		hillsFraction   0.691481
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.221825
		craterFreq      0.276346
		craterDensity   0.924353
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.6945
		volcanoTemp     1622.87
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.184, 0.159, 0.129, 0.000)
		colorShelf     (0.189, 0.164, 0.148, 0.000)
		colorBeach     (0.222, 0.192, 0.175, 0.000)
		colorDesert    (0.241, 0.206, 0.171, 0.000)
		colorLowland   (0.264, 0.220, 0.194, 0.000)
		colorUpland    (0.293, 0.267, 0.235, 0.000)
		colorRock      (0.316, 0.290, 0.254, 0.000)
		colorSnow      (0.345, 0.309, 0.267, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.171854
		Period          4.22079
		Eccentricity    0.0977625
		Inclination     -5.05209
		AscendingNode   -108.691
		ArgOfPericenter -164.729
		MeanAnomaly     55.3034
	}
}

DwarfMoon	"2.D59"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.7895e-008
	Radius          39.5736
	InertiaMoment   0.399734

	RotationPeriod  756.72
	Obliquity       -6.13755
	EqAscendNode    -46.0754

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.809 0.766 0.747)

	Surface
	{
		SurfStyle       0.801474
		OceanStyle      0.216679
		Randomize      (0.186, 0.057, -0.160)
		colorDistMagn   0.676758
		colorDistFreq   0.783703
		detailScale     1080.62
		colorConversion true
		snowLevel       2
		tropicLatitude  0.92107
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.744488
		terraceProb     0.128774
		erosion         0
		montesMagn      0.468278
		montesFreq      3.39825
		montesSpiky     0.954325
		montesFraction  0.402789
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.78366
		hillsFraction   0.808653
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233103
		craterFreq      0.143193
		craterDensity   0.860854
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   46.3815
		volcanoTemp     1565.17
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.315, 0.261, 0.209, 0.000)
		colorShelf     (0.324, 0.268, 0.239, 0.000)
		colorBeach     (0.380, 0.314, 0.284, 0.000)
		colorDesert    (0.412, 0.337, 0.276, 0.000)
		colorLowland   (0.453, 0.360, 0.314, 0.000)
		colorUpland    (0.501, 0.437, 0.381, 0.000)
		colorRock      (0.542, 0.475, 0.411, 0.000)
		colorSnow      (0.590, 0.506, 0.433, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.172331
		Period          4.23837
		Eccentricity    0.00782837
		Inclination     71.6166
		AscendingNode   -41.6348
		ArgOfPericenter 141.64
		MeanAnomaly     9.07895
	}
}

DwarfMoon	"2.D60"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.43017e-008
	Radius          41.5733
	InertiaMoment   0.397671

	RotationPeriod  682.652
	Obliquity       -7.73578
	EqAscendNode    148.201

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.584 0.581 0.579)

	Surface
	{
		SurfStyle       0.114404
		OceanStyle      0.807536
		Randomize      (0.394, 0.437, -0.524)
		colorDistMagn   0.514482
		colorDistFreq   0.4436
		detailScale     1135.23
		colorConversion true
		snowLevel       2
		tropicLatitude  0.417084
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.683614
		terraceProb     0.224284
		erosion         0
		montesMagn      0.389595
		montesFreq      2.23903
		montesSpiky     0.791643
		montesFraction  0.349333
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.28121
		hillsFraction   0.408787
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.235932
		craterFreq      0.257923
		craterDensity   0.89548
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.8121
		volcanoTemp     1491.25
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.234, 0.232, 0.232, 0.000)
		colorShelf     (0.248, 0.247, 0.246, 0.000)
		colorBeach     (0.263, 0.261, 0.261, 0.000)
		colorDesert    (0.277, 0.276, 0.275, 0.000)
		colorLowland   (0.292, 0.290, 0.290, 0.000)
		colorUpland    (0.307, 0.305, 0.304, 0.000)
		colorRock      (0.321, 0.319, 0.319, 0.000)
		colorSnow      (0.336, 0.334, 0.333, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.172657
		Period          4.25042
		Eccentricity    0.189476
		Inclination     17.4564
		AscendingNode   154.338
		ArgOfPericenter -164.255
		MeanAnomaly     -128.14
	}
}

DwarfMoon	"2.D61"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            3.29775e-008
	Radius          44.21
	InertiaMoment   0.398934

	RotationPeriod  625.758
	Obliquity       59.1742
	EqAscendNode    -187.997

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.467 0.461 0.459)

	Surface
	{
		SurfStyle       0.20985
		OceanStyle      0.337464
		Randomize      (-0.219, -0.644, 0.720)
		colorDistMagn   0.283217
		colorDistFreq   1.09229
		detailScale     1207.23
		colorConversion true
		snowLevel       2
		tropicLatitude  0.213124
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.664331
		terraceProb     0.716007
		erosion         0
		montesMagn      0.421875
		montesFreq      3.60724
		montesSpiky     0.667191
		montesFraction  0.732903
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.23695
		hillsFraction   0.694884
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247818
		craterFreq      0.193097
		craterDensity   0.774041
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   38.1696
		volcanoTemp     1373.81
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.187, 0.184, 0.184, 0.000)
		colorShelf     (0.198, 0.196, 0.195, 0.000)
		colorBeach     (0.210, 0.208, 0.206, 0.000)
		colorDesert    (0.222, 0.219, 0.218, 0.000)
		colorLowland   (0.234, 0.231, 0.229, 0.000)
		colorUpland    (0.245, 0.242, 0.241, 0.000)
		colorRock      (0.257, 0.254, 0.252, 0.000)
		colorSnow      (0.269, 0.265, 0.264, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.1732
		Period          4.27049
		Eccentricity    0.11653
		Inclination     70.7104
		AscendingNode   -175.259
		ArgOfPericenter -108.437
		MeanAnomaly     113.86
	}
}

DwarfMoon	"2.D62"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            4.47559e-008
	Radius          46.4849
	InertiaMoment   0.39986

	RotationPeriod  566.912
	Obliquity       -32.6419
	EqAscendNode    96.745

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.683 0.681 0.678)

	Surface
	{
		SurfStyle       0.977559
		OceanStyle      0.467418
		Randomize      (0.586, -0.099, 0.432)
		colorDistMagn   0.0701813
		colorDistFreq   0.983563
		detailScale     1269.35
		colorConversion true
		snowLevel       2
		tropicLatitude  0.957285
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.46428
		terraceProb     0.174845
		erosion         0
		montesMagn      0.565146
		montesFreq      3.29259
		montesSpiky     0.969084
		montesFraction  0.712164
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.5979
		hillsFraction   0.694129
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.244201
		craterFreq      0.270993
		craterDensity   1.02726
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.4503
		volcanoTemp     1298.76
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.232, 0.238, 0.271, 0.050)
		colorShelf     (0.273, 0.279, 0.312, 0.040)
		colorBeach     (0.314, 0.320, 0.353, 0.030)
		colorDesert    (0.355, 0.361, 0.400, 0.020)
		colorLowland   (0.396, 0.402, 0.441, 0.030)
		colorUpland    (0.437, 0.443, 0.482, 0.050)
		colorRock      (0.478, 0.484, 0.536, 0.020)
		colorSnow      (0.478, 0.484, 0.536, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.173604
		Period          4.28542
		Eccentricity    0.487699
		Inclination     -74.1028
		AscendingNode   96.4748
		ArgOfPericenter 95.3408
		MeanAnomaly     -82.9002
	}
}

DwarfMoon	"2.D63"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            6.08007e-008
	Radius          60.1552
	InertiaMoment   0.397902

	RotationPeriod  626.264
	Obliquity       31.3244
	EqAscendNode    40.8638

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.537 0.529 0.523)

	Surface
	{
		SurfStyle       0.988554
		OceanStyle      0.503284
		Randomize      (-0.181, 0.981, -0.415)
		colorDistMagn   0.989352
		colorDistFreq   2.29056
		detailScale     1642.64
		colorConversion true
		snowLevel       2
		tropicLatitude  0.983516
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.596577
		terraceProb     0.297786
		erosion         0
		montesMagn      0.615523
		montesFreq      3.58367
		montesSpiky     0.979651
		montesFraction  0.578434
		dunesFraction   0
		hillsMagn       0
		hillsFreq       10.9982
		hillsFraction   0.707202
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.253743
		craterFreq      0.242279
		craterDensity   0.710575
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   38.2494
		volcanoTemp     1724.49
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.183, 0.185, 0.209, 0.050)
		colorShelf     (0.215, 0.217, 0.241, 0.040)
		colorBeach     (0.247, 0.249, 0.272, 0.030)
		colorDesert    (0.279, 0.280, 0.309, 0.020)
		colorLowland   (0.312, 0.312, 0.340, 0.030)
		colorUpland    (0.344, 0.344, 0.372, 0.050)
		colorRock      (0.376, 0.375, 0.413, 0.020)
		colorSnow      (0.376, 0.375, 0.413, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.173814
		Period          4.2932
		Eccentricity    0.422865
		Inclination     54.6313
		AscendingNode   42.2829
		ArgOfPericenter -81.8314
		MeanAnomaly     -126.698
	}
}

DwarfMoon	"2.D64"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            8.27518e-008
	Radius          62.9298
	InertiaMoment   0.399076

	RotationPeriod  563.952
	Obliquity       57.6981
	EqAscendNode    74.4135

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.416 0.412 0.405)

	Surface
	{
		SurfStyle       0.796824
		OceanStyle      0.71061
		Randomize      (-0.778, -0.942, -0.003)
		colorDistMagn   0.825096
		colorDistFreq   2.88453
		detailScale     1718.4
		colorConversion true
		snowLevel       2
		tropicLatitude  0.995971
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.375855
		terraceProb     0.247976
		erosion         0
		montesMagn      0.484046
		montesFreq      2.58209
		montesSpiky     0.971143
		montesFraction  0.309179
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.46485
		hillsFraction   0.692643
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.277143
		craterFreq      0.222421
		craterDensity   0.874849
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.2984
		volcanoTemp     1843.41
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.162, 0.140, 0.113, 0.000)
		colorShelf     (0.167, 0.144, 0.130, 0.000)
		colorBeach     (0.196, 0.169, 0.154, 0.000)
		colorDesert    (0.212, 0.181, 0.150, 0.000)
		colorLowland   (0.233, 0.194, 0.170, 0.000)
		colorUpland    (0.258, 0.235, 0.207, 0.000)
		colorRock      (0.279, 0.255, 0.223, 0.000)
		colorSnow      (0.304, 0.272, 0.235, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.174217
		Period          4.30815
		Eccentricity    0.440621
		Inclination     67.3064
		AscendingNode   67.7044
		ArgOfPericenter -48.9375
		MeanAnomaly     -65.7226
	}
}

DwarfMoon	"2.D65"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.12942e-007
	Radius          67.0228
	InertiaMoment   0.399985

	RotationPeriod  515.805
	Obliquity       17.5021
	EqAscendNode    -74.4479

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.640 0.637 0.635)

	Surface
	{
		SurfStyle       0.508911
		OceanStyle      0.925027
		Randomize      (-0.144, 0.298, 0.572)
		colorDistMagn   0.0448735
		colorDistFreq   1.90225
		detailScale     1830.17
		colorConversion true
		snowLevel       2
		tropicLatitude  0.402906
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.595618
		terraceProb     0.304442
		erosion         0
		montesMagn      0.491574
		montesFreq      3.67629
		montesSpiky     0.938547
		montesFraction  0.346322
		dunesFraction   0
		hillsMagn       0
		hillsFreq       8.12682
		hillsFraction   0.356434
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.26761
		craterFreq      0.201102
		craterDensity   0.907891
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   31.2681
		volcanoTemp     1488.79
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.250, 0.217, 0.178, 0.000)
		colorShelf     (0.256, 0.223, 0.203, 0.000)
		colorBeach     (0.301, 0.261, 0.241, 0.000)
		colorDesert    (0.327, 0.280, 0.235, 0.000)
		colorLowland   (0.359, 0.299, 0.267, 0.000)
		colorUpland    (0.397, 0.363, 0.324, 0.000)
		colorRock      (0.429, 0.395, 0.349, 0.000)
		colorSnow      (0.468, 0.420, 0.368, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.174568
		Period          4.32118
		Eccentricity    0.217063
		Inclination     13.3515
		AscendingNode   -79.473
		ArgOfPericenter -57.4596
		MeanAnomaly     174.82
	}
}

DwarfMoon	"2.D66"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            1.54728e-007
	Radius          71.0016
	InertiaMoment   0.398107

	RotationPeriod  466.758
	Obliquity       84.8882
	EqAscendNode    -33.9246

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.627 0.484 0.381)

	Surface
	{
		SurfStyle       0.689712
		OceanStyle      0.815436
		Randomize      (-0.890, -0.186, -0.987)
		colorDistMagn   0.864937
		colorDistFreq   2.01199
		detailScale     1938.82
		colorConversion true
		snowLevel       2
		tropicLatitude  0.719577
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.414368
		terraceProb     0.391362
		erosion         0
		montesMagn      0.457045
		montesFreq      3.0208
		montesSpiky     0.957227
		montesFraction  0.651316
		dunesFraction   0
		hillsMagn       0
		hillsFreq       14.8433
		hillsFraction   0.540029
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.206811
		craterFreq      0.166807
		craterDensity   0.828063
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   28.3002
		volcanoTemp     1774.52
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.245, 0.165, 0.107, 0.000)
		colorShelf     (0.251, 0.170, 0.122, 0.000)
		colorBeach     (0.295, 0.199, 0.145, 0.000)
		colorDesert    (0.320, 0.213, 0.141, 0.000)
		colorLowland   (0.351, 0.228, 0.160, 0.000)
		colorUpland    (0.389, 0.276, 0.194, 0.000)
		colorRock      (0.420, 0.300, 0.209, 0.000)
		colorSnow      (0.458, 0.320, 0.221, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.175131
		Period          4.3421
		Eccentricity    0.125825
		Inclination     66.9292
		AscendingNode   -37.2602
		ArgOfPericenter -81.2987
		MeanAnomaly     48.0932
	}
}

DwarfMoon	"2.D67"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.12999e-007
	Radius          92.5865
	InertiaMoment   0.399213

	RotationPeriod  518.329
	Obliquity       38.3439
	EqAscendNode    -53.3786

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.723 0.667 0.628)

	Surface
	{
		SurfStyle       0.824779
		OceanStyle      0.717131
		Randomize      (-0.652, -0.033, -0.123)
		colorDistMagn   0.626157
		colorDistFreq   5.15968
		detailScale     2528.23
		colorConversion true
		snowLevel       2
		tropicLatitude  0.674802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.267293
		terraceProb     0.233184
		erosion         0
		montesMagn      0.314779
		montesFreq      3.44611
		montesSpiky     0.807138
		montesFraction  0.641065
		dunesFraction   0
		hillsMagn       0
		hillsFreq       28.6205
		hillsFraction   0.739961
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.25199
		craterFreq      0.320424
		craterDensity   0.973861
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   31.4532
		volcanoTemp     1156.21
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.282, 0.227, 0.176, 0.000)
		colorShelf     (0.289, 0.233, 0.201, 0.000)
		colorBeach     (0.340, 0.273, 0.239, 0.000)
		colorDesert    (0.369, 0.293, 0.232, 0.000)
		colorLowland   (0.405, 0.313, 0.264, 0.000)
		colorUpland    (0.448, 0.380, 0.320, 0.000)
		colorRock      (0.485, 0.414, 0.345, 0.000)
		colorSnow      (0.528, 0.440, 0.364, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.175501
		Period          4.35587
		Eccentricity    0.0593723
		Inclination     6.62831
		AscendingNode   -55.0131
		ArgOfPericenter 65.8023
		MeanAnomaly     93.5244
	}
}

DwarfMoon	"2.D68"
{
	ParentBody     "2"
	Class	       "Asteroid"

	Mass            2.94977e-007
	Radius          96.747
	InertiaMoment   0.395968

	RotationPeriod  459.553
	Obliquity       -33.2744
	EqAscendNode    -31.6094

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.663 0.660 0.657)

	Surface
	{
		SurfStyle       0.294023
		OceanStyle      0.0308719
		Randomize      (-0.325, -0.755, 0.395)
		colorDistMagn   0.166464
		colorDistFreq   2.71633
		detailScale     2641.84
		colorConversion true
		snowLevel       2
		tropicLatitude  0.930615
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.644148
		terraceProb     0.600138
		erosion         0
		montesMagn      0.670878
		montesFreq      3.27928
		montesSpiky     0.883737
		montesFraction  0.365212
		dunesFraction   0
		hillsMagn       0
		hillsFreq       32.2308
		hillsFraction   0.417213
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.221399
		craterFreq      0.217585
		craterDensity   0.909903
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.9286
		volcanoTemp     1508.95
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.265, 0.264, 0.263, 0.000)
		colorShelf     (0.282, 0.281, 0.279, 0.000)
		colorBeach     (0.298, 0.297, 0.296, 0.000)
		colorDesert    (0.315, 0.314, 0.312, 0.000)
		colorLowland   (0.332, 0.330, 0.329, 0.000)
		colorUpland    (0.348, 0.347, 0.345, 0.000)
		colorRock      (0.365, 0.363, 0.361, 0.000)
		colorSnow      (0.381, 0.380, 0.378, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.175929
		Period          4.3718
		Eccentricity    0.0315381
		Inclination     -39.4022
		AscendingNode   -36.4799
		ArgOfPericenter 95.3379
		MeanAnomaly     -22.8071
	}
}

Barycenter	"3-3.1"
{
	ParentBody     "MiStar I"
	Mass            0.637838
	Radius          3913.61
	RotationPeriod  24
	Obliquity       0
	EqAscendNode    0

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      -1e+038
	Color          (1.000 1.000 1.000)

	Surface
	{
		DiffTileSize    131070
		DiffTileBorder  65535
		BumpTileSize    131070
		BumpTileBorder  65535
		GlowTileSize    131070
		GlowTileBorder  65535
		SpecularPower   -1e+038
		Hapke           -1e+038
		SpotBright      -1e+038
		SpotWidth       -1e+038
		DayAmbient      -1e+038
		ModulateColor  (-99999996802856925000000000000000000000.000 1.000 1.000 1.000)
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   28.2978
		Period          136.196
		Eccentricity    0.0885841
		Inclination     -11.1174
		AscendingNode   -98.3247
		ArgOfPericenter 10.0136
		MeanAnomaly     250.348
	}
}

Planet	"3"
{
	ParentBody     "3-3.1"
	Class	       "IceWorld"

	Mass            0.526953
	Radius          6694.21
	InertiaMoment   0.330588

	Obliquity       0.933546
	EqAscendNode    -179.712
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.592 0.585 0.582)

	Surface
	{
		SurfStyle       0.662089
		OceanStyle      0.30753
		Randomize      (0.496, -0.732, 0.443)
		colorDistMagn   0.0672606
		colorDistFreq   828.538
		detailScale     17217.9
		colorConversion true
		drivenDarkening 0
		seaLevel        0.220388
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  0.610457
		icecapHeight    0.256157
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.61103
		venusFreq       0.67927
		venusMagn       0.168395
		mareFreq        1.8873
		mareDensity     0.0424443
		terraceProb     0.545066
		erosion         0
		montesMagn      0.181097
		montesFreq      239.951
		montesSpiky     0.971571
		montesFraction  0.0655576
		dunesMagn       0.0240081
		dunesFreq       8868.16
		dunesFraction   0.534311
		hillsMagn       0.129564
		hillsFreq       788.746
		hillsFraction   0.152621
		hills2Fraction  0.106063
		riversMagn      58.7705
		riversFreq      3.12121
		riversSin       6.10986
		riversOctaves   0
		canyonsMagn     0.482569
		canyonsFreq     2.46151
		canyonFraction  0
		cracksMagn      0.0533014
		cracksFreq      3.32479
		cracksOctaves   5
		craterMagn      0.653713
		craterFreq      20.9609
		craterDensity   0.836671
		craterOctaves   13
		craterRayedFactor 0.244398
		volcanoMagn     0.743455
		volcanoFreq     3.41629
		volcanoDensity  0.4
		volcanoOctaves  0
		volcanoActivity 2
		volcanoFlows    0.36644
		volcanoRadius   0.411616
		volcanoTemp     1433.52
		lavaCoverTidal  0.0268847
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.379, 0.375, 0.390, 0.250)
		colorShelf     (0.414, 0.427, 0.442, 0.250)
		colorBeach     (0.337, 0.316, 0.338, 0.200)
		colorDesert    (0.314, 0.287, 0.297, 0.200)
		colorLowland   (0.231, 0.222, 0.244, 0.200)
		colorUpland    (0.438, 0.433, 0.442, 0.250)
		colorRock      (0.640, 0.630, 0.660, 0.150)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.231, 0.222, 0.244, 0.200)
		colorUpPlants  (0.438, 0.433, 0.442, 0.250)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           0.999996
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Pluto"
		Height          78.0807
		Density         4.01441e-007
		Pressure        5.0378e-008
		Greenhouse      0.00320167
		Bright          0.833152
		Opacity         0
		SkyLight        0.277717
		Hue             -0.0184737
		Saturation      1

		Composition
		{
			N2    	86.3847
			Ne    	13.6076
			CO    	0.00430723
			Ar    	0.00334346
		}
	}

	Aurora
	{
		Height      120.096
		NorthLat    65.0745
		NorthLon    -98.5583
		NorthRadius 1961.22
		NorthWidth  1630.53
		NorthRings  3
		NorthBright 0.3
		NorthParticles 50000
		SouthLat    -50.8657
		SouthLon    89.2923
		SouthRadius 1537.33
		SouthWidth  1361.43
		SouthRings  2
		SouthBright 0.3
		SouthParticles 50000
		TopColor    (1.000 1.000 1.000)
		BottomColor (0.000 1.000 0.000)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000111734
		Period          0.0117994
		Eccentricity    0.0146357
		Inclination     0.933546
		AscendingNode   -179.712
		ArgOfPericenter 74.1527
		MeanAnomaly     -23.9096
	}
}

Moon	"3.1"
{
	ParentBody     "3-3.1"
	Class	       "Selena"

	Mass            0.110885
	Radius          3855.57
	InertiaMoment   0.332496

	Obliquity       0.933546
	EqAscendNode    -179.712
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.619 0.613 0.609)

	Surface
	{
		SurfStyle       0.408141
		OceanStyle      0.158836
		Randomize      (0.184, 0.478, -0.116)
		colorDistMagn   0.0757026
		colorDistFreq   434.407
		detailScale     9916.75
		colorConversion true
		drivenDarkening 0
		seaLevel        0.219867
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  0.424462
		icecapHeight    0.25131
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.67443
		venusFreq       1.0045
		venusMagn       0
		mareFreq        1.80473
		mareDensity     0.0147112
		terraceProb     0.110666
		erosion         0
		montesMagn      0.226732
		montesFreq      195.987
		montesSpiky     0.97889
		montesFraction  0.0377963
		dunesMagn       0.0573348
		dunesFreq       4984.73
		dunesFraction   0.178362
		hillsMagn       0.145548
		hillsFreq       437.445
		hillsFraction   0.834534
		hills2Fraction  0
		riversMagn      58.0172
		riversFreq      3.39275
		riversSin       6.81697
		riversOctaves   0
		canyonsMagn     0.724813
		canyonsFreq     1.36842
		canyonFraction  0.14158
		cracksMagn      0.0251272
		cracksFreq      1.78711
		cracksOctaves   0
		craterMagn      0.576863
		craterFreq      8.23509
		craterDensity   0.815738
		craterOctaves   11.277
		craterRayedFactor 0
		volcanoMagn     0.679236
		volcanoFreq     2.27524
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.286867
		volcanoRadius   0.344195
		volcanoTemp     1717.33
		lavaCoverTidal  0.0669427
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.420, 0.420, 0.430, 0.000)
		colorShelf     (0.470, 0.480, 0.480, 0.000)
		colorBeach     (0.340, 0.350, 0.365, 0.000)
		colorDesert    (0.297, 0.282, 0.280, 0.000)
		colorLowland   (0.377, 0.374, 0.341, 0.000)
		colorUpland    (0.402, 0.399, 0.372, 0.000)
		colorRock      (0.340, 0.340, 0.340, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           0.99997
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Pluto"
		Height          102.907
		Density         3.01503e-006
		Pressure        4.16901e-007
		Greenhouse      0.00896903
		Bright          1.24698
		Opacity         0
		SkyLight        0.415659
		Hue             0.0111698
		Saturation      1

		Composition
		{
			N2    	88.0942
			Ar    	11.6275
			Ne    	0.186255
			CO    	0.0918258
			O2    	0.000214374
		}
	}

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000530988
		Period          0.0117994
		Eccentricity    0.0146357
		Inclination     0.933546
		AscendingNode   -179.712
		ArgOfPericenter -105.847
		MeanAnomaly     -23.9096
	}
}

Planet	"4"
{
	ParentBody     "MiStar I"
	Class	       "GasGiant"

	Mass            711.877
	Radius          76758.6
	InertiaMoment   0.259123

	Oblateness      0.0433219

	RotationPeriod  9.16445
	Obliquity       -61.5061
	EqAscendNode    -109.623

	AlbedoBond      0.456826
	AlbedoGeom      0.548191
	Brightness      2
	Color          (1.000 1.000 1.000)

	Surface
	{
		SurfStyle       0.535892
		Randomize      (-0.348, -0.826, 0.601)
		detailScale     197427
		colorConversion true
		tropicLatitude  0.865667
		icecapLatitude  1
		mainFreq        0.0310059
		venusFreq       3.90546
		venusMagn       0.422929
		craterOctaves   0
		volcanoActivity 0
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		twistZones      7.88724
		twistMagn       1.27908
		cycloneMagn     16.7831
		cycloneFreq     0.441267
		cycloneDensity  0.13818
		cycloneOctaves  1
		colorLayer0    (0.570, 0.550, 0.480, 1.100)
		colorLayer1    (0.850, 0.860, 0.870, 0.700)
		colorLayer2    (0.450, 0.390, 0.260, 0.200)
		colorLayer3    (0.430, 0.330, 0.170, 0.020)
		colorLayer4    (0.830, 0.830, 0.830, 0.000)
		colorLayer5    (0.510, 0.400, 0.140, 0.000)
		colorLayer6    (0.370, 0.350, 0.280, 0.000)
		colorLayer7    (0.420, 0.390, 0.310, 1.000)
		colorLowPlants (0.830, 0.830, 0.830, 0.000)
		colorUpPlants  (0.510, 0.400, 0.140, 0.000)
		BumpHeight      9.02112
		SpecularPower   -1e+038
		Hapke           0
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      1
	}

	Clouds
	{
		Height          27.9609
		BumpHeight      52.1224
		Hapke           0
		SpotBright      2
		SpotWidth       0.15
		DayAmbient      1
		mainFreq        0.958811
		mainOctaves     10
		Coverage        0.0682622
		twistZones      7.88724
		twistMagn       1.27908
	}

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Neptune"
		Height          103.712
		Density         10925.7
		Pressure        1e+006
		Bright          10
		Opacity         1
		SkyLight        3.33333
		Hue             -0.0136844
		Saturation      0.716141

		Composition
		{
			H2    	92.5178
			He    	7.48013
			Ne    	0.00143265
			N2    	0.000634637
		}
	}

	Aurora
	{
		Height      1292.5
		NorthLat    81.2524
		NorthLon    -29.259
		NorthRadius 17970.2
		NorthWidth  9030.82
		NorthRings  5
		NorthBright 1
		NorthParticles 10000
		SouthLat    -80.7511
		SouthLon    154.089
		SouthRadius 16801
		SouthWidth  7847.83
		SouthRings  4
		SouthBright 1
		SouthParticles 10000
		TopColor    (1.000 1.000 1.000)
		BottomColor (1.000 0.000 0.500)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   46.6892
		Period          288.391
		Eccentricity    0.0463075
		Inclination     -12.5646
		AscendingNode   -100.542
		ArgOfPericenter 346.222
		MeanAnomaly     82.6778
	}
}

Moon	"4.1"
{
	ParentBody     "4"
	Class	       "Desert"

	Mass            0.138191
	Radius          4399.78
	InertiaMoment   0.327969

	Oblateness      0.0108669

	Obliquity       1.46313
	EqAscendNode    45.8565
	TidalLocked     true

	AlbedoBond      0.264572
	AlbedoGeom      0.317487
	Brightness      2
	Color          (0.580 0.484 0.436)

	Surface
	{
		SurfStyle       0.144361
		OceanStyle      0.394431
		Randomize      (0.248, -0.379, 0.817)
		colorDistMagn   0.0951555
		colorDistFreq   604.292
		detailScale     11316.5
		colorConversion true
		seaLevel        0.0955791
		snowLevel       0.85
		tropicLatitude  0.0470194
		icecapLatitude  10
		icecapHeight    0.187534
		climatePole     0.5625
		climateTropic   0.5625
		climateEquator  0.6875
		heightTempGrad  0.375
		tropicWidth     0.5
		mainFreq        1.03217
		venusFreq       0.506371
		venusMagn       0.368327
		mareFreq        1.37598
		mareDensity     0.017038
		terraceProb     0.153244
		erosion         0
		montesMagn      0.252521
		montesFreq      141.097
		montesSpiky     0.799508
		montesFraction  0.572694
		dunesMagn       0.0425378
		dunesFreq       43.6889
		dunesFraction   0.208098
		hillsMagn       0.140918
		hillsFreq       407.556
		hillsFraction   0
		hills2Fraction  0
		riversMagn      60.4063
		riversFreq      3.22746
		riversSin       6.5089
		riversOctaves   0
		canyonsMagn     0.0534478
		canyonsFreq     101.274
		canyonFraction  0
		cracksMagn      0.0870473
		cracksFreq      0.397309
		cracksOctaves   0
		craterMagn      0.593441
		craterFreq      12.416
		craterDensity   0.0791575
		craterOctaves   1.17324
		volcanoMagn     0.634142
		volcanoFreq     1.97155
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.741018
		volcanoRadius   0.304877
		volcanoTemp     1331.3
		lavaCoverTidal  0.620244
		lavaCoverSun    0
		lavaCoverYoung  0
		twistZones      1.65041
		twistMagn       0
		cycloneMagn     2.22543
		cycloneFreq     0.347779
		cycloneDensity  0.0113954
		colorSea       (0.240, 0.230, 0.230, 0.000)
		colorShelf     (0.380, 0.360, 0.350, 0.000)
		colorBeach     (0.550, 0.520, 0.480, 0.000)
		colorDesert    (0.520, 0.490, 0.470, 0.000)
		colorLowland   (0.460, 0.440, 0.410, 0.000)
		colorUpland    (0.390, 0.360, 0.330, 0.000)
		colorRock      (0.170, 0.160, 0.160, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 0.769)
		colorLowPlants (0.460, 0.440, 0.410, 0.000)
		colorUpPlants  (0.390, 0.360, 0.330, 0.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.5
		SpecBrightIce   0.5
		SpecularPower   30
		Hapke           0
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	Clouds
	{
		Height          12.6719
		BumpHeight      5.50096
		Hapke           0.2
		SpotBright      2
		SpotWidth       0.15
		DayAmbient      2
		mainFreq        1.02383
		mainOctaves     10
		Coverage        0.129144
		twistZones      1.65041
		twistMagn       0
	}

	Clouds
	{
		Height          15.3433
		BumpHeight      6.78393
		Hapke           0.2
		SpotBright      2
		SpotWidth       0.15
		DayAmbient      2
		mainFreq        1.02383
		mainOctaves     10
		Coverage        0.129144
		twistZones      1.65041
		twistMagn       0
	}

	NoOcean         true

	NoLava          true

	Atmosphere
	{
		Model          "Neptune"
		Height          219.989
		Density         0.140287
		Pressure        0.243863
		Greenhouse      18.7218
		Bright          10
		Opacity         1
		SkyLight        3.33333
		Hue             0.0399472
		Saturation      1

		Composition
		{
			H2O   	72.9022
			CO2   	25.9207
			CH4   	0.567844
			SO2   	0.432035
			N2    	0.0894685
			NH3   	0.0693559
			C3H8  	0.0060835
			C2H2  	0.00392465
			H2S   	0.00366867
			C2H4  	0.0034064
			C2H6  	0.00109849
			Ar    	0.000200672
			CO    	8.41544e-005
			Ne    	2.12031e-005
		}
	}

	Aurora
	{
		Height      34.183
		NorthLat    87.7188
		NorthLon    -32.4223
		NorthRadius 1309.52
		NorthWidth  1466.85
		NorthRings  2
		NorthBright 0.3
		NorthParticles 50000
		SouthLat    -90
		SouthLon    137.698
		SouthRadius 1415.27
		SouthWidth  1675.47
		SouthRings  5
		SouthBright 0.3
		SouthParticles 50000
		TopColor    (1.000 1.000 1.000)
		BottomColor (0.000 1.000 0.000)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00225633
		Period          0.00232294
		Eccentricity    0.0243877
		Inclination     1.46313
		AscendingNode   45.8565
		ArgOfPericenter 144.659
		MeanAnomaly     66.0098
	}
}

Moon	"4.2"
{
	ParentBody     "4"
	Class	       "Selena"

	Mass            0.0162696
	Radius          2073.21
	InertiaMoment   0.370637

	Oblateness      0.00324226

	Obliquity       -0.657321
	EqAscendNode    -29.4051
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.727 0.723 0.722)

	Surface
	{
		SurfStyle       0.747761
		OceanStyle      0.648941
		Randomize      (0.246, 0.944, 0.349)
		colorDistMagn   0.0518229
		colorDistFreq   242.431
		detailScale     5332.42
		colorConversion true
		drivenDarkening 0
		seaLevel        0.13349
		snowLevel       2
		tropicLatitude  0.0221926
		icecapLatitude  0.87585
		icecapHeight    0.142532
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.65263
		venusFreq       0.754349
		venusMagn       0
		mareFreq        1.13056
		mareDensity     0.00433979
		terraceProb     0.116747
		erosion         0
		montesMagn      0.122647
		montesFreq      101.594
		montesSpiky     0.848017
		montesFraction  0.519223
		dunesMagn       0.0357874
		dunesFreq       2739.27
		dunesFraction   0.241448
		hillsMagn       0.114611
		hillsFreq       275.691
		hillsFraction   0.0977753
		hills2Fraction  0
		riversMagn      60.9299
		riversFreq      2.75034
		riversSin       6.3114
		riversOctaves   0
		canyonsMagn     0.352642
		canyonsFreq     0.732046
		canyonFraction  0.742929
		cracksMagn      0.0572655
		cracksFreq      1.28111
		cracksOctaves   0
		craterMagn      0.685732
		craterFreq      5.63786
		craterDensity   0.835487
		craterOctaves   10.902
		craterRayedFactor 0.486334
		volcanoMagn     0.395954
		volcanoFreq     2.68807
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.298045
		volcanoRadius   0.570849
		volcanoTemp     1642.64
		lavaCoverTidal  0.00990129
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.470, 0.400, 0.340, 0.000)
		colorShelf     (0.640, 0.600, 0.470, 0.000)
		colorBeach     (0.458, 0.441, 0.346, 0.000)
		colorDesert    (0.487, 0.448, 0.354, 0.000)
		colorLowland   (0.400, 0.333, 0.281, 0.000)
		colorUpland    (0.567, 0.513, 0.375, 0.000)
		colorRock      (0.300, 0.260, 0.220, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00342122
		Period          0.00433755
		Eccentricity    0.00231169
		Inclination     -0.657321
		AscendingNode   -29.4051
		ArgOfPericenter 134.275
		MeanAnomaly     113.593
	}
}

Moon	"4.3"
{
	ParentBody     "4"
	Class	       "Selena"

	Mass            0.0190603
	Radius          2320.69
	InertiaMoment   0.365206

	Oblateness      0.00109116

	Obliquity       -0.324179
	EqAscendNode    -93.7327
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.574 0.495 0.456)

	Surface
	{
		SurfStyle       0.747088
		OceanStyle      0.632618
		Randomize      (-0.219, -0.639, 0.578)
		colorDistMagn   0.0521431
		colorDistFreq   312.188
		detailScale     5968.95
		colorConversion true
		drivenDarkening 0
		seaLevel        0.223846
		snowLevel       2
		tropicLatitude  0.00773577
		icecapLatitude  0.825733
		icecapHeight    0.234511
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.85918
		venusFreq       1.02776
		venusMagn       0
		mareFreq        1.11819
		mareDensity     0.00364199
		terraceProb     0.166693
		erosion         0
		montesMagn      0.175766
		montesFreq      143.653
		montesSpiky     0.964505
		montesFraction  0.980485
		dunesMagn       0.0302338
		dunesFreq       3076.85
		dunesFraction   0.589459
		hillsMagn       0.116063
		hillsFreq       251.053
		hillsFraction   0.260497
		hills2Fraction  0
		riversMagn      66.6391
		riversFreq      2.5545
		riversSin       4.42886
		riversOctaves   0
		canyonsMagn     0.357021
		canyonsFreq     0.782403
		canyonFraction  0.103158
		cracksMagn      0.0395588
		cracksFreq      1.3966
		cracksOctaves   0
		craterMagn      0.562799
		craterFreq      5.8623
		craterDensity   0.830082
		craterOctaves   11.4438
		craterRayedFactor 0.369159
		volcanoMagn     0.482001
		volcanoFreq     3.18286
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.00781953
		volcanoRadius   0.699028
		volcanoTemp     1830.12
		lavaCoverTidal  0.0514957
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.470, 0.400, 0.340, 0.000)
		colorShelf     (0.640, 0.600, 0.470, 0.000)
		colorBeach     (0.362, 0.302, 0.219, 0.000)
		colorDesert    (0.385, 0.307, 0.224, 0.000)
		colorLowland   (0.316, 0.228, 0.178, 0.000)
		colorUpland    (0.448, 0.351, 0.237, 0.000)
		colorRock      (0.300, 0.260, 0.220, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00518753
		Period          0.00809866
		Eccentricity    0.0131456
		Inclination     -0.324179
		AscendingNode   -93.7327
		ArgOfPericenter 137.432
		MeanAnomaly     78.0911
	}
}

Moon	"4.4"
{
	ParentBody     "4"
	Class	       "Selena"

	Mass            0.0222421
	Radius          2295.82
	InertiaMoment   0.36101

	Obliquity       1.32346
	EqAscendNode    -147.194
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      3.5
	Color          (0.584 0.500 0.451)

	Surface
	{
		SurfStyle       0.875447
		OceanStyle      0.382696
		Randomize      (-0.097, 0.999, 0.816)
		colorDistMagn   0.0523793
		colorDistFreq   260.163
		detailScale     5904.97
		colorConversion true
		drivenDarkening 0
		seaLevel        0.349959
		snowLevel       2
		tropicLatitude  0.0130424
		icecapLatitude  0.746095
		icecapHeight    0.366945
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.80076
		venusFreq       1.08851
		venusMagn       0
		mareFreq        1.23816
		mareDensity     0.00349184
		terraceProb     0.198107
		erosion         0
		montesMagn      0.120903
		montesFreq      90.0907
		montesSpiky     0.959132
		montesFraction  0.375184
		dunesMagn       0.0509894
		dunesFreq       2954.96
		dunesFraction   0.760103
		hillsMagn       0.124321
		hillsFreq       235.839
		hillsFraction   0.538519
		hills2Fraction  0
		riversMagn      55.0449
		riversFreq      2.30432
		riversSin       6.34067
		riversOctaves   0
		canyonsMagn     0.546552
		canyonsFreq     0.869998
		canyonFraction  0.144139
		cracksMagn      0.0678193
		cracksFreq      1.30185
		cracksOctaves   0
		craterMagn      0.637248
		craterFreq      7.04304
		craterDensity   0.877671
		craterOctaves   10.8516
		craterRayedFactor 0.260382
		volcanoMagn     0.51727
		volcanoFreq     3.69586
		volcanoDensity  0.4
		volcanoOctaves  1
		volcanoActivity 2
		volcanoFlows    0.147569
		volcanoRadius   0.743343
		volcanoTemp     1736.6
		lavaCoverTidal  0.0149858
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.400, 0.350, 0.320, 0.000)
		colorShelf     (0.470, 0.410, 0.380, 0.000)
		colorBeach     (0.327, 0.235, 0.189, 0.000)
		colorDesert    (0.298, 0.220, 0.167, 0.000)
		colorLowland   (0.228, 0.170, 0.126, 0.000)
		colorUpland    (0.386, 0.300, 0.234, 0.000)
		colorRock      (0.670, 0.620, 0.550, 0.000)
		colorSnow      (1.000, 1.000, 1.000, 1.000)
		BumpHeight      20
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   55
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00786576
		Period          0.015121
		Eccentricity    0.0359469
		Inclination     1.32346
		AscendingNode   -147.194
		ArgOfPericenter -165.741
		MeanAnomaly     86.2392
	}
}

Moon	"4.5"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            0.0258753
	Radius          2563.88
	InertiaMoment   0.35702

	Obliquity       -0.180057
	EqAscendNode    -133.37
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.420 0.417 0.411)

	Surface
	{
		SurfStyle       0.502425
		OceanStyle      0.756924
		Randomize      (-0.593, 0.146, -0.580)
		colorDistMagn   0.0703697
		colorDistFreq   336.852
		detailScale     6594.46
		colorConversion true
		drivenDarkening 0.602295
		seaLevel        0.209236
		snowLevel       2
		tropicLatitude  0.00248975
		icecapLatitude  0.967952
		icecapHeight    0.21047
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.90829
		venusFreq       1.26974
		venusMagn       0.103441
		mareFreq        1.76053
		mareDensity     0.00364792
		terraceProb     0.4751
		erosion         0
		montesMagn      0.158437
		montesFreq      88.6316
		montesSpiky     0.869361
		montesFraction  0.14239
		dunesMagn       0.0424765
		dunesFreq       3292.85
		dunesFraction   0.879788
		hillsMagn       0.124623
		hillsFreq       245.387
		hillsFraction   0.949563
		hills2Fraction  0.192115
		riversMagn      57.4809
		riversFreq      4.8126
		riversSin       6.9488
		riversOctaves   0
		canyonsMagn     0.50955
		canyonsFreq     1.01601
		canyonFraction  0
		cracksMagn      0.0534176
		cracksFreq      1.24657
		cracksOctaves   1
		craterMagn      0.613039
		craterFreq      5.81746
		craterDensity   0.916187
		craterOctaves   12
		craterRayedFactor 0.32875
		volcanoMagn     0.592524
		volcanoFreq     0.964075
		volcanoDensity  0.0594204
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.42279
		volcanoRadius   0.602299
		volcanoTemp     1866.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.126, 0.104, 0.091, 0.000)
		colorShelf     (0.156, 0.129, 0.115, 0.000)
		colorBeach     (0.235, 0.196, 0.173, 0.200)
		colorDesert    (0.214, 0.184, 0.152, 0.500)
		colorLowland   (0.164, 0.142, 0.115, 0.800)
		colorUpland    (0.277, 0.250, 0.214, 1.000)
		colorRock      (0.670, 0.620, 0.550, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.164, 0.142, 0.115, 0.800)
		colorUpPlants  (0.277, 0.250, 0.214, 1.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0119267
		Period          0.0282325
		Eccentricity    0.0103406
		Inclination     -0.180057
		AscendingNode   -133.37
		ArgOfPericenter -135.251
		MeanAnomaly     171.409
	}
}

Moon	"4.6"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            0.300321
	Radius          5281.11
	InertiaMoment   0.328603

	Obliquity       -1.10801
	EqAscendNode    152.815
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.628 0.529 0.445)

	Surface
	{
		SurfStyle       0.332112
		OceanStyle      0.0692088
		Randomize      (-0.278, 0.162, -0.833)
		colorDistMagn   0.0519169
		colorDistFreq   696.283
		detailScale     13583.3
		colorConversion true
		drivenDarkening 0.397219
		seaLevel        0.266542
		snowLevel       2
		tropicLatitude  0.00908902
		icecapLatitude  0.935308
		icecapHeight    0.272656
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.69647
		venusFreq       0.791096
		venusMagn       0.208003
		mareFreq        1.85244
		mareDensity     0.0195577
		terraceProb     0.527907
		erosion         0
		montesMagn      0.187092
		montesFreq      314.473
		montesSpiky     0.949544
		montesFraction  0.740561
		dunesMagn       0.0313955
		dunesFreq       7058.85
		dunesFraction   0.933891
		hillsMagn       0.12088
		hillsFreq       651.814
		hillsFraction   0.035791
		hills2Fraction  0.0766735
		riversMagn      65.0794
		riversFreq      3.04124
		riversSin       4.90682
		riversOctaves   0
		canyonsMagn     0.551348
		canyonsFreq     1.88981
		canyonFraction  0
		cracksMagn      0.0395768
		cracksFreq      2.45086
		cracksOctaves   5
		craterMagn      0.6507
		craterFreq      15.4756
		craterDensity   0.713633
		craterOctaves   13
		craterRayedFactor 0.342127
		volcanoMagn     0.642641
		volcanoFreq     1.2142
		volcanoDensity  0.0585177
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.155516
		volcanoRadius   0.458635
		volcanoTemp     1358.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.628, 0.529, 0.445, 0.500)
		colorShelf     (0.596, 0.502, 0.423, 0.500)
		colorBeach     (0.439, 0.370, 0.312, 0.750)
		colorDesert    (0.533, 0.450, 0.379, 1.000)
		colorLowland   (0.552, 0.465, 0.392, 1.000)
		colorUpland    (0.584, 0.492, 0.414, 1.000)
		colorRock      (1.000, 1.000, 1.000, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.552, 0.465, 0.392, 1.000)
		colorUpPlants  (0.584, 0.492, 0.414, 1.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	Aurora
	{
		Height      52.918
		NorthLat    57.2636
		NorthLon    67.2416
		NorthRadius 1535.06
		NorthWidth  1479.39
		NorthRings  2
		NorthBright 0.3
		NorthParticles 50000
		SouthLat    -59.5263
		SouthLon    244.48
		SouthRadius 1343.24
		SouthWidth  1391.79
		SouthRings  5
		SouthBright 0.3
		SouthParticles 50000
		TopColor    (1.000 1.000 1.000)
		BottomColor (0.000 1.000 0.000)
	}

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0180842
		Period          0.0527029
		Eccentricity    0.0311668
		Inclination     -1.10801
		AscendingNode   152.815
		ArgOfPericenter -15.1857
		MeanAnomaly     143.047
	}
}

Moon	"4.7"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            0.0347992
	Radius          2823.15
	InertiaMoment   0.348284

	Obliquity       0.8216
	EqAscendNode    -171.374
	TidalLocked     true

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.639 0.541 0.473)

	Surface
	{
		SurfStyle       0.486455
		OceanStyle      0.0291431
		Randomize      (-0.369, -0.660, -0.482)
		colorDistMagn   0.087155
		colorDistFreq   349.271
		detailScale     7261.3
		colorConversion true
		drivenDarkening 0.261969
		seaLevel        0.221843
		snowLevel       2
		tropicLatitude  0.00215619
		icecapLatitude  0.576691
		icecapHeight    0.253844
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.73382
		venusFreq       0.675295
		venusMagn       0.214834
		mareFreq        1.53594
		mareDensity     0.00565584
		terraceProb     0.231026
		erosion         0
		montesMagn      0.209391
		montesFreq      150.602
		montesSpiky     0.951289
		montesFraction  0.596842
		dunesMagn       0.045065
		dunesFreq       3723.65
		dunesFraction   0.422394
		hillsMagn       0.142136
		hillsFreq       308.146
		hillsFraction   0.108463
		hills2Fraction  0.0501226
		riversMagn      68.7082
		riversFreq      2.43707
		riversSin       3.9693
		riversOctaves   0
		canyonsMagn     0.416793
		canyonsFreq     1.0594
		canyonFraction  0
		cracksMagn      0.0744695
		cracksFreq      0.865137
		cracksOctaves   2
		craterMagn      0.600432
		craterFreq      10.004
		craterDensity   0.772367
		craterOctaves   12
		craterRayedFactor 0.138562
		volcanoMagn     0.61561
		volcanoFreq     1.1495
		volcanoDensity  0.0542524
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.240472
		volcanoRadius   0.681876
		volcanoTemp     1035.64
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.192, 0.135, 0.104, 0.000)
		colorShelf     (0.237, 0.168, 0.133, 0.000)
		colorBeach     (0.358, 0.254, 0.199, 0.200)
		colorDesert    (0.326, 0.238, 0.175, 0.500)
		colorLowland   (0.249, 0.184, 0.133, 0.800)
		colorUpland    (0.422, 0.324, 0.246, 1.000)
		colorRock      (0.670, 0.620, 0.550, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.249, 0.184, 0.133, 0.800)
		colorUpPlants  (0.422, 0.324, 0.246, 1.000)
		BumpHeight      20
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0274207
		Period          0.0984204
		Eccentricity    0.0283434
		Inclination     0.8216
		AscendingNode   -171.374
		ArgOfPericenter -20.7885
		MeanAnomaly     -154.53
	}
}

DwarfMoon	"4.D1"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.50983e-008
	Radius          41.5585
	InertiaMoment   0.398385

	RotationPeriod  684.589
	Obliquity       59.3883
	EqAscendNode    -164.617

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.521 0.417 0.308)

	Surface
	{
		SurfStyle       0.722182
		OceanStyle      0.185143
		Randomize      (-0.949, -0.645, -0.187)
		colorDistMagn   0.641654
		colorDistFreq   1.14185
		detailScale     1134.82
		colorConversion true
		snowLevel       2
		tropicLatitude  0.226508
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.617626
		terraceProb     0.75077
		erosion         0
		montesMagn      0.627646
		montesFreq      3.3534
		montesSpiky     0.935556
		montesFraction  0.326382
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.86062
		hillsFraction   0.729049
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.298477
		craterFreq      0.257813
		craterDensity   0.848817
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.1285
		volcanoTemp     1944.14
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.203, 0.142, 0.086, 0.000)
		colorShelf     (0.209, 0.146, 0.098, 0.000)
		colorBeach     (0.245, 0.171, 0.117, 0.000)
		colorDesert    (0.266, 0.184, 0.114, 0.000)
		colorLowland   (0.292, 0.196, 0.129, 0.000)
		colorUpland    (0.323, 0.238, 0.157, 0.000)
		colorRock      (0.349, 0.259, 0.169, 0.000)
		colorSnow      (0.381, 0.275, 0.178, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.742996
		Period          13.8821
		Eccentricity    0.414994
		Inclination     62.8057
		AscendingNode   -165.551
		ArgOfPericenter -92.1791
		MeanAnomaly     -116.327
	}
}

DwarfMoon	"4.D2"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.40576e-008
	Radius          44.1846
	InertiaMoment   0.399414

	RotationPeriod  626.238
	Obliquity       21.4127
	EqAscendNode    116.723

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.407 0.402 0.397)

	Surface
	{
		SurfStyle       0.274397
		OceanStyle      0.0819978
		Randomize      (-0.932, 0.208, -0.688)
		colorDistMagn   0.706432
		colorDistFreq   0.532836
		detailScale     1206.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.323933
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.311314
		terraceProb     0.624276
		erosion         0
		montesMagn      0.566769
		montesFreq      3.46431
		montesSpiky     0.988238
		montesFraction  0.334099
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.30033
		hillsFraction   0.700739
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248321
		craterFreq      0.228875
		craterDensity   0.81498
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.5379
		volcanoTemp     1891.16
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.163, 0.161, 0.159, 0.000)
		colorShelf     (0.173, 0.171, 0.169, 0.000)
		colorBeach     (0.183, 0.181, 0.179, 0.000)
		colorDesert    (0.193, 0.191, 0.189, 0.000)
		colorLowland   (0.203, 0.201, 0.199, 0.000)
		colorUpland    (0.213, 0.211, 0.208, 0.000)
		colorRock      (0.224, 0.221, 0.218, 0.000)
		colorSnow      (0.234, 0.231, 0.228, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.743443
		Period          13.8947
		Eccentricity    0.265344
		Inclination     10.8347
		AscendingNode   117.512
		ArgOfPericenter 92.8936
		MeanAnomaly     143.879
	}
}

DwarfMoon	"4.D3"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.62247e-008
	Radius          45.503
	InertiaMoment   0.396885

	RotationPeriod  552.498
	Obliquity       -6.70788
	EqAscendNode    -143.453

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.536 0.469 0.403)

	Surface
	{
		SurfStyle       0.610351
		OceanStyle      0.37261
		Randomize      (-0.022, -0.765, 0.525)
		colorDistMagn   0.537804
		colorDistFreq   1.54678
		detailScale     1242.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.809394
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.361933
		terraceProb     0.274006
		erosion         0
		montesMagn      0.419219
		montesFreq      3.0897
		montesSpiky     0.750251
		montesFraction  0.565872
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.43014
		hillsFraction   0.745985
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.2489
		craterFreq      0.247454
		craterDensity   0.984844
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   33.1825
		volcanoTemp     1787.53
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.209, 0.159, 0.113, 0.000)
		colorShelf     (0.214, 0.164, 0.129, 0.000)
		colorBeach     (0.252, 0.192, 0.153, 0.000)
		colorDesert    (0.273, 0.206, 0.149, 0.000)
		colorLowland   (0.300, 0.220, 0.169, 0.000)
		colorUpland    (0.332, 0.267, 0.206, 0.000)
		colorRock      (0.359, 0.291, 0.222, 0.000)
		colorSnow      (0.391, 0.310, 0.234, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.743969
		Period          13.9094
		Eccentricity    0.22025
		Inclination     48.7054
		AscendingNode   -140.942
		ArgOfPericenter 52.0342
		MeanAnomaly     -165.934
	}
}

DwarfMoon	"4.D4"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.28058e-008
	Radius          59.6222
	InertiaMoment   0.398553

	RotationPeriod  621.667
	Obliquity       -36.8771
	EqAscendNode    -14.167

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.586 0.582 0.576)

	Surface
	{
		SurfStyle       0.646661
		OceanStyle      0.33457
		Randomize      (-0.906, 0.544, -0.480)
		colorDistMagn   0.277211
		colorDistFreq   1.08737
		detailScale     1628.08
		colorConversion true
		snowLevel       2
		tropicLatitude  0.932868
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.519147
		terraceProb     0.269501
		erosion         0
		montesMagn      0.698923
		montesFreq      3.87086
		montesSpiky     0.853217
		montesFraction  0.728278
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.80408
		hillsFraction   0.697576
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238009
		craterFreq      0.258518
		craterDensity   0.91715
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.3004
		volcanoTemp     1565.74
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.229, 0.198, 0.161, 0.000)
		colorShelf     (0.235, 0.204, 0.184, 0.000)
		colorBeach     (0.276, 0.238, 0.219, 0.000)
		colorDesert    (0.299, 0.256, 0.213, 0.000)
		colorLowland   (0.328, 0.273, 0.242, 0.000)
		colorUpland    (0.364, 0.332, 0.294, 0.000)
		colorRock      (0.393, 0.361, 0.317, 0.000)
		colorSnow      (0.428, 0.384, 0.334, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.744622
		Period          13.9278
		Eccentricity    0.213435
		Inclination     -75.4462
		AscendingNode   -14.932
		ArgOfPericenter -68.8003
		MeanAnomaly     -137.43
	}
}

DwarfMoon	"4.D5"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.55021e-008
	Radius          62.8955
	InertiaMoment   0.399543

	RotationPeriod  563.302
	Obliquity       -38.053
	EqAscendNode    -48.056

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.634 0.630 0.627)

	Surface
	{
		SurfStyle       0.33455
		OceanStyle      0.527642
		Randomize      (0.951, 0.521, -0.642)
		colorDistMagn   0.0928313
		colorDistFreq   1.92468
		detailScale     1717.47
		colorConversion true
		snowLevel       2
		tropicLatitude  0.724241
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.705521
		terraceProb     0.253882
		erosion         0
		montesMagn      0.429564
		montesFreq      3.60917
		montesSpiky     0.781219
		montesFraction  0.196501
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.88925
		hillsFraction   0.649318
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.223303
		craterFreq      0.241967
		craterDensity   0.81386
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   33.7238
		volcanoTemp     1731.46
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.254, 0.252, 0.251, 0.000)
		colorShelf     (0.269, 0.268, 0.267, 0.000)
		colorBeach     (0.285, 0.284, 0.282, 0.000)
		colorDesert    (0.301, 0.299, 0.298, 0.000)
		colorLowland   (0.317, 0.315, 0.314, 0.000)
		colorUpland    (0.333, 0.331, 0.329, 0.000)
		colorRock      (0.349, 0.347, 0.345, 0.000)
		colorSnow      (0.365, 0.362, 0.361, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.745228
		Period          13.9447
		Eccentricity    0.370177
		Inclination     -10.6314
		AscendingNode   -42.099
		ArgOfPericenter 91.9643
		MeanAnomaly     9.4055
	}
}

DwarfMoon	"4.D6"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.16737e-007
	Radius          67.0248
	InertiaMoment   0.39725

	RotationPeriod  512.694
	Obliquity       34.843
	EqAscendNode    -92.2446

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.755 0.646 0.608)

	Surface
	{
		SurfStyle       0.0122334
		OceanStyle      0.0761523
		Randomize      (-0.387, 0.774, -0.988)
		colorDistMagn   0.497753
		colorDistFreq   1.36036
		detailScale     1830.22
		colorConversion true
		snowLevel       2
		tropicLatitude  0.761443
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.577005
		terraceProb     0.134673
		erosion         0
		montesMagn      0.583645
		montesFreq      3.37039
		montesSpiky     0.979665
		montesFraction  0.696332
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.94394
		hillsFraction   0.703827
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233496
		craterFreq      0.201503
		craterDensity   0.985232
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.7566
		volcanoTemp     1355.62
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.302, 0.258, 0.243, 0.000)
		colorShelf     (0.321, 0.275, 0.258, 0.000)
		colorBeach     (0.340, 0.291, 0.274, 0.000)
		colorDesert    (0.359, 0.307, 0.289, 0.000)
		colorLowland   (0.378, 0.323, 0.304, 0.000)
		colorUpland    (0.396, 0.339, 0.319, 0.000)
		colorRock      (0.415, 0.355, 0.334, 0.000)
		colorSnow      (0.434, 0.372, 0.350, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.745833
		Period          13.9618
		Eccentricity    0.137197
		Inclination     -31.7194
		AscendingNode   -99.5626
		ArgOfPericenter 91.2861
		MeanAnomaly     -99.9009
	}
}

DwarfMoon	"4.D7"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.6e-007
	Radius          70.2592
	InertiaMoment   0.398711

	RotationPeriod  460.301
	Obliquity       7.4686
	EqAscendNode    123.315

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.541 0.536 0.531)

	Surface
	{
		SurfStyle       0.407258
		OceanStyle      0.291846
		Randomize      (0.286, -0.329, -0.044)
		colorDistMagn   0.172476
		colorDistFreq   0.456759
		detailScale     1918.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.100577
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.704432
		terraceProb     0.279011
		erosion         0
		montesMagn      0.504877
		montesFreq      3.22296
		montesSpiky     0.973949
		montesFraction  0.668316
		dunesFraction   0
		hillsMagn       0
		hillsFreq       15.6491
		hillsFraction   0.533672
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238695
		craterFreq      0.212496
		craterDensity   0.771775
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.5391
		volcanoTemp     1456.37
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.217, 0.215, 0.212, 0.000)
		colorShelf     (0.230, 0.228, 0.225, 0.000)
		colorBeach     (0.244, 0.241, 0.239, 0.000)
		colorDesert    (0.257, 0.255, 0.252, 0.000)
		colorLowland   (0.271, 0.268, 0.265, 0.000)
		colorUpland    (0.284, 0.282, 0.279, 0.000)
		colorRock      (0.298, 0.295, 0.292, 0.000)
		colorSnow      (0.311, 0.308, 0.305, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.746394
		Period          13.9775
		Eccentricity    0.0687905
		Inclination     6.89868
		AscendingNode   132.718
		ArgOfPericenter -66.2284
		MeanAnomaly     -177.985
	}
}

DwarfMoon	"4.D8"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.20382e-007
	Radius          91.4862
	InertiaMoment   0.39967

	RotationPeriod  510.894
	Obliquity       -89.3161
	EqAscendNode    -75.0431

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.469 0.464 0.459)

	Surface
	{
		SurfStyle       0.45243
		OceanStyle      0.67114
		Randomize      (-0.966, -0.003, -0.557)
		colorDistMagn   0.168886
		colorDistFreq   1.45676
		detailScale     2498.18
		colorConversion true
		snowLevel       2
		tropicLatitude  0.985895
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.551937
		terraceProb     0.278468
		erosion         0
		montesMagn      0.329994
		montesFreq      2.25305
		montesSpiky     0.722968
		montesFraction  0.322447
		dunesFraction   0
		hillsMagn       0
		hillsFreq       21.4177
		hillsFraction   0.572865
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.206237
		craterFreq      0.311224
		craterDensity   0.943205
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.5544
		volcanoTemp     1514.74
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.188, 0.186, 0.184, 0.000)
		colorShelf     (0.199, 0.197, 0.195, 0.000)
		colorBeach     (0.211, 0.209, 0.206, 0.000)
		colorDesert    (0.223, 0.220, 0.218, 0.000)
		colorLowland   (0.234, 0.232, 0.229, 0.000)
		colorUpland    (0.246, 0.244, 0.241, 0.000)
		colorRock      (0.258, 0.255, 0.252, 0.000)
		colorSnow      (0.270, 0.267, 0.264, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.746662
		Period          13.985
		Eccentricity    0.269211
		Inclination     -63.8878
		AscendingNode   -78.9156
		ArgOfPericenter -3.55794
		MeanAnomaly     -56.8147
	}
}

DwarfMoon	"4.D9"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.05419e-007
	Radius          96.7181
	InertiaMoment   0.397542

	RotationPeriod  457.977
	Obliquity       -126.323
	EqAscendNode    121.97

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.547 0.476 0.339)

	Surface
	{
		SurfStyle       0.472677
		OceanStyle      0.252954
		Randomize      (0.248, -0.217, -0.374)
		colorDistMagn   0.986985
		colorDistFreq   5.31318
		detailScale     2641.05
		colorConversion true
		snowLevel       2
		tropicLatitude  0.972604
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.641089
		terraceProb     0.293131
		erosion         0
		montesMagn      0.409897
		montesFreq      3.30467
		montesSpiky     0.842319
		montesFraction  0.428002
		dunesFraction   0
		hillsMagn       0
		hillsFreq       20.3757
		hillsFraction   0.658996
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.230355
		craterFreq      0.338907
		craterDensity   0.777048
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.4389
		volcanoTemp     1418.62
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.219, 0.191, 0.136, 0.000)
		colorShelf     (0.232, 0.202, 0.144, 0.000)
		colorBeach     (0.246, 0.214, 0.153, 0.000)
		colorDesert    (0.260, 0.226, 0.161, 0.000)
		colorLowland   (0.273, 0.238, 0.169, 0.000)
		colorUpland    (0.287, 0.250, 0.178, 0.000)
		colorRock      (0.301, 0.262, 0.186, 0.000)
		colorSnow      (0.314, 0.274, 0.195, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.747247
		Period          14.0015
		Eccentricity    0.491301
		Inclination     -74.896
		AscendingNode   119.821
		ArgOfPericenter -14.001
		MeanAnomaly     93.6347
	}
}

DwarfMoon	"4.D10"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.26437e-007
	Radius          103.832
	InertiaMoment   0.398861

	RotationPeriod  417.058
	Obliquity       102.224
	EqAscendNode    -14.2798

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.792 0.790 0.786)

	Surface
	{
		SurfStyle       0.973729
		OceanStyle      0.858602
		Randomize      (0.669, -0.550, 0.195)
		colorDistMagn   0.720418
		colorDistFreq   4.45216
		detailScale     2835.29
		colorConversion true
		snowLevel       2
		tropicLatitude  0.385224
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.617721
		terraceProb     0.458161
		erosion         0
		montesMagn      0.577156
		montesFreq      3.3437
		montesSpiky     0.915024
		montesFraction  0.567222
		dunesFraction   0
		hillsMagn       0
		hillsFreq       20.332
		hillsFraction   0.685444
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.264598
		craterFreq      0.374482
		craterDensity   0.785705
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   24.9292
		volcanoTemp     1486.71
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.269, 0.276, 0.314, 0.050)
		colorShelf     (0.317, 0.324, 0.362, 0.040)
		colorBeach     (0.364, 0.371, 0.409, 0.030)
		colorDesert    (0.412, 0.418, 0.464, 0.020)
		colorLowland   (0.459, 0.466, 0.511, 0.030)
		colorUpland    (0.507, 0.513, 0.558, 0.050)
		colorRock      (0.555, 0.561, 0.621, 0.020)
		colorSnow      (0.555, 0.561, 0.621, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.747668
		Period          14.0133
		Eccentricity    0.391376
		Inclination     59.6651
		AscendingNode   -14.7067
		ArgOfPericenter 168.59
		MeanAnomaly     109.212
	}
}

DwarfMoon	"4.D11"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.00785e-007
	Radius          110.605
	InertiaMoment   0.399796

	RotationPeriod  374.987
	Obliquity       25.2861
	EqAscendNode    41.2957

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.463 0.459 0.454)

	Surface
	{
		SurfStyle       0.179815
		OceanStyle      0.96585
		Randomize      (-0.134, 0.904, -0.857)
		colorDistMagn   0.634573
		colorDistFreq   6.12227
		detailScale     3020.24
		colorConversion true
		snowLevel       2
		tropicLatitude  0.932879
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.353624
		terraceProb     0.141075
		erosion         0
		montesMagn      0.607202
		montesFreq      4.4914
		montesSpiky     0.905057
		montesFraction  0.255596
		dunesFraction   0
		hillsMagn       0
		hillsFreq       34.5735
		hillsFraction   0.674842
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23058
		craterFreq      0.363061
		craterDensity   0.889032
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   22.3728
		volcanoTemp     1437.46
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.185, 0.183, 0.182, 0.000)
		colorShelf     (0.197, 0.195, 0.193, 0.000)
		colorBeach     (0.208, 0.206, 0.204, 0.000)
		colorDesert    (0.220, 0.218, 0.216, 0.000)
		colorLowland   (0.232, 0.229, 0.227, 0.000)
		colorUpland    (0.243, 0.241, 0.238, 0.000)
		colorRock      (0.255, 0.252, 0.250, 0.000)
		colorSnow      (0.266, 0.264, 0.261, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.747972
		Period          14.0218
		Eccentricity    0.440358
		Inclination     48.7216
		AscendingNode   42.5916
		ArgOfPericenter -167.927
		MeanAnomaly     17.9165
	}
}

DwarfMoon	"4.D12"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.55586e-007
	Radius          145.415
	InertiaMoment   0.397788

	RotationPeriod  411.841
	Obliquity       59.882
	EqAscendNode    -153.351

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.458 0.455 0.450)

	Surface
	{
		SurfStyle       0.326718
		OceanStyle      0.713941
		Randomize      (0.160, 0.193, -0.755)
		colorDistMagn   0.903061
		colorDistFreq   14.5135
		detailScale     3970.81
		colorConversion true
		snowLevel       2
		tropicLatitude  0.568818
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.633883
		terraceProb     0.478407
		erosion         0
		montesMagn      0.530972
		montesFreq      3.04688
		montesSpiky     0.907362
		montesFraction  0.750217
		dunesFraction   0
		hillsMagn       0
		hillsFreq       44.6196
		hillsFraction   0.585947
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.223207
		craterFreq      0.723798
		craterDensity   0.839642
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   24.6481
		volcanoTemp     1287.39
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.183, 0.182, 0.180, 0.000)
		colorShelf     (0.195, 0.193, 0.191, 0.000)
		colorBeach     (0.206, 0.205, 0.202, 0.000)
		colorDesert    (0.218, 0.216, 0.214, 0.000)
		colorLowland   (0.229, 0.227, 0.225, 0.000)
		colorUpland    (0.241, 0.239, 0.236, 0.000)
		colorRock      (0.252, 0.250, 0.247, 0.000)
		colorSnow      (0.263, 0.261, 0.259, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.748331
		Period          14.0319
		Eccentricity    0.491157
		Inclination     29.3254
		AscendingNode   -155.331
		ArgOfPericenter -179.217
		MeanAnomaly     68.7267
	}
}

DwarfMoon	"4.D13"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.23428e-006
	Radius          155.008
	InertiaMoment   0.399005

	RotationPeriod  366.339
	Obliquity       11.2554
	EqAscendNode    -15.7596

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.526 0.457 0.378)

	Surface
	{
		SurfStyle       0.542405
		OceanStyle      0.450845
		Randomize      (0.661, 0.110, -0.950)
		colorDistMagn   0.625771
		colorDistFreq   15.7538
		detailScale     4232.75
		colorConversion true
		snowLevel       2
		tropicLatitude  0.844101
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.667925
		terraceProb     0.10813
		erosion         0
		montesMagn      0.584763
		montesFreq      2.24602
		montesSpiky     0.852655
		montesFraction  0.291376
		dunesFraction   0
		hillsMagn       0
		hillsFreq       59.3754
		hillsFraction   0.645703
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.239055
		craterFreq      0.60175
		craterDensity   1.05053
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   21.8752
		volcanoTemp     1439.05
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.205, 0.155, 0.106, 0.000)
		colorShelf     (0.211, 0.160, 0.121, 0.000)
		colorBeach     (0.247, 0.187, 0.144, 0.000)
		colorDesert    (0.268, 0.201, 0.140, 0.000)
		colorLowland   (0.295, 0.215, 0.159, 0.000)
		colorUpland    (0.326, 0.260, 0.193, 0.000)
		colorRock      (0.353, 0.283, 0.208, 0.000)
		colorSnow      (0.384, 0.301, 0.219, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.748534
		Period          14.0377
		Eccentricity    0.00230482
		Inclination     46.6938
		AscendingNode   -16.0174
		ArgOfPericenter 142.801
		MeanAnomaly     -117.072
	}
}

DwarfMoon	"4.D14"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.80841e-006
	Radius          169.029
	InertiaMoment   0.399922

	RotationPeriod  330.599
	Obliquity       14.0529
	EqAscendNode    80.1702

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.578 0.575 0.571)

	Surface
	{
		SurfStyle       0.574248
		OceanStyle      0.0301349
		Randomize      (-0.532, -0.744, 0.178)
		colorDistMagn   0.328748
		colorDistFreq   22.9502
		detailScale     4615.61
		colorConversion true
		snowLevel       2
		tropicLatitude  0.237103
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.444853
		terraceProb     0.300945
		erosion         0
		montesMagn      0.419052
		montesFreq      3.19293
		montesSpiky     0.976558
		montesFraction  0.418049
		dunesFraction   0
		hillsMagn       0
		hillsFreq       29.0477
		hillsFraction   0.806257
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236517
		craterFreq      1.05955
		craterDensity   0.983393
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   19.7069
		volcanoTemp     1300.92
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.226, 0.195, 0.160, 0.000)
		colorShelf     (0.231, 0.201, 0.183, 0.000)
		colorBeach     (0.272, 0.236, 0.217, 0.000)
		colorDesert    (0.295, 0.253, 0.211, 0.000)
		colorLowland   (0.324, 0.270, 0.240, 0.000)
		colorUpland    (0.359, 0.328, 0.291, 0.000)
		colorRock      (0.388, 0.356, 0.314, 0.000)
		colorSnow      (0.422, 0.379, 0.331, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.748784
		Period          14.0447
		Eccentricity    0.417836
		Inclination     -4.50149
		AscendingNode   76.6356
		ArgOfPericenter -150.289
		MeanAnomaly     -32.059
	}
}

DwarfMoon	"4.D15"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.69963e-006
	Radius          184.328
	InertiaMoment   0.398006

	RotationPeriod  294.538
	Obliquity       -69.8467
	EqAscendNode    -84.1715

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.709 0.596 0.508)

	Surface
	{
		SurfStyle       0.144664
		OceanStyle      0.273819
		Randomize      (-0.035, -0.085, -0.594)
		colorDistMagn   0.0633397
		colorDistFreq   4.13191
		detailScale     5033.39
		colorConversion true
		snowLevel       2
		tropicLatitude  0.964945
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.607001
		terraceProb     0.119883
		erosion         0
		montesMagn      0.443886
		montesFreq      3.39324
		montesSpiky     0.941223
		montesFraction  0.594399
		dunesFraction   0
		hillsMagn       0
		hillsFreq       97.2558
		hillsFraction   0.785602
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.237639
		craterFreq      1.19324
		craterDensity   0.69294
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   17.5892
		volcanoTemp     1319.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.284, 0.239, 0.203, 0.000)
		colorShelf     (0.301, 0.254, 0.216, 0.000)
		colorBeach     (0.319, 0.268, 0.228, 0.000)
		colorDesert    (0.337, 0.283, 0.241, 0.000)
		colorLowland   (0.355, 0.298, 0.254, 0.000)
		colorUpland    (0.372, 0.313, 0.266, 0.000)
		colorRock      (0.390, 0.328, 0.279, 0.000)
		colorSnow      (0.408, 0.343, 0.292, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.749043
		Period          14.052
		Eccentricity    0.203423
		Inclination     -22.4046
		AscendingNode   -80.9837
		ArgOfPericenter -91.1245
		MeanAnomaly     -166.35
	}
}

Moon	"4.8"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            4.12303e-006
	Radius          248.988
	InertiaMoment   0.399144

	RotationPeriod  322.253
	Obliquity       -83.5852
	EqAscendNode    -137.972

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.680 0.678 0.677)

	Surface
	{
		SurfStyle       0.861099
		OceanStyle      0.685552
		Randomize      (-0.578, -0.393, -0.993)
		colorDistMagn   0.0640191
		colorDistFreq   31.6499
		detailScale     640.41
		colorConversion true
		drivenDarkening 0.00958708
		seaLevel        0.290993
		snowLevel       2
		tropicLatitude  0.732004
		icecapLatitude  1
		icecapHeight    0.290993
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.74208
		venusFreq       1.19898
		venusMagn       0.198063
		mareFreq        0
		mareDensity     1.07195e-006
		terraceProb     0.234182
		erosion         0
		montesMagn      0.0489819
		montesFreq      9.17572
		montesSpiky     0.951859
		montesFraction  0.99293
		dunesMagn       0.0451265
		dunesFreq       328.037
		dunesFraction   0.627888
		hillsMagn       0.100125
		hillsFreq       30.8887
		hillsFraction   0.0443791
		hills2Fraction  0.122349
		riversMagn      62.2466
		riversFreq      2.91664
		riversSin       5.65333
		riversOctaves   0
		canyonsMagn     0.509904
		canyonsFreq     0.0833688
		canyonFraction  0
		cracksMagn      0.0496607
		cracksFreq      0.0915634
		cracksOctaves   0
		craterMagn      1.02227
		craterFreq      0.756186
		craterDensity   0.984207
		craterOctaves   8
		craterRayedFactor 0.172664
		volcanoMagn     0.195311
		volcanoFreq     1.28613
		volcanoDensity  0.0640133
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.0381401
		volcanoRadius   6.18157
		volcanoTemp     1796.31
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.680, 0.509, 0.389, 0.000)
		colorShelf     (0.646, 0.483, 0.369, 0.000)
		colorBeach     (0.340, 0.254, 0.194, 0.000)
		colorDesert    (0.578, 0.433, 0.330, 0.000)
		colorLowland   (0.551, 0.448, 0.369, 0.000)
		colorUpland    (0.633, 0.473, 0.362, 0.000)
		colorRock      (1.000, 1.000, 1.000, 0.500)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.551, 0.448, 0.369, 0.000)
		colorUpPlants  (0.633, 0.473, 0.362, 0.000)
		BumpHeight      12.4494
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.749278
		Period          14.0586
		Eccentricity    0.0387595
		Inclination     -50.1403
		AscendingNode   -143.061
		ArgOfPericenter 68.1936
		MeanAnomaly     -88.7696
	}
}

DwarfMoon	"4.D16"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.04634e-011
	Radius          3.181
	InertiaMoment   0.395291

	RotationPeriod  2481.85
	Obliquity       41.6964
	EqAscendNode    5.65273

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.728 0.726 0.723)

	Surface
	{
		SurfStyle       0.976771
		OceanStyle      0.399375
		Randomize      (0.043, 0.369, 0.188)
		colorDistMagn   0.466437
		colorDistFreq   0.00721832
		detailScale     86.8625
		colorConversion true
		snowLevel       2
		tropicLatitude  0.976096
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.760945
		terraceProb     0.388185
		erosion         0
		montesMagn      0.42321
		montesFreq      3.19676
		montesSpiky     0.99755
		montesFraction  0.421799
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0240669
		hillsFraction   0.515711
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24337
		craterFreq      0.253646
		craterDensity   0.645516
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   154.182
		volcanoTemp     1303.43
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.247, 0.254, 0.289, 0.050)
		colorShelf     (0.291, 0.298, 0.333, 0.040)
		colorBeach     (0.335, 0.341, 0.376, 0.030)
		colorDesert    (0.379, 0.385, 0.427, 0.020)
		colorLowland   (0.422, 0.428, 0.470, 0.030)
		colorUpland    (0.466, 0.472, 0.513, 0.050)
		colorRock      (0.510, 0.516, 0.571, 0.020)
		colorSnow      (0.510, 0.516, 0.571, 1.000)
		BumpHeight      2.8629
		BumpOffset      0.57258
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.749711
		Period          14.0708
		Eccentricity    0.166189
		Inclination     61.1327
		AscendingNode   7.28575
		ArgOfPericenter 153.371
		MeanAnomaly     74.4777
	}
}

DwarfMoon	"4.D17"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.18613e-011
	Radius          3.90126
	InertiaMoment   0.398201

	RotationPeriod  2126.21
	Obliquity       67.9007
	EqAscendNode    133.787

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.617 0.612 0.608)

	Surface
	{
		SurfStyle       0.695213
		OceanStyle      0.249608
		Randomize      (-0.352, 0.546, -0.094)
		colorDistMagn   0.742277
		colorDistFreq   0.00175237
		detailScale     106.53
		colorConversion true
		snowLevel       2
		tropicLatitude  0.953238
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.471076
		terraceProb     0.452844
		erosion         0
		montesMagn      0.380348
		montesFreq      3.82035
		montesSpiky     0.824204
		montesFraction  0.84331
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0365996
		hillsFraction   0.545105
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248037
		craterFreq      0.269529
		craterDensity   0.822189
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   130.819
		volcanoTemp     1501.74
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.241, 0.208, 0.170, 0.000)
		colorShelf     (0.247, 0.214, 0.194, 0.000)
		colorBeach     (0.290, 0.251, 0.231, 0.000)
		colorDesert    (0.315, 0.269, 0.225, 0.000)
		colorLowland   (0.345, 0.288, 0.255, 0.000)
		colorUpland    (0.382, 0.349, 0.310, 0.000)
		colorRock      (0.413, 0.379, 0.334, 0.000)
		colorSnow      (0.450, 0.404, 0.352, 1.000)
		BumpHeight      3.51113
		BumpOffset      0.702226
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.750165
		Period          14.0836
		Eccentricity    0.395592
		Inclination     -6.60351
		AscendingNode   132.145
		ArgOfPericenter 37.6836
		MeanAnomaly     163.635
	}
}

DwarfMoon	"4.D18"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.12008e-011
	Radius          4.61059
	InertiaMoment   0.399279

	RotationPeriod  1841.6
	Obliquity       -2.73913
	EqAscendNode    160.376

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.812 0.753 0.677)

	Surface
	{
		SurfStyle       0.777261
		OceanStyle      0.692216
		Randomize      (0.315, -0.078, -0.525)
		colorDistMagn   0.79233
		colorDistFreq   0.0117361
		detailScale     125.9
		colorConversion true
		snowLevel       2
		tropicLatitude  0.520368
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.544903
		terraceProb     0.531027
		erosion         0
		montesMagn      0.408875
		montesFreq      2.7628
		montesSpiky     0.969848
		montesFraction  0.695615
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0448123
		hillsFraction   0.586502
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.2613
		craterFreq      0.236644
		craterDensity   0.976485
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   112.618
		volcanoTemp     1496.56
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.317, 0.256, 0.190, 0.000)
		colorShelf     (0.325, 0.264, 0.217, 0.000)
		colorBeach     (0.382, 0.309, 0.257, 0.000)
		colorDesert    (0.414, 0.331, 0.251, 0.000)
		colorLowland   (0.455, 0.354, 0.285, 0.000)
		colorUpland    (0.504, 0.429, 0.345, 0.000)
		colorRock      (0.544, 0.467, 0.373, 0.000)
		colorSnow      (0.593, 0.497, 0.393, 1.000)
		BumpHeight      4.14953
		BumpOffset      0.829906
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.750401
		Period          14.0902
		Eccentricity    0.265517
		Inclination     28.6987
		AscendingNode   165.454
		ArgOfPericenter 84.2441
		MeanAnomaly     -8.27955
	}
}

DwarfMoon	"4.D19"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.22772e-011
	Radius          6.58326
	InertiaMoment   0.396355

	RotationPeriod  1973.78
	Obliquity       26.2045
	EqAscendNode    -44.666

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.428 0.424 0.418)

	Surface
	{
		SurfStyle       0.582021
		OceanStyle      0.501746
		Randomize      (-0.049, 0.693, 0.496)
		colorDistMagn   0.16897
		colorDistFreq   0.0331239
		detailScale     179.767
		colorConversion true
		snowLevel       2
		tropicLatitude  0.439051
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.597284
		terraceProb     0.113515
		erosion         0
		montesMagn      0.433929
		montesFreq      2.8321
		montesSpiky     0.962218
		montesFraction  0.760808
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.114277
		hillsFraction   0.629384
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.259199
		craterFreq      0.196087
		craterDensity   0.97513
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   121.408
		volcanoTemp     1053.58
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.167, 0.144, 0.117, 0.000)
		colorShelf     (0.171, 0.148, 0.134, 0.000)
		colorBeach     (0.201, 0.174, 0.159, 0.000)
		colorDesert    (0.218, 0.187, 0.155, 0.000)
		colorLowland   (0.240, 0.199, 0.176, 0.000)
		colorUpland    (0.266, 0.242, 0.213, 0.000)
		colorRock      (0.287, 0.263, 0.230, 0.000)
		colorSnow      (0.313, 0.280, 0.242, 1.000)
		BumpHeight      5.92493
		BumpOffset      1.18499
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.751012
		Period          14.1074
		Eccentricity    0.360564
		Inclination     -36.3058
		AscendingNode   -47.8611
		ArgOfPericenter -99.2328
		MeanAnomaly     -86.6423
	}
}

DwarfMoon	"4.D20"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.20285e-010
	Radius          7.22804
	InertiaMoment   0.398381

	RotationPeriod  1692.09
	Obliquity       -117.71
	EqAscendNode    1.22789

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.649 0.646 0.642)

	Surface
	{
		SurfStyle       0.646914
		OceanStyle      0.0118782
		Randomize      (0.474, -0.591, 0.725)
		colorDistMagn   0.596504
		colorDistFreq   0.0335287
		detailScale     197.374
		colorConversion true
		snowLevel       2
		tropicLatitude  0.207637
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.374428
		terraceProb     0.647294
		erosion         0
		montesMagn      0.411243
		montesFreq      3.00118
		montesSpiky     0.938286
		montesFraction  0.464809
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0823608
		hillsFraction   0.463496
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.239031
		craterFreq      0.240324
		craterDensity   0.837139
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   103.329
		volcanoTemp     1526.32
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.253, 0.220, 0.180, 0.000)
		colorShelf     (0.260, 0.226, 0.206, 0.000)
		colorBeach     (0.305, 0.265, 0.244, 0.000)
		colorDesert    (0.331, 0.284, 0.238, 0.000)
		colorLowland   (0.364, 0.303, 0.270, 0.000)
		colorUpland    (0.403, 0.368, 0.328, 0.000)
		colorRock      (0.435, 0.400, 0.353, 0.000)
		colorSnow      (0.474, 0.426, 0.373, 1.000)
		BumpHeight      6.50523
		BumpOffset      1.30105
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.751634
		Period          14.1249
		Eccentricity    0.285016
		Inclination     -74.272
		AscendingNode   -0.245216
		ArgOfPericenter 86.8352
		MeanAnomaly     156.101
	}
}

DwarfMoon	"4.D21"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.9228e-010
	Radius          8.09829
	InertiaMoment   0.399411

	RotationPeriod  1506.04
	Obliquity       -125.316
	EqAscendNode    2.37794

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.753 0.729 0.691)

	Surface
	{
		SurfStyle       0.367848
		OceanStyle      0.258832
		Randomize      (-0.629, -0.220, 0.134)
		colorDistMagn   0.47687
		colorDistFreq   0.0436776
		detailScale     221.137
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0431069
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.440228
		terraceProb     0.523403
		erosion         0
		montesMagn      0.611138
		montesFreq      4.16322
		montesSpiky     0.971889
		montesFraction  0.497717
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.118579
		hillsFraction   0.512672
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.237329
		craterFreq      0.215982
		craterDensity   0.935112
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   91.5656
		volcanoTemp     1555.74
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.301, 0.292, 0.276, 0.000)
		colorShelf     (0.320, 0.310, 0.294, 0.000)
		colorBeach     (0.339, 0.328, 0.311, 0.000)
		colorDesert    (0.358, 0.346, 0.328, 0.000)
		colorLowland   (0.377, 0.365, 0.346, 0.000)
		colorUpland    (0.395, 0.383, 0.363, 0.000)
		colorRock      (0.414, 0.401, 0.380, 0.000)
		colorSnow      (0.433, 0.419, 0.397, 1.000)
		BumpHeight      7.28846
		BumpOffset      1.45769
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.752102
		Period          14.1381
		Eccentricity    0.292723
		Inclination     -55.8846
		AscendingNode   2.62707
		ArgOfPericenter 133.663
		MeanAnomaly     -5.73307
	}
}

DwarfMoon	"4.D22"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.97788e-010
	Radius          8.98081
	InertiaMoment   0.396875

	RotationPeriod  1341.43
	Obliquity       47.4044
	EqAscendNode    181.518

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.493 0.490 0.487)

	Surface
	{
		SurfStyle       0.524813
		OceanStyle      0.878769
		Randomize      (0.048, -0.596, 0.230)
		colorDistMagn   0.461149
		colorDistFreq   0.0443959
		detailScale     245.236
		colorConversion true
		snowLevel       2
		tropicLatitude  0.415377
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.496376
		terraceProb     0.226388
		erosion         0
		montesMagn      0.390447
		montesFreq      2.41876
		montesSpiky     0.904434
		montesFraction  0.58352
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.181921
		hillsFraction   0.694151
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.242818
		craterFreq      0.266812
		craterDensity   0.891929
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   81.5958
		volcanoTemp     1545.48
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.192, 0.167, 0.136, 0.000)
		colorShelf     (0.197, 0.171, 0.156, 0.000)
		colorBeach     (0.232, 0.201, 0.185, 0.000)
		colorDesert    (0.251, 0.216, 0.180, 0.000)
		colorLowland   (0.276, 0.230, 0.205, 0.000)
		colorUpland    (0.306, 0.279, 0.249, 0.000)
		colorRock      (0.330, 0.304, 0.268, 0.000)
		colorSnow      (0.360, 0.323, 0.283, 1.000)
		BumpHeight      8.08273
		BumpOffset      1.61655
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.752386
		Period          14.1461
		Eccentricity    0.0732344
		Inclination     22.875
		AscendingNode   178.492
		ArgOfPericenter 36.3668
		MeanAnomaly     5.2579
	}
}

DwarfMoon	"4.D23"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.49615e-010
	Radius          12.4281
	InertiaMoment   0.398549

	RotationPeriod  1509.78
	Obliquity       -4.35902
	EqAscendNode    13.9423

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.586 0.496 0.440)

	Surface
	{
		SurfStyle       0.079646
		OceanStyle      0.918933
		Randomize      (-0.585, -0.451, -0.916)
		colorDistMagn   0.57328
		colorDistFreq   0.0468633
		detailScale     339.371
		colorConversion true
		snowLevel       2
		tropicLatitude  0.731933
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.570336
		terraceProb     0.205678
		erosion         0
		montesMagn      0.549019
		montesFreq      2.87607
		montesSpiky     0.768404
		montesFraction  0.376831
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.384189
		hillsFraction   0.418345
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248973
		craterFreq      0.224993
		craterDensity   0.897173
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   91.8949
		volcanoTemp     1541.48
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.235, 0.198, 0.176, 0.000)
		colorShelf     (0.249, 0.211, 0.187, 0.000)
		colorBeach     (0.264, 0.223, 0.198, 0.000)
		colorDesert    (0.279, 0.235, 0.209, 0.000)
		colorLowland   (0.293, 0.248, 0.220, 0.000)
		colorUpland    (0.308, 0.260, 0.231, 0.000)
		colorRock      (0.323, 0.273, 0.242, 0.000)
		colorSnow      (0.337, 0.285, 0.253, 1.000)
		BumpHeight      11.1853
		BumpOffset      2.23706
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.752728
		Period          14.1558
		Eccentricity    0.194182
		Inclination     -42.8796
		AscendingNode   17.636
		ArgOfPericenter -141.276
		MeanAnomaly     -151.606
	}
}

DwarfMoon	"4.D24"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.6493e-010
	Radius          12.8731
	InertiaMoment   0.39954

	RotationPeriod  1292.16
	Obliquity       40.6291
	EqAscendNode    -150.881

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.641 0.636 0.633)

	Surface
	{
		SurfStyle       0.705399
		OceanStyle      0.754059
		Randomize      (0.353, 0.054, 0.099)
		colorDistMagn   0.26593
		colorDistFreq   0.0809366
		detailScale     351.521
		colorConversion true
		snowLevel       2
		tropicLatitude  0.316833
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.317609
		terraceProb     0.489566
		erosion         0
		montesMagn      0.443228
		montesFreq      2.725
		montesSpiky     0.879425
		montesFraction  0.683359
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.381875
		hillsFraction   0.48414
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.245368
		craterFreq      0.26582
		craterDensity   0.735036
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   78.2709
		volcanoTemp     1377.22
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.250, 0.216, 0.177, 0.000)
		colorShelf     (0.257, 0.223, 0.202, 0.000)
		colorBeach     (0.301, 0.261, 0.240, 0.000)
		colorDesert    (0.327, 0.280, 0.234, 0.000)
		colorLowland   (0.359, 0.299, 0.266, 0.000)
		colorUpland    (0.398, 0.363, 0.323, 0.000)
		colorRock      (0.430, 0.394, 0.348, 0.000)
		colorSnow      (0.468, 0.420, 0.367, 1.000)
		BumpHeight      11.5858
		BumpOffset      2.31715
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.753083
		Period          14.1658
		Eccentricity    0.199912
		Inclination     28.0991
		AscendingNode   -155.461
		ArgOfPericenter 130.445
		MeanAnomaly     -153.759
	}
}

DwarfMoon	"4.D25"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            9.66697e-010
	Radius          13.9515
	InertiaMoment   0.397243

	RotationPeriod  1160.61
	Obliquity       26.006
	EqAscendNode    149.872

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.623 0.619 0.616)

	Surface
	{
		SurfStyle       0.805191
		OceanStyle      0.764015
		Randomize      (-0.514, 0.613, -0.779)
		colorDistMagn   0.382873
		colorDistFreq   0.161029
		detailScale     380.97
		colorConversion true
		snowLevel       2
		tropicLatitude  0.445644
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.730866
		terraceProb     0.294655
		erosion         0
		montesMagn      0.479306
		montesFreq      3.76322
		montesSpiky     0.994403
		montesFraction  0.853265
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.385967
		hillsFraction   0.487952
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.273895
		craterFreq      0.19473
		craterDensity   0.855669
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   70.353
		volcanoTemp     1433.8
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.243, 0.211, 0.172, 0.000)
		colorShelf     (0.249, 0.217, 0.197, 0.000)
		colorBeach     (0.293, 0.254, 0.234, 0.000)
		colorDesert    (0.318, 0.272, 0.228, 0.000)
		colorLowland   (0.349, 0.291, 0.259, 0.000)
		colorUpland    (0.387, 0.353, 0.314, 0.000)
		colorRock      (0.418, 0.384, 0.339, 0.000)
		colorSnow      (0.455, 0.409, 0.357, 1.000)
		BumpHeight      12.5564
		BumpOffset      2.51128
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.753284
		Period          14.1715
		Eccentricity    0.36637
		Inclination     -0.518094
		AscendingNode   152.013
		ArgOfPericenter -163.067
		MeanAnomaly     -111.564
	}
}

DwarfMoon	"4.D26"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.38561e-009
	Radius          15.0956
	InertiaMoment   0.398707

	RotationPeriod  1052.7
	Obliquity       25.6174
	EqAscendNode    143.978

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.721 0.718 0.715)

	Surface
	{
		SurfStyle       0.354836
		OceanStyle      0.450795
		Randomize      (-0.843, -0.222, -0.511)
		colorDistMagn   0.774148
		colorDistFreq   0.102493
		detailScale     412.21
		colorConversion true
		snowLevel       2
		tropicLatitude  0.629193
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.646359
		terraceProb     0.426381
		erosion         0
		montesMagn      0.442684
		montesFreq      2.50517
		montesSpiky     0.985982
		montesFraction  0.415427
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.540484
		hillsFraction   0.725366
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.229051
		craterFreq      0.211485
		craterDensity   0.996853
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   63.5822
		volcanoTemp     1558.7
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.289, 0.287, 0.286, 0.000)
		colorShelf     (0.307, 0.305, 0.304, 0.000)
		colorBeach     (0.325, 0.323, 0.322, 0.000)
		colorDesert    (0.343, 0.341, 0.340, 0.000)
		colorLowland   (0.361, 0.359, 0.357, 0.000)
		colorUpland    (0.379, 0.377, 0.375, 0.000)
		colorRock      (0.397, 0.395, 0.393, 0.000)
		colorSnow      (0.415, 0.413, 0.411, 1.000)
		BumpHeight      13.586
		BumpOffset      2.7172
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.753512
		Period          14.1779
		Eccentricity    0.112231
		Inclination     -14.9016
		AscendingNode   147.841
		ArgOfPericenter -78.4431
		MeanAnomaly     -21.9828
	}
}

DwarfMoon	"4.D27"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.96266e-009
	Radius          21.5143
	InertiaMoment   0.399667

	RotationPeriod  1257.94
	Obliquity       37.7812
	EqAscendNode    -166.663

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.617 0.611 0.607)

	Surface
	{
		SurfStyle       0.884779
		OceanStyle      0.497812
		Randomize      (0.139, 0.128, 0.359)
		colorDistMagn   0.437195
		colorDistFreq   0.266268
		detailScale     587.485
		colorConversion true
		snowLevel       2
		tropicLatitude  0.276768
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.446882
		terraceProb     0.24298
		erosion         0
		montesMagn      0.499211
		montesFreq      2.99754
		montesSpiky     0.928475
		montesFraction  0.464341
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.924314
		hillsFraction   0.551628
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.226268
		craterFreq      0.242283
		craterDensity   0.949388
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   76.1397
		volcanoTemp     1837.9
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.210, 0.214, 0.243, 0.050)
		colorShelf     (0.247, 0.251, 0.279, 0.040)
		colorBeach     (0.284, 0.287, 0.315, 0.030)
		colorDesert    (0.321, 0.324, 0.358, 0.020)
		colorLowland   (0.358, 0.360, 0.394, 0.030)
		colorUpland    (0.395, 0.397, 0.431, 0.050)
		colorRock      (0.432, 0.434, 0.479, 0.020)
		colorSnow      (0.432, 0.434, 0.479, 1.000)
		BumpHeight      19.3629
		BumpOffset      3.87258
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.75414
		Period          14.1956
		Eccentricity    0.0662844
		Inclination     23.2577
		AscendingNode   -166.076
		ArgOfPericenter 60.4087
		MeanAnomaly     -99.748
	}
}

DwarfMoon	"4.D28"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.75269e-009
	Radius          20.8324
	InertiaMoment   0.397536

	RotationPeriod  1029.61
	Obliquity       -85.2922
	EqAscendNode    -144.397

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.623 0.525 0.432)

	Surface
	{
		SurfStyle       0.385871
		OceanStyle      0.697369
		Randomize      (-0.761, 0.434, 0.505)
		colorDistMagn   0.51312
		colorDistFreq   0.293388
		detailScale     568.863
		colorConversion true
		snowLevel       2
		tropicLatitude  0.628248
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.703965
		terraceProb     0.208322
		erosion         0
		montesMagn      0.433936
		montesFreq      3.02471
		montesSpiky     0.981342
		montesFraction  0.865913
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.12601
		hillsFraction   0.707581
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.221199
		craterFreq      0.225869
		craterDensity   0.900245
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   62.2538
		volcanoTemp     1472.97
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.249, 0.210, 0.173, 0.000)
		colorShelf     (0.265, 0.223, 0.184, 0.000)
		colorBeach     (0.280, 0.236, 0.194, 0.000)
		colorDesert    (0.296, 0.249, 0.205, 0.000)
		colorLowland   (0.312, 0.262, 0.216, 0.000)
		colorUpland    (0.327, 0.275, 0.227, 0.000)
		colorRock      (0.343, 0.289, 0.238, 0.000)
		colorSnow      (0.358, 0.302, 0.248, 1.000)
		BumpHeight      18.7491
		BumpOffset      3.74983
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.754534
		Period          14.2068
		Eccentricity    0.291065
		Inclination     -73.8217
		AscendingNode   -142.087
		ArgOfPericenter -130.425
		MeanAnomaly     173.965
	}
}

DwarfMoon	"4.D29"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.82907e-009
	Radius          22.2003
	InertiaMoment   0.398858

	RotationPeriod  933.319
	Obliquity       66.9675
	EqAscendNode    -146.675

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.441 0.434 0.430)

	Surface
	{
		SurfStyle       0.130762
		OceanStyle      0.294161
		Randomize      (-0.257, -0.202, 0.244)
		colorDistMagn   0.971668
		colorDistFreq   0.404289
		detailScale     606.215
		colorConversion true
		snowLevel       2
		tropicLatitude  0.983479
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.459579
		terraceProb     0.32715
		erosion         0
		montesMagn      0.54881
		montesFreq      3.99144
		montesSpiky     0.991331
		montesFraction  0.750939
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.37296
		hillsFraction   0.342395
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238106
		craterFreq      0.250244
		craterDensity   0.97785
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   56.2493
		volcanoTemp     1428.12
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.177, 0.173, 0.172, 0.000)
		colorShelf     (0.188, 0.184, 0.183, 0.000)
		colorBeach     (0.199, 0.195, 0.194, 0.000)
		colorDesert    (0.210, 0.206, 0.204, 0.000)
		colorLowland   (0.221, 0.217, 0.215, 0.000)
		colorUpland    (0.232, 0.228, 0.226, 0.000)
		colorRock      (0.243, 0.238, 0.237, 0.000)
		colorSnow      (0.254, 0.249, 0.247, 1.000)
		BumpHeight      19.9802
		BumpOffset      3.99605
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.755041
		Period          14.2211
		Eccentricity    0.162737
		Inclination     -15.5367
		AscendingNode   -142.643
		ArgOfPericenter -135.1
		MeanAnomaly     -34.634
	}
}

DwarfMoon	"4.D30"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.29023e-009
	Radius          23.7446
	InertiaMoment   0.399794

	RotationPeriod  851.408
	Obliquity       11.9971
	EqAscendNode    -24.4167

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.518 0.402 0.360)

	Surface
	{
		SurfStyle       0.177599
		OceanStyle      0.364703
		Randomize      (-0.303, -0.764, -0.064)
		colorDistMagn   0.95783
		colorDistFreq   0.438415
		detailScale     648.385
		colorConversion true
		snowLevel       2
		tropicLatitude  0.727451
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.514791
		terraceProb     0.356262
		erosion         0
		montesMagn      0.51974
		montesFreq      3.15459
		montesSpiky     0.927512
		montesFraction  0.58882
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.40315
		hillsFraction   0.755538
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.237212
		craterFreq      0.22645
		craterDensity   0.958696
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   51.1838
		volcanoTemp     1631.61
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.207, 0.161, 0.144, 0.000)
		colorShelf     (0.220, 0.171, 0.153, 0.000)
		colorBeach     (0.233, 0.181, 0.162, 0.000)
		colorDesert    (0.246, 0.191, 0.171, 0.000)
		colorLowland   (0.259, 0.201, 0.180, 0.000)
		colorUpland    (0.272, 0.211, 0.189, 0.000)
		colorRock      (0.285, 0.221, 0.198, 0.000)
		colorSnow      (0.298, 0.231, 0.207, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.75564
		Period          14.238
		Eccentricity    0.407227
		Inclination     35.4695
		AscendingNode   -23.6605
		ArgOfPericenter 14.253
		MeanAnomaly     -115.622
	}
}

DwarfMoon	"4.D31"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.26856e-009
	Radius          24.5243
	InertiaMoment   0.397783

	RotationPeriod  749.561
	Obliquity       -39.9858
	EqAscendNode    152.141

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.496 0.419 0.382)

	Surface
	{
		SurfStyle       0.949566
		OceanStyle      0.163509
		Randomize      (0.143, 0.524, 0.306)
		colorDistMagn   0.722761
		colorDistFreq   0.164171
		detailScale     669.678
		colorConversion true
		snowLevel       2
		tropicLatitude  0.998401
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.452212
		terraceProb     0.317842
		erosion         0
		montesMagn      0.549006
		montesFreq      3.59275
		montesSpiky     0.779961
		montesFraction  0.440405
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.38388
		hillsFraction   0.727094
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.253031
		craterFreq      0.270063
		craterDensity   0.956573
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   45.1003
		volcanoTemp     1991.92
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.169, 0.147, 0.153, 0.050)
		colorShelf     (0.198, 0.172, 0.176, 0.040)
		colorBeach     (0.228, 0.197, 0.199, 0.030)
		colorDesert    (0.258, 0.222, 0.226, 0.020)
		colorLowland   (0.288, 0.247, 0.249, 0.030)
		colorUpland    (0.317, 0.272, 0.272, 0.050)
		colorRock      (0.347, 0.297, 0.302, 0.020)
		colorSnow      (0.347, 0.297, 0.302, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.755975
		Period          14.2475
		Eccentricity    0.292607
		Inclination     49.4764
		AscendingNode   154.62
		ArgOfPericenter -157.709
		MeanAnomaly     -56.5337
	}
}

DwarfMoon	"4.D32"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            9.94263e-009
	Radius          32.2395
	InertiaMoment   0.399002

	RotationPeriod  842.535
	Obliquity       76.2986
	EqAscendNode    65.0746

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.616 0.614 0.611)

	Surface
	{
		SurfStyle       0.795562
		OceanStyle      0.564782
		Randomize      (0.750, 0.926, 0.565)
		colorDistMagn   0.953072
		colorDistFreq   0.770861
		detailScale     880.353
		colorConversion true
		snowLevel       2
		tropicLatitude  0.999796
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.763041
		terraceProb     0.2093
		erosion         0
		montesMagn      0.419811
		montesFreq      2.09745
		montesSpiky     0.778527
		montesFraction  0.509584
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.4875
		hillsFraction   0.569013
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.260868
		craterFreq      0.146618
		craterDensity   0.775776
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   50.6925
		volcanoTemp     1570.7
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.240, 0.209, 0.171, 0.000)
		colorShelf     (0.247, 0.215, 0.196, 0.000)
		colorBeach     (0.290, 0.252, 0.232, 0.000)
		colorDesert    (0.314, 0.270, 0.226, 0.000)
		colorLowland   (0.345, 0.289, 0.257, 0.000)
		colorUpland    (0.382, 0.350, 0.312, 0.000)
		colorRock      (0.413, 0.381, 0.336, 0.000)
		colorSnow      (0.450, 0.405, 0.354, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.756317
		Period          14.2572
		Eccentricity    0.477725
		Inclination     31.7899
		AscendingNode   69.2761
		ArgOfPericenter 87.7277
		MeanAnomaly     -121.035
	}
}

DwarfMoon	"4.D33"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.35545e-008
	Radius          34.0304
	InertiaMoment   0.399919

	RotationPeriod  763.541
	Obliquity       69.6451
	EqAscendNode    82.9171

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.795 0.793 0.790)

	Surface
	{
		SurfStyle       0.218363
		OceanStyle      0.653379
		Randomize      (0.469, 0.666, 0.437)
		colorDistMagn   0.831651
		colorDistFreq   0.236295
		detailScale     929.258
		colorConversion true
		snowLevel       2
		tropicLatitude  0.979072
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.390243
		terraceProb     0.189776
		erosion         0
		montesMagn      0.437892
		montesFreq      2.35064
		montesSpiky     0.75868
		montesFraction  0.918993
		dunesFraction   0
		hillsMagn       0
		hillsFreq       3.10173
		hillsFraction   0.932916
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.231058
		craterFreq      0.275472
		craterDensity   0.627501
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   45.8282
		volcanoTemp     1593.44
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.318, 0.317, 0.316, 0.000)
		colorShelf     (0.338, 0.337, 0.336, 0.000)
		colorBeach     (0.358, 0.357, 0.356, 0.000)
		colorDesert    (0.377, 0.377, 0.375, 0.000)
		colorLowland   (0.397, 0.396, 0.395, 0.000)
		colorUpland    (0.417, 0.416, 0.415, 0.000)
		colorRock      (0.437, 0.436, 0.435, 0.000)
		colorSnow      (0.457, 0.456, 0.454, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.75669
		Period          14.2677
		Eccentricity    0.0170896
		Inclination     51.1324
		AscendingNode   88.8413
		ArgOfPericenter 153.097
		MeanAnomaly     34.9051
	}
}

DwarfMoon	"4.D34"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.84334e-008
	Radius          36.217
	InertiaMoment   0.398001

	RotationPeriod  695.902
	Obliquity       55.4953
	EqAscendNode    -2.69953

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.603 0.401 0.330)

	Surface
	{
		SurfStyle       0.231818
		OceanStyle      0.56354
		Randomize      (-0.528, -0.362, 0.272)
		colorDistMagn   0.871049
		colorDistFreq   0.828416
		detailScale     988.966
		colorConversion true
		snowLevel       2
		tropicLatitude  0.879027
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.36143
		terraceProb     0.256687
		erosion         0
		montesMagn      0.488032
		montesFreq      3.02695
		montesSpiky     0.9559
		montesFraction  0.327246
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.65189
		hillsFraction   0.445182
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.226242
		craterFreq      0.149576
		craterDensity   0.964175
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.8231
		volcanoTemp     1222.53
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.241, 0.161, 0.132, 0.000)
		colorShelf     (0.256, 0.171, 0.140, 0.000)
		colorBeach     (0.271, 0.181, 0.148, 0.000)
		colorDesert    (0.287, 0.191, 0.157, 0.000)
		colorLowland   (0.302, 0.201, 0.165, 0.000)
		colorUpland    (0.317, 0.211, 0.173, 0.000)
		colorRock      (0.332, 0.221, 0.181, 0.000)
		colorSnow      (0.347, 0.231, 0.190, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.756993
		Period          14.2763
		Eccentricity    0.0220041
		Inclination     62.9795
		AscendingNode   -0.0515676
		ArgOfPericenter -12.9814
		MeanAnomaly     -70.6542
	}
}

DwarfMoon	"4.D35"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.503e-008
	Radius          37.83
	InertiaMoment   0.399141

	RotationPeriod  625.401
	Obliquity       -30.9305
	EqAscendNode    -172.903

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.542 0.538 0.535)

	Surface
	{
		SurfStyle       0.035175
		OceanStyle      0.864329
		Randomize      (0.973, -0.065, -0.915)
		colorDistMagn   0.361678
		colorDistFreq   0.409851
		detailScale     1033.01
		colorConversion true
		snowLevel       2
		tropicLatitude  0.551457
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.561703
		terraceProb     0.325214
		erosion         0
		montesMagn      0.52009
		montesFreq      3.58395
		montesSpiky     0.995807
		montesFraction  0.222703
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.33064
		hillsFraction   0.622126
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.218391
		craterFreq      0.206462
		craterDensity   0.627955
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.4897
		volcanoTemp     1619.03
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.217, 0.215, 0.214, 0.000)
		colorShelf     (0.230, 0.229, 0.227, 0.000)
		colorBeach     (0.244, 0.242, 0.241, 0.000)
		colorDesert    (0.257, 0.255, 0.254, 0.000)
		colorLowland   (0.271, 0.269, 0.267, 0.000)
		colorUpland    (0.284, 0.282, 0.281, 0.000)
		colorRock      (0.298, 0.296, 0.294, 0.000)
		colorSnow      (0.312, 0.309, 0.308, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.757204
		Period          14.2822
		Eccentricity    0.477947
		Inclination     2.55167
		AscendingNode   -173.531
		ArgOfPericenter -81.0342
		MeanAnomaly     -96.8013
	}
}

DwarfMoon	"4.D36"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.39649e-008
	Radius          49.0262
	InertiaMoment   0.395246

	RotationPeriod  691.637
	Obliquity       -92.2306
	EqAscendNode    -134.943

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.521 0.413 0.302)

	Surface
	{
		SurfStyle       0.0567051
		OceanStyle      0.287988
		Randomize      (-0.483, 0.268, 0.798)
		colorDistMagn   0.47323
		colorDistFreq   0.872195
		detailScale     1338.74
		colorConversion true
		snowLevel       2
		tropicLatitude  0.927305
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.680006
		terraceProb     0.678284
		erosion         0
		montesMagn      0.587721
		montesFreq      2.57653
		montesSpiky     0.990483
		montesFraction  0.671745
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.63387
		hillsFraction   0.696377
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238245
		craterFreq      0.194848
		craterDensity   0.770597
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.7079
		volcanoTemp     1425.63
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.208, 0.165, 0.121, 0.000)
		colorShelf     (0.221, 0.175, 0.128, 0.000)
		colorBeach     (0.234, 0.186, 0.136, 0.000)
		colorDesert    (0.247, 0.196, 0.144, 0.000)
		colorLowland   (0.260, 0.206, 0.151, 0.000)
		colorUpland    (0.273, 0.217, 0.159, 0.000)
		colorRock      (0.287, 0.227, 0.166, 0.000)
		colorSnow      (0.300, 0.237, 0.174, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.75771
		Period          14.2966
		Eccentricity    0.218205
		Inclination     -32.7517
		AscendingNode   -138.847
		ArgOfPericenter -113.472
		MeanAnomaly     91.5577
	}
}

DwarfMoon	"4.D37"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.60986e-008
	Radius          51.4811
	InertiaMoment   0.398197

	RotationPeriod  626.391
	Obliquity       -33.6163
	EqAscendNode    -98.0453

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.624 0.560 0.524)

	Surface
	{
		SurfStyle       0.0793398
		OceanStyle      0.299118
		Randomize      (0.451, -0.390, 0.522)
		colorDistMagn   0.454359
		colorDistFreq   2.01953
		detailScale     1405.78
		colorConversion true
		snowLevel       2
		tropicLatitude  0.677557
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.344947
		terraceProb     0.105122
		erosion         0
		montesMagn      0.571734
		montesFreq      3.01346
		montesSpiky     0.850962
		montesFraction  0.472693
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.29435
		hillsFraction   0.629113
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.235317
		craterFreq      0.214637
		craterDensity   0.719152
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   37.5933
		volcanoTemp     1467.36
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.250, 0.224, 0.209, 0.000)
		colorShelf     (0.265, 0.238, 0.223, 0.000)
		colorBeach     (0.281, 0.252, 0.236, 0.000)
		colorDesert    (0.296, 0.266, 0.249, 0.000)
		colorLowland   (0.312, 0.280, 0.262, 0.000)
		colorUpland    (0.328, 0.294, 0.275, 0.000)
		colorRock      (0.343, 0.308, 0.288, 0.000)
		colorSnow      (0.359, 0.322, 0.301, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.758377
		Period          14.3155
		Eccentricity    0.0537565
		Inclination     -28.1257
		AscendingNode   -90.2291
		ArgOfPericenter -144.82
		MeanAnomaly     -42.4728
	}
}

DwarfMoon	"4.D38"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.26337e-008
	Radius          54.7682
	InertiaMoment   0.399276

	RotationPeriod  572.964
	Obliquity       14.6446
	EqAscendNode    -101.784

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.479 0.473 0.466)

	Surface
	{
		SurfStyle       0.566411
		OceanStyle      0.708496
		Randomize      (-0.365, 0.521, 0.779)
		colorDistMagn   0.673965
		colorDistFreq   2.41691
		detailScale     1495.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.602718
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.396916
		terraceProb     0.387195
		erosion         0
		montesMagn      0.423569
		montesFreq      3.0307
		montesSpiky     0.873369
		montesFraction  0.690697
		dunesFraction   0
		hillsMagn       0
		hillsFreq       8.12862
		hillsFraction   0.53188
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241025
		craterFreq      0.189045
		craterDensity   0.915454
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.3107
		volcanoTemp     1435.53
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.187, 0.161, 0.131, 0.000)
		colorShelf     (0.192, 0.166, 0.149, 0.000)
		colorBeach     (0.225, 0.194, 0.177, 0.000)
		colorDesert    (0.244, 0.208, 0.173, 0.000)
		colorLowland   (0.268, 0.222, 0.196, 0.000)
		colorUpland    (0.297, 0.270, 0.238, 0.000)
		colorRock      (0.321, 0.293, 0.256, 0.000)
		colorSnow      (0.350, 0.312, 0.270, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.758729
		Period          14.3254
		Eccentricity    0.059406
		Inclination     -33.8549
		AscendingNode   -92.2451
		ArgOfPericenter -9.45784
		MeanAnomaly     -171.45
	}
}

DwarfMoon	"4.D39"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.5266e-008
	Radius          57.6632
	InertiaMoment   0.396341

	RotationPeriod  515.601
	Obliquity       18.9919
	EqAscendNode    108.074

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.582 0.543 0.479)

	Surface
	{
		SurfStyle       0.851511
		OceanStyle      0.481733
		Randomize      (0.018, 0.139, 0.832)
		colorDistMagn   0.438239
		colorDistFreq   2.1581
		detailScale     1574.59
		colorConversion true
		snowLevel       2
		tropicLatitude  0.348808
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.657802
		terraceProb     0.347827
		erosion         0
		montesMagn      0.568676
		montesFreq      2.64735
		montesSpiky     0.959505
		montesFraction  0.755751
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.88719
		hillsFraction   0.719002
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.264264
		craterFreq      0.182051
		craterDensity   0.819428
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.9611
		volcanoTemp     1246.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.198, 0.190, 0.192, 0.050)
		colorShelf     (0.233, 0.223, 0.220, 0.040)
		colorBeach     (0.268, 0.255, 0.249, 0.030)
		colorDesert    (0.303, 0.288, 0.283, 0.020)
		colorLowland   (0.338, 0.320, 0.312, 0.030)
		colorUpland    (0.373, 0.353, 0.340, 0.050)
		colorRock      (0.408, 0.386, 0.379, 0.020)
		colorSnow      (0.408, 0.386, 0.379, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.759271
		Period          14.3408
		Eccentricity    0.0161636
		Inclination     -3.50968
		AscendingNode   109.337
		ArgOfPericenter -136.847
		MeanAnomaly     115.235
	}
}

DwarfMoon	"4.D40"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.16411e-007
	Radius          74.7485
	InertiaMoment   0.398378

	RotationPeriod  572.965
	Obliquity       65.1758
	EqAscendNode    131.205

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.705 0.704 0.702)

	Surface
	{
		SurfStyle       0.33565
		OceanStyle      0.604618
		Randomize      (-0.308, 0.815, 0.840)
		colorDistMagn   0.558988
		colorDistFreq   2.03913
		detailScale     2041.13
		colorConversion true
		snowLevel       2
		tropicLatitude  0.726707
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.646334
		terraceProb     0.258875
		erosion         0
		montesMagn      0.509369
		montesFreq      3.51898
		montesSpiky     0.90044
		montesFraction  0.412078
		dunesFraction   0
		hillsMagn       0
		hillsFreq       16.5312
		hillsFraction   0.583273
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227266
		craterFreq      0.210619
		craterDensity   0.658483
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.3489
		volcanoTemp     1498.87
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.282, 0.281, 0.281, 0.000)
		colorShelf     (0.300, 0.299, 0.298, 0.000)
		colorBeach     (0.317, 0.317, 0.316, 0.000)
		colorDesert    (0.335, 0.334, 0.334, 0.000)
		colorLowland   (0.353, 0.352, 0.351, 0.000)
		colorUpland    (0.370, 0.369, 0.369, 0.000)
		colorRock      (0.388, 0.387, 0.386, 0.000)
		colorSnow      (0.405, 0.405, 0.404, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.759776
		Period          14.3551
		Eccentricity    0.00988005
		Inclination     68.6727
		AscendingNode   129.192
		ArgOfPericenter -74.2719
		MeanAnomaly     12.6866
	}
}

DwarfMoon	"4.D41"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.59547e-007
	Radius          78.3518
	InertiaMoment   0.399408

	RotationPeriod  514.16
	Obliquity       49.8861
	EqAscendNode    81.8664

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.489 0.480 0.477)

	Surface
	{
		SurfStyle       0.571144
		OceanStyle      0.397158
		Randomize      (0.273, 0.361, 0.637)
		colorDistMagn   0.107171
		colorDistFreq   2.02605
		detailScale     2139.53
		colorConversion true
		snowLevel       2
		tropicLatitude  0.922784
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.55681
		terraceProb     0.165155
		erosion         0
		montesMagn      0.289409
		montesFreq      2.86088
		montesSpiky     0.890364
		montesFraction  0.631444
		dunesFraction   0
		hillsMagn       0
		hillsFreq       13.9106
		hillsFraction   0.565047
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241743
		craterFreq      0.258128
		craterDensity   0.830502
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   30.7547
		volcanoTemp     1640.66
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.191, 0.163, 0.134, 0.000)
		colorShelf     (0.196, 0.168, 0.153, 0.000)
		colorBeach     (0.230, 0.197, 0.181, 0.000)
		colorDesert    (0.249, 0.211, 0.176, 0.000)
		colorLowland   (0.274, 0.226, 0.200, 0.000)
		colorUpland    (0.303, 0.274, 0.243, 0.000)
		colorRock      (0.328, 0.298, 0.262, 0.000)
		colorSnow      (0.357, 0.317, 0.277, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.760168
		Period          14.3662
		Eccentricity    0.186129
		Inclination     39.3869
		AscendingNode   76.5766
		ArgOfPericenter -137.068
		MeanAnomaly     4.33083
	}
}

DwarfMoon	"4.D42"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.19748e-007
	Radius          83.699
	InertiaMoment   0.396866

	RotationPeriod  466.87
	Obliquity       68.4878
	EqAscendNode    -184.461

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.585 0.577 0.572)

	Surface
	{
		SurfStyle       0.855253
		OceanStyle      0.739514
		Randomize      (0.166, 0.510, 0.078)
		colorDistMagn   0.129177
		colorDistFreq   5.63942
		detailScale     2285.54
		colorConversion true
		snowLevel       2
		tropicLatitude  0.415464
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.360942
		terraceProb     0.519217
		erosion         0
		montesMagn      0.528542
		montesFreq      3.08212
		montesSpiky     0.99647
		montesFraction  0.807411
		dunesFraction   0
		hillsMagn       0
		hillsFreq       20.653
		hillsFraction   0.81424
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.293499
		craterFreq      0.227867
		craterDensity   0.757286
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.994
		volcanoTemp     1353.24
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.199, 0.202, 0.229, 0.050)
		colorShelf     (0.234, 0.237, 0.263, 0.040)
		colorBeach     (0.269, 0.271, 0.298, 0.030)
		colorDesert    (0.304, 0.306, 0.338, 0.020)
		colorLowland   (0.339, 0.341, 0.372, 0.030)
		colorUpland    (0.374, 0.375, 0.406, 0.050)
		colorRock      (0.409, 0.410, 0.452, 0.020)
		colorSnow      (0.409, 0.410, 0.452, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.760767
		Period          14.3832
		Eccentricity    0.16134
		Inclination     43.9921
		AscendingNode   -178.029
		ArgOfPericenter -66.3629
		MeanAnomaly     -111.755
	}
}

DwarfMoon	"4.D43"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.04521e-007
	Radius          89.0248
	InertiaMoment   0.398546

	RotationPeriod  423.02
	Obliquity       -21.7076
	EqAscendNode    -6.93634

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.599 0.591 0.589)

	Surface
	{
		SurfStyle       0.557273
		OceanStyle      0.924882
		Randomize      (-0.969, 0.726, -0.572)
		colorDistMagn   0.805849
		colorDistFreq   1.9426
		detailScale     2430.97
		colorConversion true
		snowLevel       2
		tropicLatitude  0.667679
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.438108
		terraceProb     0.197184
		erosion         0
		montesMagn      0.553203
		montesFreq      3.40523
		montesSpiky     0.892817
		montesFraction  0.633112
		dunesFraction   0
		hillsMagn       0
		hillsFreq       14.2156
		hillsFraction   0.56847
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.249289
		craterFreq      0.270891
		craterDensity   1.02966
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   25.2935
		volcanoTemp     1508.73
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.234, 0.201, 0.165, 0.000)
		colorShelf     (0.240, 0.207, 0.188, 0.000)
		colorBeach     (0.282, 0.242, 0.224, 0.000)
		colorDesert    (0.306, 0.260, 0.218, 0.000)
		colorLowland   (0.335, 0.278, 0.247, 0.000)
		colorUpland    (0.371, 0.337, 0.300, 0.000)
		colorRock      (0.401, 0.367, 0.324, 0.000)
		colorSnow      (0.437, 0.390, 0.341, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.760984
		Period          14.3893
		Eccentricity    0.09018
		Inclination     -20.2044
		AscendingNode   -3.78109
		ArgOfPericenter -94.3038
		MeanAnomaly     -114.013
	}
}

DwarfMoon	"4.D44"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.25153e-007
	Radius          116.675
	InertiaMoment   0.399537

	RotationPeriod  469.446
	Obliquity       97.3379
	EqAscendNode    42.2902

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.789 0.786 0.785)

	Surface
	{
		SurfStyle       0.9628
		OceanStyle      0.336138
		Randomize      (-0.217, -0.921, 0.444)
		colorDistMagn   0.247544
		colorDistFreq   0.661522
		detailScale     3186
		colorConversion true
		snowLevel       2
		tropicLatitude  0.668622
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.310708
		terraceProb     0.137198
		erosion         0
		montesMagn      0.616547
		montesFreq      2.35281
		montesSpiky     0.994039
		montesFraction  0.362768
		dunesFraction   0
		hillsMagn       0
		hillsFreq       35.7845
		hillsFraction   0.61829
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.253996
		craterFreq      0.494162
		craterDensity   0.690983
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   28.055
		volcanoTemp     1715.29
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.268, 0.275, 0.314, 0.050)
		colorShelf     (0.315, 0.322, 0.361, 0.040)
		colorBeach     (0.363, 0.370, 0.408, 0.030)
		colorDesert    (0.410, 0.417, 0.463, 0.020)
		colorLowland   (0.457, 0.464, 0.511, 0.030)
		colorUpland    (0.505, 0.511, 0.558, 0.050)
		colorRock      (0.552, 0.558, 0.621, 0.020)
		colorSnow      (0.552, 0.558, 0.621, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.761645
		Period          14.4081
		Eccentricity    0.389189
		Inclination     84.8447
		AscendingNode   42.1688
		ArgOfPericenter -96.7971
		MeanAnomaly     153.919
	}
}

DwarfMoon	"4.D45"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.98922e-007
	Radius          122.554
	InertiaMoment   0.397236

	RotationPeriod  414.62
	Obliquity       13.1703
	EqAscendNode    162.212

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.645 0.585 0.490)

	Surface
	{
		SurfStyle       0.567801
		OceanStyle      0.381486
		Randomize      (0.251, -0.870, 0.242)
		colorDistMagn   0.367791
		colorDistFreq   7.47539
		detailScale     3346.55
		colorConversion true
		snowLevel       2
		tropicLatitude  0.43885
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.528869
		terraceProb     0.333858
		erosion         0
		montesMagn      0.504945
		montesFreq      3.6974
		montesSpiky     0.963379
		montesFraction  0.0963878
		dunesFraction   0
		hillsMagn       0
		hillsFreq       24.5641
		hillsFraction   0.590966
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.20864
		craterFreq      0.332992
		craterDensity   0.985489
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   24.8284
		volcanoTemp     1577.62
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.252, 0.199, 0.137, 0.000)
		colorShelf     (0.258, 0.205, 0.157, 0.000)
		colorBeach     (0.303, 0.240, 0.186, 0.000)
		colorDesert    (0.329, 0.257, 0.181, 0.000)
		colorLowland   (0.361, 0.275, 0.206, 0.000)
		colorUpland    (0.400, 0.333, 0.250, 0.000)
		colorRock      (0.432, 0.362, 0.269, 0.000)
		colorSnow      (0.471, 0.386, 0.284, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.762075
		Period          14.4203
		Eccentricity    0.116661
		Inclination     -13.3196
		AscendingNode   158.814
		ArgOfPericenter -73.7406
		MeanAnomaly     137.04
	}
}

DwarfMoon	"4.D46"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.52844e-007
	Radius          132.278
	InertiaMoment   0.398704

	RotationPeriod  375.948
	Obliquity       54.6318
	EqAscendNode    -55.3919

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.494 0.445 0.375)

	Surface
	{
		SurfStyle       0.873067
		OceanStyle      0.530619
		Randomize      (-0.738, 0.533, 0.387)
		colorDistMagn   0.887868
		colorDistFreq   5.28001
		detailScale     3612.06
		colorConversion true
		snowLevel       2
		tropicLatitude  0.999565
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.50072
		terraceProb     0.331333
		erosion         0
		montesMagn      0.470707
		montesFreq      2.72311
		montesSpiky     0.874859
		montesFraction  0.368929
		dunesFraction   0
		hillsMagn       0
		hillsFreq       25.1558
		hillsFraction   0.474002
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.221168
		craterFreq      0.71356
		craterDensity   0.895258
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   22.4573
		volcanoTemp     1819.69
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.168, 0.156, 0.150, 0.050)
		colorShelf     (0.198, 0.182, 0.172, 0.040)
		colorBeach     (0.227, 0.209, 0.195, 0.030)
		colorDesert    (0.257, 0.236, 0.221, 0.020)
		colorLowland   (0.286, 0.262, 0.244, 0.030)
		colorUpland    (0.316, 0.289, 0.266, 0.050)
		colorRock      (0.346, 0.316, 0.296, 0.020)
		colorSnow      (0.346, 0.316, 0.296, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.762279
		Period          14.4261
		Eccentricity    0.00877438
		Inclination     54.1411
		AscendingNode   -62.0667
		ArgOfPericenter -156.758
		MeanAnomaly     -74.6878
	}
}

DwarfMoon	"4.D47"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.23017e-006
	Radius          142.982
	InertiaMoment   0.399665

	RotationPeriod  338.964
	Obliquity       15.2898
	EqAscendNode    178.184

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.807 0.775 0.752)

	Surface
	{
		SurfStyle       0.385993
		OceanStyle      0.362872
		Randomize      (0.270, 0.386, -0.088)
		colorDistMagn   0.562187
		colorDistFreq   8.35141
		detailScale     3904.37
		colorConversion true
		snowLevel       2
		tropicLatitude  0.250268
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.510094
		terraceProb     0.462631
		erosion         0
		montesMagn      0.644753
		montesFreq      2.84895
		montesSpiky     0.996634
		montesFraction  0.518536
		dunesFraction   0
		hillsMagn       0
		hillsFreq       21.9202
		hillsFraction   0.877895
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227362
		craterFreq      0.556752
		craterDensity   0.918998
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   20.2118
		volcanoTemp     1392.44
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.323, 0.310, 0.301, 0.000)
		colorShelf     (0.343, 0.329, 0.320, 0.000)
		colorBeach     (0.363, 0.349, 0.338, 0.000)
		colorDesert    (0.384, 0.368, 0.357, 0.000)
		colorLowland   (0.404, 0.387, 0.376, 0.000)
		colorUpland    (0.424, 0.407, 0.395, 0.000)
		colorRock      (0.444, 0.426, 0.413, 0.000)
		colorSnow      (0.464, 0.445, 0.432, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.762753
		Period          14.4395
		Eccentricity    0.171981
		Inclination     0.802349
		AscendingNode   173.232
		ArgOfPericenter -144.434
		MeanAnomaly     12.4899
	}
}

DwarfMoon	"4.D48"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.80211e-006
	Radius          192.138
	InertiaMoment   0.39753

	RotationPeriod  375.119
	Obliquity       10.1817
	EqAscendNode    -69.7891

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.530 0.526 0.524)

	Surface
	{
		SurfStyle       0.0964852
		OceanStyle      0.237032
		Randomize      (-0.902, 0.223, 0.807)
		colorDistMagn   0.388146
		colorDistFreq   8.67321
		detailScale     5246.65
		colorConversion true
		snowLevel       2
		tropicLatitude  0.433876
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.447154
		terraceProb     0.226773
		erosion         0
		montesMagn      0.585166
		montesFreq      3.66413
		montesSpiky     0.872308
		montesFraction  0.508544
		dunesFraction   0
		hillsMagn       0
		hillsFreq       72.1139
		hillsFraction   0.729787
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.218098
		craterFreq      1.19519
		craterDensity   0.84925
		craterOctaves   16
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   22.4403
		volcanoTemp     1671.27
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.212, 0.211, 0.210, 0.000)
		colorShelf     (0.225, 0.224, 0.223, 0.000)
		colorBeach     (0.238, 0.237, 0.236, 0.000)
		colorDesert    (0.252, 0.250, 0.249, 0.000)
		colorLowland   (0.265, 0.263, 0.262, 0.000)
		colorUpland    (0.278, 0.276, 0.275, 0.000)
		colorRock      (0.291, 0.290, 0.288, 0.000)
		colorSnow      (0.304, 0.303, 0.301, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.763357
		Period          14.4567
		Eccentricity    0.431632
		Inclination     21.694
		AscendingNode   -78.0177
		ArgOfPericenter -5.04633
		MeanAnomaly     177.446
	}
}

Moon	"4.9"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            2.68973e-006
	Radius          203.568
	InertiaMoment   0.398854

	RotationPeriod  326.107
	Obliquity       29.5652
	EqAscendNode    -19.3301

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.794 0.793 0.792)

	Surface
	{
		SurfStyle       0.982921
		OceanStyle      0.0971823
		Randomize      (0.634, 0.112, -0.055)
		colorDistMagn   0.0790881
		colorDistFreq   26.2947
		detailScale     523.589
		colorConversion true
		drivenDarkening 0.00940699
		seaLevel        0.227563
		snowLevel       2
		tropicLatitude  0.996299
		icecapLatitude  1
		icecapHeight    0.227563
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.59566
		venusFreq       1.08279
		venusMagn       0.261569
		mareFreq        0
		mareDensity     1.295e-006
		terraceProb     0.264419
		erosion         0
		montesMagn      0.0623398
		montesFreq      9.34083
		montesSpiky     0.929591
		montesFraction  0.100627
		dunesMagn       0.0329986
		dunesFreq       270.078
		dunesFraction   0.121805
		hillsMagn       0.117342
		hillsFreq       20.4731
		hillsFraction   0.498101
		hills2Fraction  0.0236151
		riversMagn      66.8635
		riversFreq      4.27179
		riversSin       7.18677
		riversOctaves   0
		canyonsMagn     0.453637
		canyonsFreq     0.0607544
		canyonFraction  0
		cracksMagn      0.0336102
		cracksFreq      0.101798
		cracksOctaves   0
		craterMagn      1.11263
		craterFreq      0.628308
		craterDensity   0.839869
		craterOctaves   7
		craterRayedFactor 0.476178
		volcanoMagn     0.210258
		volcanoFreq     0.974501
		volcanoDensity  0.0513307
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.246981
		volcanoRadius   4.74115
		volcanoTemp     1711.97
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.604, 0.563, 0.459, 1.000)
		colorShelf     (0.604, 0.563, 0.459, 1.000)
		colorBeach     (0.556, 0.492, 0.396, 1.000)
		colorDesert    (0.556, 0.492, 0.396, 1.000)
		colorLowland   (0.675, 0.643, 0.602, 1.000)
		colorUpland    (0.707, 0.706, 0.681, 1.000)
		colorRock      (0.930, 0.910, 0.860, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.675, 0.643, 0.602, 1.000)
		colorUpPlants  (0.707, 0.706, 0.681, 1.000)
		BumpHeight      10.1784
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.763623
		Period          14.4642
		Eccentricity    0.336867
		Inclination     67.0775
		AscendingNode   -20.8363
		ArgOfPericenter 93.1955
		MeanAnomaly     8.00229
	}
}

Moon	"4.10"
{
	ParentBody     "4"
	Class	       "IceWorld"

	Mass            4.10699e-006
	Radius          224.634
	InertiaMoment   0.399791

	RotationPeriod  291.719
	Obliquity       -52.1221
	EqAscendNode    173.887

	AlbedoBond      0.3
	AlbedoGeom      0.36
	Brightness      2
	Color          (0.794 0.744 0.723)

	Surface
	{
		SurfStyle       0.0128157
		OceanStyle      0.338959
		Randomize      (-0.432, 0.690, 0.164)
		colorDistMagn   0.0877807
		colorDistFreq   27.5353
		detailScale     577.771
		colorConversion true
		drivenDarkening 0.00940159
		seaLevel        0.222381
		snowLevel       2
		tropicLatitude  0.365508
		icecapLatitude  0.941388
		icecapHeight    0.225209
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        1.95274
		venusFreq       0.472818
		venusMagn       0.110541
		mareFreq        0
		mareDensity     1.24275e-006
		terraceProb     0.372247
		erosion         0
		montesMagn      0.0489394
		montesFreq      10.9247
		montesSpiky     0.88787
		montesFraction  0.797798
		dunesMagn       0.045446
		dunesFreq       291.577
		dunesFraction   0.715956
		hillsMagn       0.132696
		hillsFreq       24.0607
		hillsFraction   0.58213
		hills2Fraction  0.0918234
		riversMagn      60.2119
		riversFreq      1.67397
		riversSin       6.76354
		riversOctaves   0
		canyonsMagn     0.526463
		canyonsFreq     0.0686815
		canyonFraction  0
		cracksMagn      0.042774
		cracksFreq      0.142175
		cracksOctaves   0
		craterMagn      1.20139
		craterFreq      0.767146
		craterDensity   0.804476
		craterOctaves   8
		craterRayedFactor 0
		volcanoMagn     0.188473
		volcanoFreq     0.831194
		volcanoDensity  0.0521407
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0.290764
		volcanoRadius   3.61128
		volcanoTemp     1204.59
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.794, 0.744, 0.723, 0.500)
		colorShelf     (0.754, 0.707, 0.687, 0.500)
		colorBeach     (0.556, 0.521, 0.506, 0.750)
		colorDesert    (0.675, 0.633, 0.614, 1.000)
		colorLowland   (0.698, 0.655, 0.636, 1.000)
		colorUpland    (0.738, 0.692, 0.672, 1.000)
		colorRock      (1.000, 1.000, 1.000, 1.000)
		colorSnow      (1.000, 1.000, 1.000, 0.154)
		colorLowPlants (0.698, 0.655, 0.636, 1.000)
		colorUpPlants  (0.738, 0.692, 0.672, 1.000)
		BumpHeight      11.2317
		DiffMapAlpha   "Ice"
		SpecBrightWater 0.03
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.2
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.764061
		Period          14.4767
		Eccentricity    0.321742
		Inclination     -68.6037
		AscendingNode   164.104
		ArgOfPericenter -135.58
		MeanAnomaly     -12.745
	}
}

DwarfMoon	"4.D49"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.03884e-011
	Radius          2.93349
	InertiaMoment   0.397778

	RotationPeriod  2313.23
	Obliquity       44.2687
	EqAscendNode    147.675

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.656 0.653 0.651)

	Surface
	{
		SurfStyle       0.662884
		OceanStyle      0.609168
		Randomize      (-0.075, -0.011, 0.234)
		colorDistMagn   0.822681
		colorDistFreq   0.00530981
		detailScale     80.1038
		colorConversion true
		snowLevel       2
		tropicLatitude  0.523408
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.392184
		terraceProb     0.338162
		erosion         0
		montesMagn      0.489762
		montesFreq      3.13493
		montesSpiky     0.770779
		montesFraction  0.794729
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0137412
		hillsFraction   0.934373
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227677
		craterFreq      0.241965
		craterDensity   0.814552
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   142.697
		volcanoTemp     1474.13
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.256, 0.222, 0.182, 0.000)
		colorShelf     (0.262, 0.229, 0.208, 0.000)
		colorBeach     (0.308, 0.268, 0.248, 0.000)
		colorDesert    (0.334, 0.287, 0.241, 0.000)
		colorLowland   (0.367, 0.307, 0.274, 0.000)
		colorUpland    (0.407, 0.372, 0.332, 0.000)
		colorRock      (0.439, 0.405, 0.358, 0.000)
		colorSnow      (0.479, 0.431, 0.378, 1.000)
		BumpHeight      2.64014
		BumpOffset      0.528028
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.764277
		Period          14.4828
		Eccentricity    0.0226133
		Inclination     53.7825
		AscendingNode   139.62
		ArgOfPericenter 179.858
		MeanAnomaly     -97.5945
	}
}

DwarfMoon	"4.D50"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.17292e-011
	Radius          4.51983
	InertiaMoment   0.398999

	RotationPeriod  2462.22
	Obliquity       -27.4035
	EqAscendNode    174.987

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.518 0.513 0.510)

	Surface
	{
		SurfStyle       0.331215
		OceanStyle      0.213886
		Randomize      (0.173, 0.942, 0.601)
		colorDistMagn   0.576562
		colorDistFreq   0.012047
		detailScale     123.421
		colorConversion true
		snowLevel       2
		tropicLatitude  0.577006
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.722901
		terraceProb     0.435209
		erosion         0
		montesMagn      0.411227
		montesFreq      2.99225
		montesSpiky     0.869767
		montesFraction  0.576791
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0604586
		hillsFraction   0.517485
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.250906
		craterFreq      0.270778
		craterDensity   0.801429
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   152.022
		volcanoTemp     1473.88
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.207, 0.205, 0.204, 0.000)
		colorShelf     (0.220, 0.218, 0.217, 0.000)
		colorBeach     (0.233, 0.231, 0.230, 0.000)
		colorDesert    (0.246, 0.244, 0.242, 0.000)
		colorLowland   (0.259, 0.257, 0.255, 0.000)
		colorUpland    (0.272, 0.269, 0.268, 0.000)
		colorRock      (0.285, 0.282, 0.281, 0.000)
		colorSnow      (0.298, 0.295, 0.293, 1.000)
		BumpHeight      4.06784
		BumpOffset      0.813569
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.764482
		Period          14.4887
		Eccentricity    0.251773
		Inclination     8.09601
		AscendingNode   163.657
		ArgOfPericenter 135.106
		MeanAnomaly     -23.9132
	}
}

DwarfMoon	"4.D51"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.09827e-011
	Radius          5.0832
	InertiaMoment   0.399916

	RotationPeriod  2032.83
	Obliquity       44.254
	EqAscendNode    -31.9515

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.428 0.421 0.417)

	Surface
	{
		SurfStyle       0.65359
		OceanStyle      0.958748
		Randomize      (-0.656, -0.575, 0.496)
		colorDistMagn   0.951375
		colorDistFreq   0.0067064
		detailScale     138.805
		colorConversion true
		snowLevel       2
		tropicLatitude  0.927665
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.558115
		terraceProb     0.294909
		erosion         0
		montesMagn      0.500811
		montesFreq      3.37043
		montesSpiky     0.956636
		montesFraction  0.693844
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0732497
		hillsFraction   0.594241
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.240301
		craterFreq      0.235409
		craterDensity   1.00056
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   124.492
		volcanoTemp     1300.75
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.167, 0.143, 0.117, 0.000)
		colorShelf     (0.171, 0.148, 0.134, 0.000)
		colorBeach     (0.201, 0.173, 0.159, 0.000)
		colorDesert    (0.218, 0.185, 0.154, 0.000)
		colorLowland   (0.240, 0.198, 0.175, 0.000)
		colorUpland    (0.265, 0.240, 0.213, 0.000)
		colorRock      (0.287, 0.261, 0.230, 0.000)
		colorSnow      (0.313, 0.278, 0.242, 1.000)
		BumpHeight      4.57488
		BumpOffset      0.914975
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.764811
		Period          14.498
		Eccentricity    0.127328
		Inclination     25.7864
		AscendingNode   -26.5685
		ArgOfPericenter -10.1028
		MeanAnomaly     40.1924
	}
}

DwarfMoon	"4.D52"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.19337e-011
	Radius          5.86661
	InertiaMoment   0.397997

	RotationPeriod  1774.04
	Obliquity       21.9103
	EqAscendNode    129.958

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.697 0.693 0.690)

	Surface
	{
		SurfStyle       0.642993
		OceanStyle      0.174679
		Randomize      (0.504, 0.924, -0.026)
		colorDistMagn   0.36108
		colorDistFreq   0.0195493
		detailScale     160.197
		colorConversion true
		snowLevel       2
		tropicLatitude  0.424584
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.506969
		terraceProb     0.124665
		erosion         0
		montesMagn      0.369328
		montesFreq      2.78359
		montesSpiky     0.938854
		montesFraction  0.673123
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0963658
		hillsFraction   0.712951
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233653
		craterFreq      0.226465
		craterDensity   1.08153
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   108.449
		volcanoTemp     1381.34
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.272, 0.236, 0.193, 0.000)
		colorShelf     (0.279, 0.243, 0.221, 0.000)
		colorBeach     (0.327, 0.284, 0.262, 0.000)
		colorDesert    (0.355, 0.305, 0.255, 0.000)
		colorLowland   (0.390, 0.326, 0.290, 0.000)
		colorUpland    (0.432, 0.395, 0.352, 0.000)
		colorRock      (0.467, 0.430, 0.380, 0.000)
		colorSnow      (0.509, 0.458, 0.400, 1.000)
		BumpHeight      5.27995
		BumpOffset      1.05599
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.765285
		Period          14.5115
		Eccentricity    0.359336
		Inclination     29.4322
		AscendingNode   122.07
		ArgOfPericenter -99.6397
		MeanAnomaly     -7.79606
	}
}

DwarfMoon	"4.D53"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.19762e-010
	Radius          6.67229
	InertiaMoment   0.399138

	RotationPeriod  1571.09
	Obliquity       94.4067
	EqAscendNode    13.9162

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.535 0.527 0.523)

	Surface
	{
		SurfStyle       0.792039
		OceanStyle      0.514936
		Randomize      (0.922, 0.333, 0.268)
		colorDistMagn   0.767834
		colorDistFreq   0.0384407
		detailScale     182.198
		colorConversion true
		snowLevel       2
		tropicLatitude  0.140632
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.712028
		terraceProb     0.30332
		erosion         0
		montesMagn      0.348179
		montesFreq      2.56624
		montesSpiky     0.859595
		montesFraction  0.654883
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.106723
		hillsFraction   0.472946
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.255637
		craterFreq      0.207949
		craterDensity   0.913418
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   95.5917
		volcanoTemp     1443.95
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.209, 0.179, 0.146, 0.000)
		colorShelf     (0.214, 0.184, 0.167, 0.000)
		colorBeach     (0.252, 0.216, 0.199, 0.000)
		colorDesert    (0.273, 0.232, 0.193, 0.000)
		colorLowland   (0.300, 0.248, 0.220, 0.000)
		colorUpland    (0.332, 0.300, 0.267, 0.000)
		colorRock      (0.359, 0.327, 0.287, 0.000)
		colorSnow      (0.391, 0.348, 0.303, 1.000)
		BumpHeight      6.00506
		BumpOffset      1.20101
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.765512
		Period          14.518
		Eccentricity    0.192187
		Inclination     87.9364
		AscendingNode   7.75032
		ArgOfPericenter -156.21
		MeanAnomaly     94.0198
	}
}

DwarfMoon	"4.D54"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.91505e-010
	Radius          9.85529
	InertiaMoment   0.395199

	RotationPeriod  1818.85
	Obliquity       -175.004
	EqAscendNode    169.781

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.565 0.560 0.557)

	Surface
	{
		SurfStyle       0.680335
		OceanStyle      0.142094
		Randomize      (0.453, 0.776, -0.357)
		colorDistMagn   0.379686
		colorDistFreq   0.0740875
		detailScale     269.115
		colorConversion true
		snowLevel       2
		tropicLatitude  0.985013
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.449235
		terraceProb     0.170614
		erosion         0
		montesMagn      0.538618
		montesFreq      3.19761
		montesSpiky     0.979217
		montesFraction  0.456776
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.215993
		hillsFraction   0.749253
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248666
		craterFreq      0.267797
		craterDensity   0.875614
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   111.657
		volcanoTemp     1545.56
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.220, 0.190, 0.156, 0.000)
		colorShelf     (0.226, 0.196, 0.178, 0.000)
		colorBeach     (0.265, 0.230, 0.212, 0.000)
		colorDesert    (0.288, 0.246, 0.206, 0.000)
		colorLowland   (0.316, 0.263, 0.234, 0.000)
		colorUpland    (0.350, 0.319, 0.284, 0.000)
		colorRock      (0.378, 0.347, 0.306, 0.000)
		colorSnow      (0.412, 0.370, 0.323, 1.000)
		BumpHeight      8.86976
		BumpOffset      1.77395
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.766026
		Period          14.5326
		Eccentricity    0.00323563
		Inclination     -75.519
		AscendingNode   155.342
		ArgOfPericenter 15.9122
		MeanAnomaly     33.2827
	}
}

DwarfMoon	"4.D55"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.96662e-010
	Radius          9.90999
	InertiaMoment   0.398193

	RotationPeriod  1483.02
	Obliquity       -43.5072
	EqAscendNode    113.269

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.456 0.451 0.447)

	Surface
	{
		SurfStyle       0.328943
		OceanStyle      0.971432
		Randomize      (0.183, 0.893, -0.181)
		colorDistMagn   0.85244
		colorDistFreq   0.0733878
		detailScale     270.609
		colorConversion true
		snowLevel       2
		tropicLatitude  0.921839
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.48776
		terraceProb     0.159181
		erosion         0
		montesMagn      0.403199
		montesFreq      3.2852
		montesSpiky     0.916208
		montesFraction  0.638113
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.289048
		hillsFraction   0.788335
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.218883
		craterFreq      0.22861
		craterDensity   0.782508
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   90.2086
		volcanoTemp     1416.8
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.182, 0.180, 0.179, 0.000)
		colorShelf     (0.194, 0.192, 0.190, 0.000)
		colorBeach     (0.205, 0.203, 0.201, 0.000)
		colorDesert    (0.216, 0.214, 0.212, 0.000)
		colorLowland   (0.228, 0.225, 0.223, 0.000)
		colorUpland    (0.239, 0.237, 0.235, 0.000)
		colorRock      (0.251, 0.248, 0.246, 0.000)
		colorSnow      (0.262, 0.259, 0.257, 1.000)
		BumpHeight      8.91899
		BumpOffset      1.7838
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.766613
		Period          14.5493
		Eccentricity    0.0576836
		Inclination     -77.9637
		AscendingNode   110.548
		ArgOfPericenter -99.3534
		MeanAnomaly     -12.7914
	}
}

DwarfMoon	"4.D56"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.48008e-010
	Radius          10.8552
	InertiaMoment   0.399273

	RotationPeriod  1327.03
	Obliquity       -27.8993
	EqAscendNode    -132.458

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.625 0.622 0.618)

	Surface
	{
		SurfStyle       0.993516
		OceanStyle      0.80552
		Randomize      (0.725, -0.153, -0.516)
		colorDistMagn   0.0519543
		colorDistFreq   0.06292
		detailScale     296.42
		colorConversion true
		snowLevel       2
		tropicLatitude  0.853374
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.390021
		terraceProb     0.51158
		erosion         0
		montesMagn      0.527723
		montesFreq      3.03944
		montesSpiky     0.875865
		montesFraction  0.341856
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.290953
		hillsFraction   0.602093
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23718
		craterFreq      0.200122
		craterDensity   0.828157
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   80.4083
		volcanoTemp     1495.66
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.213, 0.218, 0.247, 0.050)
		colorShelf     (0.250, 0.255, 0.284, 0.040)
		colorBeach     (0.288, 0.292, 0.321, 0.030)
		colorDesert    (0.325, 0.330, 0.365, 0.020)
		colorLowland   (0.363, 0.367, 0.402, 0.030)
		colorUpland    (0.400, 0.404, 0.439, 0.050)
		colorRock      (0.438, 0.441, 0.488, 0.020)
		colorSnow      (0.438, 0.441, 0.488, 1.000)
		BumpHeight      9.76969
		BumpOffset      1.95394
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.767274
		Period          14.5681
		Eccentricity    0.419715
		Inclination     -76.3507
		AscendingNode   -133.457
		ArgOfPericenter -27.6244
		MeanAnomaly     88.9137
	}
}

DwarfMoon	"4.D57"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.62665e-010
	Radius          11.8771
	InertiaMoment   0.396326

	RotationPeriod  1192.01
	Obliquity       -25.1621
	EqAscendNode    137.395

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.515 0.507 0.504)

	Surface
	{
		SurfStyle       0.383277
		OceanStyle      0.121225
		Randomize      (-0.739, -0.930, 0.911)
		colorDistMagn   0.741853
		colorDistFreq   0.0324511
		detailScale     324.323
		colorConversion true
		snowLevel       2
		tropicLatitude  0.33489
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.522009
		terraceProb     0.308927
		erosion         0
		montesMagn      0.654781
		montesFreq      2.88303
		montesSpiky     0.940645
		montesFraction  0.4367
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.364755
		hillsFraction   0.350012
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236009
		craterFreq      0.215553
		craterDensity   0.849629
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   72.3384
		volcanoTemp     1383.38
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.206, 0.203, 0.202, 0.000)
		colorShelf     (0.219, 0.216, 0.214, 0.000)
		colorBeach     (0.232, 0.228, 0.227, 0.000)
		colorDesert    (0.244, 0.241, 0.240, 0.000)
		colorLowland   (0.257, 0.254, 0.252, 0.000)
		colorUpland    (0.270, 0.266, 0.265, 0.000)
		colorRock      (0.283, 0.279, 0.277, 0.000)
		colorSnow      (0.296, 0.292, 0.290, 1.000)
		BumpHeight      10.6894
		BumpOffset      2.13787
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.767636
		Period          14.5784
		Eccentricity    0.0198754
		Inclination     -7.63198
		AscendingNode   143.117
		ArgOfPericenter -89.2915
		MeanAnomaly     96.2438
	}
}

DwarfMoon	"4.D58"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            9.63537e-010
	Radius          12.4853
	InertiaMoment   0.398374

	RotationPeriod  1044.29
	Obliquity       147.725
	EqAscendNode    75.8662

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.457 0.454 0.451)

	Surface
	{
		SurfStyle       0.112511
		OceanStyle      0.953596
		Randomize      (0.798, -0.229, -0.285)
		colorDistMagn   0.454899
		colorDistFreq   0.0352997
		detailScale     340.931
		colorConversion true
		snowLevel       2
		tropicLatitude  0.927513
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.584623
		terraceProb     0.32085
		erosion         0
		montesMagn      0.48818
		montesFreq      2.5181
		montesSpiky     0.917773
		montesFraction  0.197383
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.39866
		hillsFraction   0.605402
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.210385
		craterFreq      0.205246
		craterDensity   0.967292
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   63.0622
		volcanoTemp     1525.85
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.183, 0.182, 0.181, 0.000)
		colorShelf     (0.194, 0.193, 0.192, 0.000)
		colorBeach     (0.206, 0.204, 0.203, 0.000)
		colorDesert    (0.217, 0.216, 0.214, 0.000)
		colorLowland   (0.229, 0.227, 0.226, 0.000)
		colorUpland    (0.240, 0.238, 0.237, 0.000)
		colorRock      (0.252, 0.250, 0.248, 0.000)
		colorSnow      (0.263, 0.261, 0.259, 1.000)
		BumpHeight      11.2367
		BumpOffset      2.24735
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.768115
		Period          14.5921
		Eccentricity    0.378709
		Inclination     71.281
		AscendingNode   78.3124
		ArgOfPericenter 167.747
		MeanAnomaly     -16.8986
	}
}

DwarfMoon	"4.D59"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.38124e-009
	Radius          16.6901
	InertiaMoment   0.399405

	RotationPeriod  1165.25
	Obliquity       -24.7471
	EqAscendNode    -106.601

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.470 0.410 0.384)

	Surface
	{
		SurfStyle       0.989924
		OceanStyle      0.271911
		Randomize      (-0.295, -0.031, 0.368)
		colorDistMagn   0.614569
		colorDistFreq   0.115101
		detailScale     455.75
		colorConversion true
		snowLevel       2
		tropicLatitude  0.935505
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.598989
		terraceProb     0.592115
		erosion         0
		montesMagn      0.504996
		montesFreq      2.86811
		montesSpiky     0.947808
		montesFraction  0.647697
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.761799
		hillsFraction   0.559438
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.191103
		craterFreq      0.209283
		craterDensity   0.727165
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   70.4093
		volcanoTemp     1949.6
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.160, 0.144, 0.154, 0.050)
		colorShelf     (0.188, 0.168, 0.177, 0.040)
		colorBeach     (0.216, 0.193, 0.200, 0.030)
		colorDesert    (0.245, 0.217, 0.227, 0.020)
		colorLowland   (0.273, 0.242, 0.250, 0.030)
		colorUpland    (0.301, 0.267, 0.273, 0.050)
		colorRock      (0.329, 0.291, 0.304, 0.020)
		colorSnow      (0.329, 0.291, 0.304, 1.000)
		BumpHeight      15.0211
		BumpOffset      3.00421
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.768663
		Period          14.6077
		Eccentricity    0.486638
		Inclination     -75.1941
		AscendingNode   -107.431
		ArgOfPericenter 47.851
		MeanAnomaly     13.2745
	}
}

DwarfMoon	"4.D60"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.95666e-009
	Radius          17.8467
	InertiaMoment   0.396857

	RotationPeriod  1045.53
	Obliquity       65.6918
	EqAscendNode    -110.534

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.796 0.794 0.793)

	Surface
	{
		SurfStyle       0.377408
		OceanStyle      0.210049
		Randomize      (0.674, 0.777, -0.718)
		colorDistMagn   0.683164
		colorDistFreq   0.182037
		detailScale     487.335
		colorConversion true
		snowLevel       2
		tropicLatitude  0.89884
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.722082
		terraceProb     0.280085
		erosion         0
		montesMagn      0.637426
		montesFreq      3.0392
		montesSpiky     0.985249
		montesFraction  0.821338
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.683209
		hillsFraction   0.590445
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.211676
		craterFreq      0.204451
		craterDensity   0.890922
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   63.2567
		volcanoTemp     1513.2
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.318, 0.318, 0.317, 0.000)
		colorShelf     (0.338, 0.338, 0.337, 0.000)
		colorBeach     (0.358, 0.357, 0.357, 0.000)
		colorDesert    (0.378, 0.377, 0.377, 0.000)
		colorLowland   (0.398, 0.397, 0.396, 0.000)
		colorUpland    (0.418, 0.417, 0.416, 0.000)
		colorRock      (0.438, 0.437, 0.436, 0.000)
		colorSnow      (0.457, 0.457, 0.456, 1.000)
		BumpHeight      16.0621
		BumpOffset      3.21241
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.769319
		Period          14.6264
		Eccentricity    0.340096
		Inclination     81.229
		AscendingNode   -114.64
		ArgOfPericenter -140.095
		MeanAnomaly     -63.2357
	}
}

DwarfMoon	"4.D61"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.74449e-009
	Radius          19.1901
	InertiaMoment   0.398542

	RotationPeriod  952.676
	Obliquity       -45.0399
	EqAscendNode    81.7219

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.540 0.533 0.528)

	Surface
	{
		SurfStyle       0.00720251
		OceanStyle      0.987864
		Randomize      (-0.807, 0.103, -0.859)
		colorDistMagn   0.527488
		colorDistFreq   0.249213
		detailScale     524.017
		colorConversion true
		snowLevel       2
		tropicLatitude  0.71314
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.32373
		terraceProb     0.163709
		erosion         0
		montesMagn      0.218276
		montesFreq      3.3469
		montesSpiky     0.957049
		montesFraction  0.705953
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.835038
		hillsFraction   0.516726
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238018
		craterFreq      0.168518
		craterDensity   1.09901
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   57.4316
		volcanoTemp     1223.63
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.216, 0.213, 0.211, 0.000)
		colorShelf     (0.229, 0.226, 0.224, 0.000)
		colorBeach     (0.243, 0.240, 0.237, 0.000)
		colorDesert    (0.256, 0.253, 0.251, 0.000)
		colorLowland   (0.270, 0.266, 0.264, 0.000)
		colorUpland    (0.283, 0.280, 0.277, 0.000)
		colorRock      (0.297, 0.293, 0.290, 0.000)
		colorSnow      (0.310, 0.306, 0.303, 1.000)
		BumpHeight      17.2711
		BumpOffset      3.45421
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.769799
		Period          14.6401
		Eccentricity    0.133912
		Inclination     -3.50613
		AscendingNode   84.3372
		ArgOfPericenter -57.9179
		MeanAnomaly     -171.386
	}
}

DwarfMoon	"4.D62"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.81792e-009
	Radius          20.1979
	InertiaMoment   0.399534

	RotationPeriod  852.547
	Obliquity       -68.3068
	EqAscendNode    -172.372

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.702 0.600 0.508)

	Surface
	{
		SurfStyle       0.55516
		OceanStyle      0.671514
		Randomize      (-0.753, 0.838, -0.990)
		colorDistMagn   0.724224
		colorDistFreq   0.0940313
		detailScale     551.536
		colorConversion true
		snowLevel       2
		tropicLatitude  0.244286
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.399939
		terraceProb     0.497188
		erosion         0
		montesMagn      0.450318
		montesFreq      2.9564
		montesSpiky     0.957082
		montesFraction  0.620296
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.554899
		hillsFraction   0.52308
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.220217
		craterFreq      0.256757
		craterDensity   0.883587
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   51.2505
		volcanoTemp     1761.28
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.274, 0.204, 0.142, 0.000)
		colorShelf     (0.281, 0.210, 0.163, 0.000)
		colorBeach     (0.330, 0.246, 0.193, 0.000)
		colorDesert    (0.358, 0.264, 0.188, 0.000)
		colorLowland   (0.393, 0.282, 0.213, 0.000)
		colorUpland    (0.435, 0.342, 0.259, 0.000)
		colorRock      (0.470, 0.372, 0.279, 0.000)
		colorSnow      (0.512, 0.396, 0.295, 1.000)
		BumpHeight      18.1781
		BumpOffset      3.63562
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.770028
		Period          14.6466
		Eccentricity    0.109944
		Inclination     -80.7593
		AscendingNode   -173.033
		ArgOfPericenter 159.111
		MeanAnomaly     50.2351
	}
}

DwarfMoon	"4.D63"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.27513e-009
	Radius          26.3401
	InertiaMoment   0.397229

	RotationPeriod  941.823
	Obliquity       -116.431
	EqAscendNode    148.614

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.764 0.760 0.758)

	Surface
	{
		SurfStyle       0.790155
		OceanStyle      0.373261
		Randomize      (-0.413, 0.493, -0.742)
		colorDistMagn   0.504165
		colorDistFreq   0.0888406
		detailScale     719.26
		colorConversion true
		snowLevel       2
		tropicLatitude  0.995477
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.529469
		terraceProb     0.373425
		erosion         0
		montesMagn      0.494847
		montesFreq      3.11233
		montesSpiky     0.976543
		montesFraction  0.42969
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.75959
		hillsFraction   0.737092
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.286002
		craterFreq      0.222869
		craterDensity   0.935378
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   56.86
		volcanoTemp     1308.31
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.298, 0.258, 0.212, 0.000)
		colorShelf     (0.306, 0.266, 0.243, 0.000)
		colorBeach     (0.359, 0.312, 0.288, 0.000)
		colorDesert    (0.390, 0.334, 0.281, 0.000)
		colorLowland   (0.428, 0.357, 0.319, 0.000)
		colorUpland    (0.474, 0.433, 0.387, 0.000)
		colorRock      (0.512, 0.471, 0.417, 0.000)
		colorSnow      (0.558, 0.501, 0.440, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.77069
		Period          14.6655
		Eccentricity    0.0619567
		Inclination     -22.9048
		AscendingNode   154.675
		ArgOfPericenter -127.957
		MeanAnomaly     -26.7613
	}
}

DwarfMoon	"4.D64"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.24813e-009
	Radius          27.7782
	InertiaMoment   0.3987

	RotationPeriod  850.141
	Obliquity       124.651
	EqAscendNode    21.698

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.719 0.628 0.503)

	Surface
	{
		SurfStyle       0.304303
		OceanStyle      0.936253
		Randomize      (-0.424, -0.556, -0.712)
		colorDistMagn   0.774518
		colorDistFreq   0.627824
		detailScale     758.529
		colorConversion true
		snowLevel       2
		tropicLatitude  0.559329
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.431942
		terraceProb     0.11115
		erosion         0
		montesMagn      0.561617
		montesFreq      3.0293
		montesSpiky     0.981433
		montesFraction  0.581285
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.85406
		hillsFraction   0.795494
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.221067
		craterFreq      0.211468
		craterDensity   0.928867
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   51.156
		volcanoTemp     1532.03
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.288, 0.251, 0.201, 0.000)
		colorShelf     (0.306, 0.267, 0.214, 0.000)
		colorBeach     (0.324, 0.283, 0.226, 0.000)
		colorDesert    (0.342, 0.298, 0.239, 0.000)
		colorLowland   (0.360, 0.314, 0.252, 0.000)
		colorUpland    (0.378, 0.330, 0.264, 0.000)
		colorRock      (0.395, 0.345, 0.277, 0.000)
		colorSnow      (0.413, 0.361, 0.289, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.771045
		Period          14.6756
		Eccentricity    0.496762
		Inclination     84.2079
		AscendingNode   19.4834
		ArgOfPericenter -179.489
		MeanAnomaly     145.761
	}
}

DwarfMoon	"4.D65"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            9.91503e-009
	Radius          29.6191
	InertiaMoment   0.399662

	RotationPeriod  776.874
	Obliquity       4.48224
	EqAscendNode    -16.3531

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.410 0.407 0.404)

	Surface
	{
		SurfStyle       0.763019
		OceanStyle      0.567948
		Randomize      (-0.255, -0.418, 0.750)
		colorDistMagn   0.702219
		colorDistFreq   0.763326
		detailScale     808.798
		colorConversion true
		snowLevel       2
		tropicLatitude  0.715458
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.639781
		terraceProb     0.37122
		erosion         0
		montesMagn      0.63919
		montesFreq      3.23876
		montesSpiky     0.91526
		montesFraction  0.740875
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.65743
		hillsFraction   0.772821
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.220024
		craterFreq      0.213723
		craterDensity   0.773982
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   46.637
		volcanoTemp     1588.14
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.160, 0.138, 0.113, 0.000)
		colorShelf     (0.164, 0.143, 0.129, 0.000)
		colorBeach     (0.193, 0.167, 0.154, 0.000)
		colorDesert    (0.209, 0.179, 0.150, 0.000)
		colorLowland   (0.230, 0.191, 0.170, 0.000)
		colorUpland    (0.254, 0.232, 0.206, 0.000)
		colorRock      (0.275, 0.252, 0.222, 0.000)
		colorSnow      (0.300, 0.269, 0.234, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.7715
		Period          14.6886
		Eccentricity    0.451595
		Inclination     -49.957
		AscendingNode   -16.8451
		ArgOfPericenter 157.506
		MeanAnomaly     -18.7093
	}
}

DwarfMoon	"4.D66"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.35172e-008
	Radius          31.1918
	InertiaMoment   0.397524

	RotationPeriod  699.662
	Obliquity       -140.962
	EqAscendNode    87.5997

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.671 0.669 0.666)

	Surface
	{
		SurfStyle       0.663565
		OceanStyle      0.997988
		Randomize      (0.565, 0.273, -0.895)
		colorDistMagn   0.579775
		colorDistFreq   0.393306
		detailScale     851.743
		colorConversion true
		snowLevel       2
		tropicLatitude  0.999785
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.415545
		terraceProb     0.264573
		erosion         0
		montesMagn      0.440772
		montesFreq      2.20054
		montesSpiky     0.974205
		montesFraction  0.315423
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.83753
		hillsFraction   0.763008
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.215902
		craterFreq      0.187755
		craterDensity   1.02478
		craterOctaves   13
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   42.0633
		volcanoTemp     1128.45
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.262, 0.227, 0.186, 0.000)
		colorShelf     (0.269, 0.234, 0.213, 0.000)
		colorBeach     (0.316, 0.274, 0.253, 0.000)
		colorDesert    (0.342, 0.294, 0.246, 0.000)
		colorLowland   (0.376, 0.314, 0.280, 0.000)
		colorUpland    (0.416, 0.381, 0.340, 0.000)
		colorRock      (0.450, 0.415, 0.366, 0.000)
		colorSnow      (0.490, 0.441, 0.386, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.772098
		Period          14.7057
		Eccentricity    0.467752
		Inclination     -89.4172
		AscendingNode   88.8305
		ArgOfPericenter 36.6319
		MeanAnomaly     -29.9986
	}
}

DwarfMoon	"4.D67"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.8383e-008
	Radius          40.3796
	InertiaMoment   0.398851

	RotationPeriod  777.05
	Obliquity       56.2341
	EqAscendNode    -182.781

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.555 0.549 0.543)

	Surface
	{
		SurfStyle       0.540915
		OceanStyle      0.343967
		Randomize      (-0.182, 0.591, 0.145)
		colorDistMagn   0.347222
		colorDistFreq   1.22708
		detailScale     1102.63
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0852487
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.629112
		terraceProb     0.385707
		erosion         0
		montesMagn      0.685547
		montesFreq      2.87746
		montesSpiky     0.870802
		montesFraction  0.756514
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.92345
		hillsFraction   0.488624
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234445
		craterFreq      0.219142
		craterDensity   0.777365
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   46.6939
		volcanoTemp     1373.24
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.216, 0.186, 0.152, 0.000)
		colorShelf     (0.222, 0.192, 0.174, 0.000)
		colorBeach     (0.261, 0.225, 0.206, 0.000)
		colorDesert    (0.283, 0.241, 0.201, 0.000)
		colorLowland   (0.311, 0.258, 0.228, 0.000)
		colorUpland    (0.344, 0.313, 0.277, 0.000)
		colorRock      (0.372, 0.340, 0.299, 0.000)
		colorSnow      (0.405, 0.362, 0.315, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.77255
		Period          14.7186
		Eccentricity    0.220469
		Inclination     53.7895
		AscendingNode   -174.829
		ArgOfPericenter -168.122
		MeanAnomaly     132.575
	}
}

DwarfMoon	"4.D68"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.49618e-008
	Radius          42.2069
	InertiaMoment   0.399788

	RotationPeriod  698.689
	Obliquity       -59.7474
	EqAscendNode    -186.676

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.617 0.612 0.610)

	Surface
	{
		SurfStyle       0.862318
		OceanStyle      0.566029
		Randomize      (0.668, -0.133, -0.673)
		colorDistMagn   0.872943
		colorDistFreq   0.8559
		detailScale     1152.53
		colorConversion true
		snowLevel       2
		tropicLatitude  0.89526
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.350312
		terraceProb     0.182414
		erosion         0
		montesMagn      0.473023
		montesFreq      2.74067
		montesSpiky     0.932488
		montesFraction  0.732584
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.15677
		hillsFraction   0.641703
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.230027
		craterFreq      0.247962
		craterDensity   0.941817
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   41.8843
		volcanoTemp     1590.53
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.210, 0.214, 0.244, 0.050)
		colorShelf     (0.247, 0.251, 0.281, 0.040)
		colorBeach     (0.284, 0.288, 0.317, 0.030)
		colorDesert    (0.321, 0.325, 0.360, 0.020)
		colorLowland   (0.358, 0.361, 0.397, 0.030)
		colorUpland    (0.395, 0.398, 0.433, 0.050)
		colorRock      (0.432, 0.435, 0.482, 0.020)
		colorSnow      (0.432, 0.435, 0.482, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.772913
		Period          14.729
		Eccentricity    0.305057
		Inclination     3.79945
		AscendingNode   -177.001
		ArgOfPericenter -130.116
		MeanAnomaly     116.532
	}
}

DwarfMoon	"4.D69"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.38725e-008
	Radius          44.8654
	InertiaMoment   0.397773

	RotationPeriod  636.583
	Obliquity       33.4993
	EqAscendNode    -111.963

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.842 0.747 0.715)

	Surface
	{
		SurfStyle       0.118922
		OceanStyle      0.476701
		Randomize      (-0.107, -0.963, 0.210)
		colorDistMagn   0.150348
		colorDistFreq   0.490614
		detailScale     1225.12
		colorConversion true
		snowLevel       2
		tropicLatitude  0.635748
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.631664
		terraceProb     0.667792
		erosion         0
		montesMagn      0.465505
		montesFreq      3.24119
		montesSpiky     0.983802
		montesFraction  0.79646
		dunesFraction   0
		hillsMagn       0
		hillsFreq       4.39301
		hillsFraction   0.785876
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.214622
		craterFreq      0.201312
		craterDensity   0.84722
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   38.2203
		volcanoTemp     1262.91
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.337, 0.299, 0.286, 0.000)
		colorShelf     (0.358, 0.318, 0.304, 0.000)
		colorBeach     (0.379, 0.336, 0.322, 0.000)
		colorDesert    (0.400, 0.355, 0.340, 0.000)
		colorLowland   (0.421, 0.374, 0.358, 0.000)
		colorUpland    (0.442, 0.392, 0.375, 0.000)
		colorRock      (0.463, 0.411, 0.393, 0.000)
		colorSnow      (0.484, 0.430, 0.411, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.773542
		Period          14.747
		Eccentricity    0.179284
		Inclination     43.0568
		AscendingNode   -115.562
		ArgOfPericenter -5.30043
		MeanAnomaly     -144.939
	}
}

DwarfMoon	"4.D70"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.59729e-008
	Radius          47.3826
	InertiaMoment   0.398996

	RotationPeriod  578.49
	Obliquity       -22.3761
	EqAscendNode    -178.571

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.486 0.484 0.481)

	Surface
	{
		SurfStyle       0.693248
		OceanStyle      0.123811
		Randomize      (-0.499, -0.695, 0.432)
		colorDistMagn   0.202018
		colorDistFreq   0.362683
		detailScale     1293.86
		colorConversion true
		snowLevel       2
		tropicLatitude  0.581119
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.363282
		terraceProb     0.104038
		erosion         0
		montesMagn      0.386582
		montesFreq      3.03143
		montesSpiky     0.969408
		montesFraction  0.494174
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.59466
		hillsFraction   0.554311
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.222998
		craterFreq      0.21788
		craterDensity   0.813285
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.6477
		volcanoTemp     1466.96
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.189, 0.164, 0.135, 0.000)
		colorShelf     (0.194, 0.169, 0.154, 0.000)
		colorBeach     (0.228, 0.198, 0.183, 0.000)
		colorDesert    (0.248, 0.213, 0.178, 0.000)
		colorLowland   (0.272, 0.227, 0.202, 0.000)
		colorUpland    (0.301, 0.276, 0.245, 0.000)
		colorRock      (0.325, 0.300, 0.264, 0.000)
		colorSnow      (0.355, 0.319, 0.279, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.773868
		Period          14.7563
		Eccentricity    0.26201
		Inclination     13.1802
		AscendingNode   -175.448
		ArgOfPericenter -34.9407
		MeanAnomaly     68.3425
	}
}

DwarfMoon	"4.D71"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.2462e-008
	Radius          61.5214
	InertiaMoment   0.399913

	RotationPeriod  644.47
	Obliquity       168.336
	EqAscendNode    -109.358

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.493 0.489 0.487)

	Surface
	{
		SurfStyle       0.428976
		OceanStyle      0.23352
		Randomize      (-0.455, -0.944, 0.799)
		colorDistMagn   0.824805
		colorDistFreq   1.40417
		detailScale     1679.94
		colorConversion true
		snowLevel       2
		tropicLatitude  0.966258
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.703583
		terraceProb     0.131532
		erosion         0
		montesMagn      0.497188
		montesFreq      2.73202
		montesSpiky     0.929133
		montesFraction  0.374826
		dunesFraction   0
		hillsMagn       0
		hillsFreq       13.0563
		hillsFraction   0.604783
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24172
		craterFreq      0.275809
		craterDensity   0.880873
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   38.5944
		volcanoTemp     1591.16
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.197, 0.195, 0.195, 0.000)
		colorShelf     (0.210, 0.208, 0.207, 0.000)
		colorBeach     (0.222, 0.220, 0.219, 0.000)
		colorDesert    (0.234, 0.232, 0.231, 0.000)
		colorLowland   (0.247, 0.244, 0.243, 0.000)
		colorUpland    (0.259, 0.257, 0.256, 0.000)
		colorRock      (0.271, 0.269, 0.268, 0.000)
		colorSnow      (0.284, 0.281, 0.280, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.774249
		Period          14.7672
		Eccentricity    0.188066
		Inclination     69.9136
		AscendingNode   -114.511
		ArgOfPericenter -35.8589
		MeanAnomaly     87.3818
	}
}

DwarfMoon	"4.D72"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.50305e-008
	Radius          63.9138
	InertiaMoment   0.397992

	RotationPeriod  573.102
	Obliquity       -66.0293
	EqAscendNode    -3.44793

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.465 0.463 0.460)

	Surface
	{
		SurfStyle       0.762784
		OceanStyle      0.515535
		Randomize      (-0.395, 0.381, 0.509)
		colorDistMagn   0.724431
		colorDistFreq   2.09399
		detailScale     1745.27
		colorConversion true
		snowLevel       2
		tropicLatitude  0.995355
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.678824
		terraceProb     0.124187
		erosion         0
		montesMagn      0.331722
		montesFreq      2.9021
		montesSpiky     0.704771
		montesFraction  0.752641
		dunesFraction   0
		hillsMagn       0
		hillsFreq       10.2383
		hillsFraction   0.581611
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238795
		craterFreq      0.226574
		craterDensity   0.797273
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   34.3648
		volcanoTemp     1325.17
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.181, 0.157, 0.129, 0.000)
		colorShelf     (0.186, 0.162, 0.147, 0.000)
		colorBeach     (0.219, 0.190, 0.175, 0.000)
		colorDesert    (0.237, 0.204, 0.170, 0.000)
		colorLowland   (0.260, 0.217, 0.193, 0.000)
		colorUpland    (0.288, 0.264, 0.234, 0.000)
		colorRock      (0.311, 0.287, 0.253, 0.000)
		colorSnow      (0.339, 0.305, 0.267, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.774843
		Period          14.7842
		Eccentricity    0.219388
		Inclination     -18.4706
		AscendingNode   3.12031
		ArgOfPericenter 141.835
		MeanAnomaly     -159.665
	}
}

DwarfMoon	"4.D73"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.16086e-007
	Radius          68.0259
	InertiaMoment   0.399135

	RotationPeriod  523.203
	Obliquity       12.3311
	EqAscendNode    82.888

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.408 0.405 0.401)

	Surface
	{
		SurfStyle       0.32378
		OceanStyle      0.687093
		Randomize      (-0.323, 0.818, -0.374)
		colorDistMagn   0.929822
		colorDistFreq   3.52053
		detailScale     1857.56
		colorConversion true
		snowLevel       2
		tropicLatitude  0.99844
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.448967
		terraceProb     0.28635
		erosion         0
		montesMagn      0.426444
		montesFreq      3.30828
		montesSpiky     0.829174
		montesFraction  0.742014
		dunesFraction   0
		hillsMagn       0
		hillsFreq       12.1885
		hillsFraction   0.638139
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.246293
		craterFreq      0.226869
		craterDensity   0.794518
		craterOctaves   14
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   31.3034
		volcanoTemp     1716.8
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.163, 0.162, 0.160, 0.000)
		colorShelf     (0.173, 0.172, 0.170, 0.000)
		colorBeach     (0.184, 0.182, 0.180, 0.000)
		colorDesert    (0.194, 0.192, 0.190, 0.000)
		colorLowland   (0.204, 0.202, 0.200, 0.000)
		colorUpland    (0.214, 0.213, 0.210, 0.000)
		colorRock      (0.224, 0.223, 0.220, 0.000)
		colorSnow      (0.235, 0.233, 0.230, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.775261
		Period          14.7962
		Eccentricity    0.312402
		Inclination     85.8894
		AscendingNode   86.1797
		ArgOfPericenter -90.4921
		MeanAnomaly     -118.665
	}
}

DwarfMoon	"4.D74"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.59095e-007
	Radius          72.2798
	InertiaMoment   0.395149

	RotationPeriod  472.862
	Obliquity       -107.355
	EqAscendNode    -137.108

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.443 0.440 0.438)

	Surface
	{
		SurfStyle       0.95535
		OceanStyle      0.61716
		Randomize      (0.423, -0.470, -0.551)
		colorDistMagn   0.495525
		colorDistFreq   2.98607
		detailScale     1973.72
		colorConversion true
		snowLevel       2
		tropicLatitude  0.778344
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.454831
		terraceProb     0.380978
		erosion         0
		montesMagn      0.57323
		montesFreq      2.81959
		montesSpiky     0.991854
		montesFraction  0.217903
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.68191
		hillsFraction   0.47271
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241337
		craterFreq      0.261581
		craterDensity   0.774513
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   28.4115
		volcanoTemp     1462.12
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.151, 0.154, 0.175, 0.050)
		colorShelf     (0.177, 0.180, 0.201, 0.040)
		colorBeach     (0.204, 0.207, 0.228, 0.030)
		colorDesert    (0.230, 0.233, 0.258, 0.020)
		colorLowland   (0.257, 0.259, 0.285, 0.030)
		colorUpland    (0.284, 0.286, 0.311, 0.050)
		colorRock      (0.310, 0.312, 0.346, 0.020)
		colorSnow      (0.310, 0.312, 0.346, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.775524
		Period          14.8037
		Eccentricity    0.341656
		Inclination     -87.7883
		AscendingNode   -132.094
		ArgOfPericenter -132.731
		MeanAnomaly     -178.174
	}
}

DwarfMoon	"4.D75"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.19115e-007
	Radius          95.0962
	InertiaMoment   0.398189

	RotationPeriod  531.674
	Obliquity       75.9261
	EqAscendNode    123.447

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.756 0.723 0.676)

	Surface
	{
		SurfStyle       0.344788
		OceanStyle      0.932586
		Randomize      (0.619, -0.013, -0.838)
		colorDistMagn   0.651268
		colorDistFreq   5.39486
		detailScale     2596.76
		colorConversion true
		snowLevel       2
		tropicLatitude  0.755666
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.474408
		terraceProb     0.287428
		erosion         0
		montesMagn      0.307709
		montesFreq      2.87707
		montesSpiky     0.968279
		montesFraction  0.541634
		dunesFraction   0
		hillsMagn       0
		hillsFreq       19.9247
		hillsFraction   0.653756
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238784
		craterFreq      0.219509
		craterDensity   0.933451
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   31.8517
		volcanoTemp     1720.58
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.302, 0.289, 0.271, 0.000)
		colorShelf     (0.321, 0.307, 0.287, 0.000)
		colorBeach     (0.340, 0.325, 0.304, 0.000)
		colorDesert    (0.359, 0.343, 0.321, 0.000)
		colorLowland   (0.378, 0.361, 0.338, 0.000)
		colorUpland    (0.397, 0.379, 0.355, 0.000)
		colorRock      (0.416, 0.397, 0.372, 0.000)
		colorSnow      (0.435, 0.416, 0.389, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.775981
		Period          14.8168
		Eccentricity    0.4797
		Inclination     81.4962
		AscendingNode   130.184
		ArgOfPericenter -116.262
		MeanAnomaly     -155.617
	}
}

DwarfMoon	"4.D76"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.03626e-007
	Radius          98.3506
	InertiaMoment   0.39927

	RotationPeriod  468.211
	Obliquity       57.6625
	EqAscendNode    -98.2784

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.618 0.612 0.608)

	Surface
	{
		SurfStyle       0.725814
		OceanStyle      0.766211
		Randomize      (-0.296, -0.529, 0.883)
		colorDistMagn   0.391702
		colorDistFreq   5.56456
		detailScale     2685.63
		colorConversion true
		snowLevel       2
		tropicLatitude  0.888759
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.688561
		terraceProb     0.396109
		erosion         0
		montesMagn      0.598211
		montesFreq      2.52599
		montesSpiky     0.915195
		montesFraction  0.68556
		dunesFraction   0
		hillsMagn       0
		hillsFreq       21.9313
		hillsFraction   0.60118
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.231604
		craterFreq      0.297256
		craterDensity   0.92423
		craterOctaves   15
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   27.9843
		volcanoTemp     1478.33
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.241, 0.208, 0.170, 0.000)
		colorShelf     (0.247, 0.214, 0.195, 0.000)
		colorBeach     (0.291, 0.251, 0.231, 0.000)
		colorDesert    (0.315, 0.269, 0.225, 0.000)
		colorLowland   (0.346, 0.288, 0.256, 0.000)
		colorUpland    (0.383, 0.349, 0.310, 0.000)
		colorRock      (0.414, 0.379, 0.335, 0.000)
		colorSnow      (0.451, 0.404, 0.353, 1.000)
		BumpHeight      20
		BumpOffset      4
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.776242
		Period          14.8243
		Eccentricity    0.233223
		Inclination     49.2362
		AscendingNode   -99.8171
		ArgOfPericenter 168.304
		MeanAnomaly     -100.953
	}
}

DwarfMoon	"4.S1"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.08119e-011
	Radius          5.19406
	InertiaMoment   0.396311

	Oblateness      0.249

	Obliquity       -0.147421
	EqAscendNode    98.4144
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.735 0.692 0.622)

	Surface
	{
		SurfStyle       0.530732
		OceanStyle      0.480342
		Randomize      (0.418, 0.888, 0.181)
		colorDistMagn   0.577354
		colorDistFreq   0.0160149
		detailScale     141.832
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00336524
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.6709
		terraceProb     0.39885
		erosion         0
		montesMagn      0.597656
		montesFreq      1.57822
		montesSpiky     0.905948
		montesFraction  0.538566
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0793638
		hillsFraction   0.705534
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.228539
		craterFreq      0.205495
		craterDensity   0.813486
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   114.243
		volcanoTemp     1471.82
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.287, 0.235, 0.174, 0.000)
		colorShelf     (0.294, 0.242, 0.199, 0.000)
		colorBeach     (0.345, 0.284, 0.236, 0.000)
		colorDesert    (0.375, 0.304, 0.230, 0.000)
		colorLowland   (0.412, 0.325, 0.261, 0.000)
		colorUpland    (0.456, 0.394, 0.317, 0.000)
		colorRock      (0.493, 0.429, 0.342, 0.000)
		colorSnow      (0.537, 0.457, 0.361, 1.000)
		BumpHeight      4.67465
		BumpOffset      0.934931
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000821427
		Period          0.000510306
		Eccentricity    0
		Inclination     -0.147421
		AscendingNode   98.4144
		ArgOfPericenter 100.685
		MeanAnomaly     -82.4884
	}
}

DwarfMoon	"4.S2"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.9556e-011
	Radius          5.78024
	InertiaMoment   0.39837

	Oblateness      0.249

	Obliquity       0.495818
	EqAscendNode    -64.0994
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.652 0.648 0.644)

	Surface
	{
		SurfStyle       0.183155
		OceanStyle      0.657053
		Randomize      (-0.639, 0.663, 0.794)
		colorDistMagn   0.209731
		colorDistFreq   0.0172884
		detailScale     157.839
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0146684
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.518836
		terraceProb     0.363462
		erosion         0
		montesMagn      0.592798
		montesFreq      3.07831
		montesSpiky     0.818959
		montesFraction  0.483527
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0769584
		hillsFraction   0.552801
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233286
		craterFreq      0.240755
		craterDensity   0.87976
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   101.605
		volcanoTemp     1777.81
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.261, 0.259, 0.258, 0.000)
		colorShelf     (0.277, 0.275, 0.274, 0.000)
		colorBeach     (0.294, 0.292, 0.290, 0.000)
		colorDesert    (0.310, 0.308, 0.306, 0.000)
		colorLowland   (0.326, 0.324, 0.322, 0.000)
		colorUpland    (0.343, 0.340, 0.338, 0.000)
		colorRock      (0.359, 0.356, 0.354, 0.000)
		colorSnow      (0.375, 0.373, 0.371, 1.000)
		BumpHeight      5.20222
		BumpOffset      1.04044
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000830548
		Period          0.000518829
		Eccentricity    0
		Inclination     0.495818
		AscendingNode   -64.0994
		ArgOfPericenter 36.6152
		MeanAnomaly     30.8791
	}
}

DwarfMoon	"4.S3"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.28133e-010
	Radius          8.15323
	InertiaMoment   0.399402

	Oblateness      0.249

	Obliquity       1.30844
	EqAscendNode    -164.383
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.650 0.544 0.491)

	Surface
	{
		SurfStyle       0.586641
		OceanStyle      0.420869
		Randomize      (-0.723, -0.016, -0.464)
		colorDistMagn   0.981572
		colorDistFreq   0.0501715
		detailScale     222.638
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00620518
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.543913
		terraceProb     0.24124
		erosion         0
		montesMagn      0.552283
		montesFreq      2.54354
		montesSpiky     0.810793
		montesFraction  0.801505
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.155545
		hillsFraction   0.912381
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.253902
		craterFreq      0.256129
		craterDensity   0.870008
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   112.929
		volcanoTemp     1027.12
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.253, 0.185, 0.137, 0.000)
		colorShelf     (0.260, 0.190, 0.157, 0.000)
		colorBeach     (0.305, 0.223, 0.186, 0.000)
		colorDesert    (0.331, 0.239, 0.181, 0.000)
		colorLowland   (0.364, 0.256, 0.206, 0.000)
		colorUpland    (0.403, 0.310, 0.250, 0.000)
		colorRock      (0.435, 0.337, 0.270, 0.000)
		colorSnow      (0.474, 0.359, 0.284, 1.000)
		BumpHeight      7.33791
		BumpOffset      1.46758
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000832109
		Period          0.000520292
		Eccentricity    0
		Inclination     1.30844
		AscendingNode   -164.383
		ArgOfPericenter 17.6438
		MeanAnomaly     45.7927
	}
}

DwarfMoon	"4.S4"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.13905e-010
	Radius          8.81435
	InertiaMoment   0.396847

	Oblateness      0.249

	Obliquity       1.2022
	EqAscendNode    -158.509
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.512 0.509 0.502)

	Surface
	{
		SurfStyle       0.6598
		OceanStyle      0.417086
		Randomize      (-0.704, 0.034, -0.081)
		colorDistMagn   0.267293
		colorDistFreq   0.0323329
		detailScale     240.691
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00782007
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.62614
		terraceProb     0.150619
		erosion         0
		montesMagn      0.454275
		montesFreq      2.80929
		montesSpiky     0.990848
		montesFraction  0.726164
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.230162
		hillsFraction   0.698998
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.21086
		craterFreq      0.237771
		craterDensity   1.09656
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   94.4901
		volcanoTemp     1656.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.200, 0.173, 0.141, 0.000)
		colorShelf     (0.205, 0.178, 0.161, 0.000)
		colorBeach     (0.241, 0.208, 0.191, 0.000)
		colorDesert    (0.261, 0.224, 0.186, 0.000)
		colorLowland   (0.287, 0.239, 0.211, 0.000)
		colorUpland    (0.317, 0.290, 0.256, 0.000)
		colorRock      (0.343, 0.315, 0.276, 0.000)
		colorSnow      (0.374, 0.336, 0.291, 1.000)
		BumpHeight      7.93292
		BumpOffset      1.58658
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000836115
		Period          0.000524054
		Eccentricity    0
		Inclination     1.2022
		AscendingNode   -158.509
		ArgOfPericenter 107.56
		MeanAnomaly     127.684
	}
}

DwarfMoon	"4.S5"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.74092e-010
	Radius          10.1614
	InertiaMoment   0.398538

	Oblateness      0.249

	Obliquity       -1.31106
	EqAscendNode    -179.073
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.519 0.515 0.508)

	Surface
	{
		SurfStyle       0.0233244
		OceanStyle      0.229419
		Randomize      (-0.299, 0.486, -0.015)
		colorDistMagn   0.401191
		colorDistFreq   0.0533231
		detailScale     277.474
		colorConversion true
		snowLevel       2
		tropicLatitude  0.000345267
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.470885
		terraceProb     0.129983
		erosion         0
		montesMagn      0.514922
		montesFreq      3.77081
		montesSpiky     0.933762
		montesFraction  0.402423
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.26842
		hillsFraction   0.743503
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23518
		craterFreq      0.166583
		craterDensity   0.920062
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   82.3701
		volcanoTemp     1723.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.208, 0.206, 0.203, 0.000)
		colorShelf     (0.221, 0.219, 0.216, 0.000)
		colorBeach     (0.234, 0.232, 0.229, 0.000)
		colorDesert    (0.247, 0.244, 0.241, 0.000)
		colorLowland   (0.260, 0.257, 0.254, 0.000)
		colorUpland    (0.273, 0.270, 0.267, 0.000)
		colorRock      (0.286, 0.283, 0.279, 0.000)
		colorSnow      (0.299, 0.296, 0.292, 1.000)
		BumpHeight      9.14525
		BumpOffset      1.82905
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000850226
		Period          0.000537377
		Eccentricity    0
		Inclination     -1.31106
		AscendingNode   -179.073
		ArgOfPericenter 138.259
		MeanAnomaly     -136.3
	}
}

DwarfMoon	"4.S6"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.96303e-010
	Radius          11.994
	InertiaMoment   0.399532

	Oblateness      0.249

	Obliquity       1.35367
	EqAscendNode    92.9488
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.779 0.733 0.702)

	Surface
	{
		SurfStyle       0.387854
		OceanStyle      0.127168
		Randomize      (0.990, -0.504, 0.211)
		colorDistMagn   0.236332
		colorDistFreq   0.0997382
		detailScale     327.517
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0325333
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.575201
		terraceProb     0.313416
		erosion         0
		montesMagn      0.388138
		montesFreq      2.3616
		montesSpiky     0.940256
		montesFraction  0.356758
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.264585
		hillsFraction   0.392575
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.193409
		craterFreq      0.225372
		craterDensity   0.719558
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   71.2643
		volcanoTemp     1239.31
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.312, 0.293, 0.281, 0.000)
		colorShelf     (0.331, 0.312, 0.298, 0.000)
		colorBeach     (0.351, 0.330, 0.316, 0.000)
		colorDesert    (0.370, 0.348, 0.333, 0.000)
		colorLowland   (0.390, 0.367, 0.351, 0.000)
		colorUpland    (0.409, 0.385, 0.368, 0.000)
		colorRock      (0.429, 0.403, 0.386, 0.000)
		colorSnow      (0.448, 0.421, 0.403, 1.000)
		BumpHeight      10.7946
		BumpOffset      2.15893
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000854187
		Period          0.000541136
		Eccentricity    0
		Inclination     1.35367
		AscendingNode   92.9488
		ArgOfPericenter 7.64907
		MeanAnomaly     -112.529
	}
}

DwarfMoon	"4.S7"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.41439e-009
	Radius          19.1061
	InertiaMoment   0.397222

	Oblateness      0.249

	Obliquity       0.209791
	EqAscendNode    -170.268
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.661 0.657 0.655)

	Surface
	{
		SurfStyle       0.95643
		OceanStyle      0.605799
		Randomize      (-0.163, 0.670, -0.932)
		colorDistMagn   0.687888
		colorDistFreq   0.257945
		detailScale     521.723
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00059802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.399738
		terraceProb     0.179652
		erosion         0
		montesMagn      0.688029
		montesFreq      2.82361
		montesSpiky     0.975671
		montesFraction  0.802113
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.09518
		hillsFraction   0.67646
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.225239
		craterFreq      0.222903
		craterDensity   1.05866
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   79.6512
		volcanoTemp     1528.77
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.225, 0.230, 0.262, 0.050)
		colorShelf     (0.264, 0.269, 0.301, 0.040)
		colorBeach     (0.304, 0.309, 0.341, 0.030)
		colorDesert    (0.344, 0.348, 0.387, 0.020)
		colorLowland   (0.383, 0.388, 0.426, 0.030)
		colorUpland    (0.423, 0.427, 0.465, 0.050)
		colorRock      (0.463, 0.466, 0.518, 0.020)
		colorSnow      (0.463, 0.466, 0.518, 1.000)
		BumpHeight      17.1955
		BumpOffset      3.43909
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000858562
		Period          0.000545299
		Eccentricity    0
		Inclination     0.209791
		AscendingNode   -170.268
		ArgOfPericenter 127.979
		MeanAnomaly     -164.121
	}
}

DwarfMoon	"4.S8"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.27485e-016
	Radius          0.10238
	InertiaMoment   0.398697

	Oblateness      0.249

	Obliquity       -0.168455
	EqAscendNode    -111.364
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.569 0.564 0.558)

	Surface
	{
		SurfStyle       0.337993
		OceanStyle      0.198995
		Randomize      (0.973, -0.736, 0.822)
		colorDistMagn   0.0372754
		colorDistFreq   8.08196e-006
		detailScale     2.79567
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00331168
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.663478
		terraceProb     0.178732
		erosion         0
		montesMagn      0.532131
		montesFreq      3.57435
		montesSpiky     0.96567
		montesFraction  0.405191
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.39809e-005
		hillsFraction   0.453891
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.255178
		craterFreq      0.178088
		craterDensity   0.703638
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   887.006
		volcanoTemp     1336.14
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.228, 0.225, 0.223, 0.000)
		colorShelf     (0.242, 0.240, 0.237, 0.000)
		colorBeach     (0.256, 0.254, 0.251, 0.000)
		colorDesert    (0.270, 0.268, 0.265, 0.000)
		colorLowland   (0.284, 0.282, 0.279, 0.000)
		colorUpland    (0.299, 0.296, 0.293, 0.000)
		colorRock      (0.313, 0.310, 0.307, 0.000)
		colorSnow      (0.327, 0.324, 0.321, 1.000)
		BumpHeight      0.0921423
		BumpOffset      0.0184285
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000865205
		Period          0.00055164
		Eccentricity    0
		Inclination     -0.168455
		AscendingNode   -111.364
		ArgOfPericenter 45.9724
		MeanAnomaly     -149.833
	}
}

DwarfMoon	"4.S9"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.49216e-016
	Radius          0.128813
	InertiaMoment   0.399659

	Oblateness      0.249

	Obliquity       -0.531989
	EqAscendNode    -51.257
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.793 0.734 0.710)

	Surface
	{
		SurfStyle       0.184805
		OceanStyle      0.343691
		Randomize      (-0.732, 0.703, 0.729)
		colorDistMagn   0.409864
		colorDistFreq   1.07405e-005
		detailScale     3.51747
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0167404
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.521
		terraceProb     0.265869
		erosion         0
		montesMagn      0.62813
		montesFreq      3.12807
		montesSpiky     0.803703
		montesFraction  0.701076
		dunesFraction   0
		hillsMagn       0
		hillsFreq       2.57366e-005
		hillsFraction   0.570629
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.249513
		craterFreq      0.203381
		craterDensity   0.743212
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   737.842
		volcanoTemp     1411.17
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.317, 0.294, 0.284, 0.000)
		colorShelf     (0.337, 0.312, 0.302, 0.000)
		colorBeach     (0.357, 0.330, 0.319, 0.000)
		colorDesert    (0.377, 0.349, 0.337, 0.000)
		colorLowland   (0.397, 0.367, 0.355, 0.000)
		colorUpland    (0.416, 0.386, 0.373, 0.000)
		colorRock      (0.436, 0.404, 0.390, 0.000)
		colorSnow      (0.456, 0.422, 0.408, 1.000)
		BumpHeight      0.115932
		BumpOffset      0.0231864
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000867442
		Period          0.000553781
		Eccentricity    0
		Inclination     -0.531989
		AscendingNode   -51.257
		ArgOfPericenter 149.908
		MeanAnomaly     142.685
	}
}

DwarfMoon	"4.S10"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.50992e-015
	Radius          0.156244
	InertiaMoment   0.397518

	Oblateness      0.249

	Obliquity       -0.848038
	EqAscendNode    -124.833
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.693 0.690 0.684)

	Surface
	{
		SurfStyle       0.0317112
		OceanStyle      0.33562
		Randomize      (-0.418, -0.520, 0.527)
		colorDistMagn   0.460697
		colorDistFreq   1.33597e-005
		detailScale     4.26649
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0137064
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.471662
		terraceProb     0.38472
		erosion         0
		montesMagn      0.464136
		montesFreq      2.4914
		montesSpiky     0.997202
		montesFraction  0.822571
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.42126e-005
		hillsFraction   0.528713
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.222363
		craterFreq      0.143506
		craterDensity   1.03866
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   630.421
		volcanoTemp     1266.05
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.277, 0.276, 0.274, 0.000)
		colorShelf     (0.295, 0.293, 0.291, 0.000)
		colorBeach     (0.312, 0.310, 0.308, 0.000)
		colorDesert    (0.329, 0.328, 0.325, 0.000)
		colorLowland   (0.347, 0.345, 0.342, 0.000)
		colorUpland    (0.364, 0.362, 0.359, 0.000)
		colorRock      (0.381, 0.379, 0.376, 0.000)
		colorSnow      (0.399, 0.397, 0.393, 1.000)
		BumpHeight      0.140619
		BumpOffset      0.0281238
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000872941
		Period          0.000559055
		Eccentricity    0
		Inclination     -0.848038
		AscendingNode   -124.833
		ArgOfPericenter -135
		MeanAnomaly     -133.704
	}
}

DwarfMoon	"4.S11"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.79507e-015
	Radius          0.177768
	InertiaMoment   0.398848

	Oblateness      0.249

	Obliquity       -0.779029
	EqAscendNode    178.034
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.508 0.402 0.316)

	Surface
	{
		SurfStyle       0.512648
		OceanStyle      0.205156
		Randomize      (0.829, -0.175, -0.829)
		colorDistMagn   0.334676
		colorDistFreq   2.17592e-005
		detailScale     4.85425
		colorConversion true
		snowLevel       2
		tropicLatitude  0.000488281
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.524682
		terraceProb     0.145846
		erosion         0
		montesMagn      0.440372
		montesFreq      2.62071
		montesSpiky     0.998665
		montesFraction  0.665575
		dunesFraction   0
		hillsMagn       0
		hillsFreq       6.58339e-005
		hillsFraction   0.454362
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.271322
		craterFreq      0.222164
		craterDensity   0.975296
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   527.185
		volcanoTemp     1291.25
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.198, 0.137, 0.089, 0.000)
		colorShelf     (0.203, 0.141, 0.101, 0.000)
		colorBeach     (0.239, 0.165, 0.120, 0.000)
		colorDesert    (0.259, 0.177, 0.117, 0.000)
		colorLowland   (0.284, 0.189, 0.133, 0.000)
		colorUpland    (0.315, 0.229, 0.161, 0.000)
		colorRock      (0.340, 0.249, 0.174, 0.000)
		colorSnow      (0.370, 0.265, 0.184, 1.000)
		BumpHeight      0.159991
		BumpOffset      0.0319982
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000876408
		Period          0.000562389
		Eccentricity    0
		Inclination     -0.779029
		AscendingNode   178.034
		ArgOfPericenter 124.987
		MeanAnomaly     176.553
	}
}

DwarfMoon	"4.S12"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.86861e-015
	Radius          0.253894
	InertiaMoment   0.399785

	Oblateness      0.249

	Obliquity       0.959884
	EqAscendNode    -31.1942
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.604 0.601 0.597)

	Surface
	{
		SurfStyle       0.525269
		OceanStyle      0.341347
		Randomize      (-0.995, -0.221, 0.235)
		colorDistMagn   0.442444
		colorDistFreq   2.79758e-005
		detailScale     6.933
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0322667
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.581779
		terraceProb     0.180703
		erosion         0
		montesMagn      0.333432
		montesFreq      2.52829
		montesSpiky     0.977283
		montesFraction  0.49038
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000104215
		hillsFraction   0.814323
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.236233
		craterFreq      0.266836
		craterDensity   0.875559
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   570.5
		volcanoTemp     1525.4
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.235, 0.204, 0.167, 0.000)
		colorShelf     (0.241, 0.210, 0.191, 0.000)
		colorBeach     (0.284, 0.246, 0.227, 0.000)
		colorDesert    (0.308, 0.264, 0.221, 0.000)
		colorLowland   (0.338, 0.282, 0.251, 0.000)
		colorUpland    (0.374, 0.342, 0.305, 0.000)
		colorRock      (0.404, 0.372, 0.329, 0.000)
		colorSnow      (0.441, 0.397, 0.347, 1.000)
		BumpHeight      0.228505
		BumpOffset      0.0457009
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000878962
		Period          0.000564849
		Eccentricity    0
		Inclination     0.959884
		AscendingNode   -31.1942
		ArgOfPericenter -15.4089
		MeanAnomaly     66.9925
	}
}

DwarfMoon	"4.S13"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.10276e-015
	Radius          0.286513
	InertiaMoment   0.397768

	Oblateness      0.249

	Obliquity       1.32319
	EqAscendNode    -178.152
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.586 0.584 0.581)

	Surface
	{
		SurfStyle       0.101218
		OceanStyle      0.952822
		Randomize      (0.483, 0.494, 0.050)
		colorDistMagn   0.693358
		colorDistFreq   1.844e-006
		detailScale     7.82372
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00077204
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.315468
		terraceProb     0.17435
		erosion         0
		montesMagn      0.466205
		montesFreq      2.80207
		montesSpiky     0.993828
		montesFraction  0.809012
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00016577
		hillsFraction   0.48427
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.260567
		craterFreq      0.220598
		craterDensity   0.859911
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   499.038
		volcanoTemp     1338.22
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.234, 0.234, 0.232, 0.000)
		colorShelf     (0.249, 0.248, 0.247, 0.000)
		colorBeach     (0.264, 0.263, 0.262, 0.000)
		colorDesert    (0.278, 0.277, 0.276, 0.000)
		colorLowland   (0.293, 0.292, 0.291, 0.000)
		colorUpland    (0.308, 0.307, 0.305, 0.000)
		colorRock      (0.322, 0.321, 0.320, 0.000)
		colorSnow      (0.337, 0.336, 0.334, 1.000)
		BumpHeight      0.257862
		BumpOffset      0.0515724
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000885401
		Period          0.000571067
		Eccentricity    0
		Inclination     1.32319
		AscendingNode   -178.152
		ArgOfPericenter 97.0473
		MeanAnomaly     3.17453
	}
}

DwarfMoon	"4.S14"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.30191e-014
	Radius          0.322349
	InertiaMoment   0.398992

	Oblateness      0.249

	Obliquity       -0.211431
	EqAscendNode    132.83
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.763 0.691 0.591)

	Surface
	{
		SurfStyle       0.596722
		OceanStyle      0.376358
		Randomize      (-0.538, 0.829, -0.548)
		colorDistMagn   0.578815
		colorDistFreq   1.47732e-005
		detailScale     8.80228
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00294996
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.391628
		terraceProb     0.29533
		erosion         0
		montesMagn      0.58608
		montesFreq      2.54342
		montesSpiky     0.815789
		montesFraction  0.691534
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000176798
		hillsFraction   0.757131
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.213455
		craterFreq      0.225916
		craterDensity   0.838759
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   442.937
		volcanoTemp     1554.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.298, 0.235, 0.165, 0.000)
		colorShelf     (0.305, 0.242, 0.189, 0.000)
		colorBeach     (0.359, 0.283, 0.225, 0.000)
		colorDesert    (0.389, 0.304, 0.219, 0.000)
		colorLowland   (0.427, 0.325, 0.248, 0.000)
		colorUpland    (0.473, 0.394, 0.301, 0.000)
		colorRock      (0.511, 0.428, 0.325, 0.000)
		colorSnow      (0.557, 0.456, 0.343, 1.000)
		BumpHeight      0.290114
		BumpOffset      0.0580229
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000899923
		Period          0.000585174
		Eccentricity    0
		Inclination     -0.211431
		AscendingNode   132.83
		ArgOfPericenter -89.0372
		MeanAnomaly     -61.2574
	}
}

DwarfMoon	"4.S15"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.03452e-014
	Radius          0.352525
	InertiaMoment   0.399911

	Oblateness      0.249

	Obliquity       -1.42774
	EqAscendNode    -139.61
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.621 0.515 0.361)

	Surface
	{
		SurfStyle       0.496222
		OceanStyle      0.376772
		Randomize      (0.462, 0.912, -0.935)
		colorDistMagn   0.60749
		colorDistFreq   4.95622e-005
		detailScale     9.62627
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0172039
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.636019
		terraceProb     0.140852
		erosion         0
		montesMagn      0.438584
		montesFreq      2.51677
		montesSpiky     0.874668
		montesFraction  0.823681
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000325183
		hillsFraction   0.602841
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.212277
		craterFreq      0.27641
		craterDensity   0.854597
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   387.494
		volcanoTemp     1773.28
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.248, 0.206, 0.145, 0.000)
		colorShelf     (0.264, 0.219, 0.154, 0.000)
		colorBeach     (0.279, 0.232, 0.163, 0.000)
		colorDesert    (0.295, 0.245, 0.172, 0.000)
		colorLowland   (0.310, 0.257, 0.181, 0.000)
		colorUpland    (0.326, 0.270, 0.190, 0.000)
		colorRock      (0.341, 0.283, 0.199, 0.000)
		colorSnow      (0.357, 0.296, 0.208, 1.000)
		BumpHeight      0.317272
		BumpOffset      0.0634544
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000912628
		Period          0.00059761
		Eccentricity    0
		Inclination     -1.42774
		AscendingNode   -139.61
		ArgOfPericenter 64.8531
		MeanAnomaly     -5.97988
	}
}

DwarfMoon	"4.S16"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.10928e-014
	Radius          0.475573
	InertiaMoment   0.397988

	Oblateness      0.249

	Obliquity       0.70941
	EqAscendNode    118.384
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.581 0.578 0.573)

	Surface
	{
		SurfStyle       0.758221
		OceanStyle      0.432041
		Randomize      (-0.286, 0.180, -0.661)
		colorDistMagn   0.954076
		colorDistFreq   8.44872e-005
		detailScale     12.9863
		colorConversion true
		snowLevel       2
		tropicLatitude  0.012681
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.554266
		terraceProb     0.431333
		erosion         0
		montesMagn      0.468501
		montesFreq      2.89474
		montesSpiky     0.911938
		montesFraction  0.687964
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000438961
		hillsFraction   0.685993
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234812
		craterFreq      0.196332
		craterDensity   0.774899
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   422.856
		volcanoTemp     1668.02
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.227, 0.197, 0.160, 0.000)
		colorShelf     (0.232, 0.202, 0.183, 0.000)
		colorBeach     (0.273, 0.237, 0.218, 0.000)
		colorDesert    (0.296, 0.254, 0.212, 0.000)
		colorLowland   (0.325, 0.272, 0.241, 0.000)
		colorUpland    (0.360, 0.330, 0.292, 0.000)
		colorRock      (0.389, 0.358, 0.315, 0.000)
		colorSnow      (0.424, 0.382, 0.332, 1.000)
		BumpHeight      0.428015
		BumpOffset      0.0856031
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000926329
		Period          0.000611118
		Eccentricity    0
		Inclination     0.70941
		AscendingNode   118.384
		ArgOfPericenter 57.2319
		MeanAnomaly     -81.8218
	}
}

DwarfMoon	"4.S17"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.66673e-014
	Radius          0.516626
	InertiaMoment   0.399132

	Oblateness      0.249

	Obliquity       0.327469
	EqAscendNode    -27.6131
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.568 0.565 0.561)

	Surface
	{
		SurfStyle       0.9389
		OceanStyle      0.158051
		Randomize      (0.534, -0.835, -0.979)
		colorDistMagn   0.577064
		colorDistFreq   0.000215602
		detailScale     14.1073
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0111022
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.383465
		terraceProb     0.191894
		erosion         0
		montesMagn      0.535759
		montesFreq      3.43981
		montesSpiky     0.91166
		montesFraction  0.415592
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00042364
		hillsFraction   0.468941
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234713
		craterFreq      0.197075
		craterDensity   0.787518
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   374.952
		volcanoTemp     1342.52
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.193, 0.198, 0.224, 0.050)
		colorShelf     (0.227, 0.232, 0.258, 0.040)
		colorBeach     (0.261, 0.266, 0.292, 0.030)
		colorDesert    (0.295, 0.300, 0.331, 0.020)
		colorLowland   (0.329, 0.333, 0.365, 0.030)
		colorUpland    (0.363, 0.367, 0.398, 0.050)
		colorRock      (0.397, 0.401, 0.443, 0.020)
		colorSnow      (0.397, 0.401, 0.443, 1.000)
		BumpHeight      0.464963
		BumpOffset      0.0929926
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000930785
		Period          0.000615532
		Eccentricity    0
		Inclination     0.327469
		AscendingNode   -27.6131
		ArgOfPericenter 107.363
		MeanAnomaly     24.7002
	}
}

DwarfMoon	"4.S18"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.90198e-014
	Radius          0.565387
	InertiaMoment   0.395096

	Oblateness      0.249

	Obliquity       0.941357
	EqAscendNode    67.4775
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.595 0.591 0.585)

	Surface
	{
		SurfStyle       0.876912
		OceanStyle      0.397777
		Randomize      (0.997, -0.444, 0.495)
		colorDistMagn   0.746885
		colorDistFreq   0.00017698
		detailScale     15.4388
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0273216
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.647106
		terraceProb     0.122995
		erosion         0
		montesMagn      0.378793
		montesFreq      3.40467
		montesSpiky     0.98002
		montesFraction  0.68545
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000915057
		hillsFraction   0.866373
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.266412
		craterFreq      0.254121
		craterDensity   0.82988
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   337.415
		volcanoTemp     2010.95
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.202, 0.207, 0.234, 0.050)
		colorShelf     (0.238, 0.242, 0.269, 0.040)
		colorBeach     (0.274, 0.278, 0.304, 0.030)
		colorDesert    (0.309, 0.313, 0.345, 0.020)
		colorLowland   (0.345, 0.349, 0.380, 0.030)
		colorUpland    (0.381, 0.384, 0.415, 0.050)
		colorRock      (0.417, 0.419, 0.462, 0.020)
		colorSnow      (0.417, 0.419, 0.462, 1.000)
		BumpHeight      0.508848
		BumpOffset      0.10177
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000937941
		Period          0.000622645
		Eccentricity    0
		Inclination     0.941357
		AscendingNode   67.4775
		ArgOfPericenter 163.614
		MeanAnomaly     -73.0383
	}
}

DwarfMoon	"4.S19"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.00862e-013
	Radius          0.609193
	InertiaMoment   0.398185

	Oblateness      0.249

	Obliquity       0.0881459
	EqAscendNode    -166.473
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.743 0.662 0.563)

	Surface
	{
		SurfStyle       0.194837
		OceanStyle      0.0484254
		Randomize      (0.839, -0.721, -0.939)
		colorDistMagn   0.7616
		colorDistFreq   0.000237425
		detailScale     16.635
		colorConversion true
		snowLevel       2
		tropicLatitude  0.000345267
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.539903
		terraceProb     0.141887
		erosion         0
		montesMagn      0.570839
		montesFreq      3.13656
		montesSpiky     0.938582
		montesFraction  0.171177
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00102349
		hillsFraction   0.797691
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.287695
		craterFreq      0.261521
		craterDensity   0.881461
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   300.744
		volcanoTemp     1421.9
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.297, 0.265, 0.225, 0.000)
		colorShelf     (0.316, 0.282, 0.239, 0.000)
		colorBeach     (0.334, 0.298, 0.253, 0.000)
		colorDesert    (0.353, 0.315, 0.268, 0.000)
		colorLowland   (0.371, 0.331, 0.282, 0.000)
		colorUpland    (0.390, 0.348, 0.296, 0.000)
		colorRock      (0.408, 0.364, 0.310, 0.000)
		colorSnow      (0.427, 0.381, 0.324, 1.000)
		BumpHeight      0.548274
		BumpOffset      0.109655
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000939984
		Period          0.000624681
		Eccentricity    0
		Inclination     0.088146
		AscendingNode   -166.473
		ArgOfPericenter -157.179
		MeanAnomaly     -46.735
	}
}

DwarfMoon	"4.S20"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.45969e-013
	Radius          0.805127
	InertiaMoment   0.399267

	Oblateness      0.249

	Obliquity       -1.44935
	EqAscendNode    84.4828
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.470 0.465 0.461)

	Surface
	{
		SurfStyle       0.231697
		OceanStyle      0.161184
		Randomize      (0.086, -0.332, 0.904)
		colorDistMagn   0.24915
		colorDistFreq   0.000565776
		detailScale     21.9853
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0374434
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.490993
		terraceProb     0.369647
		erosion         0
		montesMagn      0.519699
		montesFreq      3.06307
		montesSpiky     0.911413
		montesFraction  0.48814
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00172049
		hillsFraction   0.93439
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.243257
		craterFreq      0.200459
		craterDensity   0.879964
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   330.4
		volcanoTemp     1203.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.188, 0.186, 0.184, 0.000)
		colorShelf     (0.200, 0.198, 0.196, 0.000)
		colorBeach     (0.211, 0.209, 0.207, 0.000)
		colorDesert    (0.223, 0.221, 0.219, 0.000)
		colorLowland   (0.235, 0.233, 0.230, 0.000)
		colorUpland    (0.247, 0.244, 0.242, 0.000)
		colorRock      (0.258, 0.256, 0.254, 0.000)
		colorSnow      (0.270, 0.268, 0.265, 1.000)
		BumpHeight      0.724614
		BumpOffset      0.144923
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000951929
		Period          0.000636625
		Eccentricity    0
		Inclination     -1.44935
		AscendingNode   84.4828
		ArgOfPericenter 125.849
		MeanAnomaly     -93.1507
	}
}

DwarfMoon	"4.S21"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.09612e-013
	Radius          0.857635
	InertiaMoment   0.396296

	Oblateness      0.249

	Obliquity       -0.059868
	EqAscendNode    31.574
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.638 0.504 0.364)

	Surface
	{
		SurfStyle       0.487028
		OceanStyle      0.928984
		Randomize      (-0.991, 0.858, 0.658)
		colorDistMagn   0.529499
		colorDistFreq   0.000349563
		detailScale     23.4191
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00201323
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.329993
		terraceProb     0.26695
		erosion         0
		montesMagn      0.51939
		montesFreq      2.59872
		montesSpiky     0.867144
		montesFraction  0.355314
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00136793
		hillsFraction   0.759097
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.233577
		craterFreq      0.256668
		craterDensity   0.843747
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   293.697
		volcanoTemp     1316.66
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.255, 0.202, 0.146, 0.000)
		colorShelf     (0.271, 0.214, 0.155, 0.000)
		colorBeach     (0.287, 0.227, 0.164, 0.000)
		colorDesert    (0.303, 0.239, 0.173, 0.000)
		colorLowland   (0.319, 0.252, 0.182, 0.000)
		colorUpland    (0.335, 0.265, 0.191, 0.000)
		colorRock      (0.351, 0.277, 0.200, 0.000)
		colorSnow      (0.367, 0.290, 0.209, 1.000)
		BumpHeight      0.771871
		BumpOffset      0.154374
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000960218
		Period          0.000644959
		Eccentricity    0
		Inclination     -0.059868
		AscendingNode   31.574
		ArgOfPericenter -30.4537
		MeanAnomaly     96.1571
	}
}

DwarfMoon	"4.S22"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.9918e-013
	Radius          0.927165
	InertiaMoment   0.398366

	Oblateness      0.249

	Obliquity       -0.512191
	EqAscendNode    79.2436
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.576 0.573 0.570)

	Surface
	{
		SurfStyle       0.572395
		OceanStyle      0.294189
		Randomize      (0.647, 0.349, 0.773)
		colorDistMagn   0.96613
		colorDistFreq   0.000501073
		detailScale     25.3178
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0137715
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.562618
		terraceProb     0.123171
		erosion         0
		montesMagn      0.242093
		montesFreq      2.92612
		montesSpiky     0.861845
		montesFraction  0.806591
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00179046
		hillsFraction   0.474924
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.272012
		craterFreq      0.179677
		craterDensity   1.06305
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   265.764
		volcanoTemp     1334.26
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.225, 0.195, 0.160, 0.000)
		colorShelf     (0.230, 0.201, 0.182, 0.000)
		colorBeach     (0.271, 0.235, 0.217, 0.000)
		colorDesert    (0.294, 0.252, 0.211, 0.000)
		colorLowland   (0.323, 0.270, 0.239, 0.000)
		colorUpland    (0.357, 0.327, 0.291, 0.000)
		colorRock      (0.386, 0.356, 0.314, 0.000)
		colorSnow      (0.420, 0.378, 0.331, 1.000)
		BumpHeight      0.834448
		BumpOffset      0.16689
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000968254
		Period          0.000653072
		Eccentricity    0
		Inclination     -0.512191
		AscendingNode   79.2436
		ArgOfPericenter 32.5131
		MeanAnomaly     -167.136
	}
}

DwarfMoon	"4.S23"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.25082e-013
	Radius          0.99408
	InertiaMoment   0.399399

	Oblateness      0.249

	Obliquity       -1.4133
	EqAscendNode    37.4111
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.632 0.630 0.625)

	Surface
	{
		SurfStyle       0.761358
		OceanStyle      0.151059
		Randomize      (0.818, -0.188, -0.227)
		colorDistMagn   0.171559
		colorDistFreq   0.00084324
		detailScale     27.145
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0467107
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.470871
		terraceProb     0.474165
		erosion         0
		montesMagn      0.373556
		montesFreq      2.55113
		montesSpiky     0.861454
		montesFraction  0.294835
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00191999
		hillsFraction   0.632218
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.22569
		craterFreq      0.275827
		craterDensity   0.785958
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   239.051
		volcanoTemp     1517.83
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.246, 0.214, 0.175, 0.000)
		colorShelf     (0.253, 0.220, 0.200, 0.000)
		colorBeach     (0.297, 0.258, 0.238, 0.000)
		colorDesert    (0.322, 0.277, 0.231, 0.000)
		colorLowland   (0.354, 0.296, 0.263, 0.000)
		colorUpland    (0.392, 0.359, 0.319, 0.000)
		colorRock      (0.423, 0.390, 0.344, 0.000)
		colorSnow      (0.461, 0.416, 0.363, 1.000)
		BumpHeight      0.894672
		BumpOffset      0.178934
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000979039
		Period          0.000664014
		Eccentricity    0
		Inclination     -1.4133
		AscendingNode   37.4112
		ArgOfPericenter 38.8152
		MeanAnomaly     159.734
	}
}

DwarfMoon	"4.S24"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.02058e-013
	Radius          1.30837
	InertiaMoment   0.396838

	Oblateness      0.249

	Obliquity       0.317273
	EqAscendNode    143.223
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.571 0.565 0.561)

	Surface
	{
		SurfStyle       0.4949
		OceanStyle      0.08922
		Randomize      (0.399, -0.098, -0.701)
		colorDistMagn   0.892003
		colorDistFreq   0.000953211
		detailScale     35.7272
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00348702
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.342956
		terraceProb     0.286672
		erosion         0
		montesMagn      0.452058
		montesFreq      2.45007
		montesSpiky     0.931005
		montesFraction  0.665409
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0026139
		hillsFraction   0.538729
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.271162
		craterFreq      0.235326
		craterDensity   0.79767
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   264.373
		volcanoTemp     1572.56
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.228, 0.226, 0.224, 0.000)
		colorShelf     (0.243, 0.240, 0.239, 0.000)
		colorBeach     (0.257, 0.254, 0.253, 0.000)
		colorDesert    (0.271, 0.269, 0.267, 0.000)
		colorLowland   (0.286, 0.283, 0.281, 0.000)
		colorUpland    (0.300, 0.297, 0.295, 0.000)
		colorRock      (0.314, 0.311, 0.309, 0.000)
		colorSnow      (0.328, 0.325, 0.323, 1.000)
		BumpHeight      1.17753
		BumpOffset      0.235506
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.000987403
		Period          0.000672541
		Eccentricity    0
		Inclination     0.317273
		AscendingNode   143.223
		ArgOfPericenter 167.982
		MeanAnomaly     -119.322
	}
}

DwarfMoon	"4.S25"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.51142e-013
	Radius          1.37701
	InertiaMoment   0.398535

	Oblateness      0.249

	Obliquity       0.761106
	EqAscendNode    -4.92675
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.597 0.594 0.593)

	Surface
	{
		SurfStyle       0.505818
		OceanStyle      0.974015
		Randomize      (-0.984, -0.929, -0.136)
		colorDistMagn   0.970489
		colorDistFreq   0.000726571
		detailScale     37.6015
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0265406
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.445471
		terraceProb     0.328135
		erosion         0
		montesMagn      0.51231
		montesFreq      3.85347
		montesSpiky     0.880361
		montesFraction  0.674128
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00382377
		hillsFraction   0.762307
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.226015
		craterFreq      0.182194
		craterDensity   0.949745
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   234.014
		volcanoTemp     1478.26
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.233, 0.202, 0.166, 0.000)
		colorShelf     (0.239, 0.208, 0.190, 0.000)
		colorBeach     (0.281, 0.244, 0.225, 0.000)
		colorDesert    (0.305, 0.261, 0.219, 0.000)
		colorLowland   (0.334, 0.279, 0.249, 0.000)
		colorUpland    (0.370, 0.339, 0.302, 0.000)
		colorRock      (0.400, 0.368, 0.326, 0.000)
		colorSnow      (0.436, 0.392, 0.344, 1.000)
		BumpHeight      1.23931
		BumpOffset      0.247861
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00100039
		Period          0.000685852
		Eccentricity    0
		Inclination     0.761106
		AscendingNode   -4.92674
		ArgOfPericenter -69.425
		MeanAnomaly     -165.465
	}
}

DwarfMoon	"4.S26"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.20258e-012
	Radius          1.48253
	InertiaMoment   0.399529

	Oblateness      0.249

	Obliquity       0.53303
	EqAscendNode    152.502
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.627 0.624 0.621)

	Surface
	{
		SurfStyle       0.0133073
		OceanStyle      0.585762
		Randomize      (0.117, 0.689, -0.008)
		colorDistMagn   0.402992
		colorDistFreq   0.00167518
		detailScale     40.483
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00442156
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.358017
		terraceProb     0.205368
		erosion         0
		montesMagn      0.444846
		montesFreq      3.75211
		montesSpiky     0.942559
		montesFraction  0.658459
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00643947
		hillsFraction   0.606568
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23077
		craterFreq      0.202041
		craterDensity   0.843089
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   211.96
		volcanoTemp     1448.79
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.251, 0.250, 0.248, 0.000)
		colorShelf     (0.266, 0.265, 0.264, 0.000)
		colorBeach     (0.282, 0.281, 0.279, 0.000)
		colorDesert    (0.298, 0.296, 0.295, 0.000)
		colorLowland   (0.313, 0.312, 0.310, 0.000)
		colorUpland    (0.329, 0.328, 0.326, 0.000)
		colorRock      (0.345, 0.343, 0.342, 0.000)
		colorSnow      (0.360, 0.359, 0.357, 1.000)
		BumpHeight      1.33428
		BumpOffset      0.266856
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00101497
		Period          0.0007009
		Eccentricity    0
		Inclination     0.53303
		AscendingNode   152.502
		ArgOfPericenter -29.4552
		MeanAnomaly     -54.7199
	}
}

DwarfMoon	"4.S27"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.70026e-012
	Radius          1.5915
	InertiaMoment   0.397215

	Oblateness      0.249

	Obliquity       -0.140025
	EqAscendNode    145.415
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.433 0.430 0.425)

	Surface
	{
		SurfStyle       0.251971
		OceanStyle      0.208438
		Randomize      (-0.067, -0.673, -0.103)
		colorDistMagn   0.0900087
		colorDistFreq   0.00134471
		detailScale     43.4586
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00146484
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.343426
		terraceProb     0.340101
		erosion         0
		montesMagn      0.324914
		montesFreq      2.70186
		montesSpiky     0.983785
		montesFraction  0.586727
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00640506
		hillsFraction   0.467104
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.252884
		craterFreq      0.219112
		craterDensity   0.99171
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   191.362
		volcanoTemp     1470.7
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.173, 0.172, 0.170, 0.000)
		colorShelf     (0.184, 0.183, 0.181, 0.000)
		colorBeach     (0.195, 0.194, 0.191, 0.000)
		colorDesert    (0.206, 0.204, 0.202, 0.000)
		colorLowland   (0.216, 0.215, 0.213, 0.000)
		colorUpland    (0.227, 0.226, 0.223, 0.000)
		colorRock      (0.238, 0.237, 0.234, 0.000)
		colorSnow      (0.249, 0.247, 0.245, 1.000)
		BumpHeight      1.43235
		BumpOffset      0.28647
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00102876
		Period          0.000715238
		Eccentricity    0
		Inclination     -0.140025
		AscendingNode   145.415
		ArgOfPericenter 63.412
		MeanAnomaly     -89.7227
	}
}

DwarfMoon	"4.S28"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.40855e-012
	Radius          2.11244
	InertiaMoment   0.398694

	Oblateness      0.249

	Obliquity       0.259037
	EqAscendNode    170.4
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.554 0.432 0.369)

	Surface
	{
		SurfStyle       0.910197
		OceanStyle      0.830091
		Randomize      (-0.853, -0.269, -0.985)
		colorDistMagn   0.575664
		colorDistFreq   0.000303731
		detailScale     57.6836
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00077204
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.489294
		terraceProb     0.676131
		erosion         0
		montesMagn      0.524981
		montesFreq      1.87262
		montesSpiky     0.905706
		montesFraction  0.49306
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0131322
		hillsFraction   0.828412
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.265097
		craterFreq      0.185355
		craterDensity   0.907187
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   213.409
		volcanoTemp     1478.86
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.188, 0.151, 0.148, 0.050)
		colorShelf     (0.222, 0.177, 0.170, 0.040)
		colorBeach     (0.255, 0.203, 0.192, 0.030)
		colorDesert    (0.288, 0.229, 0.218, 0.020)
		colorLowland   (0.321, 0.255, 0.240, 0.030)
		colorUpland    (0.355, 0.281, 0.262, 0.050)
		colorRock      (0.388, 0.307, 0.292, 0.020)
		colorSnow      (0.388, 0.307, 0.292, 1.000)
		BumpHeight      1.90119
		BumpOffset      0.380239
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00103381
		Period          0.000720504
		Eccentricity    0
		Inclination     0.259037
		AscendingNode   170.4
		ArgOfPericenter 156.889
		MeanAnomaly     34.295
	}
}

DwarfMoon	"4.S29"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.42301e-012
	Radius          2.20457
	InertiaMoment   0.399656

	Oblateness      0.249

	Obliquity       -0.172721
	EqAscendNode    -120.015
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.726 0.721 0.718)

	Surface
	{
		SurfStyle       0.771027
		OceanStyle      0.162507
		Randomize      (-0.490, -0.259, -0.288)
		colorDistMagn   0.494016
		colorDistFreq   0.0034242
		detailScale     60.1995
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00300996
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.557536
		terraceProb     0.200285
		erosion         0
		montesMagn      0.494205
		montesFreq      3.08642
		montesSpiky     0.934225
		montesFraction  0.71248
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0126227
		hillsFraction   0.855452
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.255604
		craterFreq      0.231387
		craterDensity   0.878149
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   186.821
		volcanoTemp     1290.33
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.283, 0.245, 0.201, 0.000)
		colorShelf     (0.290, 0.252, 0.230, 0.000)
		colorBeach     (0.341, 0.295, 0.273, 0.000)
		colorDesert    (0.370, 0.317, 0.266, 0.000)
		colorLowland   (0.406, 0.339, 0.301, 0.000)
		colorUpland    (0.450, 0.411, 0.366, 0.000)
		colorRock      (0.486, 0.447, 0.395, 0.000)
		colorSnow      (0.530, 0.476, 0.416, 1.000)
		BumpHeight      1.98412
		BumpOffset      0.396823
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00104141
		Period          0.000728465
		Eccentricity    0
		Inclination     -0.172721
		AscendingNode   -120.015
		ArgOfPericenter 33.6531
		MeanAnomaly     -125.528
	}
}

DwarfMoon	"4.S30"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.88744e-012
	Radius          2.3792
	InertiaMoment   0.397512

	Oblateness      0.249

	Obliquity       -1.15696
	EqAscendNode    -139.539
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.470 0.464 0.461)

	Surface
	{
		SurfStyle       0.0917549
		OceanStyle      0.502568
		Randomize      (0.128, 0.121, -0.618)
		colorDistMagn   0.857708
		colorDistFreq   0.00341105
		detailScale     64.968
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0139648
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.525457
		terraceProb     0.13845
		erosion         0
		montesMagn      0.572147
		montesFreq      3.30745
		montesSpiky     0.909724
		montesFraction  0.385262
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0127671
		hillsFraction   0.787785
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.223048
		craterFreq      0.265835
		craterDensity   0.901837
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   168.731
		volcanoTemp     1387.12
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.188, 0.185, 0.184, 0.000)
		colorShelf     (0.200, 0.197, 0.196, 0.000)
		colorBeach     (0.212, 0.209, 0.207, 0.000)
		colorDesert    (0.223, 0.220, 0.219, 0.000)
		colorLowland   (0.235, 0.232, 0.230, 0.000)
		colorUpland    (0.247, 0.243, 0.242, 0.000)
		colorRock      (0.259, 0.255, 0.253, 0.000)
		colorSnow      (0.270, 0.267, 0.265, 1.000)
		BumpHeight      2.14128
		BumpOffset      0.428256
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.001054
		Period          0.000741718
		Eccentricity    0
		Inclination     -1.15696
		AscendingNode   -139.539
		ArgOfPericenter -112.487
		MeanAnomaly     -146.589
	}
}

DwarfMoon	"4.S31"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.02167e-012
	Radius          2.57269
	InertiaMoment   0.398845

	Oblateness      0.249

	Obliquity       1.34483
	EqAscendNode    36.4005
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.671 0.632 0.562)

	Surface
	{
		SurfStyle       0.399685
		OceanStyle      0.986381
		Randomize      (0.274, -0.517, -0.284)
		colorDistMagn   0.44618
		colorDistFreq   0.000888955
		detailScale     70.2517
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0445792
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.620108
		terraceProb     0.353747
		erosion         0
		montesMagn      0.464455
		montesFreq      3.47074
		montesSpiky     0.898459
		montesFraction  0.17573
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0181934
		hillsFraction   0.681443
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.282612
		craterFreq      0.242149
		craterDensity   0.737957
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   152.221
		volcanoTemp     1364.43
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.269, 0.253, 0.225, 0.000)
		colorShelf     (0.285, 0.268, 0.239, 0.000)
		colorBeach     (0.302, 0.284, 0.253, 0.000)
		colorDesert    (0.319, 0.300, 0.267, 0.000)
		colorLowland   (0.336, 0.316, 0.281, 0.000)
		colorUpland    (0.352, 0.332, 0.295, 0.000)
		colorRock      (0.369, 0.347, 0.309, 0.000)
		colorSnow      (0.386, 0.363, 0.323, 1.000)
		BumpHeight      2.31542
		BumpOffset      0.463085
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00106733
		Period          0.000755834
		Eccentricity    0
		Inclination     1.34483
		AscendingNode   36.4005
		ArgOfPericenter 67.2814
		MeanAnomaly     128.968
	}
}

DwarfMoon	"4.S32"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.01679e-011
	Radius          3.49844
	InertiaMoment   0.399783

	Oblateness      0.249

	Obliquity       0.304643
	EqAscendNode    -149.837
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.529 0.524 0.520)

	Surface
	{
		SurfStyle       0.0777333
		OceanStyle      0.290072
		Randomize      (-0.947, 0.976, -0.289)
		colorDistMagn   0.613332
		colorDistFreq   0.00584167
		detailScale     95.5306
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00276213
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.736502
		terraceProb     0.283962
		erosion         0
		montesMagn      0.522532
		montesFreq      3.36225
		montesSpiky     0.811671
		montesFraction  0.319141
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0334565
		hillsFraction   0.889888
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.269369
		craterFreq      0.276116
		craterDensity   0.838225
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   172.014
		volcanoTemp     1392.9
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.212, 0.210, 0.208, 0.000)
		colorShelf     (0.225, 0.223, 0.221, 0.000)
		colorBeach     (0.238, 0.236, 0.234, 0.000)
		colorDesert    (0.251, 0.249, 0.247, 0.000)
		colorLowland   (0.265, 0.262, 0.260, 0.000)
		colorUpland    (0.278, 0.275, 0.273, 0.000)
		colorRock      (0.291, 0.288, 0.286, 0.000)
		colorSnow      (0.304, 0.302, 0.299, 1.000)
		BumpHeight      3.14859
		BumpOffset      0.629718
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00107852
		Period          0.000767755
		Eccentricity    0
		Inclination     0.304643
		AscendingNode   -149.837
		ArgOfPericenter 25.0123
		MeanAnomaly     -34.1895
	}
}

DwarfMoon	"4.S33"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.48697e-011
	Radius          3.62297
	InertiaMoment   0.397763

	Oblateness      0.249

	Obliquity       0.435194
	EqAscendNode    96.5553
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.489 0.432 0.364)

	Surface
	{
		SurfStyle       0.955354
		OceanStyle      0.326855
		Randomize      (-0.044, -0.075, -0.533)
		colorDistMagn   0.174234
		colorDistFreq   0.00674752
		detailScale     98.9313
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0101074
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.413159
		terraceProb     0.250039
		erosion         0
		montesMagn      0.468369
		montesFreq      3.71344
		montesSpiky     0.826695
		montesFraction  0.826027
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.036099
		hillsFraction   0.524527
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.21238
		craterFreq      0.276904
		craterDensity   0.845897
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   147.306
		volcanoTemp     1231.53
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.166, 0.151, 0.146, 0.050)
		colorShelf     (0.196, 0.177, 0.168, 0.040)
		colorBeach     (0.225, 0.203, 0.189, 0.030)
		colorDesert    (0.254, 0.229, 0.215, 0.020)
		colorLowland   (0.284, 0.255, 0.237, 0.030)
		colorUpland    (0.313, 0.281, 0.259, 0.050)
		colorRock      (0.342, 0.307, 0.288, 0.020)
		colorSnow      (0.342, 0.307, 0.288, 1.000)
		BumpHeight      3.26067
		BumpOffset      0.652135
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00108795
		Period          0.000777838
		Eccentricity    0
		Inclination     0.435194
		AscendingNode   96.5553
		ArgOfPericenter 4.94278
		MeanAnomaly     29.2544
	}
}

DwarfMoon	"4.S34"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.20117e-011
	Radius          3.9512
	InertiaMoment   0.398989

	Oblateness      0.249

	Obliquity       0.230224
	EqAscendNode    39.3199
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.665 0.661 0.658)

	Surface
	{
		SurfStyle       0.729892
		OceanStyle      0.538354
		Randomize      (0.855, -0.925, -0.126)
		colorDistMagn   0.683294
		colorDistFreq   0.0100682
		detailScale     107.894
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00756437
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.424414
		terraceProb     0.22807
		erosion         0
		montesMagn      0.429985
		montesFreq      2.30386
		montesSpiky     0.859445
		montesFraction  0.602441
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0408415
		hillsFraction   0.565354
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.244573
		craterFreq      0.242627
		craterDensity   0.774507
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   132.041
		volcanoTemp     1622.9
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.260, 0.225, 0.184, 0.000)
		colorShelf     (0.266, 0.231, 0.211, 0.000)
		colorBeach     (0.313, 0.271, 0.250, 0.000)
		colorDesert    (0.339, 0.291, 0.244, 0.000)
		colorLowland   (0.373, 0.310, 0.277, 0.000)
		colorUpland    (0.413, 0.377, 0.336, 0.000)
		colorRock      (0.446, 0.410, 0.362, 0.000)
		colorSnow      (0.486, 0.436, 0.382, 1.000)
		BumpHeight      3.55608
		BumpOffset      0.711216
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00109465
		Period          0.00078504
		Eccentricity    0
		Inclination     0.230224
		AscendingNode   39.3199
		ArgOfPericenter 1.11885
		MeanAnomaly     -95.3072
	}
}

DwarfMoon	"4.S35"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.30739e-011
	Radius          4.34235
	InertiaMoment   0.399908

	Oblateness      0.249

	Obliquity       1.34359
	EqAscendNode    16.8419
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.776 0.773 0.770)

	Surface
	{
		SurfStyle       0.888808
		OceanStyle      0.154687
		Randomize      (-0.257, 0.484, 0.001)
		colorDistMagn   0.814422
		colorDistFreq   0.0103774
		detailScale     118.575
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0463781
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.759665
		terraceProb     0.291479
		erosion         0
		montesMagn      0.655491
		montesFreq      2.99615
		montesSpiky     0.838863
		montesFraction  0.826597
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0408773
		hillsFraction   0.50627
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227383
		craterFreq      0.217655
		craterDensity   0.878211
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   118.383
		volcanoTemp     1552.54
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.264, 0.270, 0.308, 0.050)
		colorShelf     (0.310, 0.317, 0.354, 0.040)
		colorBeach     (0.357, 0.363, 0.400, 0.030)
		colorDesert    (0.404, 0.410, 0.454, 0.020)
		colorLowland   (0.450, 0.456, 0.500, 0.030)
		colorUpland    (0.497, 0.502, 0.546, 0.050)
		colorRock      (0.543, 0.549, 0.608, 0.020)
		colorSnow      (0.543, 0.549, 0.608, 1.000)
		BumpHeight      3.90812
		BumpOffset      0.781624
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00110055
		Period          0.000791397
		Eccentricity    0
		Inclination     1.34359
		AscendingNode   16.8419
		ArgOfPericenter -152.763
		MeanAnomaly     -146.565
	}
}

DwarfMoon	"4.S36"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.06144e-011
	Radius          6.27024
	InertiaMoment   0.397983

	Oblateness      0.249

	Obliquity       -0.543541
	EqAscendNode    117.317
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.782 0.781 0.779)

	Surface
	{
		SurfStyle       0.679004
		OceanStyle      0.85289
		Randomize      (-0.572, -0.098, 0.332)
		colorDistMagn   0.310748
		colorDistFreq   0.0172197
		detailScale     171.219
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00986872
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.651489
		terraceProb     0.589436
		erosion         0
		montesMagn      0.45525
		montesFreq      1.89153
		montesSpiky     0.837841
		montesFraction  0.566518
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0596711
		hillsFraction   0.794664
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.195131
		craterFreq      0.261714
		craterDensity   0.867766
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   138.182
		volcanoTemp     1311.79
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.305, 0.265, 0.218, 0.000)
		colorShelf     (0.313, 0.273, 0.249, 0.000)
		colorBeach     (0.368, 0.320, 0.296, 0.000)
		colorDesert    (0.399, 0.344, 0.288, 0.000)
		colorLowland   (0.438, 0.367, 0.327, 0.000)
		colorUpland    (0.485, 0.445, 0.397, 0.000)
		colorRock      (0.524, 0.484, 0.429, 0.000)
		colorSnow      (0.571, 0.515, 0.452, 1.000)
		BumpHeight      5.64322
		BumpOffset      1.12864
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00110937
		Period          0.000800925
		Eccentricity    0
		Inclination     -0.543541
		AscendingNode   117.317
		ArgOfPericenter 31.3804
		MeanAnomaly     -89.4476
	}
}

DwarfMoon	"4.S37"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.92291e-011
	Radius          6.37698
	InertiaMoment   0.399129

	Oblateness      0.249

	Obliquity       1.22448
	EqAscendNode    -92.2576
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.759 0.718 0.685)

	Surface
	{
		SurfStyle       0.737396
		OceanStyle      0.522556
		Randomize      (-0.983, -0.392, 0.265)
		colorDistMagn   0.979785
		colorDistFreq   0.0251816
		detailScale     174.134
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0296174
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.307473
		terraceProb     0.548044
		erosion         0
		montesMagn      0.492956
		montesFreq      3.41127
		montesSpiky     0.978903
		montesFraction  0.617662
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0940834
		hillsFraction   0.696526
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.243709
		craterFreq      0.252229
		craterDensity   0.754454
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   112.326
		volcanoTemp     1616.52
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.296, 0.244, 0.192, 0.000)
		colorShelf     (0.303, 0.251, 0.219, 0.000)
		colorBeach     (0.357, 0.294, 0.260, 0.000)
		colorDesert    (0.387, 0.316, 0.254, 0.000)
		colorLowland   (0.425, 0.337, 0.288, 0.000)
		colorUpland    (0.470, 0.409, 0.350, 0.000)
		colorRock      (0.508, 0.445, 0.377, 0.000)
		colorSnow      (0.554, 0.474, 0.398, 1.000)
		BumpHeight      5.73928
		BumpOffset      1.14786
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00111517
		Period          0.000807217
		Eccentricity    0
		Inclination     1.22448
		AscendingNode   -92.2576
		ArgOfPericenter -12.7911
		MeanAnomaly     133.882
	}
}

DwarfMoon	"4.S38"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.2757e-010
	Radius          7.1377
	InertiaMoment   0.395039

	Oblateness      0.249

	Obliquity       1.18776
	EqAscendNode    152.635
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.435 0.432 0.429)

	Surface
	{
		SurfStyle       0.46226
		OceanStyle      0.989669
		Randomize      (-0.453, 0.160, -0.714)
		colorDistMagn   0.40306
		colorDistFreq   0.0081387
		detailScale     194.907
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00980814
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.622395
		terraceProb     0.355657
		erosion         0
		montesMagn      0.507802
		montesFreq      3.89975
		montesSpiky     0.942202
		montesFraction  0.601011
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.132399
		hillsFraction   0.727789
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.252876
		craterFreq      0.221157
		craterDensity   0.835823
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   99.0807
		volcanoTemp     1453.66
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.174, 0.173, 0.171, 0.000)
		colorShelf     (0.185, 0.183, 0.182, 0.000)
		colorBeach     (0.196, 0.194, 0.193, 0.000)
		colorDesert    (0.207, 0.205, 0.204, 0.000)
		colorLowland   (0.217, 0.216, 0.214, 0.000)
		colorUpland    (0.228, 0.227, 0.225, 0.000)
		colorRock      (0.239, 0.237, 0.236, 0.000)
		colorSnow      (0.250, 0.248, 0.246, 1.000)
		BumpHeight      6.42393
		BumpOffset      1.28479
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00112107
		Period          0.000813625
		Eccentricity    0
		Inclination     1.18776
		AscendingNode   152.635
		ArgOfPericenter 170.952
		MeanAnomaly     95.1954
	}
}

DwarfMoon	"4.S39"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.12888e-010
	Radius          8.12967
	InertiaMoment   0.398181

	Oblateness      0.249

	Obliquity       1.40385
	EqAscendNode    -168.891
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.626 0.429 0.360)

	Surface
	{
		SurfStyle       0.146021
		OceanStyle      0.164882
		Randomize      (0.577, 0.373, 0.436)
		colorDistMagn   0.148106
		colorDistFreq   0.0266729
		detailScale     221.994
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00474662
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.282209
		terraceProb     0.177961
		erosion         0
		montesMagn      0.479055
		montesFreq      2.38974
		montesSpiky     0.970239
		montesFraction  0.6598
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.190701
		hillsFraction   0.562624
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.196598
		craterFreq      0.177484
		craterDensity   0.845104
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   87.3581
		volcanoTemp     1303.4
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.250, 0.172, 0.144, 0.000)
		colorShelf     (0.266, 0.182, 0.153, 0.000)
		colorBeach     (0.282, 0.193, 0.162, 0.000)
		colorDesert    (0.297, 0.204, 0.171, 0.000)
		colorLowland   (0.313, 0.215, 0.180, 0.000)
		colorUpland    (0.328, 0.225, 0.189, 0.000)
		colorRock      (0.344, 0.236, 0.198, 0.000)
		colorSnow      (0.360, 0.247, 0.207, 1.000)
		BumpHeight      7.3167
		BumpOffset      1.46334
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00113124
		Period          0.000824722
		Eccentricity    0
		Inclination     1.40385
		AscendingNode   -168.891
		ArgOfPericenter -47.9929
		MeanAnomaly     -172.674
	}
}

DwarfMoon	"4.S40"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.72138e-010
	Radius          9.06119
	InertiaMoment   0.399264

	Oblateness      0.249

	Obliquity       0.988942
	EqAscendNode    -101.113
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.439 0.436 0.429)

	Surface
	{
		SurfStyle       0.44249
		OceanStyle      0.651756
		Randomize      (0.693, -0.453, -0.679)
		colorDistMagn   0.719607
		colorDistFreq   0.00754035
		detailScale     247.431
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0219279
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.603428
		terraceProb     0.43523
		erosion         0
		montesMagn      0.52206
		montesFreq      2.9978
		montesSpiky     0.929904
		montesFraction  0.491706
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.116347
		hillsFraction   0.580564
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23904
		craterFreq      0.177655
		craterDensity   0.740045
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   73.6444
		volcanoTemp     1166.69
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.176, 0.174, 0.172, 0.000)
		colorShelf     (0.187, 0.185, 0.182, 0.000)
		colorBeach     (0.198, 0.196, 0.193, 0.000)
		colorDesert    (0.209, 0.207, 0.204, 0.000)
		colorLowland   (0.220, 0.218, 0.215, 0.000)
		colorUpland    (0.231, 0.229, 0.225, 0.000)
		colorRock      (0.242, 0.240, 0.236, 0.000)
		colorSnow      (0.253, 0.251, 0.247, 1.000)
		BumpHeight      8.15507
		BumpOffset      1.63101
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00114103
		Period          0.00083545
		Eccentricity    0
		Inclination     0.988942
		AscendingNode   -101.113
		ArgOfPericenter 143.583
		MeanAnomaly     85.1625
	}
}

DwarfMoon	"4.S41"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.92216e-010
	Radius          13.2459
	InertiaMoment   0.396281

	Oblateness      0.249

	Obliquity       0.00642386
	EqAscendNode    79.7527
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.467 0.461 0.458)

	Surface
	{
		SurfStyle       0.778752
		OceanStyle      0.0744139
		Randomize      (-0.598, 0.665, 0.841)
		colorDistMagn   0.424182
		colorDistFreq   0.081212
		detailScale     361.701
		colorConversion true
		snowLevel       2
		tropicLatitude  0
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.706401
		terraceProb     0.518839
		erosion         0
		montesMagn      0.623167
		montesFreq      3.29015
		montesSpiky     0.784791
		montesFraction  0.576642
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.439009
		hillsFraction   0.539311
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.217809
		craterFreq      0.255361
		craterDensity   0.99921
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   78.9344
		volcanoTemp     1466.25
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.182, 0.157, 0.128, 0.000)
		colorShelf     (0.187, 0.161, 0.146, 0.000)
		colorBeach     (0.219, 0.189, 0.174, 0.000)
		colorDesert    (0.238, 0.203, 0.169, 0.000)
		colorLowland   (0.261, 0.216, 0.192, 0.000)
		colorUpland    (0.289, 0.263, 0.233, 0.000)
		colorRock      (0.313, 0.286, 0.252, 0.000)
		colorSnow      (0.341, 0.304, 0.265, 1.000)
		BumpHeight      11.9213
		BumpOffset      2.38426
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00115234
		Period          0.000847904
		Eccentricity    0
		Inclination     0.00642386
		AscendingNode   79.7527
		ArgOfPericenter -11.4964
		MeanAnomaly     110.838
	}
}

DwarfMoon	"4.S42"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.40478e-009
	Radius          15.9716
	InertiaMoment   0.398362

	Oblateness      0.249

	Obliquity       -1.17999
	EqAscendNode    -143.508
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.519 0.515 0.508)

	Surface
	{
		SurfStyle       0.9605
		OceanStyle      0.245958
		Randomize      (0.372, -0.681, 0.814)
		colorDistMagn   0.62784
		colorDistFreq   0.192575
		detailScale     436.132
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0128953
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.329451
		terraceProb     0.105701
		erosion         0
		montesMagn      0.555664
		montesFreq      3.48225
		montesSpiky     0.897023
		montesFraction  0.230394
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.579943
		hillsFraction   0.629534
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.205921
		craterFreq      0.178526
		craterDensity   0.901917
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   66.8116
		volcanoTemp     1433.63
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.176, 0.180, 0.203, 0.050)
		colorShelf     (0.207, 0.211, 0.234, 0.040)
		colorBeach     (0.239, 0.242, 0.264, 0.030)
		colorDesert    (0.270, 0.273, 0.300, 0.020)
		colorLowland   (0.301, 0.304, 0.330, 0.030)
		colorUpland    (0.332, 0.335, 0.361, 0.050)
		colorRock      (0.363, 0.366, 0.401, 0.020)
		colorSnow      (0.363, 0.366, 0.401, 1.000)
		BumpHeight      14.3745
		BumpOffset      2.8749
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00116661
		Period          0.000863703
		Eccentricity    0
		Inclination     -1.17999
		AscendingNode   -143.508
		ArgOfPericenter -28.8963
		MeanAnomaly     110.694
	}
}

DwarfMoon	"4.S43"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.24824e-016
	Radius          0.0941657
	InertiaMoment   0.399397

	Oblateness      0.249

	Obliquity       0.216895
	EqAscendNode    -91.9545
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.662 0.558 0.410)

	Surface
	{
		SurfStyle       0.913684
		OceanStyle      0.79691
		Randomize      (-0.443, -0.822, 0.257)
		colorDistMagn   0.180039
		colorDistFreq   7.0262e-006
		detailScale     2.57135
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00525893
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.423005
		terraceProb     0.143761
		erosion         0
		montesMagn      0.450648
		montesFreq      2.91048
		montesSpiky     0.913822
		montesFraction  0.620394
		dunesFraction   0
		hillsMagn       0
		hillsFreq       1.75478e-005
		hillsFraction   0.443351
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.222737
		craterFreq      0.243762
		craterDensity   0.948511
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   819.171
		volcanoTemp     1495.61
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.225, 0.195, 0.164, 0.050)
		colorShelf     (0.265, 0.229, 0.189, 0.040)
		colorBeach     (0.305, 0.262, 0.213, 0.030)
		colorDesert    (0.344, 0.296, 0.242, 0.020)
		colorLowland   (0.384, 0.329, 0.267, 0.030)
		colorUpland    (0.424, 0.363, 0.291, 0.050)
		colorRock      (0.464, 0.396, 0.324, 0.020)
		colorSnow      (0.464, 0.396, 0.324, 1.000)
		BumpHeight      0.0847492
		BumpOffset      0.0169498
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00117857
		Period          0.000877026
		Eccentricity    0
		Inclination     0.216895
		AscendingNode   -91.9545
		ArgOfPericenter -159.135
		MeanAnomaly     64.5313
	}
}

DwarfMoon	"4.S44"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.44179e-016
	Radius          0.11693
	InertiaMoment   0.396828

	Oblateness      0.249

	Obliquity       -1.12735
	EqAscendNode    -49.4278
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.668 0.665 0.662)

	Surface
	{
		SurfStyle       0.184491
		OceanStyle      0.31894
		Randomize      (-0.696, 0.565, 0.454)
		colorDistMagn   0.290134
		colorDistFreq   1.06401e-005
		detailScale     3.19298
		colorConversion true
		snowLevel       2
		tropicLatitude  0.035739
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.693828
		terraceProb     0.346609
		erosion         0
		montesMagn      0.601174
		montesFreq      4.44899
		montesSpiky     0.875281
		montesFraction  0.453245
		dunesFraction   0
		hillsMagn       0
		hillsFreq       3.32595e-005
		hillsFraction   0.539139
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.240369
		craterFreq      0.20068
		craterDensity   0.879139
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   672.039
		volcanoTemp     1080.58
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.267, 0.266, 0.265, 0.000)
		colorShelf     (0.284, 0.283, 0.281, 0.000)
		colorBeach     (0.301, 0.299, 0.298, 0.000)
		colorDesert    (0.317, 0.316, 0.314, 0.000)
		colorLowland   (0.334, 0.333, 0.331, 0.000)
		colorUpland    (0.351, 0.349, 0.348, 0.000)
		colorRock      (0.367, 0.366, 0.364, 0.000)
		colorSnow      (0.384, 0.382, 0.381, 1.000)
		BumpHeight      0.105237
		BumpOffset      0.0210475
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00118148
		Period          0.000880273
		Eccentricity    0
		Inclination     -1.12735
		AscendingNode   -49.4278
		ArgOfPericenter 14.9416
		MeanAnomaly     -74.8328
	}
}

DwarfMoon	"4.S45"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.50114e-015
	Radius          0.173086
	InertiaMoment   0.398531

	Oblateness      0.249

	Obliquity       0.571976
	EqAscendNode    76.684
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.583 0.580 0.577)

	Surface
	{
		SurfStyle       0.45993
		OceanStyle      0.987
		Randomize      (-0.466, -0.484, 0.228)
		colorDistMagn   0.960244
		colorDistFreq   1.07497e-005
		detailScale     4.7264
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0156588
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.683093
		terraceProb     0.371938
		erosion         0
		montesMagn      0.641401
		montesFreq      2.51984
		montesSpiky     0.963316
		montesFraction  0.647473
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.31266e-005
		hillsFraction   0.781585
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.226775
		craterFreq      0.175319
		craterDensity   0.767982
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   700.419
		volcanoTemp     1428.29
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.233, 0.232, 0.231, 0.000)
		colorShelf     (0.248, 0.247, 0.245, 0.000)
		colorBeach     (0.262, 0.261, 0.260, 0.000)
		colorDesert    (0.277, 0.276, 0.274, 0.000)
		colorLowland   (0.291, 0.290, 0.289, 0.000)
		colorUpland    (0.306, 0.305, 0.303, 0.000)
		colorRock      (0.321, 0.319, 0.317, 0.000)
		colorSnow      (0.335, 0.334, 0.332, 1.000)
		BumpHeight      0.155777
		BumpOffset      0.0311555
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00119276
		Period          0.000892903
		Eccentricity    0
		Inclination     0.571976
		AscendingNode   76.684
		ArgOfPericenter -35.986
		MeanAnomaly     -150.834
	}
}

DwarfMoon	"4.S46"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.78058e-015
	Radius          0.201725
	InertiaMoment   0.399526

	Oblateness      0.249

	Obliquity       -1.13437
	EqAscendNode    46.1329
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.743 0.741 0.739)

	Surface
	{
		SurfStyle       0.578588
		OceanStyle      0.846269
		Randomize      (0.013, 0.764, -0.396)
		colorDistMagn   0.530007
		colorDistFreq   1.64192e-005
		detailScale     5.50844
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0364225
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.621115
		terraceProb     0.260143
		erosion         0
		montesMagn      0.432925
		montesFreq      2.55434
		montesSpiky     0.948473
		montesFraction  0.451794
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.94103e-005
		hillsFraction   0.785465
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.242271
		craterFreq      0.150626
		craterDensity   0.810334
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   599.789
		volcanoTemp     1656.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.290, 0.252, 0.207, 0.000)
		colorShelf     (0.297, 0.259, 0.236, 0.000)
		colorBeach     (0.349, 0.304, 0.281, 0.000)
		colorDesert    (0.379, 0.326, 0.273, 0.000)
		colorLowland   (0.416, 0.348, 0.310, 0.000)
		colorUpland    (0.461, 0.422, 0.377, 0.000)
		colorRock      (0.498, 0.459, 0.406, 0.000)
		colorSnow      (0.543, 0.489, 0.428, 1.000)
		BumpHeight      0.181553
		BumpOffset      0.0363105
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00120677
		Period          0.000908692
		Eccentricity    0
		Inclination     -1.13437
		AscendingNode   46.1329
		ArgOfPericenter 47.0511
		MeanAnomaly     6.52422
	}
}

DwarfMoon	"4.S47"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.84561e-015
	Radius          0.233177
	InertiaMoment   0.397207

	Oblateness      0.249

	Obliquity       -0.856065
	EqAscendNode    101.952
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.676 0.673 0.668)

	Surface
	{
		SurfStyle       0.120989
		OceanStyle      0.0778971
		Randomize      (0.806, -0.296, 0.232)
		colorDistMagn   0.532195
		colorDistFreq   2.82635e-005
		detailScale     6.36727
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0188123
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.479129
		terraceProb     0.398889
		erosion         0
		montesMagn      0.625547
		montesFreq      2.62141
		montesSpiky     0.874604
		montesFraction  0.778879
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000121011
		hillsFraction   0.458574
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.252213
		craterFreq      0.25361
		craterDensity   0.960569
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   525.19
		volcanoTemp     1563.29
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.270, 0.269, 0.267, 0.000)
		colorShelf     (0.287, 0.286, 0.284, 0.000)
		colorBeach     (0.304, 0.303, 0.301, 0.000)
		colorDesert    (0.321, 0.320, 0.318, 0.000)
		colorLowland   (0.338, 0.336, 0.334, 0.000)
		colorUpland    (0.355, 0.353, 0.351, 0.000)
		colorRock      (0.372, 0.370, 0.368, 0.000)
		colorSnow      (0.389, 0.387, 0.384, 1.000)
		BumpHeight      0.209859
		BumpOffset      0.0419718
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00121252
		Period          0.000915194
		Eccentricity    0
		Inclination     -0.856065
		AscendingNode   101.952
		ArgOfPericenter -81.7738
		MeanAnomaly     -59.2185
	}
}

DwarfMoon	"4.S48"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.06735e-015
	Radius          0.262334
	InertiaMoment   0.39869

	Oblateness      0.249

	Obliquity       -1.40427
	EqAscendNode    113.695
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.600 0.598 0.595)

	Surface
	{
		SurfStyle       0.128274
		OceanStyle      0.853504
		Randomize      (-0.102, 0.725, 0.341)
		colorDistMagn   0.142926
		colorDistFreq   5.56829e-005
		detailScale     7.16347
		colorConversion true
		snowLevel       2
		tropicLatitude  0.026802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.408522
		terraceProb     0.475268
		erosion         0
		montesMagn      0.425558
		montesFreq      2.15672
		montesSpiky     0.845992
		montesFraction  0.420923
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000146454
		hillsFraction   0.754103
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.216497
		craterFreq      0.247901
		craterDensity   0.838085
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   457.926
		volcanoTemp     1676.11
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.240, 0.239, 0.238, 0.000)
		colorShelf     (0.255, 0.254, 0.253, 0.000)
		colorBeach     (0.270, 0.269, 0.268, 0.000)
		colorDesert    (0.285, 0.284, 0.282, 0.000)
		colorLowland   (0.300, 0.299, 0.297, 0.000)
		colorUpland    (0.315, 0.314, 0.312, 0.000)
		colorRock      (0.330, 0.329, 0.327, 0.000)
		colorSnow      (0.345, 0.344, 0.342, 1.000)
		BumpHeight      0.236101
		BumpOffset      0.0472201
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00121863
		Period          0.00092211
		Eccentricity    0
		Inclination     -1.40427
		AscendingNode   113.695
		ArgOfPericenter 147.501
		MeanAnomaly     169.149
	}
}

DwarfMoon	"4.S49"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.29658e-014
	Radius          0.359032
	InertiaMoment   0.399654

	Oblateness      0.249

	Obliquity       -0.536299
	EqAscendNode    42.3923
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.770 0.767 0.764)

	Surface
	{
		SurfStyle       0.515657
		OceanStyle      0.547497
		Randomize      (-0.800, 0.505, 0.817)
		colorDistMagn   0.718311
		colorDistFreq   4.40357e-005
		detailScale     9.80396
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0174515
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.628248
		terraceProb     0.484025
		erosion         0
		montesMagn      0.576124
		montesFreq      2.09948
		montesSpiky     0.983455
		montesFraction  0.6868
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000224976
		hillsFraction   0.419529
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227811
		craterFreq      0.272999
		craterDensity   1.03397
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   494.355
		volcanoTemp     1347.14
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.300, 0.261, 0.214, 0.000)
		colorShelf     (0.308, 0.269, 0.244, 0.000)
		colorBeach     (0.362, 0.315, 0.290, 0.000)
		colorDesert    (0.393, 0.338, 0.283, 0.000)
		colorLowland   (0.431, 0.361, 0.321, 0.000)
		colorUpland    (0.478, 0.437, 0.390, 0.000)
		colorRock      (0.516, 0.476, 0.420, 0.000)
		colorSnow      (0.562, 0.506, 0.443, 1.000)
		BumpHeight      0.323129
		BumpOffset      0.0646257
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00122466
		Period          0.000928962
		Eccentricity    0
		Inclination     -0.536299
		AscendingNode   42.3923
		ArgOfPericenter 19.1998
		MeanAnomaly     -62.4925
	}
}

DwarfMoon	"4.S50"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.02664e-014
	Radius          0.393515
	InertiaMoment   0.397506

	Oblateness      0.249

	Obliquity       -0.639614
	EqAscendNode    -165.354
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.492 0.486 0.484)

	Surface
	{
		SurfStyle       0.246689
		OceanStyle      0.568179
		Randomize      (-0.952, 0.088, 0.679)
		colorDistMagn   0.518772
		colorDistFreq   9.39013e-005
		detailScale     10.7456
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00284714
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.573336
		terraceProb     0.252089
		erosion         0
		montesMagn      0.429459
		montesFreq      3.79594
		montesSpiky     0.988177
		montesFraction  0.396907
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000393826
		hillsFraction   0.828478
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.293719
		craterFreq      0.257484
		craterDensity   0.987557
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   433.39
		volcanoTemp     1488.36
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.197, 0.194, 0.194, 0.000)
		colorShelf     (0.209, 0.207, 0.206, 0.000)
		colorBeach     (0.222, 0.219, 0.218, 0.000)
		colorDesert    (0.234, 0.231, 0.230, 0.000)
		colorLowland   (0.246, 0.243, 0.242, 0.000)
		colorUpland    (0.258, 0.255, 0.254, 0.000)
		colorRock      (0.271, 0.267, 0.266, 0.000)
		colorSnow      (0.283, 0.279, 0.278, 1.000)
		BumpHeight      0.354163
		BumpOffset      0.0708326
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00123534
		Period          0.000941149
		Eccentricity    0
		Inclination     -0.639613
		AscendingNode   -165.354
		ArgOfPericenter -7.58764
		MeanAnomaly     24.3487
	}
}

DwarfMoon	"4.S51"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.09779e-014
	Radius          0.435258
	InertiaMoment   0.398841

	Oblateness      0.249

	Obliquity       1.22978
	EqAscendNode    -83.8791
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.555 0.391 0.322)

	Surface
	{
		SurfStyle       0.818592
		OceanStyle      0.526108
		Randomize      (0.580, -0.747, -0.341)
		colorDistMagn   0.367968
		colorDistFreq   0.000134977
		detailScale     11.8854
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0319252
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.323568
		terraceProb     0.241347
		erosion         0
		montesMagn      0.513545
		montesFreq      3.23209
		montesSpiky     0.992638
		montesFraction  0.614233
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000345251
		hillsFraction   0.760222
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.202676
		craterFreq      0.276715
		craterDensity   0.889917
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   387.727
		volcanoTemp     1491.38
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.216, 0.133, 0.090, 0.000)
		colorShelf     (0.222, 0.137, 0.103, 0.000)
		colorBeach     (0.261, 0.160, 0.122, 0.000)
		colorDesert    (0.283, 0.172, 0.119, 0.000)
		colorLowland   (0.311, 0.184, 0.135, 0.000)
		colorUpland    (0.344, 0.223, 0.164, 0.000)
		colorRock      (0.372, 0.242, 0.177, 0.000)
		colorSnow      (0.405, 0.258, 0.187, 1.000)
		BumpHeight      0.391732
		BumpOffset      0.0783464
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00124395
		Period          0.000951005
		Eccentricity    0
		Inclination     1.22978
		AscendingNode   -83.8791
		ArgOfPericenter -42.6451
		MeanAnomaly     98.2649
	}
}

DwarfMoon	"4.S52"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.65016e-014
	Radius          0.475223
	InertiaMoment   0.39978

	Oblateness      0.249

	Obliquity       -0.695315
	EqAscendNode    168.293
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.506 0.447 0.401)

	Surface
	{
		SurfStyle       0.95468
		OceanStyle      0.497834
		Randomize      (-0.085, -0.262, 0.104)
		colorDistMagn   0.518318
		colorDistFreq   9.58372e-005
		detailScale     12.9767
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0024657
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.465762
		terraceProb     0.410397
		erosion         0
		montesMagn      0.498356
		montesFreq      2.95301
		montesSpiky     0.996765
		montesFraction  0.484536
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000416228
		hillsFraction   0.639278
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.25614
		craterFreq      0.202374
		craterDensity   0.939957
		craterOctaves   6
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   345.517
		volcanoTemp     2033.42
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.172, 0.156, 0.160, 0.050)
		colorShelf     (0.202, 0.183, 0.184, 0.040)
		colorBeach     (0.233, 0.210, 0.208, 0.030)
		colorDesert    (0.263, 0.237, 0.236, 0.020)
		colorLowland   (0.293, 0.264, 0.260, 0.030)
		colorUpland    (0.324, 0.291, 0.284, 0.050)
		colorRock      (0.354, 0.317, 0.316, 0.020)
		colorSnow      (0.354, 0.317, 0.316, 1.000)
		BumpHeight      0.4277
		BumpOffset      0.0855401
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00124631
		Period          0.000953715
		Eccentricity    0
		Inclination     -0.695315
		AscendingNode   168.293
		ArgOfPericenter -118.537
		MeanAnomaly     32.6483
	}
}

DwarfMoon	"4.S53"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.87831e-014
	Radius          0.634421
	InertiaMoment   0.397758

	Oblateness      0.249

	Obliquity       -0.554089
	EqAscendNode    -97.2885
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.480 0.477 0.475)

	Surface
	{
		SurfStyle       0.960236
		OceanStyle      0.199053
		Randomize      (0.837, -0.478, -0.300)
		colorDistMagn   0.0252846
		colorDistFreq   0.000276612
		detailScale     17.3239
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0127793
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.496839
		terraceProb     0.488182
		erosion         0
		montesMagn      0.241616
		montesFreq      2.91842
		montesSpiky     0.922772
		montesFraction  0.57644
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000770898
		hillsFraction   0.724536
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247805
		craterFreq      0.252686
		craterDensity   0.719871
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   379.265
		volcanoTemp     1884.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.163, 0.167, 0.190, 0.050)
		colorShelf     (0.192, 0.196, 0.218, 0.040)
		colorBeach     (0.221, 0.224, 0.247, 0.030)
		colorDesert    (0.250, 0.253, 0.280, 0.020)
		colorLowland   (0.279, 0.282, 0.309, 0.030)
		colorUpland    (0.307, 0.310, 0.337, 0.050)
		colorRock      (0.336, 0.339, 0.375, 0.020)
		colorSnow      (0.336, 0.339, 0.375, 1.000)
		BumpHeight      0.570979
		BumpOffset      0.114196
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00125997
		Period          0.000969429
		Eccentricity    0
		Inclination     -0.554089
		AscendingNode   -97.2885
		ArgOfPericenter -47.656
		MeanAnomaly     61.6962
	}
}

DwarfMoon	"4.S54"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.00526e-013
	Radius          0.675399
	InertiaMoment   0.398986

	Oblateness      0.249

	Obliquity       0.236402
	EqAscendNode    44.3592
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.634 0.628 0.625)

	Surface
	{
		SurfStyle       0.291777
		OceanStyle      0.0645738
		Randomize      (-0.359, 0.470, 0.013)
		colorDistMagn   0.445576
		colorDistFreq   0.000148551
		detailScale     18.4429
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00764275
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.653659
		terraceProb     0.179171
		erosion         0
		montesMagn      0.575157
		montesFreq      3.1727
		montesSpiky     0.982106
		montesFraction  0.538419
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000834218
		hillsFraction   0.424997
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238782
		craterFreq      0.236784
		craterDensity   0.917539
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   333.986
		volcanoTemp     1350.33
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.254, 0.251, 0.250, 0.000)
		colorShelf     (0.269, 0.267, 0.266, 0.000)
		colorBeach     (0.285, 0.282, 0.281, 0.000)
		colorDesert    (0.301, 0.298, 0.297, 0.000)
		colorLowland   (0.317, 0.314, 0.312, 0.000)
		colorUpland    (0.333, 0.330, 0.328, 0.000)
		colorRock      (0.349, 0.345, 0.344, 0.000)
		colorSnow      (0.364, 0.361, 0.359, 1.000)
		BumpHeight      0.607859
		BumpOffset      0.121572
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00127435
		Period          0.00098607
		Eccentricity    0
		Inclination     0.236402
		AscendingNode   44.3592
		ArgOfPericenter -48.7832
		MeanAnomaly     -66.0295
	}
}

DwarfMoon	"4.S55"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.45494e-013
	Radius          0.733047
	InertiaMoment   0.399905

	Oblateness      0.249

	Obliquity       1.31309
	EqAscendNode    -32.9782
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.808 0.775 0.708)

	Surface
	{
		SurfStyle       0.192344
		OceanStyle      0.923222
		Randomize      (-0.043, -0.960, 0.523)
		colorDistMagn   0.561731
		colorDistFreq   0.000312377
		detailScale     20.0171
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0439361
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.348975
		terraceProb     0.207896
		erosion         0
		montesMagn      0.515403
		montesFreq      2.31402
		montesSpiky     0.991393
		montesFraction  0.412102
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0015267
		hillsFraction   0.646471
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.242829
		craterFreq      0.202639
		craterDensity   0.793899
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   301.312
		volcanoTemp     1660.97
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.323, 0.310, 0.283, 0.000)
		colorShelf     (0.344, 0.329, 0.301, 0.000)
		colorBeach     (0.364, 0.349, 0.318, 0.000)
		colorDesert    (0.384, 0.368, 0.336, 0.000)
		colorLowland   (0.404, 0.387, 0.354, 0.000)
		colorUpland    (0.424, 0.407, 0.372, 0.000)
		colorRock      (0.445, 0.426, 0.389, 0.000)
		colorSnow      (0.465, 0.445, 0.407, 1.000)
		BumpHeight      0.659742
		BumpOffset      0.131948
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00128048
		Period          0.000993199
		Eccentricity    0
		Inclination     1.31309
		AscendingNode   -32.9782
		ArgOfPericenter -163.707
		MeanAnomaly     138.87
	}
}

DwarfMoon	"4.S56"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.08942e-013
	Radius          0.790946
	InertiaMoment   0.397979

	Oblateness      0.249

	Obliquity       -0.0635585
	EqAscendNode    147.964
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.796 0.793 0.790)

	Surface
	{
		SurfStyle       0.287285
		OceanStyle      0.763573
		Randomize      (0.496, 0.569, 0.292)
		colorDistMagn   0.738381
		colorDistFreq   0.000485923
		detailScale     21.5981
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00059802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.706192
		terraceProb     0.111941
		erosion         0
		montesMagn      0.436329
		montesFreq      3.2675
		montesSpiky     0.983754
		montesFraction  0.561479
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00159758
		hillsFraction   0.592687
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24454
		craterFreq      0.278286
		craterDensity   0.913823
		craterOctaves   7
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   271.294
		volcanoTemp     1497.91
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.318, 0.317, 0.316, 0.000)
		colorShelf     (0.338, 0.337, 0.336, 0.000)
		colorBeach     (0.358, 0.357, 0.356, 0.000)
		colorDesert    (0.378, 0.377, 0.375, 0.000)
		colorLowland   (0.398, 0.396, 0.395, 0.000)
		colorUpland    (0.418, 0.416, 0.415, 0.000)
		colorRock      (0.438, 0.436, 0.435, 0.000)
		colorSnow      (0.457, 0.456, 0.454, 1.000)
		BumpHeight      0.711851
		BumpOffset      0.14237
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0012884
		Period          0.00100243
		Eccentricity    0
		Inclination     -0.0635586
		AscendingNode   147.964
		ArgOfPericenter -178.303
		MeanAnomaly     164.909
	}
}

DwarfMoon	"4.S57"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.98238e-013
	Radius          1.05193
	InertiaMoment   0.399126

	Oblateness      0.249

	Obliquity       1.15744
	EqAscendNode    -108.851
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.696 0.621 0.575)

	Surface
	{
		SurfStyle       0.943565
		OceanStyle      0.0127617
		Randomize      (0.603, -0.085, 0.690)
		colorDistMagn   0.443666
		colorDistFreq   0.000813316
		detailScale     28.7247
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0235019
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.530433
		terraceProb     0.335189
		erosion         0
		montesMagn      0.461001
		montesFreq      3.44307
		montesSpiky     0.853046
		montesFraction  0.501729
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00327423
		hillsFraction   0.585368
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.232444
		craterFreq      0.247967
		craterDensity   1.00118
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   302.002
		volcanoTemp     1589.68
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.237, 0.217, 0.230, 0.050)
		colorShelf     (0.278, 0.255, 0.265, 0.040)
		colorBeach     (0.320, 0.292, 0.299, 0.030)
		colorDesert    (0.362, 0.329, 0.339, 0.020)
		colorLowland   (0.404, 0.367, 0.374, 0.030)
		colorUpland    (0.445, 0.404, 0.408, 0.050)
		colorRock      (0.487, 0.441, 0.454, 0.020)
		colorSnow      (0.487, 0.441, 0.454, 1.000)
		BumpHeight      0.946736
		BumpOffset      0.189347
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00130056
		Period          0.00101666
		Eccentricity    0
		Inclination     1.15744
		AscendingNode   -108.851
		ArgOfPericenter -35.3561
		MeanAnomaly     -112.444
	}
}

DwarfMoon	"4.S58"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.23757e-013
	Radius          1.09838
	InertiaMoment   0.394978

	Oblateness      0.249

	Obliquity       -0.0950909
	EqAscendNode    121.547
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.589 0.585 0.582)

	Surface
	{
		SurfStyle       0.0131356
		OceanStyle      0.813904
		Randomize      (0.584, -0.627, -0.968)
		colorDistMagn   0.158612
		colorDistFreq   0.000687531
		detailScale     29.9931
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00161945
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.54924
		terraceProb     0.372019
		erosion         0
		montesMagn      0.462409
		montesFreq      2.87213
		montesSpiky     0.95773
		montesFraction  0.665808
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00335424
		hillsFraction   0.758777
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.24326
		craterFreq      0.181127
		craterDensity   0.89632
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   264.545
		volcanoTemp     1751.52
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.236, 0.234, 0.233, 0.000)
		colorShelf     (0.250, 0.249, 0.247, 0.000)
		colorBeach     (0.265, 0.263, 0.262, 0.000)
		colorDesert    (0.280, 0.278, 0.277, 0.000)
		colorLowland   (0.294, 0.292, 0.291, 0.000)
		colorUpland    (0.309, 0.307, 0.306, 0.000)
		colorRock      (0.324, 0.322, 0.320, 0.000)
		colorSnow      (0.339, 0.336, 0.335, 1.000)
		BumpHeight      0.988542
		BumpOffset      0.197708
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00130762
		Period          0.00102494
		Eccentricity    0
		Inclination     -0.0950909
		AscendingNode   121.547
		ArgOfPericenter -78.6942
		MeanAnomaly     178.304
	}
}

DwarfMoon	"4.S59"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.00195e-013
	Radius          1.18228
	InertiaMoment   0.398177

	Oblateness      0.249

	Obliquity       -1.40726
	EqAscendNode    -142.713
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.563 0.397 0.312)

	Surface
	{
		SurfStyle       0.921754
		OceanStyle      0.0680588
		Randomize      (-0.164, 0.602, -0.516)
		colorDistMagn   0.331458
		colorDistFreq   0.00102233
		detailScale     32.284
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0157006
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.470452
		terraceProb     0.119335
		erosion         0
		montesMagn      0.540138
		montesFreq      3.55429
		montesSpiky     0.850576
		montesFraction  0.53792
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00306695
		hillsFraction   0.449589
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.237737
		craterFreq      0.242146
		craterDensity   1.08564
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   239.265
		volcanoTemp     1344.6
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.191, 0.139, 0.125, 0.050)
		colorShelf     (0.225, 0.163, 0.143, 0.040)
		colorBeach     (0.259, 0.187, 0.162, 0.030)
		colorDesert    (0.293, 0.210, 0.184, 0.020)
		colorLowland   (0.326, 0.234, 0.203, 0.030)
		colorUpland    (0.360, 0.258, 0.221, 0.050)
		colorRock      (0.394, 0.282, 0.246, 0.020)
		colorSnow      (0.394, 0.282, 0.246, 1.000)
		BumpHeight      1.06405
		BumpOffset      0.21281
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00131384
		Period          0.00103227
		Eccentricity    0
		Inclination     -1.40726
		AscendingNode   -142.713
		ArgOfPericenter -40.8586
		MeanAnomaly     -148.311
	}
}

DwarfMoon	"4.S60"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.4852e-013
	Radius          1.2715
	InertiaMoment   0.399261

	Oblateness      0.249

	Obliquity       -0.236576
	EqAscendNode    32.0953
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.453 0.450 0.445)

	Surface
	{
		SurfStyle       0.565267
		OceanStyle      0.997607
		Randomize      (-0.080, 0.867, 0.534)
		colorDistMagn   0.125398
		colorDistFreq   0.00129634
		detailScale     34.7203
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00793357
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.594587
		terraceProb     0.193863
		erosion         0
		montesMagn      0.350507
		montesFreq      1.93803
		montesSpiky     0.72638
		montesFraction  0.478125
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00471478
		hillsFraction   0.694979
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.265055
		craterFreq      0.2205
		craterDensity   0.850554
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   216.416
		volcanoTemp     1138.07
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.177, 0.153, 0.124, 0.000)
		colorShelf     (0.181, 0.157, 0.142, 0.000)
		colorBeach     (0.213, 0.184, 0.169, 0.000)
		colorDesert    (0.231, 0.198, 0.165, 0.000)
		colorLowland   (0.254, 0.211, 0.187, 0.000)
		colorUpland    (0.281, 0.256, 0.227, 0.000)
		colorRock      (0.304, 0.279, 0.245, 0.000)
		colorSnow      (0.331, 0.297, 0.258, 1.000)
		BumpHeight      1.14435
		BumpOffset      0.228869
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00131838
		Period          0.00103762
		Eccentricity    0
		Inclination     -0.236576
		AscendingNode   32.0953
		ArgOfPericenter -158.062
		MeanAnomaly     -148.391
	}
}

DwarfMoon	"4.S61"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.19887e-012
	Radius          1.71301
	InertiaMoment   0.396266

	Oblateness      0.249

	Obliquity       0.181415
	EqAscendNode    51.1822
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.538 0.530 0.524)

	Surface
	{
		SurfStyle       0.428441
		OceanStyle      0.336412
		Randomize      (-0.096, -0.783, -0.072)
		colorDistMagn   0.364632
		colorDistFreq   0.00231212
		detailScale     46.7767
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00571516
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.639703
		terraceProb     0.435981
		erosion         0
		montesMagn      0.46712
		montesFreq      2.83189
		montesSpiky     0.82745
		montesFraction  0.637647
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00933042
		hillsFraction   0.594969
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.225274
		craterFreq      0.149195
		craterDensity   0.855992
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   245.29
		volcanoTemp     1419.8
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.215, 0.212, 0.210, 0.000)
		colorShelf     (0.229, 0.225, 0.223, 0.000)
		colorBeach     (0.242, 0.239, 0.236, 0.000)
		colorDesert    (0.255, 0.252, 0.249, 0.000)
		colorLowland   (0.269, 0.265, 0.262, 0.000)
		colorUpland    (0.282, 0.278, 0.275, 0.000)
		colorRock      (0.296, 0.292, 0.288, 0.000)
		colorSnow      (0.309, 0.305, 0.301, 1.000)
		BumpHeight      1.54171
		BumpOffset      0.308343
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.001324
		Period          0.00104426
		Eccentricity    0
		Inclination     0.181415
		AscendingNode   51.1822
		ArgOfPericenter 135.965
		MeanAnomaly     139.518
	}
}

DwarfMoon	"4.S62"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.695e-012
	Radius          1.75604
	InertiaMoment   0.398359

	Oblateness      0.249

	Obliquity       0.619205
	EqAscendNode    -44.9132
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.504 0.501 0.496)

	Surface
	{
		SurfStyle       0.0908657
		OceanStyle      0.399543
		Randomize      (-0.790, -0.361, -0.688)
		colorDistMagn   0.242121
		colorDistFreq   0.00201231
		detailScale     47.9517
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0199738
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.504364
		terraceProb     0.303838
		erosion         0
		montesMagn      0.425133
		montesFreq      3.42543
		montesSpiky     0.968849
		montesFraction  0.306608
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00610864
		hillsFraction   0.727879
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.214337
		craterFreq      0.204685
		craterDensity   0.962168
		craterOctaves   8
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   211.474
		volcanoTemp     1371.79
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.202, 0.201, 0.198, 0.000)
		colorShelf     (0.214, 0.213, 0.211, 0.000)
		colorBeach     (0.227, 0.226, 0.223, 0.000)
		colorDesert    (0.239, 0.238, 0.236, 0.000)
		colorLowland   (0.252, 0.251, 0.248, 0.000)
		colorUpland    (0.265, 0.263, 0.260, 0.000)
		colorRock      (0.277, 0.276, 0.273, 0.000)
		colorSnow      (0.290, 0.288, 0.285, 1.000)
		BumpHeight      1.58044
		BumpOffset      0.316088
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00132681
		Period          0.00104759
		Eccentricity    0
		Inclination     0.619205
		AscendingNode   -44.9132
		ArgOfPericenter -175.509
		MeanAnomaly     -10.3633
	}
}

DwarfMoon	"4.S63"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.40104e-012
	Radius          1.88739
	InertiaMoment   0.399394

	Oblateness      0.249

	Obliquity       0.759601
	EqAscendNode    -44.3963
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.534 0.487 0.418)

	Surface
	{
		SurfStyle       0.398797
		OceanStyle      0.214872
		Randomize      (-0.853, 0.975, 0.834)
		colorDistMagn   0.739811
		colorDistFreq   0.00106753
		detailScale     51.5384
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0245461
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.346684
		terraceProb     0.273387
		erosion         0
		montesMagn      0.326178
		montesFreq      3.65521
		montesSpiky     0.987099
		montesFraction  0.715353
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.00508727
		hillsFraction   0.629689
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.227023
		craterFreq      0.268855
		craterDensity   0.85234
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   190.971
		volcanoTemp     1451.58
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.214, 0.195, 0.167, 0.000)
		colorShelf     (0.227, 0.207, 0.178, 0.000)
		colorBeach     (0.241, 0.219, 0.188, 0.000)
		colorDesert    (0.254, 0.231, 0.198, 0.000)
		colorLowland   (0.267, 0.243, 0.209, 0.000)
		colorUpland    (0.281, 0.256, 0.219, 0.000)
		colorRock      (0.294, 0.268, 0.230, 0.000)
		colorSnow      (0.307, 0.280, 0.240, 1.000)
		BumpHeight      1.69865
		BumpOffset      0.339731
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00133367
		Period          0.00105572
		Eccentricity    0
		Inclination     0.759601
		AscendingNode   -44.3963
		ArgOfPericenter -94.1795
		MeanAnomaly     -69.6001
	}
}

DwarfMoon	"4.S64"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.41222e-012
	Radius          2.03598
	InertiaMoment   0.396819

	Oblateness      0.249

	Obliquity       0.523629
	EqAscendNode    -98.9009
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.664 0.659 0.657)

	Surface
	{
		SurfStyle       0.507088
		OceanStyle      0.1287
		Randomize      (0.383, 0.705, -0.019)
		colorDistMagn   0.70278
		colorDistFreq   0.00256857
		detailScale     55.5957
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0118802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.337219
		terraceProb     0.16023
		erosion         0
		montesMagn      0.531596
		montesFreq      2.8896
		montesSpiky     0.962411
		montesFraction  0.781437
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0109224
		hillsFraction   0.512034
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.248725
		craterFreq      0.241649
		craterDensity   0.786094
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   172.807
		volcanoTemp     1853.31
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.259, 0.224, 0.184, 0.000)
		colorShelf     (0.266, 0.231, 0.210, 0.000)
		colorBeach     (0.312, 0.270, 0.250, 0.000)
		colorDesert    (0.339, 0.290, 0.243, 0.000)
		colorLowland   (0.372, 0.310, 0.276, 0.000)
		colorUpland    (0.412, 0.376, 0.335, 0.000)
		colorRock      (0.445, 0.408, 0.361, 0.000)
		colorSnow      (0.485, 0.435, 0.381, 1.000)
		BumpHeight      1.83238
		BumpOffset      0.366476
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00133818
		Period          0.00106109
		Eccentricity    0
		Inclination     0.523629
		AscendingNode   -98.9009
		ArgOfPericenter 97.3096
		MeanAnomaly     56.6893
	}
}

DwarfMoon	"4.S65"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.87179e-012
	Radius          2.86271
	InertiaMoment   0.398528

	Oblateness      0.249

	Obliquity       -0.483631
	EqAscendNode    -41.7152
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.484 0.482 0.478)

	Surface
	{
		SurfStyle       0.829783
		OceanStyle      0.448107
		Randomize      (0.513, -0.288, 0.489)
		colorDistMagn   0.380451
		colorDistFreq   0.00272601
		detailScale     78.1711
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0157764
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.282514
		terraceProb     0.139577
		erosion         0
		montesMagn      0.473176
		montesFreq      3.41531
		montesSpiky     0.87603
		montesFraction  0.47937
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0236187
		hillsFraction   0.813174
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241245
		craterFreq      0.142855
		craterDensity   1.08111
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   203.348
		volcanoTemp     1910.16
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.189, 0.164, 0.134, 0.000)
		colorShelf     (0.194, 0.169, 0.153, 0.000)
		colorBeach     (0.228, 0.198, 0.182, 0.000)
		colorDesert    (0.247, 0.212, 0.177, 0.000)
		colorLowland   (0.271, 0.227, 0.201, 0.000)
		colorUpland    (0.300, 0.275, 0.244, 0.000)
		colorRock      (0.325, 0.299, 0.263, 0.000)
		colorSnow      (0.354, 0.318, 0.277, 1.000)
		BumpHeight      2.57644
		BumpOffset      0.515288
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00133992
		Period          0.00106315
		Eccentricity    0
		Inclination     -0.483631
		AscendingNode   -41.7152
		ArgOfPericenter -45.6152
		MeanAnomaly     -124.324
	}
}

DwarfMoon	"4.S66"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.99876e-012
	Radius          2.83898
	InertiaMoment   0.399523

	Oblateness      0.249

	Obliquity       0.164778
	EqAscendNode    169.682
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.709 0.707 0.706)

	Surface
	{
		SurfStyle       0.155526
		OceanStyle      0.383874
		Randomize      (0.220, -0.609, 0.767)
		colorDistMagn   0.979074
		colorDistFreq   0.00329474
		detailScale     77.523
		colorConversion true
		snowLevel       2
		tropicLatitude  0.000488281
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.466015
		terraceProb     0.298123
		erosion         0
		montesMagn      0.251291
		montesFreq      2.9562
		montesSpiky     0.956534
		montesFraction  0.500295
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0187348
		hillsFraction   0.649457
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.238552
		craterFreq      0.233822
		craterDensity   0.991287
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   168.251
		volcanoTemp     1794.55
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.284, 0.283, 0.282, 0.000)
		colorShelf     (0.302, 0.301, 0.300, 0.000)
		colorBeach     (0.319, 0.318, 0.318, 0.000)
		colorDesert    (0.337, 0.336, 0.335, 0.000)
		colorLowland   (0.355, 0.354, 0.353, 0.000)
		colorUpland    (0.372, 0.371, 0.371, 0.000)
		colorRock      (0.390, 0.389, 0.388, 0.000)
		colorSnow      (0.408, 0.407, 0.406, 1.000)
		BumpHeight      2.55508
		BumpOffset      0.511016
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00134461
		Period          0.00106874
		Eccentricity    0
		Inclination     0.164778
		AscendingNode   169.682
		ArgOfPericenter -100.904
		MeanAnomaly     -24.6923
	}
}

DwarfMoon	"4.S67"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.01339e-011
	Radius          3.06749
	InertiaMoment   0.3972

	Oblateness      0.249

	Obliquity       -1.4469
	EqAscendNode    -88.3493
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.432 0.429 0.425)

	Surface
	{
		SurfStyle       0.572705
		OceanStyle      0.149336
		Randomize      (-0.317, 0.915, 0.098)
		colorDistMagn   0.301609
		colorDistFreq   0.00381231
		detailScale     83.7629
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0362142
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.66255
		terraceProb     0.286712
		erosion         0
		montesMagn      0.620341
		montesFreq      2.55442
		montesSpiky     0.94003
		montesFraction  0.67303
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0212366
		hillsFraction   0.642159
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.247224
		craterFreq      0.212077
		craterDensity   0.807184
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   151.078
		volcanoTemp     1523.3
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.168, 0.146, 0.119, 0.000)
		colorShelf     (0.173, 0.150, 0.136, 0.000)
		colorBeach     (0.203, 0.176, 0.162, 0.000)
		colorDesert    (0.220, 0.189, 0.157, 0.000)
		colorLowland   (0.242, 0.201, 0.179, 0.000)
		colorUpland    (0.268, 0.244, 0.217, 0.000)
		colorRock      (0.289, 0.266, 0.234, 0.000)
		colorSnow      (0.315, 0.283, 0.247, 1.000)
		BumpHeight      2.76074
		BumpOffset      0.552148
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00135183
		Period          0.00107736
		Eccentricity    0
		Inclination     -1.4469
		AscendingNode   -88.3493
		ArgOfPericenter 63.4276
		MeanAnomaly     26.1649
	}
}

DwarfMoon	"4.S68"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.48185e-011
	Radius          3.3432
	InertiaMoment   0.398687

	Oblateness      0.249

	Obliquity       0.05753
	EqAscendNode    -69.7152
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.619 0.614 0.612)

	Surface
	{
		SurfStyle       0.618127
		OceanStyle      0.485435
		Randomize      (-0.624, -0.746, -0.936)
		colorDistMagn   0.563946
		colorDistFreq   0.00494361
		detailScale     91.2916
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00165584
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.478206
		terraceProb     0.416046
		erosion         0
		montesMagn      0.410069
		montesFreq      2.93454
		montesSpiky     0.974174
		montesFraction  0.659088
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0307847
		hillsFraction   0.396302
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.2292
		craterFreq      0.231061
		craterDensity   0.890088
		craterOctaves   9
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   136.165
		volcanoTemp     1731.78
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.242, 0.209, 0.171, 0.000)
		colorShelf     (0.248, 0.215, 0.196, 0.000)
		colorBeach     (0.291, 0.252, 0.232, 0.000)
		colorDesert    (0.316, 0.270, 0.226, 0.000)
		colorLowland   (0.347, 0.288, 0.257, 0.000)
		colorUpland    (0.384, 0.350, 0.312, 0.000)
		colorRock      (0.415, 0.380, 0.336, 0.000)
		colorSnow      (0.452, 0.405, 0.355, 1.000)
		BumpHeight      3.00888
		BumpOffset      0.601776
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00136534
		Period          0.00109355
		Eccentricity    0
		Inclination     0.05753
		AscendingNode   -69.7152
		ArgOfPericenter -34.2094
		MeanAnomaly     -133.593
	}
}

DwarfMoon	"4.S69"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.19334e-011
	Radius          3.51952
	InertiaMoment   0.399651

	Oblateness      0.200922

	Obliquity       0.183133
	EqAscendNode    -5.20018
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.591 0.520 0.495)

	Surface
	{
		SurfStyle       0.00639285
		OceanStyle      0.292901
		Randomize      (0.962, 0.388, -0.115)
		colorDistMagn   0.864389
		colorDistFreq   0.00987678
		detailScale     96.1065
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00638507
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.503297
		terraceProb     0.114415
		erosion         0
		montesMagn      0.405105
		montesFreq      2.78304
		montesSpiky     0.943006
		montesFraction  0.64466
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0256575
		hillsFraction   0.524136
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.234821
		craterFreq      0.225877
		craterDensity   0.900938
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   117.825
		volcanoTemp     1794.56
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.237, 0.208, 0.198, 0.000)
		colorShelf     (0.251, 0.221, 0.210, 0.000)
		colorBeach     (0.266, 0.234, 0.223, 0.000)
		colorDesert    (0.281, 0.247, 0.235, 0.000)
		colorLowland   (0.296, 0.260, 0.247, 0.000)
		colorUpland    (0.310, 0.273, 0.260, 0.000)
		colorRock      (0.325, 0.286, 0.272, 0.000)
		colorSnow      (0.340, 0.299, 0.284, 1.000)
		BumpHeight      3.16757
		BumpOffset      0.633514
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00137754
		Period          0.00110823
		Eccentricity    0
		Inclination     0.183133
		AscendingNode   -5.20018
		ArgOfPericenter -2.35019
		MeanAnomaly     89.9261
	}
}

DwarfMoon	"4.S70"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.29514e-011
	Radius          4.79854
	InertiaMoment   0.3975

	Oblateness      0.249

	Obliquity       -0.826543
	EqAscendNode    -45.7155
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.753 0.751 0.748)

	Surface
	{
		SurfStyle       0.0970337
		OceanStyle      0.292723
		Randomize      (-0.054, -0.342, -0.889)
		colorDistMagn   0.186359
		colorDistFreq   0.0171397
		detailScale     131.032
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0265832
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.596426
		terraceProb     0.232072
		erosion         0
		montesMagn      0.40777
		montesFreq      2.99814
		montesSpiky     0.911027
		montesFraction  0.705686
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0715661
		hillsFraction   0.575275
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.23999
		craterFreq      0.172775
		craterDensity   0.944495
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   131.062
		volcanoTemp     1889.6
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.301, 0.300, 0.299, 0.000)
		colorShelf     (0.320, 0.319, 0.318, 0.000)
		colorBeach     (0.339, 0.338, 0.337, 0.000)
		colorDesert    (0.358, 0.357, 0.355, 0.000)
		colorLowland   (0.377, 0.375, 0.374, 0.000)
		colorUpland    (0.396, 0.394, 0.393, 0.000)
		colorRock      (0.414, 0.413, 0.411, 0.000)
		colorSnow      (0.433, 0.432, 0.430, 1.000)
		BumpHeight      4.31869
		BumpOffset      0.863737
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00138908
		Period          0.0011222
		Eccentricity    0
		Inclination     -0.826542
		AscendingNode   -45.7155
		ArgOfPericenter -19.4931
		MeanAnomaly     -159.079
	}
}

DwarfMoon	"4.S71"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            5.04177e-011
	Radius          5.2669
	InertiaMoment   0.398838

	Oblateness      0.249

	Obliquity       1.35198
	EqAscendNode    144.194
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.737 0.736 0.733)

	Surface
	{
		SurfStyle       0.436351
		OceanStyle      0.105354
		Randomize      (-0.549, 0.953, 0.415)
		colorDistMagn   0.69158
		colorDistFreq   0.0159081
		detailScale     143.822
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0145049
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.719222
		terraceProb     0.40842
		erosion         0
		montesMagn      0.542289
		montesFreq      3.34191
		montesSpiky     0.976425
		montesFraction  0.420423
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.075509
		hillsFraction   0.707551
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.22635
		craterFreq      0.279034
		craterDensity   0.856549
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   116.297
		volcanoTemp     1378.54
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.295, 0.294, 0.293, 0.000)
		colorShelf     (0.313, 0.313, 0.312, 0.000)
		colorBeach     (0.332, 0.331, 0.330, 0.000)
		colorDesert    (0.350, 0.349, 0.348, 0.000)
		colorLowland   (0.369, 0.368, 0.367, 0.000)
		colorUpland    (0.387, 0.386, 0.385, 0.000)
		colorRock      (0.405, 0.405, 0.403, 0.000)
		colorSnow      (0.424, 0.423, 0.422, 1.000)
		BumpHeight      4.74021
		BumpOffset      0.948042
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00139731
		Period          0.00113218
		Eccentricity    0
		Inclination     1.35198
		AscendingNode   144.194
		ArgOfPericenter -77.6755
		MeanAnomaly     -8.34864
	}
}

DwarfMoon	"4.S72"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.89036e-011
	Radius          5.87381
	InertiaMoment   0.399777

	Oblateness      0.24544

	Obliquity       1.12369
	EqAscendNode    47.9846
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.562 0.494 0.448)

	Surface
	{
		SurfStyle       0.445377
		OceanStyle      0.826053
		Randomize      (-0.535, -0.436, -0.407)
		colorDistMagn   0.429829
		colorDistFreq   0.0244448
		detailScale     160.394
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0358272
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.438276
		terraceProb     0.182747
		erosion         0
		montesMagn      0.56405
		montesFreq      3.46044
		montesSpiky     0.888881
		montesFraction  0.674367
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.0643746
		hillsFraction   0.77363
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.279975
		craterFreq      0.212587
		craterDensity   0.871147
		craterOctaves   10
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   103.676
		volcanoTemp     1658.12
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.225, 0.198, 0.179, 0.000)
		colorShelf     (0.239, 0.210, 0.191, 0.000)
		colorBeach     (0.253, 0.222, 0.202, 0.000)
		colorDesert    (0.267, 0.235, 0.213, 0.000)
		colorLowland   (0.281, 0.247, 0.224, 0.000)
		colorUpland    (0.295, 0.259, 0.235, 0.000)
		colorRock      (0.309, 0.272, 0.247, 0.000)
		colorSnow      (0.323, 0.284, 0.258, 1.000)
		BumpHeight      5.28642
		BumpOffset      1.05728
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.0014038
		Period          0.00114007
		Eccentricity    0
		Inclination     1.12369
		AscendingNode   47.9846
		ArgOfPericenter 9.25466
		MeanAnomaly     -91.2574
	}
}

DwarfMoon	"4.S73"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.27011e-010
	Radius          6.48095
	InertiaMoment   0.397753

	Oblateness      0.201873

	Obliquity       -0.548186
	EqAscendNode    -159.207
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.563 0.444 0.344)

	Surface
	{
		SurfStyle       0.245877
		OceanStyle      0.630565
		Randomize      (0.340, 0.287, 0.873)
		colorDistMagn   0.741907
		colorDistFreq   0.0224903
		detailScale     176.973
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00345266
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.719017
		terraceProb     0.489358
		erosion         0
		montesMagn      0.327506
		montesFreq      2.38806
		montesSpiky     0.903204
		montesFraction  0.74506
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.112874
		hillsFraction   0.576481
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.241836
		craterFreq      0.236771
		craterDensity   0.978709
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   90.1623
		volcanoTemp     875.612
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.225, 0.178, 0.138, 0.000)
		colorShelf     (0.239, 0.189, 0.146, 0.000)
		colorBeach     (0.253, 0.200, 0.155, 0.000)
		colorDesert    (0.268, 0.211, 0.163, 0.000)
		colorLowland   (0.282, 0.222, 0.172, 0.000)
		colorUpland    (0.296, 0.233, 0.181, 0.000)
		colorRock      (0.310, 0.244, 0.189, 0.000)
		colorSnow      (0.324, 0.256, 0.198, 1.000)
		BumpHeight      5.83286
		BumpOffset      1.16657
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00140702
		Period          0.001144
		Eccentricity    0
		Inclination     -0.548186
		AscendingNode   -159.207
		ArgOfPericenter 34.6728
		MeanAnomaly     101.786
	}
}

DwarfMoon	"4.S74"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.11878e-010
	Radius          9.00762
	InertiaMoment   0.398983

	Oblateness      0.249

	Obliquity       0.108459
	EqAscendNode    -143.666
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.701 0.696 0.694)

	Surface
	{
		SurfStyle       0.940944
		OceanStyle      0.475771
		Randomize      (-0.914, -0.900, 0.857)
		colorDistMagn   0.265794
		colorDistFreq   0.0350399
		detailScale     245.968
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00119604
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.56787
		terraceProb     0.346688
		erosion         0
		montesMagn      0.574165
		montesFreq      3.35189
		montesSpiky     0.982303
		montesFraction  0.295379
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.204885
		hillsFraction   0.717244
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.261826
		craterFreq      0.141588
		craterDensity   0.949429
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   97.0227
		volcanoTemp     1445.93
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.238, 0.244, 0.278, 0.050)
		colorShelf     (0.281, 0.286, 0.319, 0.040)
		colorBeach     (0.323, 0.327, 0.361, 0.030)
		colorDesert    (0.365, 0.369, 0.409, 0.020)
		colorLowland   (0.407, 0.411, 0.451, 0.030)
		colorUpland    (0.449, 0.453, 0.493, 0.050)
		colorRock      (0.491, 0.494, 0.548, 0.020)
		colorSnow      (0.491, 0.494, 0.548, 1.000)
		BumpHeight      8.10686
		BumpOffset      1.62137
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00141219
		Period          0.00115031
		Eccentricity    0
		Inclination     0.108459
		AscendingNode   -143.666
		ArgOfPericenter -74.649
		MeanAnomaly     9.22437
	}
}

DwarfMoon	"4.S75"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.70195e-010
	Radius          10.2976
	InertiaMoment   0.399902

	Oblateness      0.249

	Obliquity       0.158638
	EqAscendNode    30.4753
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.755 0.695 0.581)

	Surface
	{
		SurfStyle       0.41987
		OceanStyle      0.975819
		Randomize      (0.960, 0.561, 0.378)
		colorDistMagn   0.295447
		colorDistFreq   0.0574818
		detailScale     281.193
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00533768
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.552238
		terraceProb     0.122063
		erosion         0
		montesMagn      0.540832
		montesFreq      3.95646
		montesSpiky     0.784442
		montesFraction  0.429488
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.287751
		hillsFraction   0.681767
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.243473
		craterFreq      0.21626
		craterDensity   0.978055
		craterOctaves   11
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   83.9124
		volcanoTemp     1608.79
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.302, 0.278, 0.232, 0.000)
		colorShelf     (0.321, 0.295, 0.247, 0.000)
		colorBeach     (0.340, 0.313, 0.261, 0.000)
		colorDesert    (0.359, 0.330, 0.276, 0.000)
		colorLowland   (0.377, 0.348, 0.291, 0.000)
		colorUpland    (0.396, 0.365, 0.305, 0.000)
		colorRock      (0.415, 0.382, 0.320, 0.000)
		colorSnow      (0.434, 0.400, 0.334, 1.000)
		BumpHeight      9.26783
		BumpOffset      1.85357
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00141731
		Period          0.00115658
		Eccentricity    0
		Inclination     0.158638
		AscendingNode   30.4753
		ArgOfPericenter 130.075
		MeanAnomaly     -178.182
	}
}

DwarfMoon	"4.S76"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            6.88158e-010
	Radius          12.1622
	InertiaMoment   0.397974

	Oblateness      0.236761

	Obliquity       -0.185061
	EqAscendNode    -106.436
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.700 0.695 0.692)

	Surface
	{
		SurfStyle       0.532339
		OceanStyle      0.970843
		Randomize      (0.740, -0.892, 0.738)
		colorDistMagn   0.43163
		colorDistFreq   0.0806886
		detailScale     332.109
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0038756
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.461462
		terraceProb     0.271819
		erosion         0
		montesMagn      0.529611
		montesFreq      3.38964
		montesSpiky     0.888896
		montesFraction  0.54716
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.227567
		hillsFraction   0.574408
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.251099
		craterFreq      0.185534
		craterDensity   0.984169
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   72.6899
		volcanoTemp     1571.35
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.273, 0.236, 0.194, 0.000)
		colorShelf     (0.280, 0.243, 0.221, 0.000)
		colorBeach     (0.329, 0.285, 0.263, 0.000)
		colorDesert    (0.357, 0.306, 0.256, 0.000)
		colorLowland   (0.392, 0.327, 0.290, 0.000)
		colorUpland    (0.434, 0.396, 0.353, 0.000)
		colorRock      (0.469, 0.431, 0.380, 0.000)
		colorSnow      (0.511, 0.459, 0.401, 1.000)
		BumpHeight      10.946
		BumpOffset      2.1892
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00142593
		Period          0.00116715
		Eccentricity    0
		Inclination     -0.185061
		AscendingNode   -106.436
		ArgOfPericenter -105.299
		MeanAnomaly     131.285
	}
}

DwarfMoon	"4.S77"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.39524e-009
	Radius          14.608
	InertiaMoment   0.399123

	Oblateness      0.20002

	Obliquity       -0.076721
	EqAscendNode    14.0048
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.486 0.482 0.480)

	Surface
	{
		SurfStyle       0.133363
		OceanStyle      0.172611
		Randomize      (0.166, -0.196, 0.480)
		colorDistMagn   0.560275
		colorDistFreq   0.0406626
		detailScale     398.895
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00265204
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.440512
		terraceProb     0.186943
		erosion         0
		montesMagn      0.547746
		montesFreq      3.50602
		montesSpiky     0.964882
		montesFraction  0.662952
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.444343
		hillsFraction   0.69065
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.258375
		craterFreq      0.186143
		craterDensity   0.859806
		craterOctaves   12
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   61.3156
		volcanoTemp     1145.01
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.195, 0.193, 0.192, 0.000)
		colorShelf     (0.207, 0.205, 0.204, 0.000)
		colorBeach     (0.219, 0.217, 0.216, 0.000)
		colorDesert    (0.231, 0.229, 0.228, 0.000)
		colorLowland   (0.243, 0.241, 0.240, 0.000)
		colorUpland    (0.255, 0.253, 0.252, 0.000)
		colorRock      (0.268, 0.265, 0.264, 0.000)
		colorSnow      (0.280, 0.277, 0.276, 1.000)
		BumpHeight      13.1472
		BumpOffset      2.62943
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00143348
		Period          0.00117643
		Eccentricity    0
		Inclination     -0.076721
		AscendingNode   14.0048
		ArgOfPericenter 145.193
		MeanAnomaly     -75.4541
	}
}

DwarfMoon	"4.S78"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            3.22179e-016
	Radius          0.10471
	InertiaMoment   0.394911

	Oblateness      0.249

	Obliquity       -1.2828
	EqAscendNode    142.445
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.428 0.424 0.418)

	Surface
	{
		SurfStyle       0.370242
		OceanStyle      0.858571
		Randomize      (-0.562, -0.223, 0.653)
		colorDistMagn   0.697476
		colorDistFreq   4.90728e-006
		detailScale     2.85929
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0144101
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.464091
		terraceProb     0.238342
		erosion         0
		montesMagn      0.362011
		montesFreq      3.67808
		montesSpiky     0.998464
		montesFraction  0.59761
		dunesFraction   0
		hillsMagn       0
		hillsFreq       3.31834e-005
		hillsFraction   0.7433
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.21334
		craterFreq      0.252327
		craterDensity   0.969475
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   914.634
		volcanoTemp     1654.51
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.171, 0.170, 0.167, 0.000)
		colorShelf     (0.182, 0.180, 0.178, 0.000)
		colorBeach     (0.192, 0.191, 0.188, 0.000)
		colorDesert    (0.203, 0.201, 0.199, 0.000)
		colorLowland   (0.214, 0.212, 0.209, 0.000)
		colorUpland    (0.225, 0.223, 0.219, 0.000)
		colorRock      (0.235, 0.233, 0.230, 0.000)
		colorSnow      (0.246, 0.244, 0.240, 1.000)
		BumpHeight      0.0942394
		BumpOffset      0.0188479
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00144476
		Period          0.00119034
		Eccentricity    0
		Inclination     -1.2828
		AscendingNode   142.445
		ArgOfPericenter -75.0594
		MeanAnomaly     142.781
	}
}

DwarfMoon	"4.S79"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            7.39168e-016
	Radius          0.130463
	InertiaMoment   0.398173

	Oblateness      0.249

	Obliquity       1.08634
	EqAscendNode    -64.9866
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.527 0.399 0.296)

	Surface
	{
		SurfStyle       0.207123
		OceanStyle      0.520429
		Randomize      (-0.649, 0.209, 0.471)
		colorDistMagn   0.520108
		colorDistFreq   8.51695e-006
		detailScale     3.56252
		colorConversion true
		snowLevel       2
		tropicLatitude  0.0319774
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.523636
		terraceProb     0.28501
		erosion         0
		montesMagn      0.467878
		montesFreq      2.40375
		montesSpiky     0.868332
		montesFraction  0.380601
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.45568e-005
		hillsFraction   0.644955
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.265423
		craterFreq      0.247898
		craterDensity   0.946893
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   752.356
		volcanoTemp     1523.55
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.211, 0.160, 0.119, 0.000)
		colorShelf     (0.224, 0.170, 0.126, 0.000)
		colorBeach     (0.237, 0.179, 0.133, 0.000)
		colorDesert    (0.250, 0.189, 0.141, 0.000)
		colorLowland   (0.264, 0.199, 0.148, 0.000)
		colorUpland    (0.277, 0.209, 0.156, 0.000)
		colorRock      (0.290, 0.219, 0.163, 0.000)
		colorSnow      (0.303, 0.229, 0.170, 1.000)
		BumpHeight      0.117417
		BumpOffset      0.0234834
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00144966
		Period          0.00119639
		Eccentricity    0
		Inclination     1.08634
		AscendingNode   -64.9866
		ArgOfPericenter 6.3611
		MeanAnomaly     7.08132
	}
}

DwarfMoon	"4.S80"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            1.49239e-015
	Radius          0.158334
	InertiaMoment   0.399259

	Oblateness      0.228914

	Obliquity       -0.252917
	EqAscendNode    160.94
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.534 0.530 0.527)

	Surface
	{
		SurfStyle       0.27724
		OceanStyle      0.677687
		Randomize      (0.722, 0.240, 0.917)
		colorDistMagn   0.519553
		colorDistFreq   1.3269e-005
		detailScale     4.32357
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00146484
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.553305
		terraceProb     0.426728
		erosion         0
		montesMagn      0.585495
		montesFreq      2.8067
		montesSpiky     0.915839
		montesFraction  0.0619332
		dunesFraction   0
		hillsMagn       0
		hillsFreq       7.30119e-005
		hillsFraction   0.662369
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.256473
		craterFreq      0.226725
		craterDensity   0.955257
		craterOctaves   4
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   642.596
		volcanoTemp     1572.64
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.214, 0.212, 0.211, 0.000)
		colorShelf     (0.227, 0.225, 0.224, 0.000)
		colorBeach     (0.240, 0.239, 0.237, 0.000)
		colorDesert    (0.254, 0.252, 0.250, 0.000)
		colorLowland   (0.267, 0.265, 0.263, 0.000)
		colorUpland    (0.280, 0.278, 0.277, 0.000)
		colorRock      (0.294, 0.292, 0.290, 0.000)
		colorSnow      (0.307, 0.305, 0.303, 1.000)
		BumpHeight      0.1425
		BumpOffset      0.0285001
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00145269
		Period          0.00120015
		Eccentricity    0
		Inclination     -0.252917
		AscendingNode   160.94
		ArgOfPericenter 66.3101
		MeanAnomaly     -69.2868
	}
}

DwarfMoon	"4.S81"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            2.76614e-015
	Radius          0.185428
	InertiaMoment   0.39625

	Oblateness      0.191316

	Obliquity       0.449507
	EqAscendNode    142.034
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.587 0.580 0.575)

	Surface
	{
		SurfStyle       0.444625
		OceanStyle      0.536694
		Randomize      (-0.506, 0.950, 0.646)
		colorDistMagn   0.736998
		colorDistFreq   2.1296e-005
		detailScale     5.06341
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00510947
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.60612
		terraceProb     0.225142
		erosion         0
		montesMagn      0.49483
		montesFreq      3.43552
		montesSpiky     0.959065
		montesFraction  0.668548
		dunesFraction   0
		hillsMagn       0
		hillsFreq       5.9927e-005
		hillsFraction   0.567818
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.207578
		craterFreq      0.192026
		craterDensity   0.802598
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   552.769
		volcanoTemp     1753.88
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.235, 0.232, 0.230, 0.000)
		colorShelf     (0.249, 0.247, 0.244, 0.000)
		colorBeach     (0.264, 0.261, 0.259, 0.000)
		colorDesert    (0.279, 0.276, 0.273, 0.000)
		colorLowland   (0.293, 0.290, 0.288, 0.000)
		colorUpland    (0.308, 0.305, 0.302, 0.000)
		colorRock      (0.323, 0.319, 0.316, 0.000)
		colorSnow      (0.337, 0.334, 0.331, 1.000)
		BumpHeight      0.166885
		BumpOffset      0.033377
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00146481
		Period          0.00121521
		Eccentricity    0
		Inclination     0.449507
		AscendingNode   142.034
		ArgOfPericenter 25.7255
		MeanAnomaly     -67.6403
	}
}

DwarfMoon	"4.S82"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            4.8227e-015
	Radius          0.261427
	InertiaMoment   0.398355

	Oblateness      0.249

	Obliquity       -0.50121
	EqAscendNode    176.162
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.605 0.602 0.599)

	Surface
	{
		SurfStyle       0.220764
		OceanStyle      0.851787
		Randomize      (0.673, 0.341, 0.234)
		colorDistMagn   0.549208
		colorDistFreq   5.40282e-005
		detailScale     7.1387
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00059802
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.513403
		terraceProb     0.266989
		erosion         0
		montesMagn      0.449901
		montesFreq      2.75127
		montesSpiky     0.964272
		montesFraction  0.548436
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000118672
		hillsFraction   0.633285
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.216816
		craterFreq      0.214667
		craterDensity   0.805098
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   590.216
		volcanoTemp     1441.17
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.242, 0.241, 0.240, 0.000)
		colorShelf     (0.257, 0.256, 0.255, 0.000)
		colorBeach     (0.272, 0.271, 0.270, 0.000)
		colorDesert    (0.287, 0.286, 0.285, 0.000)
		colorLowland   (0.302, 0.301, 0.300, 0.000)
		colorUpland    (0.317, 0.316, 0.315, 0.000)
		colorRock      (0.332, 0.331, 0.330, 0.000)
		colorSnow      (0.348, 0.346, 0.345, 1.000)
		BumpHeight      0.235284
		BumpOffset      0.0470568
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00147597
		Period          0.00122912
		Eccentricity    0
		Inclination     -0.50121
		AscendingNode   176.162
		ArgOfPericenter -96.4063
		MeanAnomaly     -91.4508
	}
}

DwarfMoon	"4.S83"
{
	ParentBody     "4"
	Class	       "Asteroid"

	Mass            8.03206e-015
	Radius          0.290811
	InertiaMoment   0.399391

	Oblateness      0.245758

	Obliquity       0.208797
	EqAscendNode    -94.0562
	TidalLocked     true

	AlbedoBond      0.2
	AlbedoGeom      0.24
	Brightness      3.5
	Color          (0.722 0.718 0.715)

	Surface
	{
		SurfStyle       0.740641
		OceanStyle      0.523715
		Randomize      (-0.244, 0.595, -0.235)
		colorDistMagn   0.661077
		colorDistFreq   2.79515e-005
		detailScale     7.94107
		colorConversion true
		snowLevel       2
		tropicLatitude  0.00496751
		icecapLatitude  1
		climatePole     0.9375
		climateTropic   0.3125
		climateEquator  0.6875
		heightTempGrad  0.625
		tropicWidth     0.07
		mainFreq        0.321409
		terraceProb     0.417468
		erosion         0
		montesMagn      0.449303
		montesFreq      2.67271
		montesSpiky     0.970024
		montesFraction  0.556947
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0.000228705
		hillsFraction   0.523428
		hills2Fraction  0
		canyonFraction  0
		craterMagn      0.231552
		craterFreq      0.201656
		craterDensity   0.932321
		craterOctaves   5
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   508.748
		volcanoTemp     1545.65
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		colorSea       (0.282, 0.244, 0.200, 0.000)
		colorShelf     (0.289, 0.251, 0.229, 0.000)
		colorBeach     (0.339, 0.295, 0.272, 0.000)
		colorDesert    (0.368, 0.316, 0.265, 0.000)
		colorLowland   (0.404, 0.338, 0.300, 0.000)
		colorUpland    (0.448, 0.409, 0.365, 0.000)
		colorRock      (0.484, 0.445, 0.393, 0.000)
		colorSnow      (0.527, 0.474, 0.415, 1.000)
		BumpHeight      0.26173
		BumpOffset      0.0523459
		SpecBrightWater 0
		SpecBrightIce   0.03
		SpecularPower   30
		Hapke           1
		SpotBright      4
		SpotWidth       0.05
		DayAmbient      0.07
	}

	NoClouds        true

	NoOcean         true

	NoLava          true

	NoAtmosphere    true

	NoAurora        true

	NoRings         true

	NoAccretionDisk true

	NoCometTail     true

	Orbit
	{
		RefPlane        "Equator"
		SemiMajorAxis   0.00148715
		Period          0.00124311
		Eccentricity    0
		Inclination     0.208797
		AscendingNode   -94.0562
		ArgOfPericenter -48.0042
		MeanAnomaly     144.488
	}
}

